/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.app.Dialog;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import java.util.ArrayList;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListFragment;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.adapter.CategoryFragmentListAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class CategoryFragment
extends AppListFragment
implements AppStoreConstant {
    protected static final String TAG = "CategoryFragment";
    private ListView list;
    private Context mContext;
    private CategoryFragmentListAdapter adapter;
    private WWidgetData mWgtData;
    protected View rootView;
    private AsyncTask<Void, Void, ArrayList<AppBean>> asyncTask = null;

    public CategoryFragment(Context context, WWidgetData mWData) {
        super(context, mWData, null, null);
        this.mContext = context;
        this.mWgtData = mWData;
        this.onCreateView();
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (isVisibleToUser && this.adapter == null) {
            this.downloadCategoryList();
        }
    }

    @Override
    public View onCreateView() {
        this.rootView = super.onCreateView();
        this.list = (ListView)this.rootView.findViewById(EUExUtil.getResIdID((String)"categoryListView"));
        return this.rootView;
    }

    public void downloadCategoryList() {
        final String resCacheKey = String.valueOf(UserInfoVO.toSpKeyString()) + "category_prefs";
        final String resCache = SharedPrefUtils.getString(this.mContext, "main_prefs", resCacheKey, "");
        if (!NetworkUtils.isOnline(this.mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        if (this.asyncTask != null) {
            return;
        }
        this.asyncTask = new AsyncTask<Void, Void, ArrayList<AppBean>>(){
            Dialog progressDialog = null;

            protected void onPreExecute() {
                this.progressDialog = DialogView.showLoadingDialog(CategoryFragment.this.mContext, EUExUtil.getString((String)"plugin_appstore_load_category_list"));
                this.progressDialog.show();
            }

            protected ArrayList<AppBean> doInBackground(Void ... params) {
                ArrayList<AppBean> categoryList = null;
                String response = AppStoteHttpURLConnection.downLoadCategoryList(CategoryFragment.this.mContext, CategoryFragment.this.mWgtData).getResult();
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    categoryList = AppStoteDataParser.parseAppListWithKey("appTypeList", response);
                    SharedPrefUtils.putString(CategoryFragment.this.mContext, "main_prefs", resCacheKey, response);
                } else if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                    categoryList = AppStoteDataParser.parseAppListWithKey("appTypeList", resCache);
                }
                return categoryList;
            }

            protected void onPostExecute(ArrayList<AppBean> result) {
                if (this.isCancelled()) {
                    CategoryFragment.this.asyncTask = null;
                    return;
                }
                if (this.progressDialog != null) {
                    this.progressDialog.dismiss();
                }
                if (result == null) {
                    Toast.makeText((Context)CategoryFragment.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                    Log.w((String)CategoryFragment.TAG, (String)"result==null");
                    CategoryFragment.this.asyncTask = null;
                }
                try {
                    if (result.size() == 0) {
                        Toast.makeText((Context)CategoryFragment.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                        Log.w((String)CategoryFragment.TAG, (String)"no apps");
                        CategoryFragment.this.asyncTask = null;
                    }
                    if (CategoryFragment.this.adapter != null) {
                        CategoryFragment.this.adapter.reload(result);
                    } else {
                        CategoryFragment.this.adapter = new CategoryFragmentListAdapter(CategoryFragment.this.mContext, result, CategoryFragment.this.mWgtData);
                        CategoryFragment.this.list.setAdapter((ListAdapter)CategoryFragment.this.adapter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CategoryFragment.this.asyncTask = null;
            }
        };
        this.asyncTask.execute((Object[])new Void[0]);
    }
}

