/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.contantprovider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.content.UriMatcher;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.contantprovider.GSharePre;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;

public class ContainerOpenAPI
extends ContentProvider {
    private static final UriMatcher URIMatcher = new UriMatcher(-1);
    private static final String PATH_USER = "user";
    private static final String PATH_TOKEN = "token";
    private static final String PATH_PUSH = "push";
    private static final String PATH_START_APP = "startApp";
    private static final int CODE_USER = 1;
    private static final int CODE_TOKEN = 2;
    private static final int CODE_PUSH = 3;
    private static final int CODE_START_APP = 4;
    private static final String AUTHORITY = "com.android.gdmcc.service";
    static final String USER_NAME = "userName";
    static final String USER_PSW = "userPsw";
    static final String ATTACH = "attach";
    static final String TITLE = "title";
    static final String BODY = "body";
    static final String CONTENT = "content";
    static final String PUSH_LIST = "pushList";

    static {
        URIMatcher.addURI(AUTHORITY, PATH_USER, 1);
        URIMatcher.addURI(AUTHORITY, PATH_TOKEN, 2);
        URIMatcher.addURI(AUTHORITY, PATH_PUSH, 3);
        URIMatcher.addURI(AUTHORITY, PATH_START_APP, 4);
    }

    public boolean onCreate() {
        return true;
    }

    public Bundle call(String method, String argment, Bundle extras) {
        String[] qAuery;
        if (method == null) {
            return null;
        }
        String appId = null;
        String appKey = null;
        String token = null;
        if (argment != null && (qAuery = argment.split("&")).length != 1) {
            if (qAuery.length == 2) {
                appId = qAuery[0];
                appKey = qAuery[1];
            } else if (qAuery.length == 3) {
                appId = qAuery[0];
                appKey = qAuery[1];
                token = qAuery[2];
            }
        }
        String result = null;
        if (PATH_USER.equals(method)) {
            result = this.queryUser(appId, appKey, token);
        } else if (PATH_TOKEN.equals(method)) {
            result = this.queryToken(appId, appKey, token);
        } else if (PATH_PUSH.equals(method)) {
            result = this.queryPush(appId, appKey, token);
        } else if (PATH_START_APP.equals(method)) {
            result = this.startApp(appId, appKey, token, extras);
            return null;
        }
        Bundle data = new Bundle();
        data.putString("result", result);
        return data;
    }

    public String getType(Uri uri) {
        int match = URIMatcher.match(uri);
        String data = null;
        String appId = null;
        String appKey = null;
        String token = null;
        String query = uri.getEncodedFragment();
        if (query != null) {
            String[] qAuery = query.split("&");
            if (qAuery.length == 1) {
                data = qAuery[0];
            } else if (qAuery.length == 2) {
                appId = qAuery[0];
                appKey = qAuery[1];
            } else if (qAuery.length == 3) {
                appId = qAuery[0];
                appKey = qAuery[1];
                token = qAuery[2];
            }
        }
        String result = null;
        switch (match) {
            case 1: {
                result = this.queryUser(appId, appKey, token);
                break;
            }
            case 2: {
                result = this.queryToken(appId, appKey, token);
                break;
            }
            case 3: {
                result = this.queryPush(appId, appKey, token);
                break;
            }
            case 4: {
                this.startApp(appId, appKey, token, this.makeExtras(data));
                return null;
            }
        }
        return result;
    }

    private String queryUser(String appId, String appKey, String token) {
        String result = null;
        try {
            String uName = GSharePre.get(this.getContext()).getUserName();
            String uPsw = GSharePre.get(this.getContext()).getUserPsw();
            uName = AppStoreURLMgr.getUserName();
            uPsw = AppStoreURLMgr.getPassWord();
            JSONObject json = new JSONObject();
            json.put(USER_NAME, (Object)uName);
            json.put(USER_PSW, (Object)uPsw);
            json.put(ATTACH, JSONObject.NULL);
            result = json.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String queryToken(String appId, String appKey, String token) {
        String result = GSharePre.get(this.getContext()).getToken();
        result = SharedPrefUtils.getString(this.getContext(), "mamStatus", "tgt", null);
        return result;
    }

    private String queryPush(String appId, String appKey, String token) {
        String result = null;
        return result;
    }

    private String startApp(String appId, String appKey, String token, Bundle data) {
        Log.i((String)"ldx", (String)"Provider: StartApp ++++");
        boolean appExist = true;
        boolean isInstalled = false;
        AppBean appBean = new AppBeanDao(this.getContext()).getAppBean(appId);
        if (appBean != null) {
            isInstalled = AppUtils.isNativeAppInstalled(this.getContext(), appBean.getPackageName());
        }
        if (appBean == null || !isInstalled) {
            return null;
        }
        String result = null;
        if (appExist) {
            try {
                Intent startApp = new Intent();
                startApp.setPackage(appBean.getPackageName());
                startApp.setAction("android.intent.action.map.MAIN");
                startApp.putExtras(data);
                startApp.setFlags(0x10000000);
                this.getContext().startActivity(startApp);
                result = "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    private Bundle makeExtras(String jsonStr) {
        Bundle result = new Bundle();
        try {
            JSONObject json = new JSONObject(jsonStr);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = json.optString(key);
                if (key == null || value == null) continue;
                result.putString(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported by this provider");
    }

    public <T> ParcelFileDescriptor openPipeHelper(Uri uri, String mimeType, Bundle opts, T args, ContentProvider.PipeDataWriter<T> func) throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported by this provider");
    }
}

