/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.zywx.wbpalmstar.base.BDebug;
import org.zywx.wbpalmstar.base.cache.DiskCache;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.ImageLoadTask;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.imageloader.LruCache;

public class ImageLoaderManager {
    private static final String TAG = "ImageCacheManager";
    public static final String MAP_KEY_BITMAP = "bitmap";
    public static final String MAP_KEY_TASK = "task";
    public static final int ACTION_LOAD_COMPLETED = 1;
    public static final int ACTION_LOAD_START = 2;
    public static final int ACTION_LOAD_COUNT = 3;
    public static final int ACTION_LOAD_FINISH = 4;
    public static final int DEFAULT_CONCURRENT_THREAD_SIZE = 3;
    public static final int SOFT_REFERENCE_MAX_SIZE = 40;
    public LruCache<String, Bitmap> memoryCache;
    private LinkedList<ImageLoadTask> taskList = new LinkedList();
    private ImageLoadStatusListener countListener;
    private static ImageLoaderManager loaderManager;
    private ExecutorService executorService;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    if (ImageLoaderManager.this.countListener == null) break;
                    ImageLoaderManager.this.countListener.onImageLoadStart(ImageLoaderManager.this);
                    break;
                }
                case 4: {
                    if (ImageLoaderManager.this.countListener == null) break;
                    ImageLoaderManager.this.countListener.onImageLoadFinish(ImageLoaderManager.this);
                }
            }
        }
    };

    private ImageLoaderManager(int maxConcurrentThreads, int memoryCacheSize) {
        this.memoryCache = new LruCache<String, Bitmap>(memoryCacheSize){

            @Override
            protected Bitmap create(String key) {
                return (Bitmap)super.create(key);
            }

            @Override
            protected int sizeOf(String key, Bitmap value) {
                if (value == null) {
                    return super.sizeOf(key, value);
                }
                int bytes = value.getRowBytes() * value.getHeight();
                return bytes;
            }

            @Override
            protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
            }
        };
        this.executorService = Executors.newFixedThreadPool(maxConcurrentThreads);
    }

    public static synchronized ImageLoaderManager getInstance(int maxConcurrentThreads, int memoryCacheSize) {
        if (loaderManager == null) {
            loaderManager = new ImageLoaderManager(maxConcurrentThreads, memoryCacheSize);
        }
        return loaderManager;
    }

    public static ImageLoaderManager getDefaultInstance() {
        return loaderManager;
    }

    public static ImageLoaderManager initImageLoaderManager(Context context) {
        if (context == null) {
            throw new NullPointerException("context can't be null!");
        }
        ImageLoaderManager imageLoaderManager = ImageLoaderManager.getDefaultInstance();
        if (imageLoaderManager == null) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            int memoryClass = activityManager.getMemoryClass();
            int memoryCacheSize = memoryClass / 8 * 1024 * 1024;
            imageLoaderManager = ImageLoaderManager.getInstance(3, memoryCacheSize);
        }
        DiskCache.initDiskCache((Context)context);
        return imageLoaderManager;
    }

    public Bitmap getCacheBitmap(String url) {
        if (url == null) {
            return null;
        }
        return this.memoryCache.get(url);
    }

    public void setOnCountListener(ImageLoadStatusListener listener) {
        this.countListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncLoad(ImageLoadTask task) {
        LinkedList<ImageLoadTask> linkedList = this.taskList;
        synchronized (linkedList) {
            int findIndex = this.taskList.indexOf(task);
            if (findIndex != -1) {
                ImageLoadTask item = this.taskList.get(findIndex);
                if (item.getStatus() == 0) {
                    this.taskList.remove(findIndex);
                    this.taskList.addLast(item);
                }
            } else {
                if (this.taskList.size() == 0) {
                    this.handler.sendEmptyMessage(2);
                }
                this.taskList.addLast(task);
                this.executorService.execute(new TaskWorker());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayTask(ImageLoadTask task) {
        LinkedList<ImageLoadTask> linkedList = this.taskList;
        synchronized (linkedList) {
            int index = this.taskList.lastIndexOf(task);
            if (index == -1) {
                this.taskList.addFirst(task);
                this.executorService.execute(new TaskWorker());
            }
        }
    }

    public void clear() {
        this.memoryCache.evictAll();
        this.removeAllTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTask() {
        LinkedList<ImageLoadTask> linkedList = this.taskList;
        synchronized (linkedList) {
            this.taskList.clear();
        }
    }

    public static interface ImageLoadStatusListener {
        public void onImageLoadStart(ImageLoaderManager var1);

        public void onImageLoadFinish(ImageLoaderManager var1);
    }

    private class TaskWorker
    implements Runnable {
        private TaskWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ImageLoadTask seekReadyTask() {
            LinkedList linkedList = ImageLoaderManager.this.taskList;
            synchronized (linkedList) {
                int i = ImageLoaderManager.this.taskList.size() - 1;
                while (i >= 0) {
                    ImageLoadTask loadTask = (ImageLoadTask)ImageLoaderManager.this.taskList.get(i);
                    if (loadTask.getStatus() == 0) {
                        loadTask.setStatus(1);
                        return loadTask;
                    }
                    --i;
                }
            }
            return null;
        }

        private Bitmap loadFromSource(ImageLoadTask loadTask) {
            Bitmap bitmap = loadTask.startExecute();
            if (bitmap != null) {
                DiskCache.writeDiskCache((String)loadTask.getKey(), (Bitmap)bitmap);
            }
            return bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                ImageLoadTask loadTask;
                int threadPriority = Process.getThreadPriority((int)Process.myTid());
                if (threadPriority != 19) {
                    Process.setThreadPriority((int)19);
                }
                if ((loadTask = this.seekReadyTask()) == null) {
                    ImageLoaderManager.this.handler.sendEmptyMessage(4);
                    return;
                }
                try {
                    try {
                        Bitmap bitmap = DiskCache.readCache((String)loadTask.getKey());
                        if (bitmap == null) {
                            bitmap = this.loadFromSource(loadTask);
                        }
                        if (bitmap != null) {
                            ImageLoaderManager.this.memoryCache.put(loadTask.filePath, bitmap);
                        }
                        final Bitmap finalBitmap = bitmap;
                        if (loadTask.getCallBack() != null) {
                            ImageLoaderManager.this.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    loadTask.performCallback(finalBitmap);
                                }
                            });
                        }
                    }
                    catch (OutOfMemoryError e) {
                        ImageLoaderManager.this.memoryCache.evictAll();
                        System.gc();
                        e.printStackTrace();
                        BDebug.e((String)ImageLoaderManager.TAG, (String)("OutOfMemoryError!!!!!!!!!!!!!!!!!!!!:" + e.getMessage()));
                        if (loadTask == null) break block21;
                        LinkedList linkedList = ImageLoaderManager.this.taskList;
                        synchronized (linkedList) {
                            ImageLoaderManager.this.taskList.remove(loadTask);
                            break block21;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (loadTask != null) {
                        LinkedList linkedList = ImageLoaderManager.this.taskList;
                        synchronized (linkedList) {
                            ImageLoaderManager.this.taskList.remove(loadTask);
                        }
                    }
                    throw throwable;
                }
                if (loadTask != null) {
                    LinkedList linkedList = ImageLoaderManager.this.taskList;
                    synchronized (linkedList) {
                        ImageLoaderManager.this.taskList.remove(loadTask);
                    }
                }
            }
        }
    }
}

