/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.ShowWapView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDb;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager3;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewFrameConfig;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.WidgetDataMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppUtils
implements AppStoreConstant {
    private static final String TAG = "AppUtils";
    private static final String KEY_MAIN_ACCESSTOKEN = "mainAccessToken";
    private static final String SPECIAL_PACKAGENAME_ZH = "com.lotus.sync.traveler";
    private static final String FIRST_ACTIVITY_ZH = "com.lotus.sync.traveler.LotusMail";

    public static void openApp(Context context, AppBean appBean, String info, boolean ischeckNativeVersion) {
        if (!AppStoreOptionVO.isOnAppClickCbToWeb()) {
            if (appBean != null) {
                switch (appBean.getType()) {
                    case 1: {
                        AppUtils.startWidgetWithBrowser(context, appBean.getDownloadUrl(), 1, info);
                        break;
                    }
                    case 2: {
                        if (ischeckNativeVersion && AppUtils.checkNativeUpdate(context, appBean, info)) break;
                    }
                    case 4: {
                        AppUtils.openNativeApp(context, appBean.getPackageName(), info);
                        break;
                    }
                    case 3: {
                        AppUtils.startWidget(appBean);
                        break;
                    }
                    default: {
                        LogUtils.logErrorO("openApp app Type error!!!");
                        break;
                    }
                }
            }
        } else {
            EUExAppStoreMgr.getInstance().onAppClick(appBean);
        }
    }

    private static boolean checkNativeUpdate(Context context, AppBean appBean, String info) {
        String maxVer = appBean.getMaxVersion();
        String installVer = appBean.getInstallVersion();
        boolean update = false;
        if (!TextUtils.isEmpty((CharSequence)maxVer) && !TextUtils.isEmpty((CharSequence)installVer) && maxVer.compareTo(installVer) > 0) {
            ViewDataManager mViewDataManager = EUExAppStoreMgr.isVisibleAppStroe ? ViewDataManager2.getInstance() : ViewDataManager3.getInstance();
            EMMStartUpVO mEmmStartUpVO = new EMMStartUpVO();
            mEmmStartUpVO.setNewAppUrl(appBean.getDownloadUrl());
            mEmmStartUpVO.setNewVersion(maxVer);
            mEmmStartUpVO.setNeedConfirm(true);
            mEmmStartUpVO.setForceUpdate(false);
            mEmmStartUpVO.setPkgType("upgrade");
            mViewDataManager.checkUpdate(context, appBean, mEmmStartUpVO, false, EUExAppStoreMgr.isVisibleAppStroe, mViewDataManager.getViewDataMgrCallBack(), EUExUtil.getString((String)"plugin_appstore_open"), info);
            update = true;
        }
        return update;
    }

    private static void startWidget(AppBean appBean) {
        String appId = appBean.getAppId();
        if (appId != null && !"".equals(appId)) {
            if (EUExAppStoreMgr.isVisibleAppStroe) {
                String js = "javascript:if(uexAppStoreMgr.startWidget){uexAppStoreMgr.startWidget('" + appId + "','" + 0 + "','" + appBean.getAppKey() + "');}";
                EUExAppStoreMgr.getInstance().onCallback(js);
            } else {
                EUExAppStoreMgr.cbLoadWidget(1, appBean, "");
            }
        }
    }

    private static void openNativeApp(Context context, String packageName, String info) {
        String mainAppId;
        try {
            mainAppId = AppStoreUtils.getMainAppId(context);
        }
        catch (Exception e) {
            LogUtils.i(TAG, "getAppId ERROR, use sharePreference");
            mainAppId = AppStoreUtils.getMainAppId(context);
        }
        String mainAccessToken = AppStoreTokenUtils.getAccessTokenByAppId(mainAppId, context);
        Bundle bundle = new Bundle();
        bundle.putString(KEY_MAIN_ACCESSTOKEN, mainAccessToken);
        if (!TextUtils.isEmpty((CharSequence)info)) {
            try {
                JSONObject jsonInfo = new JSONObject(info);
                Iterator it = jsonInfo.keys();
                String key = "";
                String value = "";
                LogUtils.logDebug(true, "open sub native App:");
                while (it.hasNext()) {
                    key = (String)it.next();
                    value = jsonInfo.optString(key);
                    bundle.putString(key, value);
                    LogUtils.logDebug(true, "key:" + key + " value:" + value);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        try {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
            if (SPECIAL_PACKAGENAME_ZH.equals(packageName)) {
                intent = new Intent();
                ComponentName cnName = new ComponentName(SPECIAL_PACKAGENAME_ZH, FIRST_ACTIVITY_ZH);
                intent.setComponent(cnName);
                intent.setFlags(0x10000000);
            }
            intent.putExtras(bundle);
            context.startActivity(intent);
        }
        catch (Exception e) {
            LogUtils.i(TAG, "android.intent.appCategory.LAUNCHER is not found :" + e.getMessage());
            try {
                String className = "";
                if (!SPECIAL_PACKAGENAME_ZH.equals(packageName)) {
                    PackageInfo pi = context.getPackageManager().getPackageInfo(packageName, 0);
                    Intent resolveIntent = new Intent("android.intent.action.MAIN", null);
                    resolveIntent.setPackage(pi.packageName);
                    List apps = context.getPackageManager().queryIntentActivities(resolveIntent, 0);
                    ResolveInfo ri = (ResolveInfo)apps.iterator().next();
                    if (ri != null) {
                        className = ri.activityInfo.name;
                    }
                } else {
                    className = FIRST_ACTIVITY_ZH;
                }
                if (!TextUtils.isEmpty((CharSequence)className)) {
                    Intent intent = new Intent("android.intent.action.MAIN");
                    ComponentName name = new ComponentName(packageName, className);
                    intent.setComponent(name);
                    intent.putExtras(bundle);
                    context.startActivity(intent);
                }
            }
            catch (PackageManager.NameNotFoundException ex) {
                LogUtils.i(TAG, "android.intent.action.MAIN is not found :" + ex.getMessage());
                Toast.makeText((Context)context, (CharSequence)EUExUtil.getString((String)"plugin_appstore_app_not_install"), (int)1).show();
            }
        }
    }

    public static void startWidgetWithBrowser(Context context, String url, int type, String appInfo) {
        if (!TextUtils.isEmpty((CharSequence)appInfo)) {
            url = AppStoreUtils.setWebUrlParams(url, appInfo);
        }
        if (type == 1 || type == 0) {
            EUExAppStoreMgr appStoreMgr = EUExAppStoreMgr.getInstance();
            ShowWapView view = new ShowWapView(context, appStoreMgr, type, url);
            ViewFrameConfig viewFrameConfig = appStoreMgr.getUserViewFrameConfig();
            int x = (int)viewFrameConfig.x;
            int y = 0;
            int w = (int)viewFrameConfig.width;
            int h = (int)viewFrameConfig.height + (int)viewFrameConfig.y;
            if (type == 0) {
                y = (int)viewFrameConfig.y;
                h = (int)viewFrameConfig.width;
            }
            if (Build.VERSION.SDK_INT <= 18) {
                float scale = appStoreMgr.getWebScale();
                w = (int)((float)w / scale);
                h = (int)((float)h / scale);
            }
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(w, h);
            lp.leftMargin = x;
            lp.topMargin = y;
            appStoreMgr.addViewToWebView("ShowWapActivity", (View)view, lp);
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.setData(Uri.parse((String)url));
            try {
                context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Toast.makeText((Context)context, (CharSequence)EUExUtil.getString((String)"plugin_appstore_operation_not_perform"), (int)0).show();
            }
        }
    }

    public static boolean isAppInstalled(Context context, AppBean appBean) {
        boolean isInstalled = false;
        switch (appBean.getType()) {
            case 2: 
            case 4: {
                isInstalled = AppUtils.isNativeAppInstalled(context, appBean.getPackageName());
                break;
            }
            case 3: {
                isInstalled = AppUtils.isWidgetInstalled(appBean.getAppId());
                break;
            }
            case 1: {
                break;
            }
            default: {
                LogUtils.logErrorO("isAppInstalled, app type error! appId:" + appBean.getAppId());
            }
        }
        return isInstalled;
    }

    public static boolean isNativeAppInstalled(Context context, String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfo = null;
            Log.w((String)TAG, (String)("packageNameNotFound==" + packageName + " " + e.getMessage()));
        }
        return packageInfo != null;
    }

    public static boolean isWidgetInstalled(String appId) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return false;
        }
        File[] dirList = FileUtils.getListFilesFromDir(AppStoreUtils.getWidgetSavePath());
        boolean isExistConfigFile = false;
        if (dirList != null) {
            int i = 0;
            while (i < dirList.length) {
                if (appId.equals(dirList[i].getName()) && dirList[i].isDirectory()) {
                    isExistConfigFile = FileUtils.isExistConfigFile(dirList[i]);
                    break;
                }
                ++i;
            }
        }
        return isExistConfigFile;
    }

    public static String getAppInstallVersion(AppBean appBean) {
        String installversion = appBean.getInstallVersion();
        installversion = TextUtils.isEmpty((CharSequence)installversion) || "null".endsWith(installversion) ? appBean.getCurVersion() : installversion;
        return installversion;
    }

    public static String getAppLocalVersion(Context context, AppBean appBean) {
        String version = "";
        switch (appBean.getType()) {
            case 2: {
                version = appBean.getInstallVersion();
                break;
            }
            case 4: {
                version = AppUtils.gatNativeAppLocalVersionName(context, appBean.getPackageName());
                break;
            }
            case 3: {
                version = AppUtils.getWidgetLocalVersion(AppStoreUtils.getConfigPathByAppId(appBean.getAppId()));
                break;
            }
            default: {
                LogUtils.logErrorO("getAppLocalVersion, app type error!");
            }
        }
        return version;
    }

    public static String gatNativeAppLocalVersionName(Context context, String packageName) {
        String versionName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static String getWidgetLocalVersion(String configFile) {
        String version = "";
        LogUtils.logDebug(true, "path:" + configFile);
        try {
            FileInputStream fis;
            if (!TextUtils.isEmpty((CharSequence)configFile) && (fis = FileUtils.getFileInputStream(configFile)) != null) {
                version = WidgetDataMgr.getWidgetDataOfXML((InputStream)fis).m_ver;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtils.logDebug(true, "getAppLocalVersion:" + version);
        return version;
    }

    public static String getAppUpgradeVersion(AppBean appBean) {
        String installVersion;
        String upgradeVersion = "";
        String maxVersion = appBean.getMaxVersion();
        upgradeVersion = !TextUtils.isEmpty((CharSequence)maxVersion) ? maxVersion : (!TextUtils.isEmpty((CharSequence)(installVersion = appBean.getInstallVersion())) ? installVersion : appBean.getCurVersion());
        return upgradeVersion;
    }

    public static void checkAppStatus(Context mContext, AppBean appBean, EMMStartUpVO mEmmStartUpInfo) {
        if ("000".equalsIgnoreCase(mEmmStartUpInfo.getWidgetStatus())) {
            if (TextUtils.isEmpty((CharSequence)mEmmStartUpInfo.getCloseHints()) || mEmmStartUpInfo.getCloseHints().equalsIgnoreCase("error")) {
                DialogView.showDialog(mContext, EUExUtil.getString((String)"plugin_appstore_sub_app_suspend_service"), appBean.getAppId());
            } else {
                DialogView.showDialog(mContext, mEmmStartUpInfo.getCloseHints(), appBean.getAppId());
            }
        }
    }

    public static void installApp(Context context, File file) {
        Uri uri = Uri.fromFile((File)file);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static void deleteApp(Context mContext, WWidgetData mWData, AppBean appBean) {
        File fi;
        if (appBean == null) {
            return;
        }
        if (AppUtils.isNativeApp(appBean.getType())) {
            if (AppUtils.isNativeAppInstalled(mContext, appBean.getPackageName())) {
                AppUtils.unInstallApp(mContext, appBean.getPackageName());
            } else {
                ViewDataManager.removeNativeApp(mContext, appBean);
            }
            return;
        }
        String installPath = AppStoreUtils.getWidgetInstallPath(appBean.getAppId());
        if (!TextUtils.isEmpty((CharSequence)installPath) && (fi = new File(installPath)).exists()) {
            FileUtils.DeleteFile(fi);
        }
        AppUtils.delAppCacheData(mContext, mWData, appBean);
    }

    public static void delAppCacheData(final Context context, final WWidgetData mWData, AppBean appBean) {
        final String appId = appBean.getAppId();
        ViewDataManager2.removeTask(appBean);
        AppStoreMainView.APP_PAUSE_LIST.remove(appBean);
        new AppBeanDao(context).updateAppState(appId, 0, "");
        new AppBeanDao(context).deleteDownFileWithDB(appBean);
        new AppBeanDao(context).deleteDefaultApp(appId);
        new AppBeanDao(context).deleteDownloadApp(appId);
        new AppBeanDao(context).deleteApp("app_list", appId);
        AppDownLoadDb.deleteTaskFromDB(context, appBean.getDownloadUrl());
        AppLocalDataManager.removeProgress(context, appId);
        new AsyncTask<Object, Object, Object>(){

            protected Object doInBackground(Object ... params) {
                return AppHttpDataManager.appUninstallReport(context, mWData, appId);
            }
        }.execute(new Object[0]);
        AppUtils.deleteAppData(appId);
    }

    public static void deleteAppData(String appId) {
        File fi;
        String appDataPath = AppStoreUtils.getWidgetDataSavePath(appId);
        if (!TextUtils.isEmpty((CharSequence)appDataPath) && (fi = new File(appDataPath)).exists()) {
            FileUtils.DeleteFile(fi);
        }
    }

    public static void unInstallApp(Context context, String packageName) {
        Uri packageURI = Uri.parse((String)("package:" + packageName));
        Intent uninstallIntent = new Intent("android.intent.action.DELETE", packageURI);
        context.startActivity(uninstallIntent);
    }

    public static boolean checkNewApp(Context mContext) {
        List<AppBean> apps = new AppBeanDao(mContext).getAppBeanList();
        if (apps == null || apps.size() == 0) {
            return false;
        }
        int i = 0;
        int length = apps.size();
        while (i < length) {
            if (apps.get(i).getNewApp() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String installSubWidget(Context context, ViewDataManager viewDataManager, String appId, String filePath, String desPath, String encoding) {
        String installPath = "";
        boolean isInvoke = false;
        try {
            try {
                Method installWidgetPatch = Class.forName("org.zywx.wbpalmstar.base.BUtility").getMethod("installSubWidget", String.class, String.class, String.class, String.class);
                try {
                    installPath = (String)installWidgetPatch.invoke((Object)viewDataManager, appId, filePath, desPath, encoding);
                    isInvoke = true;
                    return installPath;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    return installPath;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return installPath;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                return installPath;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                if (isInvoke) return installPath;
                LogUtils.logErrorO("App can not support dynamic loading plugins\uff01");
                try {
                    installPath = FileUtils.unzip(new FileInputStream(filePath), desPath, encoding);
                    return installPath;
                }
                catch (FileNotFoundException e2) {
                    e2.printStackTrace();
                }
                return installPath;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                if (isInvoke) return installPath;
                LogUtils.logErrorO("App can not support dynamic loading plugins\uff01");
                try {
                    installPath = FileUtils.unzip(new FileInputStream(filePath), desPath, encoding);
                    return installPath;
                }
                catch (FileNotFoundException e3) {
                    e3.printStackTrace();
                }
                return installPath;
            }
        }
        finally {
            if (!isInvoke) {
                LogUtils.logErrorO("App can not support dynamic loading plugins\uff01");
                try {
                    installPath = FileUtils.unzip(new FileInputStream(filePath), desPath, encoding);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isNativeApp(int appType) {
        return 2 == appType || 4 == appType;
    }

    public static void changeAppStateToInstall(Context context, WWidgetData mWidgetData, AppBean appBean) {
        new AppBeanDao(context).updateAppState(appBean.getAppId(), 4, null);
        AppHttpDataManager.appInstallReport(context, appBean, mWidgetData);
    }
}

