/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.Toast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter.AppDiscussListViewAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.XListView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppEvaluteVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppInfoDiscussView
extends AppInfoBaseView
implements View.OnClickListener,
AppStoreConstant {
    private String TAG = "StoreDiscuss";
    private XListView list;
    private static Context mContext;
    private AppDiscussListViewAdapter adapter;
    private AppBean appBean;
    private String indexIdDown;
    private LinearLayout pinglun;
    private static AppInfoDiscussView mAppDiscussFragment;
    private EUExAppStoreMgr mEuExAppStoreMgr;
    private WWidgetData mWgtData;

    public AppInfoDiscussView(Context context, EUExAppStoreMgr appStoreMgr, AppBean appBean, WWidgetData mWData) {
        super(context);
        mContext = context;
        this.mEuExAppStoreMgr = appStoreMgr;
        this.appBean = appBean;
        this.mWgtData = mWData;
        mAppDiscussFragment = this;
        this.onCreateView();
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (this.adapter == null) {
            GetAppEvaluteVO evaluteVO = new GetAppEvaluteVO();
            evaluteVO.setAppId(this.appBean.getAppId());
            this.downloadAppEvalute(evaluteVO);
        }
    }

    public View onCreateView() {
        this.rootView = LayoutInflater.from((Context)mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_app_details_discuss_listview"), (ViewGroup)this, false);
        this.pinglun = (LinearLayout)this.rootView.findViewById(EUExUtil.getResIdID((String)"pinglun"));
        this.list = (XListView)this.rootView.findViewById(EUExUtil.getResIdID((String)"listView"));
        this.list.setPullLoadEnable(true);
        this.list.setPullRefreshEnable(true);
        this.list.setXListViewListener(new ListViewIXListViewListener(this.list));
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        String time = sdf.format(new Date());
        this.list.setRefreshTime(time);
        this.pinglun.setOnClickListener((View.OnClickListener)this);
        return this.rootView;
    }

    private void downloadAppEvalute(GetAppEvaluteVO evaluteVO) {
        final String resCache = SharedPrefUtils.getString(mContext, "main_prefs", this.appBean.getAppId(), "");
        if (!NetworkUtils.isOnline(mContext) && TextUtils.isEmpty((CharSequence)resCache)) {
            Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            this.pinglun.setVisibility(0);
            return;
        }
        final Dialog progressDialog = DialogView.showLoadingDialog(mContext, EUExUtil.getString((String)"plugin_appstore_download_evalute"));
        progressDialog.show();
        try {
            AppHttpDataManager.getAppEvalute(mContext, this.mWgtData, evaluteVO, new AppStoteHttpURLConnection.HttpRequestMgr(){

                @Override
                public void onRequestComplete(String result) {
                    ArrayList<AppBean> commentList = null;
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        commentList = AppStoteDataParser.parseAppListWithKey("evaluteList", result);
                        SharedPrefUtils.putString(mContext, "main_prefs", AppInfoDiscussView.this.appBean.getAppId(), result);
                    } else {
                        LogUtils.e(AppInfoDiscussView.this.TAG, "NetworkUnavailable or appList is null");
                        if (!AppStatusVO.isForceConnected() && !TextUtils.isEmpty((CharSequence)resCache)) {
                            commentList = AppStoteDataParser.parseAppListWithKey("evaluteList", resCache);
                        }
                    }
                    if (progressDialog != null) {
                        progressDialog.dismiss();
                    }
                    if (commentList == null || commentList.size() == 0) {
                        Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
                        AppInfoDiscussView.this.pinglun.setVisibility(0);
                        LogUtils.i(AppInfoDiscussView.this.TAG, "no data");
                        return;
                    }
                    AppInfoDiscussView.this.list.setVisibility(0);
                    AppInfoDiscussView.this.pinglun.setVisibility(8);
                    int leng = commentList.size() - 1;
                    AppInfoDiscussView.this.indexIdDown = commentList.get(leng).getIndexId();
                    if (AppInfoDiscussView.this.adapter == null) {
                        AppInfoDiscussView.this.adapter = new AppDiscussListViewAdapter(mContext, AppInfoDiscussView.this.mEuExAppStoreMgr, commentList, AppInfoDiscussView.this.appBean);
                        AppInfoDiscussView.this.list.setAdapter((ListAdapter)AppInfoDiscussView.this.adapter);
                        LogUtils.i(AppInfoDiscussView.this.TAG, "setAdapter");
                    } else {
                        LogUtils.i(AppInfoDiscussView.this.TAG, "resumeLoad");
                        AppInfoDiscussView.this.adapter.resumeLoad(commentList);
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void refreshData(final XListView listView, GetAppEvaluteVO evaluteVO) {
        if (!NetworkUtils.isOnline(mContext)) {
            Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopRefresh();
            return;
        }
        try {
            AppHttpDataManager.getAppEvalute(mContext, this.mWgtData, evaluteVO, new AppStoteHttpURLConnection.HttpRequestMgr(){

                @Override
                public void onRequestComplete(String result) {
                    ArrayList<AppBean> commentList = AppStoteDataParser.parseAppListWithKey("evaluteList", result);
                    if (commentList == null || commentList.size() == 0) {
                        listView.stopRefresh();
                        Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_no_evalute"), (int)0).show();
                    }
                    if (AppInfoDiscussView.this.adapter != null) {
                        AppInfoDiscussView.this.adapter.reload(commentList);
                    } else {
                        AppInfoDiscussView.this.adapter = new AppDiscussListViewAdapter(mContext, AppInfoDiscussView.this.mEuExAppStoreMgr, commentList, AppInfoDiscussView.this.appBean);
                        listView.setAdapter((ListAdapter)AppInfoDiscussView.this.adapter);
                    }
                    listView.stopRefresh();
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                    String time = sdf.format(new Date());
                    listView.setRefreshTime(time);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void loadMoreData(final XListView listView, GetAppEvaluteVO evaluteVO) {
        if (!NetworkUtils.isOnline(mContext)) {
            Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            listView.stopLoadMore();
            return;
        }
        try {
            AppHttpDataManager.getAppEvalute(mContext, this.mWgtData, evaluteVO, new AppStoteHttpURLConnection.HttpRequestMgr(){

                @Override
                public void onRequestComplete(String result) {
                    ArrayList<AppBean> commentList = AppStoteDataParser.parseAppListWithKey("evaluteList", result);
                    if (commentList == null || commentList.size() == 0) {
                        listView.stopLoadMore();
                        Toast.makeText((Context)mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_no_more_evalute"), (int)0).show();
                        return;
                    }
                    int length = commentList.size() - 1;
                    AppInfoDiscussView.this.indexIdDown = commentList.get(length).getIndexId();
                    if (AppInfoDiscussView.this.adapter != null) {
                        AppInfoDiscussView.this.adapter.addList(commentList);
                    } else {
                        AppInfoDiscussView.this.adapter = new AppDiscussListViewAdapter(mContext, AppInfoDiscussView.this.mEuExAppStoreMgr, commentList, AppInfoDiscussView.this.appBean);
                        listView.setAdapter((ListAdapter)AppInfoDiscussView.this.adapter);
                    }
                    listView.stopLoadMore();
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void onClick(View v) {
        if (v == this.pinglun) {
            if (!AppStoreOptionVO.isShowAllViewsInWeb()) {
                this.mEuExAppStoreMgr.openSubmitAppEvaluate(this.appBean.getAppId());
            } else if (this.mEuExAppStoreMgr != null) {
                this.mEuExAppStoreMgr.onSubmitAppEvaluateClick(this.appBean);
            }
        }
    }

    public void refresh() {
        GetAppEvaluteVO evaluteVO = new GetAppEvaluteVO();
        evaluteVO.setAppId(this.appBean.getAppId());
        this.downloadAppEvalute(evaluteVO);
    }

    public static AppInfoDiscussView getInstance() {
        return mAppDiscussFragment;
    }

    class ListViewIXListViewListener
    implements XListView.IXListViewListener {
        XListView mListView;
        GetAppEvaluteVO evaluteVO = new GetAppEvaluteVO();

        public ListViewIXListViewListener(XListView listView) {
            this.mListView = listView;
            this.evaluteVO.setAppId(AppInfoDiscussView.this.appBean.getAppId());
        }

        @Override
        public void onRefresh() {
            this.evaluteVO.setAction("up");
            AppInfoDiscussView.this.refreshData(this.mListView, this.evaluteVO);
        }

        @Override
        public void onLoadMore() {
            this.evaluteVO.setAction("down");
            this.evaluteVO.setStartIndex(AppInfoDiscussView.this.indexIdDown);
            AppInfoDiscussView.this.loadMoreData(this.mListView, this.evaluteVO);
        }
    }
}

