/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.AppInfoDiscussView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppStoreMainView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppHttpDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.DialogView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.SubmitAppEvaluteVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class SubmitAppDiscussView
extends RelativeLayout
implements View.OnClickListener,
AppStoreConstant {
    public static final String TAG = "SubmitAppDiscussTAG";
    private TextView title;
    private ImageView back;
    private Button submitButton;
    private EditText content;
    private RatingBar score;
    private String appId;
    private EUExAppStoreMgr mEuExAppStoreMgr = null;
    private WWidgetData mWgtData;
    private Context mContext;

    public SubmitAppDiscussView(Context context, EUExAppStoreMgr appStoreMgr, WWidgetData mWidgetData, String appId) {
        super(context);
        this.mContext = context;
        this.mEuExAppStoreMgr = appStoreMgr;
        this.mWgtData = mWidgetData;
        this.appId = appId;
        LayoutInflater mInflater = LayoutInflater.from((Context)this.mContext);
        View rootView = mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_submit_app_discuss"), (ViewGroup)this, true);
        View titleLayout = this.findViewById(EUExUtil.getResIdID((String)"title"));
        if (AppStoreMainView.TITLE_HEIGHT > 0) {
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)titleLayout.getLayoutParams();
            lp.height = AppStoreMainView.TITLE_HEIGHT;
            titleLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (AppStoreOptionVO.isShowAllViewsInWeb()) {
            titleLayout.setVisibility(8);
        }
        this.title = (TextView)rootView.findViewById(EUExUtil.getResIdID((String)"centerTitle"));
        this.back = (ImageView)rootView.findViewById(EUExUtil.getResIdID((String)"back"));
        this.submitButton = (Button)rootView.findViewById(EUExUtil.getResIdID((String)"submitButton"));
        this.content = (EditText)rootView.findViewById(EUExUtil.getResIdID((String)"contentEdit"));
        this.score = (RatingBar)rootView.findViewById(EUExUtil.getResIdID((String)"userScore"));
        this.title.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_evalute_action"));
        this.back.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_back"));
        this.submitButton.setOnClickListener((View.OnClickListener)this);
        this.back.setOnClickListener((View.OnClickListener)this);
        this.back.setVisibility(0);
        this.score.setStepSize(1.0f);
    }

    public void onClick(View v) {
        if (v == this.back) {
            if (this.mEuExAppStoreMgr != null) {
                this.mEuExAppStoreMgr.closeSubmitAppEvaluate(new String[0]);
            }
        } else if (v == this.submitButton) {
            this.submitDiscuss(this.appId);
        }
    }

    public void onDetachedFromWindow() {
        if (this.mEuExAppStoreMgr != null) {
            this.mEuExAppStoreMgr.closeSubmitAppEvaluate(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    private void submitDiscuss(final String appId) {
        int appScore = (int)this.score.getRating();
        String appDiscuss = this.content.getText().toString().trim();
        String appScores = String.valueOf(appScore);
        if (appScore == 0) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_rate_app"), (int)0).show();
            return;
        }
        if (appDiscuss == null || appDiscuss.length() == 0) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_enter_comment"), (int)0).show();
            return;
        }
        if (appDiscuss.length() > 100) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_enter_comment_limit"), (int)0).show();
            return;
        }
        if (!NetworkUtils.isOnline(this.mContext)) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_error_network"), (int)0).show();
            return;
        }
        final Dialog progressDialog = DialogView.showLoadingDialog(this.mContext, EUExUtil.getString((String)"plugin_appstore_subit_comment"));
        progressDialog.show();
        try {
            SubmitAppEvaluteVO evaluteVO = new SubmitAppEvaluteVO();
            evaluteVO.setAppId(appId);
            evaluteVO.setEvaluteInfo(appDiscuss);
            evaluteVO.setStarLevel(appScores);
            evaluteVO.setUserName(UserInfoVO.getUserName());
            AppHttpDataManager.submitAppEvalute(this.mContext, this.mWgtData, evaluteVO, new AppStoteHttpURLConnection.HttpRequestMgr(){

                @Override
                public void onRequestComplete(String result) {
                    if (progressDialog != null) {
                        progressDialog.dismiss();
                    }
                    if (TextUtils.isEmpty((CharSequence)result) || "null".equalsIgnoreCase(result)) {
                        Toast.makeText((Context)SubmitAppDiscussView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_subit_comment_fail"), (int)0).show();
                        return;
                    }
                    try {
                        JSONObject jsonResult = new JSONObject(result);
                        String status = jsonResult.optString("status");
                        if (status.equals("ok")) {
                            if (SubmitAppDiscussView.this.mEuExAppStoreMgr != null) {
                                SubmitAppDiscussView.this.mEuExAppStoreMgr.closeSubmitAppEvaluate(new String[]{appId});
                                if (AppStoreOptionVO.isShowAllViewsInWeb()) {
                                    SubmitAppDiscussView.this.mEuExAppStoreMgr.onSubmitAppEvaluateComplete(appId);
                                }
                            }
                            Toast.makeText((Context)SubmitAppDiscussView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_subit_comment_success"), (int)0).show();
                            AppInfoDiscussView.getInstance().refresh();
                        } else {
                            Toast.makeText((Context)SubmitAppDiscussView.this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_subit_comment_fail"), (int)0).show();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            Log.e((String)"submitDiscuss", (String)e.getMessage());
        }
    }
}

