/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListFragment;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.CategoryFragment;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.NewAppListFragment;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.NiceAppListFragment;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.RankAppListFragment;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.MyHorizontalScrollView;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppListMainView
extends AppListBaseView
implements AppStoreConstant {
    public static final String TAG = "AppListMainActivity";
    private boolean isTitleClick = false;
    private MyHorizontalScrollView scrollView;
    private ArrayList<String> myTitleList = new ArrayList();
    private ViewPager mViewPager;
    private TextView title;
    private ImageView back;
    private ImageView search;
    private ArrayList<AppListFragment> fragmentsList;
    private AppListViewPagerAdapter appListViewAdapter;
    private EUExAppStoreMgr mAppStoreMgr;
    private WWidgetData mWgtData = null;

    public AppListMainView(Context context, EUExAppStoreMgr appStoreMgr, WWidgetData mWgt) {
        super(context);
        LayoutInflater.from((Context)this.mContext).inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_main"), (ViewGroup)this, true);
        this.mAppStoreMgr = appStoreMgr;
        this.mWgtData = mWgt;
        this.mViewPager = (ViewPager)this.findViewById(EUExUtil.getResIdID((String)"viewpager"));
        this.scrollView = (MyHorizontalScrollView)this.findViewById(EUExUtil.getResIdID((String)"scrollView"));
        this.title = (TextView)this.findViewById(EUExUtil.getResIdID((String)"centerTitle"));
        this.back = (ImageView)this.findViewById(EUExUtil.getResIdID((String)"back"));
        this.search = (ImageView)this.findViewById(EUExUtil.getResIdID((String)"search"));
        this.back.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_back"));
        this.search.setImageResource(EUExUtil.getResDrawableID((String)"plugin_appstoremgr_search"));
        this.title.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_str"));
        String softToken = AppStoreTokenUtils.getSoftToken(this.mContext);
        if (softToken == null || softToken.length() == 0) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_soft_token_null"), (int)0).show();
            this.closeAppListMainView();
            return;
        }
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AppListMainView.this.closeAppListMainView();
            }
        });
        this.search.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AppListMainView.this.mAppStoreMgr != null) {
                    AppListMainView.this.mAppStoreMgr.searchApp(new String[0]);
                }
            }
        });
        this.fragmentsList = new ArrayList();
        RankAppListFragment rankingFragment = new RankAppListFragment(this.mContext, this.mWgtData);
        CategoryFragment categoryFragment = new CategoryFragment(this.mContext, this.mWgtData);
        NewAppListFragment newFragment = new NewAppListFragment(this.mContext, this.mWgtData);
        int pageLimit = 3;
        NiceAppListFragment niceFragment = new NiceAppListFragment(this.mContext, this.mWgtData);
        this.fragmentsList.add(niceFragment);
        pageLimit = 4;
        this.fragmentsList.add(rankingFragment);
        this.fragmentsList.add(categoryFragment);
        this.fragmentsList.add(newFragment);
        this.myTitleList.add(0, EUExUtil.getString((String)"plugin_appstore_boutique_list"));
        this.myTitleList.add(1, EUExUtil.getString((String)"plugin_appstore_rank_list"));
        this.myTitleList.add(2, EUExUtil.getString((String)"plugin_appstore_category_list"));
        this.myTitleList.add(3, EUExUtil.getString((String)"plugin_appstore_new_list"));
        this.scrollView.setAnim(true);
        this.scrollView.setPager(this.mViewPager);
        this.scrollView.setAllTitle(this.myTitleList, this);
        this.appListViewAdapter = new AppListViewPagerAdapter(this.mViewPager, this.fragmentsList);
        this.mViewPager.setAdapter((PagerAdapter)this.appListViewAdapter);
        this.mViewPager.setCurrentItem(0);
        this.mViewPager.setOffscreenPageLimit(pageLimit);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int arg0) {
                AppListMainView.this.scrollView.setViewPager(arg0);
                ((AppListFragment)AppListMainView.this.fragmentsList.get(arg0)).setUserVisibleHint(true);
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageScrollStateChanged(int arg0) {
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
        this.appListViewAdapter.notifyDataSetChanged();
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mAppStoreMgr != null) {
            this.mAppStoreMgr.closeAppStore(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    private void closeAppListMainView() {
        if (this.mAppStoreMgr != null) {
            this.mAppStoreMgr.closeAppStore(new String[0]);
        }
    }

    public boolean isTitleClick() {
        return this.isTitleClick;
    }

    public void setTitleClick(boolean isTitleClick) {
        this.isTitleClick = isTitleClick;
    }

    public static class AppListViewPagerAdapter
    extends PagerAdapter {
        private ArrayList<AppListFragment> fragmentList;
        private ViewPager mViewPager;

        public AppListViewPagerAdapter(ViewPager viewPager, ArrayList<AppListFragment> fragmentList) {
            this.mViewPager = viewPager;
            this.fragmentList = fragmentList;
        }

        public int getCount() {
            return this.fragmentList.size();
        }

        public AppListFragment getItem(int position) {
            return this.fragmentList.get(position);
        }

        public Object instantiateItem(ViewGroup viewGroup, int postion) {
            View viewItem = null;
            if (postion < this.fragmentList.size()) {
                viewItem = this.fragmentList.get((int)postion).rootView;
                this.mViewPager.addView(viewItem, postion);
            }
            return viewItem;
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }
    }
}

