/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.appInfoView.adapter.AppAdPagerAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.applistView.AppListBaseView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.AppTileListAdapter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.apptile.AppTileListAdapterScroll;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppLocalDataManager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTaskList;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppTileBeanDao;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.ViewDataManager2;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewFrameConfig;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.ChildViewPager;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.HeaderGridView;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.PageIndicator;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.view.ScrollLayout;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileOptionVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppTileMainView
extends AppListBaseView
implements ViewDataManager2.AppStoreDataCallback,
AppStoreConstant {
    protected static final long AD_SLIDE_DELAY_TIME = 10000L;
    public static int TITLE_HEIGHT = 0;
    public static int AD_HEIGHT = 0;
    public static int PAGER_TOP = 10;
    public static int ROWS = 3;
    public static int DEFAULT_ITEM_HEIGHT = 130;
    public static final int ACTION_ADD_APP_CODE = 0;
    public static final int GRID_ITEMS_PER_PAGER = 8;
    private static AppTileMainView mAppTileActivity = null;
    private HeaderGridView mAppsTileListGridView;
    private AppTileListAdapter appsTileAdapter;
    private ScrollLayout mAppsTileScrollLayout;
    private AppTileListAdapterScroll appsTileAdapterScoll;
    private PageIndicator mTilePageIndicator;
    private Button mDelTileOkBtn;
    private TextView mEnterMCMTextView;
    private LinearLayout mMCMTitleLayout;
    private View mAdViewPagerLayout;
    private ChildViewPager mAdViewPager;
    private PageIndicator mAdPageIndicator;
    private int currentPageState = 0;
    private AppAdPagerAdapter adPagerAdapter;
    private LayoutInflater mInflater;
    private View.OnClickListener mMCMOnClickListener;
    public static final String TAG = "AppTileMainActivity";
    private ViewFrameConfig mViewFrameConfig = new ViewFrameConfig();
    private int mainActivityHeight;
    private int tileHeightScroll;
    private EUExAppStoreMgr mEUExAppStoreMgr;
    private WWidgetData mWgtData;
    private float htmlScale;
    private float nowScale;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (AppTileMainView.this.mAdViewPager == null) {
                        return;
                    }
                    if (AppTileMainView.this.currentPageState == 0 && AppTileMainView.this.mAdViewPager.getAdapter() != null) {
                        int current = AppTileMainView.this.mAdViewPager.getCurrentItem();
                        AppTileMainView.this.mAdViewPager.setCurrentItem(current + 1, true);
                    }
                    if (AppTileMainView.this.adPagerAdapter.getActualCount() == 1) break;
                    AppTileMainView.this.handler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
    };

    public AppTileMainView(Context context, EUExAppStoreMgr mAppStoreMgr, WWidgetData mWidgetData, ViewFrameConfig vConfig, int hight, float scale, float nowScale) {
        super(context);
        mAppTileActivity = this;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        EUExUtil.init((Context)this.mContext);
        this.mainActivityHeight = hight;
        this.mViewFrameConfig = vConfig;
        this.mWgtData = mWidgetData;
        this.mEUExAppStoreMgr = mAppStoreMgr;
        this.htmlScale = scale;
        this.nowScale = nowScale;
        this.init();
    }

    private boolean isShowMCMDocument() {
        boolean isMCMExist = AppStoreUtils.isMCMExist();
        boolean optionShowMCM = AppStoreOptionVO.isShowMCMDocument();
        return optionShowMCM ? isMCMExist : false;
    }

    private void initData() {
        new ViewDataManager2(this.mContext, this.mWgtData, this.mEUExAppStoreMgr, this);
        ViewDataManager2.performAsyncLoadMyAppListDataAction(this.mContext, this.mWgtData, AppStoreURLMgr.getUrlInstallAppList(), this, this.isShowMCMDocument(), AppStoreOptionVO.isShowAdView(), true);
    }

    private void init() {
        this.initData();
        this.initView();
    }

    private void initView() {
        View rootView = null;
        if (AppTileOptionVO.isShowAllTileInOnePage()) {
            if (this.mAppsTileListGridView == null) {
                this.removeAllViewsInLayout();
                if (this.mAppsTileScrollLayout != null) {
                    this.mAppsTileScrollLayout = null;
                }
            } else {
                return;
            }
            rootView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_tile_main_layout"), (ViewGroup)this, true);
            this.mAppsTileListGridView = (HeaderGridView)rootView.findViewById(EUExUtil.getResIdID((String)"app_tile_headergridview"));
            this.mAppsTileScrollLayout = null;
        } else {
            if (this.mAppsTileScrollLayout == null) {
                this.removeAllViewsInLayout();
                if (this.mAppsTileScrollLayout != null) {
                    this.mAppsTileScrollLayout = null;
                }
            } else {
                return;
            }
            rootView = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_tile_main_layout_scroll"), (ViewGroup)this, true);
            this.mAppsTileScrollLayout = (ScrollLayout)rootView.findViewById(EUExUtil.getResIdID((String)"app_tile_scroll_layout"));
            this.mTilePageIndicator = (PageIndicator)rootView.findViewById(EUExUtil.getResIdID((String)"tile_page_indictor"));
            this.mAppsTileListGridView = null;
        }
        if (this.htmlScale == 0.0f) {
            final View contextView = ((Activity)this.mContext).getWindow().getDecorView();
            ViewTreeObserver vto = contextView.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    int height = contextView.getMeasuredHeight();
                    int width = contextView.getMeasuredWidth();
                    Log.i((String)AppTileMainView.TAG, (String)("onGlobalLayoutheight==" + height + " width==" + width));
                    TITLE_HEIGHT = AppTileMainView.this.mainActivityHeight - height;
                    System.out.println("mainActivityHeight:" + AppTileMainView.this.mainActivityHeight + " height:" + height);
                    contextView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            });
        } else {
            TITLE_HEIGHT = (int)(this.mViewFrameConfig.y * this.htmlScale);
            System.out.println("TITLE_HEIGHT:" + TITLE_HEIGHT + " scale:" + this.htmlScale);
        }
        this.setupNewUI(rootView);
    }

    private void setupNewUI(View rootView) {
        this.mMCMOnClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (v == AppTileMainView.this.mEnterMCMTextView) {
                    AppTileMainView.this.mEUExAppStoreMgr.cbStartMCM("");
                } else {
                    Object obj = v.getTag();
                    if (obj != null && obj instanceof AppBean) {
                        AppBean appBean = (AppBean)obj;
                        AppTileMainView.this.mEUExAppStoreMgr.cbStartMCM(appBean.getMcmDocumentTitleJsonData());
                    }
                }
            }
        };
        this.mDelTileOkBtn = (Button)rootView.findViewById(EUExUtil.getResIdID((String)"plugin_appstoremgr_del_tile_ok_button"));
        this.mAdViewPagerLayout = this.mInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_appstoremgr_adv_viewpager_layout"), null);
        this.mAdViewPager = (ChildViewPager)this.mAdViewPagerLayout.findViewById(EUExUtil.getResIdID((String)"ad_viewpager"));
        this.mAdViewPager.setBackgroundColor(-1);
        this.mAdPageIndicator = (PageIndicator)this.mAdViewPagerLayout.findViewById(EUExUtil.getResIdID((String)"ad_page_indictor"));
        this.mAdViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrollStateChanged(int state) {
                AppTileMainView.this.currentPageState = state;
            }

            public void onPageScrolled(int arg0, float arg1, int arg2) {
            }

            public void onPageSelected(int index) {
                AppTileMainView.this.currentPageState = 0;
                int pageCount = AppTileMainView.this.adPagerAdapter.getActualCount();
                if (pageCount != 0) {
                    int nowIndex = index % pageCount;
                    AppTileMainView.this.mAdPageIndicator.setCurrentPage(nowIndex);
                    AppTileMainView.this.mAdViewPager.setmIndex(nowIndex);
                }
            }
        });
        this.mAdViewPager.setOnSingleTouchListener(new ChildViewPager.OnSingleTouchListener(){

            @Override
            public void onSingleTouch(int position) {
                ((AppAdPagerAdapter)AppTileMainView.this.mAdViewPager.getAdapter()).onADPageClick(position, AppTileMainView.this.mEUExAppStoreMgr);
            }
        });
        if (!AppStoreOptionVO.isShowAdView()) {
            this.mAdViewPagerLayout.setVisibility(8);
            this.mAdViewPager.setVisibility(8);
            this.mAdPageIndicator.setVisibility(8);
        }
        this.mEnterMCMTextView = new TextView(this.mContext);
        this.mEnterMCMTextView.setGravity(5);
        this.mEnterMCMTextView.setTextColor(this.getResources().getColorStateList(EUExUtil.getResColorID((String)"plugin_appstoremgr_mcmtitle_item_text_color_selector")));
        this.mEnterMCMTextView.setClickable(true);
        this.mEnterMCMTextView.setText((CharSequence)EUExUtil.getString((String)"plugin_appstore_into_document_center"));
        this.mEnterMCMTextView.setOnClickListener(this.mMCMOnClickListener);
        this.mMCMTitleLayout = new LinearLayout(this.mContext);
        this.mMCMTitleLayout.setOrientation(1);
        if (!this.isShowMCMDocument()) {
            this.mEnterMCMTextView.setVisibility(8);
            this.mMCMTitleLayout.setVisibility(8);
        }
        if (AppTileOptionVO.isShowAllTileInOnePage()) {
            this.mAppsTileListGridView.addHeaderView(this.mAdViewPagerLayout);
            this.mAppsTileListGridView.addHeaderView((View)this.mEnterMCMTextView);
            this.mAppsTileListGridView.addHeaderView((View)this.mMCMTitleLayout);
        }
        int tileWidth = ViewUtils.getTileItemWidth(this.mViewFrameConfig.width, 3, this.nowScale);
        this.tileHeightScroll = ViewUtils.getTileItemHight(this.mViewFrameConfig.height, this.getDeltetAppOkBtnHight(), 4, this.nowScale);
        int tileHeight = ViewUtils.getTileItemHight(this.mViewFrameConfig.height, 0, 4, this.nowScale);
        SharedPrefUtils.putInt(this.mContext, "pluginAppStoreTileViewConfig", "pluginAppStoreTileWidth", tileWidth);
        SharedPrefUtils.putInt(this.mContext, "pluginAppStoreTileViewConfig", "pluginAppStoreTileHeight", tileHeight);
        SharedPrefUtils.putInt(this.mContext, "pluginAppStoreTileViewConfig", "pluginAppStoreTileHeightScroll", this.tileHeightScroll);
    }

    private void refreshAllData(ViewDataManager2.AppStoreData data, boolean isNetworkData) {
        if (data == null) {
            Toast.makeText((Context)this.mContext, (CharSequence)EUExUtil.getString((String)"plugin_appstore_hint_no_data"), (int)0).show();
            this.refreshAppTileData(null, isNetworkData);
            this.handler.removeMessages(1);
            return;
        }
        if (AppStoreOptionVO.isShowAdView()) {
            this.refreshAdData(data.adList);
        }
        if (this.isShowMCMDocument()) {
            this.refreshMCMData(data.mcmTitleList);
        }
        this.refreshAppTileData(data.tileList, isNetworkData);
    }

    private void refreshAdData(List<AppBean> adList) {
        if (adList == null || adList.size() <= 0) {
            this.handler.removeMessages(1);
            this.mAdViewPagerLayout.setVisibility(8);
            LogUtils.i(TAG, "refreshAdData: AD list is not exist");
            return;
        }
        this.mAdViewPagerLayout.setVisibility(0);
        List<AppBean> brandADs = adList;
        int adPageSize = brandADs.size();
        if (this.adPagerAdapter == null) {
            this.adPagerAdapter = new AppAdPagerAdapter(this.mContext, brandADs, this.mAdViewPager);
            this.mAdViewPager.setAdapter(this.adPagerAdapter);
        } else {
            this.adPagerAdapter.refreshAdData(brandADs);
        }
        this.mAdPageIndicator.setTotalPageSize(adPageSize);
        int maxSize = 65535;
        int pos = maxSize / 2 - maxSize / 2 % adPageSize;
        this.mAdViewPager.setCurrentItem(pos, true);
        this.handler.sendEmptyMessage(1);
    }

    private void refreshMCMData(List<AppBean> mcmTitleList) {
        if (mcmTitleList == null || mcmTitleList.size() == 0) {
            this.mMCMTitleLayout.setVisibility(8);
            LogUtils.i(TAG, "mcmTitleList is empty");
            return;
        }
        this.mMCMTitleLayout.setVisibility(0);
        this.mMCMTitleLayout.removeAllViews();
        int i = 0;
        while (i < mcmTitleList.size()) {
            AppBean appBean = mcmTitleList.get(i);
            TextView mcmTitleItem = (TextView)View.inflate((Context)this.mContext, (int)EUExUtil.getResLayoutID((String)"plugin_appstoremgr_mcmtitle_item"), null);
            mcmTitleItem.setText((CharSequence)appBean.getMcmDocumentTitle());
            mcmTitleItem.setTextSize(16.0f);
            mcmTitleItem.setSingleLine(true);
            mcmTitleItem.setTag((Object)appBean);
            mcmTitleItem.setEms(13);
            mcmTitleItem.setEllipsize(TextUtils.TruncateAt.END);
            mcmTitleItem.setOnClickListener(this.mMCMOnClickListener);
            this.mMCMTitleLayout.addView((View)mcmTitleItem);
            ++i;
        }
    }

    private void updateTileUI(List<AppTileBean> tilesList) {
        JSONObject json = new JSONObject();
        try {
            json.put("IS_HOME_PAGE", true);
            json.put("IS_SHOW_ADD_TILE_ICON", !AppStoreOptionVO.isShowAllAppsInMain());
            json.put("IS_ADD_TILE_ICON_FIRST", false);
            json.put("CAN_DEL_TILE", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.appsTileAdapter = new AppTileListAdapter(this, this.mContext, tilesList, this.mAppsTileListGridView, json);
        this.mAppsTileListGridView.setAdapter((ListAdapter)this.appsTileAdapter);
    }

    private void updateTileUIScoll(List<AppTileBean> tilesList) {
        JSONObject json = new JSONObject();
        try {
            json.put("IS_HOME_PAGE", true);
            json.put("IS_SHOW_ADD_TILE_ICON", !AppStoreOptionVO.isShowAllAppsInMain());
            json.put("IS_ADD_TILE_ICON_FIRST", false);
            json.put("CAN_DEL_TILE", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.appsTileAdapterScoll = new AppTileListAdapterScroll(this, this.mContext, tilesList, this.mAppsTileScrollLayout, json);
        int pageSize = (int)Math.ceil((float)(tilesList.size() + 1) / 12.0f);
        this.mAppsTileScrollLayout.setColCount(3);
        this.mAppsTileScrollLayout.setLineCount(4);
        this.mAppsTileScrollLayout.setAdapter(this.appsTileAdapterScoll);
        this.mTilePageIndicator.initViews();
        RelativeLayout.LayoutParams lParams = (RelativeLayout.LayoutParams)this.mTilePageIndicator.getLayoutParams();
        lParams.height = (int)((float)this.tileHeightScroll * 0.15f);
        this.mTilePageIndicator.setLayoutParams((ViewGroup.LayoutParams)lParams);
        this.mTilePageIndicator.setTotalPageSize(pageSize);
        this.mTilePageIndicator.setCurrentPage(0);
        this.mAppsTileScrollLayout.setOnPageChangedListener(new ScrollLayout.OnPageChangedListener(){

            @Override
            public void onPage2Other(int totalPage, int former, int current) {
                AppTileMainView.this.mTilePageIndicator.setTotalPageSize(totalPage);
                AppTileMainView.this.mTilePageIndicator.setCurrentPage(current);
            }
        });
        this.mAppsTileScrollLayout.refreView();
    }

    private void refreshAppData(List<AppBean> netAppList) {
        List<AppBean> localAppList = new AppBeanDao(this.mContext).getAppBeanList();
        AppLocalDataManager.refrshAppData(this.mContext, netAppList, localAppList, true);
    }

    private void refreshAppTileData(List<AppTileBean> serverTileList, boolean isNetworkData) {
        List<AppTileBean> localTileList = new AppTileBeanDao(this.mContext).getAppTileList();
        if (serverTileList != null) {
            if (isNetworkData) {
                if (serverTileList == null || serverTileList.size() == 0) {
                    ViewUtils.showToast(this.mContext, EUExUtil.getString((String)"plugin_appstore_hint_no_data"), 1);
                }
                AppLocalDataManager.refrshAppTileData(this.mContext, serverTileList, localTileList);
            }
        } else {
            LogUtils.i(TAG, "tilesList is null, use local data");
        }
        if (isNetworkData) {
            localTileList = new AppTileBeanDao(this.mContext).getAppTileList();
        }
        List<AppTileBean> showList = AppTileBean.getShowTileList(this.mContext, localTileList);
        if (AppTileOptionVO.isShowAllTileInOnePage()) {
            this.updateTileUI(showList);
        } else {
            this.updateTileUIScoll(showList);
        }
    }

    @Override
    public void refreshLocalData() {
        this.refreshLocalAppTileData();
    }

    public void refresh() {
        this.initView();
        this.refreshLocalAppTileData();
    }

    public void refreshLocalAppTileData() {
        List<AppTileBean> appTile = new AppTileBeanDao(this.mContext).getAppTileList();
        this.refreshAppTileData(appTile, false);
    }

    @Override
    public void callBackAllRes(final ViewDataManager2.AppStoreData result) {
        ((Activity)this.mContext).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (result == null) {
                    AppTileMainView.this.refreshAllData(null, false);
                    return;
                }
                if (AppStoreOptionVO.isShowAdView()) {
                    AppTileMainView.this.refreshAdData(result.adList);
                }
                if (AppTileMainView.this.isShowMCMDocument()) {
                    AppTileMainView.this.refreshMCMData(result.mcmTitleList);
                }
                AppTileMainView.this.refreshAppData(result.appList);
                AppTileMainView.this.refreshAppTileData(result.tileList, true);
                AppTileMainView.this.mEUExAppStoreMgr.cbOpenTilesHomePage();
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                AppTaskList appsTaskList = ViewDataManager2.getAppTaskList();
                if (appsTaskList != null && !appsTaskList.isEmpty()) {
                    LogUtils.i(TAG, "onBackKeyDown with AppTaskList isn't null");
                    return true;
                }
                LogUtils.i(TAG, "onBackKeyDown");
                return false;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                return false;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mEUExAppStoreMgr != null) {
            this.mEUExAppStoreMgr.closeTilesHomePage(new String[0]);
        }
        super.onDetachedFromWindow();
    }

    @Override
    public void onResume() {
        super.onResume();
        Log.i((String)TAG, (String)"AppTileMainActivity onResume");
        this.currentPageState = 0;
    }

    public static AppTileMainView getInstance() {
        return mAppTileActivity;
    }

    public Button getDeltetAppOkButton() {
        return this.mDelTileOkBtn;
    }

    public int getDeltetAppOkBtnHight() {
        return this.mDelTileOkBtn.getLayoutParams().height + 20;
    }

    public void finishWidget(String appId) {
        this.mEUExAppStoreMgr.cbToFinishWidget(appId);
    }

    public void adClick(String url) {
        this.mEUExAppStoreMgr.adPicClick(url);
    }

    public EUExAppStoreMgr getEUExAppStoreMgrInstance() {
        return this.mEUExAppStoreMgr;
    }
}

