/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDbHelper;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppDownLoadDbHelper;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;

public class AppBeanDao
implements AppStoreConstant {
    private AppDbHelper dbHelper;
    private String TAG = "AppBeanDao";
    private Context mContext;

    public AppBeanDao(Context context) {
        this.mContext = context;
        this.dbHelper = new AppDbHelper(context);
    }

    public void addAppBean(String table, AppBean appBean) {
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
            String sql = "SELECT * FROM " + table + " WHERE " + UserInfoVO.toDbSqlString() + " and " + "appId" + "='" + appBean.getAppId() + "'";
            Cursor c = db.rawQuery(sql, new String[0]);
            if (c != null && c.getCount() > 0) {
                return;
            }
            try {
                ContentValues cv = new ContentValues(7);
                cv.put("store_id", appBean.getId());
                cv.put("app_key", appBean.getAppKey());
                cv.put("app_name", appBean.getAppName());
                cv.put("type", Integer.valueOf(appBean.getType()));
                cv.put("download_url", appBean.getDownloadUrl());
                cv.put("icon_url", appBean.getIconLoc());
                cv.put("state", Integer.valueOf(appBean.getState()));
                cv.put("install_path", appBean.getInstallPath());
                cv.put("app_ver", AppUtils.getAppInstallVersion(appBean));
                cv.put("max_ver", appBean.getMaxVersion());
                cv.put("certificates_path", appBean.getCertificatesPath());
                cv.put("certificates_pwd", appBean.getCertificatesPwd());
                cv.put("package_name", appBean.getPackageName());
                cv.put("certificates_url", appBean.getCertificatesUrl());
                cv.put("appId", appBean.getAppId());
                cv.put("mainApp", appBean.getMainApp());
                cv.put("wgtAppId", appBean.getWgtAppId());
                cv.put("default_app", Integer.valueOf(appBean.getDefaultApp()));
                cv.put("remain_app", Integer.valueOf(appBean.getRemainApp()));
                cv.put("new_app", Integer.valueOf(appBean.getNewApp()));
                cv.put("app_size", appBean.getAppSize());
                cv.put("isOmmApp", appBean.getIsOMMApp());
                cv.put("tenantAccount", UserInfoVO.getTenantAccount());
                cv.put("domainName", UserInfoVO.getDomainName());
                cv.put("loginName", UserInfoVO.getUserName());
                long rowId = db.insert(table, null, cv);
                LogUtils.logDebug(true, "addAppBean rowId = " + rowId);
            }
            catch (SQLException e) {
                LogUtils.oe("addAppBean", (Exception)((Object)e));
            }
        }
        finally {
            db.close();
        }
    }

    public void deleteAllFromTable(String table) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "DELETE FROM " + table;
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                    db = null;
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
                db = null;
            }
        }
    }

    public void addAppList(String table, List<AppBean> list) {
        if (list == null || list.size() < 1) {
            return;
        }
        try {
            int size = list.size();
            int i = 0;
            while (i < size) {
                AppBean appBean = list.get(i);
                if (appBean != null) {
                    this.addAppBean(table, appBean);
                }
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteApp(String table, String appId) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                if (!TextUtils.isEmpty((CharSequence)appId) && !"null".equalsIgnoreCase(appId)) {
                    String deleteSql = "DELETE FROM " + table + " WHERE " + "appId" + "='" + appId + "'";
                    db.execSQL(deleteSql);
                    LogUtils.logDebug(true, "deleteSql:" + deleteSql);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void updateDownloadUrl(String tabName, String appId, String downloadUrl) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "Update " + tabName + " set " + "download_url" + " = '" + downloadUrl + "'" + " where " + "appId" + " = '" + appId + "'";
                LogUtils.logDebug(true, "updateDownloadUrl sql:" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void updatePackageName(String tabName, String appId, String packageName) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "Update " + tabName + " set " + "package_name" + " = '" + packageName + "'" + " where " + "appId" + " = '" + appId + "'";
                LogUtils.logDebug(true, "updatePackageName sql\uff1a" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void updateAppVer(AppBean appBean, String installVer) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "Update app_list set app_ver = '" + installVer + "'," + "max_ver" + " = '" + appBean.getMaxVersion() + "'," + "install_path" + " = '" + appBean.getInstallVersion() + "' where " + UserInfoVO.toDbSqlString() + " and " + "appId" + " = '" + appBean.getAppId() + "'";
                LogUtils.logDebug(true, "updateAppVer sql:" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void updateAppState(String appId, int state, String installPath) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "Update app_list set state = '" + state + "', " + "install_path" + "='" + installPath + "'" + " where " + "appId" + " = '" + appId + "'";
                LogUtils.logDebug(true, "updateAppState sql\uff1a" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void updateAppLocatData(AppBean appBean) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "Update app_list set store_id = '" + appBean.getId() + "', " + "app_key" + " = '" + appBean.getAppKey() + "', " + "app_name" + " = '" + appBean.getAppName() + "', " + "type" + " = '" + appBean.getType() + "', " + "download_url" + " = '" + appBean.getDownloadUrl() + "', " + "icon_url" + " = '" + appBean.getIconLoc() + "', " + "mainApp" + " = '" + appBean.getMainApp() + "', " + "certificates_path" + " = '" + appBean.getCertificatesPath() + "', " + "certificates_pwd" + " = '" + appBean.getCertificatesPwd() + "', " + "certificates_url" + " = '" + appBean.getCertificatesUrl() + "', " + "package_name" + " = '" + appBean.getPackageName() + "', " + "default_app" + " = '" + appBean.getDefaultApp() + "', " + "remain_app" + " = '" + appBean.getRemainApp() + "', " + "app_size" + " = '" + appBean.getAppSize() + "', " + "isOmmApp" + " = '" + appBean.getIsOMMApp() + "', " + "max_ver" + "='" + appBean.getMaxVersion() + "'" + " where " + "appId" + " = '" + appBean.getAppId() + "'";
                LogUtils.logDebug(true, "updateAppLocatData sql\uff1a" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    private List<AppBean> getAppBeanList(String sql) {
        ArrayList<AppBean> list = new ArrayList<AppBean>();
        SQLiteDatabase db = null;
        Cursor cursor = null;
        try {
            try {
                db = this.dbHelper.getReadableDatabase();
                cursor = db.rawQuery(sql, new String[0]);
                if (cursor != null) {
                    int storeIdIndex = cursor.getColumnIndex("store_id");
                    int appNameIndex = cursor.getColumnIndex("app_name");
                    int appTypeIndex = cursor.getColumnIndex("type");
                    int downloadUrlIndex = cursor.getColumnIndex("download_url");
                    int iconUrlIndex = cursor.getColumnIndex("icon_url");
                    int stateIndex = cursor.getColumnIndex("state");
                    int installPathIndex = cursor.getColumnIndex("install_path");
                    int installVerIndex = cursor.getColumnIndex("app_ver");
                    int maxVerIndex = cursor.getColumnIndex("max_ver");
                    int certificatesPathIndex = cursor.getColumnIndex("certificates_path");
                    int certificatesPwdIndex = cursor.getColumnIndex("certificates_pwd");
                    int packageNameIndex = cursor.getColumnIndex("package_name");
                    int certificatesUrlIndex = cursor.getColumnIndex("certificates_url");
                    int appIdIndex = cursor.getColumnIndex("appId");
                    int wgtAppIdIndex = cursor.getColumnIndex("wgtAppId");
                    int mainAppIndex = cursor.getColumnIndex("mainApp");
                    int newAppIndex = cursor.getColumnIndex("new_app");
                    int appSizeIndex = cursor.getColumnIndex("app_size");
                    int appKeyIndex = cursor.getColumnIndex("app_key");
                    int isOMMAppIndex = cursor.getColumnIndex("isOmmApp");
                    while (cursor.moveToNext()) {
                        AppBean appBean = new AppBean();
                        appBean.setId(cursor.getString(storeIdIndex));
                        appBean.setAppName(cursor.getString(appNameIndex));
                        appBean.setType(cursor.getInt(appTypeIndex));
                        appBean.setDownloadUrl(cursor.getString(downloadUrlIndex));
                        appBean.setIconLoc(cursor.getString(iconUrlIndex));
                        appBean.setState(cursor.getInt(stateIndex));
                        appBean.setInstallVersion(cursor.getString(installVerIndex));
                        appBean.setMaxVersion(cursor.getString(maxVerIndex));
                        appBean.setCertificatesPath(cursor.getString(certificatesPathIndex));
                        appBean.setCertificatesPwd(cursor.getString(certificatesPwdIndex));
                        appBean.setPackageName(cursor.getString(packageNameIndex));
                        appBean.setCertificatesUrl(cursor.getString(certificatesUrlIndex));
                        appBean.setAppId(cursor.getString(appIdIndex));
                        appBean.setAppSize(cursor.getString(appSizeIndex));
                        appBean.setAppKey(cursor.getString(appKeyIndex));
                        if (wgtAppIdIndex > -1) {
                            appBean.setWgtAppId(cursor.getString(wgtAppIdIndex));
                        }
                        appBean.setMainApp(cursor.getString(mainAppIndex));
                        if (appBean.getType() == 3) {
                            appBean.setInstallPath(cursor.getString(installPathIndex));
                        }
                        if (newAppIndex >= 0) {
                            appBean.setNewApp(cursor.getInt(newAppIndex));
                        }
                        list.add(appBean);
                    }
                }
            }
            catch (SQLException e) {
                LogUtils.oe("getAppBeanList", (Exception)((Object)e));
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (db != null) {
                db.close();
            }
        }
        return list;
    }

    public List<AppBean> getAppBeanList() {
        String sql = "SELECT * FROM app_list WHERE " + UserInfoVO.toDbSqlString() + " ORDER BY " + "_id";
        return this.getAppBeanList(sql);
    }

    public AppBean getAppBean(String appId) {
        return this.getAppBeanByUserInfoAndOtherKey("app_list", "appId", appId);
    }

    private AppBean getAppBeanByUserInfoAndOtherKey(String table, String whereKey, String whereValue) {
        String sql = "SELECT * FROM " + table + " WHERE " + UserInfoVO.toDbSqlString() + " and " + whereKey + "=" + "'" + whereValue + "'";
        List<AppBean> appBeans = this.getAppBeanList(sql);
        AppBean appBean = null;
        if (appBeans != null && appBeans.size() != 0) {
            appBean = appBeans.get(0);
        }
        return appBean;
    }

    public AppBean getAppByPkgName(String pkg) {
        return this.getAppBeanByUserInfoAndOtherKey("app_list", "package_name", pkg);
    }

    public void deleteDefaultApp(String appId) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String querySql = "SELECT app_ver FROM t_apps WHERE " + UserInfoVO.toDbSqlString() + " and " + "appId" + "='" + appId + "'";
                Cursor c = db.rawQuery(querySql, null);
                String appVer = null;
                if (c != null && c.getCount() > 0 && c.moveToNext()) {
                    appVer = c.getString(c.getColumnIndex("app_ver"));
                    c.close();
                }
                String sql = "Update app_list set state=0, app_ver='" + appVer + "', " + "default_app" + "=0, " + "remain_app" + "=1 where " + UserInfoVO.toDbSqlString() + " and " + "appId" + " = '" + appId + "'";
                LogUtils.logDebug(true, "deleteDefaultApp sql\uff1a" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void deleteDownloadApp(String appId) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "DELETE FROM t_apps where " + UserInfoVO.toDbSqlString() + " and " + "appId" + " = '" + appId + "'";
                LogUtils.logDebug(true, "deleteDownloadApp sql:" + sql);
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public void deleteDownFileWithDB(AppBean appBean) {
        try {
            if (appBean == null || TextUtils.isEmpty((CharSequence)appBean.getDownloadUrl())) {
                return;
            }
            AppDownLoadDbHelper databaseHelper = AppDownLoadDbHelper.getInstance(this.mContext);
            SQLiteDatabase db = databaseHelper.getWritableDatabase();
            String sql = "DELETE FROM Downloader WHERE url='" + appBean.getDownloadUrl() + "'";
            db.execSQL(sql);
            db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDownFileFromDB(AppBean appBean) {
        Cursor c;
        SQLiteDatabase db;
        block5: {
            block4: {
                try {
                    if (appBean != null && !TextUtils.isEmpty((CharSequence)appBean.getDownloadUrl())) break block4;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            AppDownLoadDbHelper databaseHelper = AppDownLoadDbHelper.getInstance(this.mContext);
            db = databaseHelper.getWritableDatabase();
            String sql = "SELECT * FROM Downloader WHERE url='" + appBean.getDownloadUrl() + "'";
            c = db.rawQuery(sql, null);
            if (c != null && c.getCount() >= 1 && c.moveToNext()) break block5;
            return null;
        }
        String path = c.getString(c.getColumnIndex("filePath"));
        c.close();
        db.close();
        return path;
    }

    public void addUpdate(AppBean appBean, String appVer, String updateUrl, String filePath) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                ContentValues cv = new ContentValues(6);
                cv.put("store_id", appBean.getId());
                cv.put("appId", appBean.getAppId());
                cv.put("app_name", appBean.getAppName());
                cv.put("app_ver", appVer);
                cv.put("download_url", updateUrl);
                cv.put("file_path", filePath);
                long insertId = db.insert("update_info", null, cv);
                LogUtils.i(this.TAG, "insertId=========" + insertId);
            }
            catch (SQLException e) {
                e.printStackTrace();
                db.close();
            }
        }
        finally {
            db.close();
        }
    }

    public void deleteUpdate(String appId) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "DELETE FROM update_info WHERE  appId='" + appId + "'";
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    public String[] getUpdate(String appId) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return null;
        }
        SQLiteDatabase db = null;
        try {
            db = this.dbHelper.getWritableDatabase();
            String sql = "SELECT * FROM update_info WHERE  appId='" + appId + "'";
            Cursor c = db.rawQuery(sql, null);
            if (c != null && c.getCount() > 0 && c.moveToNext()) {
                String path = c.getString(c.getColumnIndex("file_path"));
                String ver = c.getString(c.getColumnIndex("app_ver"));
                String[] stringArray = new String[]{path, ver};
                return stringArray;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return null;
    }

    public void updateNewAppState(String appId, int upstate) {
        SQLiteDatabase db = null;
        try {
            try {
                db = this.dbHelper.getWritableDatabase();
                String sql = "Update app_list set new_app = " + upstate + " where " + UserInfoVO.toDbSqlString() + " and " + "appId" + " = '" + appId + "'";
                db.execSQL(sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (db != null) {
                    db.close();
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

