/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.data;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.ViewFrameConfig;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStoreOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppTileOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AutoDownloadAppOptionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppEvaluteVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppVersionVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.HttpRequrstResultVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.SubmitAppEvaluteVO;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.UserInfoVO;

public class AppStoteDataParser
implements AppStoreConstant {
    public static ArrayList<AppBean> parseMCMDocumentInfoJsonArray(String json) {
        JSONObject jsonItem;
        ArrayList<AppBean> list;
        block6: {
            if (TextUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            list = new ArrayList<AppBean>();
            jsonItem = new JSONObject(json);
            String status = jsonItem.getString("status");
            String info = jsonItem.getString("info");
            if ("ok".equalsIgnoreCase(status)) break block6;
            Log.e((String)"JSON", (String)("MCM Title:" + info));
            return null;
        }
        try {
            String data = jsonItem.getString("data");
            if (!TextUtils.isEmpty((CharSequence)data)) {
                JSONArray jsonArray = new JSONArray(data);
                int i = 0;
                while (i < jsonArray.length()) {
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    StringBuilder strb = new StringBuilder();
                    strb.append("\u3010");
                    strb.append(jsonObj.getString("programaName"));
                    strb.append("\u3011");
                    strb.append(jsonObj.getString("title"));
                    AppBean appBean = new AppBean();
                    appBean.setMcmDocumentTitle(strb.toString());
                    appBean.setMcmDocumentTitleJsonData(jsonObj.toString());
                    list.add(appBean);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<AppBean> parseAdJsonArray(String json) {
        ArrayList<AppBean> list;
        block5: {
            if (TextUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            list = new ArrayList<AppBean>();
            try {
                JSONObject obj = new JSONObject(json);
                JSONArray array = obj.optJSONArray("advList");
                if (array == null || array.length() <= 0) break block5;
                list = new ArrayList();
                int i = 0;
                int size = array.length();
                while (i < size) {
                    JSONObject jsonItem = array.getJSONObject(i);
                    AppBean appBean = new AppBean();
                    if (!jsonItem.has("imageUrl")) {
                        AppBean appBean1 = new AppBean();
                        appBean1.setNewAdVersion(false);
                        appBean1.setAdvImageUrl(jsonItem.optString("image1Url"));
                        list.add(appBean1);
                        AppBean appBean2 = new AppBean();
                        appBean2.setNewAdVersion(false);
                        appBean2.setAdvImageUrl(jsonItem.optString("image2Url"));
                        list.add(appBean2);
                        AppBean appBean3 = new AppBean();
                        appBean3.setNewAdVersion(false);
                        appBean3.setAdvImageUrl(jsonItem.optString("image3Url"));
                        list.add(appBean3);
                        break;
                    }
                    appBean.setNewAdVersion(true);
                    appBean.setAdvImageUrl(jsonItem.optString("imageUrl"));
                    appBean.setAdvImageLink(jsonItem.optString("imageAdsLink"));
                    list.add(appBean);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ArrayList<AppBean> parseAppListWithKey(String key, String json) {
        ArrayList<AppBean> list = null;
        if (!TextUtils.isEmpty((CharSequence)json) && !TextUtils.isEmpty((CharSequence)key)) {
            try {
                list = AppStoteDataParser.parseAppList(new JSONObject(json).optString(key));
            }
            catch (Exception e) {
                LogUtils.oe("parseAppListWithKey", e);
                e.printStackTrace();
            }
        }
        return list;
    }

    public static ArrayList<AppBean> parseAppList(String json) {
        ArrayList<AppBean> list = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                list = new ArrayList<AppBean>();
                JSONArray array = new JSONArray(json);
                int i = 0;
                while (i < array.length()) {
                    AppBean appBean = AppStoteDataParser.parseAppBean(array.getJSONObject(i));
                    if (appBean != null) {
                        list.add(appBean);
                    }
                    ++i;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static AppBean parseAppDetailData(String key, String json) {
        AppBean appBean = new AppBean();
        try {
            JSONObject jsonItem = new JSONObject(json).getJSONObject(key);
            appBean = AppStoteDataParser.parseAppBean(jsonItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.oe("parseAppDetailData", e);
            LogUtils.logDebugO(true, "parseAppDetailData appStr:" + json);
            appBean = null;
        }
        return appBean;
    }

    private static int getAppType(String appCategory) {
        String[] typeKeyList = new String[]{"", "Web", "Native", "AppCanWgt", "AppCanNative"};
        int appType = -1;
        int i = 1;
        while (i < typeKeyList.length) {
            if (typeKeyList[i].equalsIgnoreCase(appCategory)) {
                appType = i;
                break;
            }
            ++i;
        }
        return appType;
    }

    private static String getAppCategory(int type) {
        String[] typeKeyList = new String[]{"", "Web", "Native", "AppCanWgt", "AppCanNative"};
        String appCategory = "";
        if (type < typeKeyList.length) {
            appCategory = typeKeyList[type];
        }
        return appCategory;
    }

    public static AppBean parseAppBean(JSONObject jsonItem) {
        AppBean appBean = new AppBean();
        String appTypeKey = "appCategory";
        if (jsonItem.has(appTypeKey)) {
            String category = jsonItem.optString(appTypeKey);
            int appType = AppStoteDataParser.getAppType(category);
            if (appType != -1) {
                appBean.setType(appType);
            } else {
                LogUtils.logDebugO(true, "appId:" + jsonItem.optString("appId") + " has error type:" + category);
                return null;
            }
        }
        appBean.setIndexId(jsonItem.optString("id"));
        appBean.setAppId(jsonItem.optString("appId"));
        appBean.setAppKey(jsonItem.optString("appKey"));
        appBean.setCurVersion(jsonItem.optString("curVersion"));
        appBean.setId(jsonItem.optString("appId"));
        appBean.setAppName(jsonItem.optString("name"));
        appBean.setDownloadUrl(jsonItem.optString("pkgUrl"));
        appBean.setIconLoc(jsonItem.optString("iconLoc"));
        appBean.setMainApp(jsonItem.optString("mainApp"));
        appBean.setWgtAppId(jsonItem.optString("appId"));
        appBean.setAppDiscription(jsonItem.optString("description"));
        appBean.setUpdateTime(jsonItem.optString("updateTime"));
        appBean.setDownloadNum(jsonItem.optInt("downloadCnt"));
        appBean.setShortImgList(AppStoteDataParser.parseShortImgList(jsonItem));
        appBean.setInstallVersion(jsonItem.optString("installVersion"));
        appBean.setMaxVersion(jsonItem.optString("maxVersion"));
        appBean.setNewApp(0);
        appBean.setAppCreator(jsonItem.optString("creator"));
        appBean.setStartLevel(jsonItem.optString("starLevel"));
        int appL = jsonItem.optInt("pkgSize", 0);
        if (appL > 0) {
            double dd = (double)appL / 1048576.0;
            double ddd = (double)((int)(dd * 10.0)) / 10.0;
            appBean.setAppSize(String.valueOf(ddd));
        } else if (appL == 0) {
            appBean.setAppSize("0");
        }
        if (appBean.getType() == 1) {
            appBean.setState(1);
        } else {
            appBean.setState(0);
        }
        if (AppUtils.isNativeApp(appBean.getType())) {
            appBean.setPackageName(jsonItem.optString("pkgName"));
        } else {
            appBean.setPackageName("wgt");
        }
        if (jsonItem.has("evaluteInfo")) {
            appBean.setAppEvaluteCreator(jsonItem.optString("username"));
            appBean.setAppEvaluteCreateTime(jsonItem.optString("createdTime"));
            appBean.setAppEvaluteInfo(jsonItem.optString("evaluteInfo"));
        }
        appBean.setTilesList(AppStoteDataParser.parseTilesList(jsonItem));
        return appBean;
    }

    public static String appBeanToJsonStr(AppBean appBean) {
        JSONObject appJson = new JSONObject();
        String appTypeKey = "appCategory";
        try {
            appJson.put(appTypeKey, (Object)AppStoteDataParser.getAppCategory(appBean.getType()));
            appJson.put("id", (Object)appBean.getIndexId());
            appJson.put("appId", (Object)appBean.getAppId());
            appJson.put("appKey", (Object)appBean.getAppKey());
            appJson.put("curVersion", (Object)appBean.getCurVersion());
            appJson.put("appId", (Object)appBean.getId());
            appJson.put("name", (Object)appBean.getAppName());
            appJson.put("pkgUrl", (Object)appBean.getDownloadUrl());
            appJson.put("iconLoc", (Object)appBean.getIconLoc());
            appJson.put("mainApp", (Object)appBean.getMainApp());
            appJson.put("appId", (Object)appBean.getWgtAppId());
            appJson.put("description", (Object)appBean.getAppDiscription());
            appJson.put("updateTime", (Object)appBean.getUpdateTime());
            appJson.put("downloadCnt", appBean.getDownloadNum());
            ArrayList<String> shortImgs = appBean.getShortImgList();
            int i = 0;
            while (i < shortImgs.size()) {
                appJson.put("shortImg" + (i + 1), (Object)shortImgs.get(i));
                ++i;
            }
            appJson.put("installVersion", (Object)appBean.getInstallVersion());
            appJson.put("maxVersion", (Object)appBean.getMaxVersion());
            appJson.put("creator", (Object)appBean.getAppCreator());
            appJson.put("starLevel", (Object)appBean.getStartLevel());
            float appSize = Float.parseFloat(appBean.getAppSize());
            appJson.put("pkgSize", (double)(appSize * 1.048576E7f));
            appJson.put("pkgName", (Object)appBean.getPackageName());
            appJson.put("username", (Object)appBean.getAppEvaluteCreator());
            appJson.put("createdTime", (Object)appBean.getAppEvaluteCreateTime());
            appJson.put("evaluteInfo", (Object)appBean.getAppEvaluteInfo());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return appJson.toString();
    }

    private static ArrayList<AppTileBean> parseTilesList(JSONObject json) {
        ArrayList<AppTileBean> tilesList = new ArrayList<AppTileBean>();
        try {
            String appName = json.optString("name");
            String appKey = json.optString("appKey");
            AppTileBean appTile = null;
            String defaultTab = "";
            if (json.has("tileList")) {
                JSONArray arrayTile = json.optJSONArray("tileList");
                int i = 0;
                int len = arrayTile.length();
                while (i < len) {
                    JSONObject jsonItem = arrayTile.optJSONObject(i);
                    jsonItem.put("appKey", (Object)appKey);
                    appTile = new AppTileBean();
                    appTile.setJsonStr(jsonItem.toString());
                    appTile.setAppId(jsonItem.optString("appId"));
                    appTile.setAppName(appName);
                    appTile.setId(jsonItem.optString("id"));
                    appTile.setTileName(jsonItem.optString("tilesname"));
                    appTile.setIcon(jsonItem.optString("icon"));
                    appTile.setLinkUrl(jsonItem.optString("tabUrl"));
                    appTile.setStartPage(jsonItem.optString("startPage"));
                    appTile.setVersion(jsonItem.optString("version"));
                    appTile.setDefaultTab(jsonItem.optString("defaultTab", "false"));
                    appTile.setAddHomePage("not_set");
                    tilesList.add(appTile);
                    ++i;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return tilesList;
    }

    private static ArrayList<String> parseShortImgList(JSONObject json) {
        ArrayList<String> arry = new ArrayList<String>();
        String img = "";
        int i = 0;
        while (i < 4) {
            img = json.optString("shortImg" + (i + 1));
            if (!TextUtils.isEmpty((CharSequence)img)) {
                arry.add(img);
            }
            ++i;
        }
        return arry;
    }

    public static EMMStartUpVO parseEmmStartUpInfo(String json) {
        EMMStartUpVO mEmmStartUpInfo = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            mEmmStartUpInfo = new EMMStartUpVO();
            mEmmStartUpInfo.setJsonStr(json);
            try {
                JSONObject jsonObj = new JSONObject(json);
                mEmmStartUpInfo.setWidgetStatus(jsonObj.optString("widgetStatus"));
                mEmmStartUpInfo.setNewAppUrl(jsonObj.optString("newAppUrl"));
                mEmmStartUpInfo.setUpdateVersion(jsonObj.optString("version"));
                mEmmStartUpInfo.setNeedConfirm(jsonObj.optBoolean("needConfirm"));
                mEmmStartUpInfo.setForceUpdate(jsonObj.optBoolean("forceUpdate"));
                mEmmStartUpInfo.setUpdateHints(jsonObj.optString("updateHints"));
                mEmmStartUpInfo.setCloseHints(jsonObj.optString("closeHints"));
                mEmmStartUpInfo.setStrategyId(jsonObj.optString("strategyId"));
                mEmmStartUpInfo.setPkgType(jsonObj.optString("pkgType"));
                mEmmStartUpInfo.setNewVersion(jsonObj.optString("version"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return mEmmStartUpInfo;
    }

    public static void parseAppStoreOption(String jsonStr) {
        JSONObject optionJson = null;
        try {
            optionJson = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        AppStoreOptionVO.setShowMCMDocument(optionJson.optBoolean("IS_SHOW_MCM_DOCUMENT", AppStoreOptionVO.isShowMCMDocument()));
        AppStoreOptionVO.setShowAdView(optionJson.optBoolean("IS_SHOW_AD_VIEW", AppStoreOptionVO.isShowAdView()));
        AppStoreOptionVO.setShowAddBtn(optionJson.optBoolean("IS_SHOW_ADD_APP_ICON", AppStoreOptionVO.isShowAddBtn()));
        AppStoreOptionVO.setCanDelApp(optionJson.optBoolean("CAN_DEL_SUB_WIDGET", AppStoreOptionVO.isCanDelApp()));
        AppStoreOptionVO.setShowAddBtnFirst(optionJson.optBoolean("IS_ADD_APP_ICON_FIRST", AppStoreOptionVO.isShowAddBtnFirst()));
        AppStoreOptionVO.setShowAllAppsInMain(optionJson.optBoolean("IS_SHOW_ALL_APPS_IN_MAIN", AppStoreOptionVO.isShowAllAppsInMain()));
        AppStoreOptionVO.setShowDiscuss(optionJson.optBoolean("IS_SHOW_DISCUSS", AppStoreOptionVO.isShowDiscuss()));
        AppStoreOptionVO.setShowClassificationAppList(optionJson.optBoolean("IS_SHOW_CLASSIFICATION_APP_LIST", AppStoreOptionVO.isShowClassificationAppList()));
        AppStoreOptionVO.setShowAllViewsInWeb(optionJson.optBoolean("IS_SHOW_ALL_VIEWS_IN_WEB", AppStoreOptionVO.isShowAllViewsInWeb()));
        AppStoreOptionVO.setOnAppClickCbToWeb(optionJson.optBoolean("ON_APP_CLICK_CB_TO_WEB", AppStoreOptionVO.isOnAppClickCbToWeb()));
    }

    public static void parseTileOption(String jsonStr) {
        JSONObject optionJson = null;
        try {
            optionJson = new JSONObject(jsonStr);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        AppTileOptionVO.setShowAllTileInMain(optionJson.optBoolean("SHOW_ALL_TILES_IN_HOME", AppTileOptionVO.isShowAllTileInMain()));
        AppTileOptionVO.setShowAllTileInOnePage(optionJson.optBoolean("SHOW_ALL_TILES_IN_ONE_PAGE", AppTileOptionVO.isShowAllTileInOnePage()));
    }

    public static String getJsonObj(JSONObject json) {
        JSONObject jsonUri = new JSONObject();
        if (json != null) {
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = json.optString(key);
                try {
                    jsonUri.put(AppStoteHttpURLConnection.uriEncode(key, ""), (Object)AppStoteHttpURLConnection.uriEncode(value, ""));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return "jsonObj" + "=" + jsonUri.toString();
    }

    public static JSONObject changeSoftTokenToJson(Context mContext) {
        JSONObject json = new JSONObject();
        try {
            json.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(mContext));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    private static String changeToV3Result(String jsonStr, String key) {
        JSONObject jsonV3 = new JSONObject();
        try {
            JSONObject json = new JSONObject(jsonStr);
            int reportRet = json.optInt("ret", -1);
            if (reportRet == 0) {
                jsonV3.put("status", (Object)"ok");
                String data = json.optString("data", "");
                if (!TextUtils.isEmpty((CharSequence)data) && !"null".equals(data)) {
                    if (data.startsWith("[")) {
                        jsonV3.put(key, (Object)new JSONArray(data));
                    } else {
                        JSONObject jsonData = new JSONObject(data);
                        if (jsonData.has("advList") || jsonData.has("appList") || jsonData.has("evaluteList") || jsonData.has("appTypeList")) {
                            Iterator it = jsonData.keys();
                            while (it.hasNext()) {
                                String dataKey = (String)it.next();
                                String value = jsonData.optString(dataKey);
                                if (value.startsWith("[")) {
                                    jsonV3.put(dataKey, (Object)new JSONArray(value));
                                    continue;
                                }
                                jsonV3.put(dataKey, (Object)new JSONObject(value));
                            }
                        } else {
                            jsonV3.put(key, (Object)new JSONObject(data));
                        }
                    }
                }
            } else {
                jsonV3.put("status", (Object)"fail");
                jsonV3.put("info", (Object)json.optString("msg", ""));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonV3.toString();
    }

    public static HttpRequrstResultVO changeToV3Result(HttpRequrstResultVO result, String key) {
        String res;
        if (result != null && !TextUtils.isEmpty((CharSequence)(res = result.getResult()))) {
            result.setResult(AppStoteDataParser.changeToV3Result(res, key));
        }
        return result;
    }

    public static String jsonToFromString(JSONObject params) {
        StringBuilder urlBuilder = new StringBuilder();
        if (params != null) {
            Iterator it = params.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = params.optString(key);
                urlBuilder.append(AppStoteHttpURLConnection.uriEncode(key, "")).append("=").append(AppStoteHttpURLConnection.uriEncode(value, "")).append("&");
            }
            int strLen = urlBuilder.length();
            if (strLen >= 1) {
                urlBuilder.deleteCharAt(urlBuilder.length() - 1);
            }
        }
        return urlBuilder.toString();
    }

    public static JSONObject putDataToJsonObj(JSONObject json) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("jsonObj", (Object)json.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static void parseUserInfo(String userInfo) {
        try {
            JSONObject json = new JSONObject(userInfo);
            UserInfoVO.setTenantAccount(json.optString("tenantAccount", "undefined_null"));
            UserInfoVO.setDomainName(json.optString("domainName", "undefined_null"));
            UserInfoVO.setUserName(json.optString("loginName", "undefined_null"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static ViewFrameConfig parseViewFrameConfig(String jsonStr) {
        ViewFrameConfig mConfig = new ViewFrameConfig();
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            try {
                JSONObject json = new JSONObject(jsonStr);
                JSONObject jaonConfig = json.optJSONObject("appListViewFrame");
                if (jaonConfig != null) {
                    mConfig.x = Float.parseFloat(jaonConfig.optString("x"));
                    mConfig.y = Float.parseFloat(jaonConfig.optString("y"));
                    mConfig.width = Float.parseFloat(jaonConfig.optString("width"));
                    mConfig.height = Float.parseFloat(jaonConfig.optString("height"));
                    mConfig.scale = Float.parseFloat(jaonConfig.optString("scale", "0"));
                    mConfig.isInit = true;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return mConfig;
    }

    public static AutoDownloadAppOptionVO parseAutoDownloadAppOption(String jsonStr) {
        AutoDownloadAppOptionVO mAutoDownloadAppOption = new AutoDownloadAppOptionVO();
        try {
            JSONObject json = new JSONObject(jsonStr);
            mAutoDownloadAppOption.setIsAutoDownloadApp(json.optBoolean("isAutoDownloadApp", false));
            mAutoDownloadAppOption.setAutoDownloadNetwork(json.optString("autoDownloadNetwork", "WIFI"));
            mAutoDownloadAppOption.setIsWantTile(json.optBoolean("isWantTile", false));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mAutoDownloadAppOption;
    }

    public static GetAppVersionVO parseGetAppVersionVO(String jsonStr) {
        GetAppVersionVO versionVO = new GetAppVersionVO();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            if (jsonObject.has("appId")) {
                versionVO.appId = jsonObject.optString("appId");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return versionVO;
    }

    public static SubmitAppEvaluteVO parseSubmitAppEvaluteVO(String jsonStr) {
        SubmitAppEvaluteVO versionVO = new SubmitAppEvaluteVO();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            if (jsonObject.has("appId")) {
                versionVO.setAppId(jsonObject.optString("appId"));
            }
            if (jsonObject.has("userName")) {
                versionVO.setUserName(jsonObject.optString("userName"));
            }
            if (jsonObject.has("evaluteInfo")) {
                versionVO.setEvaluteInfo(jsonObject.optString("evaluteInfo"));
            }
            if (jsonObject.has("starLevel")) {
                versionVO.setStarLevel(jsonObject.optString("starLevel"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return versionVO;
    }

    public static GetAppEvaluteVO parseGetAppEvaluteVO(String jsonStr) {
        GetAppEvaluteVO versionVO = new GetAppEvaluteVO();
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            if (jsonObject.has("appId")) {
                versionVO.setAppId(jsonObject.optString("appId"));
            }
            if (jsonObject.has("indexId")) {
                versionVO.setStartIndex(jsonObject.optString("indexId"));
            }
            if (jsonObject.has("action")) {
                versionVO.setAction(jsonObject.optString("action"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return versionVO;
    }
}

