/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.upgrade;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.EUExAppStoreMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoreURLMgr;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.http.AppStoteHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreTokenUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.StringUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.EMMStartUpVO;

public class GrayRelease
implements AppStoreConstant {
    public static void saveGrayReleaseStrategyId(Context context, EMMStartUpVO mEmmStartUpInfo, String curAppId) {
        String strategyId = mEmmStartUpInfo.getStrategyId();
        if (!TextUtils.isEmpty((CharSequence)strategyId)) {
            String version = mEmmStartUpInfo.getNewVersion();
            SharedPrefUtils.putString(context, "isInstallGrayReleaseApp" + curAppId, version, strategyId);
            SharedPrefUtils.putString(context, "upgradeStrategyId" + curAppId, strategyId, version);
        }
    }

    private static void delGrayReleaseStrategyId(Context context, EMMStartUpVO mEmmStartUpInfo, String curAppId) {
        SharedPrefUtils.remove(context, "isInstallGrayReleaseApp" + curAppId, mEmmStartUpInfo.getNewVersion());
        SharedPrefUtils.remove(context, "upgradeStrategyId" + curAppId, mEmmStartUpInfo.getStrategyId());
    }

    public static void freeGrayReleaseVersion(final Context context, final AppBean mAppBena, final EMMStartUpVO mEmmStartUpInfo) {
        if (mEmmStartUpInfo != null && !TextUtils.isEmpty((CharSequence)mEmmStartUpInfo.getStrategyId())) {
            new AsyncTask<Void, Void, String>(){

                protected String doInBackground(Void ... params) {
                    return GrayRelease.freeGrayReleaseVersionReport(context, mAppBena, mEmmStartUpInfo.getStrategyId());
                }

                protected void onPostExecute(String result) {
                    String status;
                    if (!TextUtils.isEmpty((CharSequence)result) && "ok".equals(status = StringUtils.getString(result, "status"))) {
                        GrayRelease.delGrayReleaseStrategyId(context, mEmmStartUpInfo, mAppBena.getAppId());
                    }
                }
            }.execute((Object[])new Void[0]);
        }
    }

    public static String freeGrayReleaseVersionReport(Context context, AppBean appBean, String strategyId) {
        String result = "";
        if (!TextUtils.isEmpty((CharSequence)strategyId)) {
            String url = AppStoreURLMgr.getUrlUpgradeStrategy().replace("{strategyId}", strategyId);
            JSONObject json = new JSONObject();
            try {
                json.put("appId", (Object)appBean.getAppId());
                json.put("softToken", (Object)AppStoreTokenUtils.getSoftToken(context));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            result = AppStoteHttpURLConnection.sendPostRequestByFrom(context, EUExAppStoreMgr.getCurrentWidget(), url, json).getResult();
        }
        LogUtils.logDebugO(true, "updateStrategyReport appId:" + appBean.getAppId() + " strategyId:" + strategyId + " result:" + result);
        return result;
    }

    public static void checkGrayReleaseNewVersion(Context context, AppBean appBean) {
        Map<String, String> strategyIdMaps;
        String appId = appBean.getAppId();
        String version = appBean.getInstallVersion();
        String strategyId = SharedPrefUtils.getString(context, "isInstallGrayReleaseApp" + appId, version, "");
        if (!TextUtils.isEmpty((CharSequence)strategyId)) {
            SharedPrefUtils.remove(context, "isInstallGrayReleaseApp" + appId, version);
            SharedPrefUtils.remove(context, "upgradeStrategyId" + appId, strategyId);
        }
        if ((strategyIdMaps = SharedPrefUtils.getAll(context, "upgradeStrategyId" + appId)) != null) {
            int i = 0;
            while (i < strategyIdMaps.size()) {
                Set<Map.Entry<String, String>> set = strategyIdMaps.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    strategyId = entry.getKey();
                    if (TextUtils.isEmpty((CharSequence)strategyId)) continue;
                    EMMStartUpVO startUpInfo = new EMMStartUpVO();
                    startUpInfo.setStrategyId(strategyId);
                    startUpInfo.setNewVersion(version);
                    GrayRelease.freeGrayReleaseVersion(context, appBean, startUpInfo);
                }
                ++i;
            }
        }
    }
}

