/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.data.AppStoteDataParser;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption.AppEncryption;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.encryption.RC4Encryption;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.HexConverter;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppStatusVO;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AppStoreUtils
implements AppStoreConstant {
    private static String widgetSavePath = "";
    private static String widgetDataParentPath = "";

    public static String getMainAppId(Context context) {
        return SharedPrefUtils.getString(context, "app", "appid", "undefined");
    }

    public static String getMainAppKey() {
        String appKey = EUExUtil.getString((String)"appkey");
        appKey = AppEncryption.decodeStr(appKey);
        return appKey;
    }

    public static boolean isMCMExist() {
        boolean isExist = false;
        try {
            Class.forName("org.zywx.wbpalmstar.plugin.uexmcm.EUexMCM");
            isExist = true;
            Log.w((String)"AppStore", (String)"MCM is exist ");
        }
        catch (ClassNotFoundException e) {
            Log.w((String)"AppStore", (String)("MCM is not exist: " + e.getMessage()));
        }
        return isExist;
    }

    public static String getAppVerifyCode(WWidgetData mWData) {
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String appVerifyCode = String.valueOf(mWData.m_appId) + ":" + mWData.m_appkey + ":" + timeStamp;
        appVerifyCode = String.valueOf(MD5Encryption.getMD5Code(appVerifyCode)) + ";" + timeStamp;
        return appVerifyCode;
    }

    public static boolean isFirstGetInstallAppList(Context context) {
        return SharedPrefUtils.getBoolean(context, "app", "firstGetInstallAppList", true);
    }

    public static void setFirstGetInstallAppList(Context context, boolean value) {
        SharedPrefUtils.putBoolean(context, "app", "firstGetInstallAppList", value);
    }

    public static Bundle getAppInforBundle(AppBean appBean, WWidgetData mWidgetData) {
        Bundle bundle = new Bundle();
        bundle.putParcelable("appBean", (Parcelable)appBean);
        bundle.putParcelable("currentWidgetData", (Parcelable)mWidgetData);
        return bundle;
    }

    public static void saveOpenSubAppInfo(Context context, String appId, String info) {
        SharedPrefUtils.putString(context, "open_sub_app_info", appId, info);
    }

    public static String getOpenSubAppInfo(Context context, String appId) {
        return SharedPrefUtils.getString(context, "open_sub_app_info", appId, "");
    }

    public static String setWebUrlParams(String url, String param) {
        String nameValueStr = "";
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                JSONObject json = new JSONObject(param);
                nameValueStr = AppStoteDataParser.jsonToFromString(json);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        if (!TextUtils.isEmpty((CharSequence)nameValueStr)) {
            urlBuilder.append("?").append(nameValueStr);
        }
        return urlBuilder.toString();
    }

    public static Intent getNotifyDownloadIntent(String packageName, String appId) {
        Intent intent = new Intent();
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            intent.setPackage(packageName);
        }
        intent.setAction("plugin_appstore_notify_download_status");
        intent.putExtra("plugin_appstore_notify_download_status_appId", appId);
        return intent;
    }

    public static Bitmap GetRoundedCornerBitmap(Bitmap bitmap, float roundPx) {
        try {
            Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            Paint paint = new Paint();
            Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF rectF = new RectF(new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()));
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(-16777216);
            canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            Rect src = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            canvas.drawBitmap(bitmap, src, rect, paint);
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getWidgetSavePath() {
        return widgetSavePath;
    }

    public static String getWidgetDataSavePath(String appId) {
        return String.valueOf(widgetDataParentPath) + appId + "/";
    }

    private static void initWidgetPath(WWidgetData wData) {
        widgetSavePath = BUtility.makeRealPath((String)"wgts://", (String)wData.getWidgetPath(), (int)wData.m_wgtType);
        String mainDataPath = BUtility.makeRealPath((String)"wgt://", (String)wData.getWidgetPath(), (int)wData.m_wgtType);
        try {
            int index = mainDataPath.indexOf("apps");
            widgetDataParentPath = mainDataPath.substring(0, index + "apps".length() + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initAppStore(Context context, WWidgetData wData) {
        SharedPrefUtils.putString(context, "app", "appid", wData.m_appId);
        AppStoreUtils.initAppStatus(context);
        AppStoreUtils.initWidgetPath(wData);
    }

    private static void initAppStatus(Context context) {
        try {
            String appstatus = ResoureFinder.getInstance().getString(context, "appstatus");
            LogUtils.logDebug(true, "appstatusStr: " + appstatus);
            byte[] appstatusToByte = HexConverter.hexStringToBinary(appstatus);
            String appstatusDecrypt = new String(RC4Encryption.encryption(appstatusToByte, appstatusToByte.length, AppStoreUtils.getMainAppId(context)));
            LogUtils.logDebugO(true, "appstatusDecrypt: " + appstatusDecrypt);
            String[] appstatuss = appstatusDecrypt.split(",");
            if (appstatuss == null || appstatuss.length == 0) {
                return;
            }
            if ("0".equals(appstatuss[0])) {
                AppStatusVO.setStartReport(false);
                return;
            }
            if ("0".equals(appstatuss[1])) {
                AppStatusVO.setWidgetStatus(false);
            }
            if ("0".equals(appstatuss[2])) {
                AppStatusVO.setAppUpdate(false);
            }
            if ("0".equals(appstatuss[3])) {
                AppStatusVO.setWidgetParam(false);
            }
            if ("0".equals(appstatuss[4])) {
                AppStatusVO.setWidgetPush(false);
            }
            if ("0".equals(appstatuss[5])) {
                AppStatusVO.setWidgetAnalytics(false);
            }
            if ("1".equals(appstatuss[6])) {
                AppStatusVO.setAuthMam(true);
            }
            if ("1".equals(appstatuss[7])) {
                AppStatusVO.setCheckRoot(true);
            }
            if ("1".equals(appstatuss[8])) {
                AppStatusVO.setCertificate(true);
            }
            if ("1".equals(appstatuss[9])) {
                AppStatusVO.setIncreUpdate(true);
            }
            if ("1".equals(appstatuss[10])) {
                AppStatusVO.setMdmStatus(true);
            }
            if ("1".equals(appstatuss[11])) {
                AppStatusVO.setMcmStatus(true);
            }
            if ("0".equals(appstatuss[12])) {
                LogUtils.logDebug(true, "isForceConnected: false");
                AppStatusVO.setForceConnected(false);
            }
            if ("1".equals(appstatuss[13])) {
                AppStatusVO.setCheckAppSign(true);
            }
            if ("1".equals(appstatuss[14])) {
                AppStatusVO.setCheckService(true);
            }
            if ("1".equals(appstatuss[15])) {
                AppStatusVO.setOfflineLogin(true);
            }
            if ("1".equals(appstatuss[16])) {
                AppStatusVO.setSaveDataToBox(true);
            }
        }
        catch (Exception e) {
            LogUtils.oe("checkAppStatus", e);
        }
    }

    public static String getConfigPathByAppId(String appId) {
        return String.valueOf(widgetSavePath) + appId + "/config.xml";
    }

    public static String getWidgetInstallPath(String appId) {
        return String.valueOf(widgetSavePath) + appId;
    }

    public static String getTenantAccount(Context context) {
        String tenantAccountEncryption = "";
        String tenantAccount = "";
        tenantAccount = SharedPrefUtils.getString(context, "app", "tenantAccount", "");
        tenantAccountEncryption = AppStoreUtils.decryptTenantAccount(context, tenantAccount);
        return tenantAccountEncryption;
    }

    private static String decryptTenantAccount(Context context, String taEncryption) {
        String tenantAccount = "";
        if (!TextUtils.isEmpty((CharSequence)taEncryption)) {
            String mainAppId = SharedPrefUtils.getString(context, "app", "appid", "undefined");
            byte[] tenantAccountByte = HexConverter.hexStringToBinary(taEncryption);
            tenantAccount = new String(RC4Encryption.encryption(tenantAccountByte, tenantAccountByte.length, mainAppId));
        }
        return tenantAccount;
    }
}

