/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexappstoremgr.utils;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.zip.CnZipInputStream;
import org.zywx.wbpalmstar.base.zip.ZipEntry;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.utils.AppStoreConstant;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.AppBean;
import org.zywx.wbpalmstar.plugin.uexappstoremgr.vo.GetAppListVO;

public class FileUtils
implements AppStoreConstant {
    public static File rename(File tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        if (tmpFile.exists()) {
            if (!tmpFile.getAbsolutePath().endsWith(".zip")) {
                String path = tmpFile.getAbsolutePath();
                File newFile = new File(path = String.valueOf(path.substring(0, path.lastIndexOf("."))) + ".zip");
                if (tmpFile.renameTo(newFile)) {
                    tmpFile = newFile;
                }
            }
            return tmpFile;
        }
        return null;
    }

    public static File renameApk(File tmpFile) {
        return FileUtils.rename(tmpFile, "apk");
    }

    public static void DeleteFile(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFile = file.listFiles();
            if (childFile == null || childFile.length == 0) {
                file.delete();
                return;
            }
            File[] fileArray = childFile;
            int n = childFile.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtils.DeleteFile(f);
                ++n2;
            }
            file.delete();
        }
    }

    public static File rename(File tmpFile, String suffix) {
        if (tmpFile == null) {
            return null;
        }
        if (tmpFile.exists()) {
            if (!tmpFile.getAbsolutePath().endsWith(".zip")) {
                String path = tmpFile.getAbsolutePath();
                File newFile = new File(path = String.valueOf(path.substring(0, path.lastIndexOf("."))) + "." + suffix);
                if (tmpFile.renameTo(newFile)) {
                    tmpFile = newFile;
                }
            }
            return tmpFile;
        }
        return null;
    }

    public static FileInputStream getFileInputStream(String fileName) {
        FileInputStream fis = null;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File file = new File(fileName);
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fis;
    }

    public static GetAppListVO pareGetAppsListConfig(String json) {
        GetAppListVO mGetAppsListConfig = new GetAppListVO();
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject(json);
            mGetAppsListConfig.setAppListType(jsonObj.optString("type"));
            mGetAppsListConfig.setAppListKey(jsonObj.optString("key"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mGetAppsListConfig;
    }

    public static String getSdDir() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static File[] getListFilesFromDir(String dirPath) {
        File[] filesList = null;
        File fileDir = new File(dirPath);
        if (fileDir.isDirectory()) {
            filesList = fileDir.listFiles();
        }
        return filesList;
    }

    public static boolean isExistConfigFile(File fileDir) {
        File[] fileList;
        boolean isExistConfigFile = false;
        if (fileDir.isDirectory() && (fileList = fileDir.listFiles()) != null) {
            int j = 0;
            while (j < fileList.length) {
                if ("config.xml".equals(fileList[j].getName())) {
                    isExistConfigFile = true;
                    break;
                }
                ++j;
            }
        }
        return isExistConfigFile;
    }

    public static synchronized String unzip(InputStream inputStream, String decompression, String encoding) {
        String installPath;
        block26: {
            if (encoding == null || encoding.equals("")) {
                encoding = "utf-8";
            }
            installPath = null;
            File dir = new File(decompression);
            CnZipInputStream zis = null;
            FileOutputStream out = null;
            try {
                try {
                    zis = new CnZipInputStream(inputStream, encoding);
                    ZipEntry file = zis.getNextEntry();
                    installPath = String.valueOf(dir.getAbsolutePath()) + "/" + file.getName();
                    byte[] c = new byte[1024];
                    while (file != null) {
                        File files;
                        String zename = file.getName();
                        if (file.isDirectory()) {
                            files = new File(String.valueOf(dir.getAbsolutePath()) + "/" + zename);
                            files.mkdirs();
                        } else {
                            int slen;
                            files = new File(String.valueOf(dir.getAbsolutePath()) + "/" + zename).getParentFile();
                            if (!files.exists()) {
                                files.mkdirs();
                            }
                            out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + "/" + zename);
                            while ((slen = zis.read(c, 0, c.length)) != -1) {
                                out.write(c, 0, slen);
                            }
                            out.close();
                        }
                        file = zis.getNextEntry();
                    }
                }
                catch (Exception e) {
                    installPath = null;
                    e.printStackTrace();
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (out == null) break block26;
                    try {
                        out.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return installPath;
    }

    public static File createExternalCacheFile(Context context, AppBean appBean) {
        String sdCard;
        String mPath;
        File filePath = null;
        if (Environment.getExternalStorageState().equals("mounted") && !(filePath = new File(mPath = String.valueOf(sdCard = FileUtils.getSdDir()) + "/widgetone/temp/download/")).exists()) {
            filePath.mkdirs();
        }
        return new File(filePath, String.valueOf(appBean.getAppId()) + ".tmp");
    }

    public static boolean isExistSdcard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static long getSDFreeSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSize();
        long freeBlocks = sf.getAvailableBlocks();
        return freeBlocks * blockSize / 1024L / 1024L;
    }

    public static long getSDAllSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        long blockSize = sf.getBlockSize();
        long allBlocks = sf.getBlockCount();
        return allBlocks * blockSize / 1024L / 1024L;
    }
}

