/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zywx.wbpalmstar.base.BDebug;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.EBrowserActivity;
import org.zywx.wbpalmstar.engine.EUtil;
import org.zywx.wbpalmstar.engine.universalex.EUExEventListener;
import org.zywx.wbpalmstar.plugin.uexmam.EUExMAM;
import org.zywx.wbpalmstar.plugin.uexmam.LogUtils;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsConstants;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsUtility;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.Event;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.PushDBAdapter;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.PushService;
import org.zywx.wbpalmstar.plugin.uexmam.encryption.PEncryption;
import org.zywx.wbpalmstar.plugin.uexmam.mam.EResources;
import org.zywx.wbpalmstar.widgetone.dataservice.WWidgetData;

public class AnalyticsAgent {
    private static final String TAG = "MMSAgent";
    public String m_appKey;
    public static String m_appId;
    public int m_strategy;
    private long m_appBecomeActiveTime;
    private long m_currentAppTime;
    private String m_updateInfo;
    private static boolean m_errorReport;
    public static Context mContext;
    private String m_appStartTime;
    public int m_status = -1;
    static AnalyticsThread analyticsThread;
    static List<String> m_showViewList;
    private static Map<String, Event> m_eventMap;
    public List<String[]> startViewList = new ArrayList<String[]>();
    public List<String[]> endViewList = new ArrayList<String[]>();
    private static String hexStr;
    public static boolean startReport;
    public static boolean widgetStatus;
    public static boolean widgetPush;
    public static boolean widgetParam;
    public static boolean widgetUpdate;
    public static boolean widgetAnalytics;
    public static boolean mam;
    public static boolean checkRoot;
    public static boolean isCertificate;
    public static boolean isUpdateWidget;
    public static boolean isForceConnected;
    public String certificatePsw = null;
    public static WWidgetData m_rootWgt;
    private static AnalyticsAgent sAnalyticsAgent;
    private EUExMAM mMAM;
    EUExEventListener eventListener = new EUExEventListener(){

        public boolean onEvent(int type) {
            if (3 == type) {
                Log.i((String)AnalyticsAgent.TAG, (String)"APP Ready");
                if (analyticsThread != null && isForceConnected) {
                    analyticsThread.initProgressDialog();
                    if (mContext instanceof EBrowserActivity) {
                        ((EBrowserActivity)mContext).unRegisterAppEventListener(AnalyticsAgent.this.eventListener);
                    }
                }
            }
            return false;
        }
    };

    public static AnalyticsAgent getInstance() {
        if (sAnalyticsAgent == null) {
            sAnalyticsAgent = new AnalyticsAgent();
        }
        return sAnalyticsAgent;
    }

    public void setEUExMAMInstance(EUExMAM mam) {
        if (null == this.mMAM) {
            this.mMAM = mam;
        }
    }

    public EUExMAM getEUExEMMInstance() {
        return this.mMAM;
    }

    public void startWithAppKey(String inAppKey, WWidgetData wData, Context inActivity) {
        AnalyticsAgent.checkAppStatus(inActivity, wData.m_appId);
        EResources.init(inActivity);
        this.m_appKey = inAppKey;
        this.m_appKey = AnalyticsUtility.decodeStr(inAppKey);
        mContext = inActivity;
        m_rootWgt = wData;
        AnalyticsAgent.m_rootWgt.m_appkey = this.m_appKey;
        this.setAppId(wData.m_appId);
        if (!startReport) {
            return;
        }
        if (inActivity instanceof EBrowserActivity) {
            ((EBrowserActivity)inActivity).registerAppEventListener(this.eventListener);
        }
        if (isCertificate) {
            String cPath = null;
            cPath = isUpdateWidget ? inActivity.getFilesDir().getPath() + "/" + "widget/wgtRes/clientCertificate.p12" : "file:///android_asset/widget/wgtRes/clientCertificate.p12";
            AnalyticsHttpClient.setCertificate(isCertificate, EUtil.getCertificatePsw((Context)inActivity, (String)m_appId), cPath, inActivity);
        } else {
            AnalyticsHttpClient.setCertificate(isCertificate, null, null, null);
        }
        if (this.m_appStartTime == null) {
            this.m_appStartTime = AnalyticsUtility.getNowTime();
        }
        if (analyticsThread == null) {
            analyticsThread = new AnalyticsThread(inActivity, this, mam, m_rootWgt);
            this.m_strategy = -1;
            LogUtils.d(TAG, "startWithAppKey == startWithAppKey");
            analyticsThread.start();
        } else {
            AnalyticsAgent.analyticsThread.m_activity = inActivity;
            this.m_strategy = -1;
            AnalyticsAgent.analyticsThread.strategyStartReport = false;
        }
        SharedPreferences sp = mContext.getSharedPreferences(AnalyticsConstants.m_app, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("appid", m_appId);
        editor.commit();
    }

    public static void checkAppStatus(Context inActivity, String appId) {
        try {
            String appstatus = ResoureFinder.getInstance().getString(inActivity, "appstatus");
            byte[] appstatusToByte = AnalyticsAgent.HexStringToBinary(appstatus);
            String appstatusDecrypt = new String(PEncryption.os_decrypt(appstatusToByte, appstatusToByte.length, appId));
            AnalyticsUtility.log("appstatus: " + appstatusDecrypt);
            String[] appstatuss = appstatusDecrypt.split(",");
            if (appstatuss == null || appstatuss.length == 0) {
                return;
            }
            if ("0".equals(appstatuss[0])) {
                startReport = false;
                return;
            }
            if ("0".equals(appstatuss[1])) {
                widgetStatus = false;
            }
            if ("0".equals(appstatuss[2])) {
                widgetUpdate = false;
            }
            if ("0".equals(appstatuss[3])) {
                widgetParam = false;
            }
            if ("0".equals(appstatuss[4])) {
                widgetPush = false;
            }
            if ("0".equals(appstatuss[5])) {
                widgetAnalytics = false;
            }
            if ("1".equals(appstatuss[6])) {
                mam = true;
            }
            LogUtils.o("checkAppStatus mam auth:" + mam);
            LogUtils.o("mam auth:" + (mam |= AnalyticsUtility.isAuthMam(inActivity)));
            if ("1".equals(appstatuss[7])) {
                checkRoot = true;
            }
            if ("1".equals(appstatuss[8])) {
                LogUtils.i(TAG, "IsCertificate==true");
                isCertificate = true;
            }
            if ("1".equals(appstatuss[9])) {
                isUpdateWidget = true;
            }
            if ("0".equals(appstatuss[12])) {
                LogUtils.i("MMSForce", "isForceConnected: false");
                isForceConnected = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] HexStringToBinary(String hexString) {
        int len = hexString.length() / 2;
        byte[] bytes = new byte[len];
        byte high = 0;
        byte low = 0;
        for (int i = 0; i < len; ++i) {
            high = (byte)(hexStr.indexOf(hexString.charAt(2 * i)) << 4);
            low = (byte)hexStr.indexOf(hexString.charAt(2 * i + 1));
            bytes[i] = (byte)(high | low);
        }
        return bytes;
    }

    public void clear() {
        if (null != analyticsThread) {
            try {
                analyticsThread.finish();
                analyticsThread.interrupt();
                analyticsThread = null;
                mContext = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setPushState(int type) {
        SharedPreferences sp = mContext.getSharedPreferences(AnalyticsConstants.SP_SAVEDATA, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("localPushMes", String.valueOf(type));
        editor.commit();
        String pushMes = sp.getString("pushMes", String.valueOf(type));
        if (type == 1 && "1".equals(pushMes)) {
            Intent myIntent = new Intent(mContext, PushService.class);
            myIntent.putExtra("type", type);
            mContext.startService(myIntent);
        } else {
            Intent myIntent = new Intent(mContext, PushService.class);
            myIntent.putExtra("type", type);
            mContext.startService(myIntent);
        }
    }

    public void setAppId(String inAppId) {
        m_appId = inAppId;
    }

    public void initAppOnlineTime() {
        if (!startReport) {
            return;
        }
        if (this.m_appBecomeActiveTime == 0L) {
            this.m_appBecomeActiveTime = System.currentTimeMillis();
        }
        Log.d((String)"debug", (String)("initAppOnlineTime==" + this.m_appBecomeActiveTime));
    }

    public void setAppBecomeActive() {
        if (!startReport) {
            return;
        }
        this.m_appBecomeActiveTime = System.currentTimeMillis();
        Log.d((String)"debug", (String)("setAppBecomeActive==" + this.m_appBecomeActiveTime));
    }

    public void setAppBecomeBackground() {
        if (!startReport) {
            return;
        }
        this.m_currentAppTime += (System.currentTimeMillis() - this.m_appBecomeActiveTime) / 1000L;
        if (mContext == null) {
            return;
        }
        SharedPreferences preferences = mContext.getSharedPreferences(AnalyticsConstants.m_app, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong("appTotalTime", this.m_currentAppTime);
        editor.commit();
        Log.d((String)"debug", (String)("setAppBecomeBackground m_currentAppTime  ==" + this.m_currentAppTime));
    }

    public void updateWithAppId(String inAppId, String inAppVer, String inUrl) {
        if (!startReport) {
            return;
        }
        this.m_updateInfo = inAppId + ";" + inAppVer + ";" + inUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartView(String opener, String name, int startType, int windowType) {
        String[] view;
        if (!startReport) {
            return;
        }
        view = new String[]{TextUtils.isEmpty((CharSequence)opener) ? "application" : opener, TextUtils.isEmpty((CharSequence)name) ? view[0] : name, AnalyticsUtility.getNowTime(), String.valueOf(startType), String.valueOf(windowType)};
        BDebug.d((String)"debug", (String)("setStartView == " + opener + "==" + name));
        List<String[]> list = this.startViewList;
        synchronized (list) {
            this.startViewList.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndView(String name, int endType) {
        if (!startReport) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        String[] view = new String[]{name, String.valueOf(endType), AnalyticsUtility.getNowTime()};
        BDebug.d((String)"debug", (String)("setEndView == " + name));
        List<String[]> list = this.endViewList;
        synchronized (list) {
            this.endViewList.add(view);
        }
    }

    public static void setEvent(String inEventID, Map inAttriDict) {
        if (!startReport) {
            return;
        }
        m_showViewList.add("2;" + inEventID + ";" + AnalyticsUtility.getNowTime() + ";[" + AnalyticsUtility.getMapToString(inAttriDict) + "]");
    }

    public static void beginEvent(String inEventID, String inKey, Map inAttriDict) {
        if (!startReport) {
            return;
        }
        Event event = m_eventMap.get(inEventID + ";" + inKey);
        if (event == null) {
            event = new Event();
            m_eventMap.put(inEventID + ";" + inKey, event);
        }
        event.m_type = 3;
        event.m_beginTime_int = System.currentTimeMillis();
        ++event.m_clickNum;
        event.m_dict = AnalyticsUtility.getMapToString(inAttriDict);
    }

    public static void endEvent(String inEventID, String inKey) {
        if (!startReport) {
            return;
        }
        Event event = m_eventMap.get(inEventID + ";" + inKey);
        if (event != null) {
            event.m_totalTime = (System.currentTimeMillis() - event.m_beginTime_int) / 1000L;
            AnalyticsAgent.analyticsThread.m_eventMap.put(inEventID + ";" + inKey, event);
        }
    }

    public static void setErrorReport(boolean isTrue) {
        if (!startReport) {
            return;
        }
        m_errorReport = isTrue;
        SharedPreferences preferences = mContext.getSharedPreferences(AnalyticsConstants.m_app, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("errorReport", isTrue);
        editor.commit();
    }

    public String getError() {
        if (!this.getErrorReportStatus()) {
            return null;
        }
        String localObject = "";
        try {
            String str1 = mContext.getPackageName();
            String str2 = "";
            boolean i1 = false;
            boolean i2 = false;
            ArrayList<String> localArrayList = new ArrayList<String>();
            localArrayList.add("logcat");
            localArrayList.add("-d");
            localArrayList.add("-v");
            localArrayList.add("time");
            localArrayList.add("-s");
            localArrayList.add("AndroidRuntime:E");
            localArrayList.add("-p");
            localArrayList.add(str1);
            Process localProcess = Runtime.getRuntime().exec(localArrayList.toArray(new String[localArrayList.size()]));
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(localProcess.getInputStream()), 1024);
            String errorTime = null;
            Time time = new Time();
            time.setToNow();
            String str3 = localBufferedReader.readLine();
            while (str3 != null) {
                if (str3.indexOf("------- beginning") <= 0) {
                    if (str3.indexOf("):") > 0) {
                        int index = str3.indexOf(")");
                        if (errorTime == null) {
                            errorTime = time.year + "-" + str3.substring(0, str3.substring(0, index).indexOf("."));
                        }
                        str3 = str3.substring(index + 2);
                    }
                    if (str3.indexOf("thread attach failed") < 0) {
                        str2 = str2 + str3 + '\n';
                    }
                    if (!i2 && str3.toLowerCase().indexOf("exception") >= 0) {
                        i2 = true;
                    }
                    if (!i1 && str3.indexOf(str1) >= 0) {
                        i1 = true;
                    }
                }
                str3 = localBufferedReader.readLine();
            }
            if (str2.length() > 0 && i2 && i1) {
                PackageManager pm = mContext.getPackageManager();
                PackageInfo pinfo = null;
                try {
                    pinfo = pm.getPackageInfo(mContext.getPackageName(), 16384);
                    localObject = "5;" + errorTime + ";" + pinfo.versionName + ";" + Build.MODEL + ";" + "Android " + Build.VERSION.RELEASE + ";{" + str2 + "}";
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                Runtime.getRuntime().exec("logcat -c");
            }
            catch (Exception localException2) {
                localException2.printStackTrace();
            }
        }
        catch (Exception localException1) {
            localException1.printStackTrace();
        }
        String error = localObject;
        Log.i((String)"MMS", (String)("getError: " + error));
        return error;
    }

    public boolean getErrorReportStatus() {
        if (mContext == null) {
            return false;
        }
        SharedPreferences preferences = mContext.getSharedPreferences(AnalyticsConstants.m_app, 0);
        boolean status = preferences.getBoolean("errorReport", m_errorReport);
        Log.i((String)"MMS", (String)("errorReportStatus:" + status));
        return status;
    }

    public String getBaseMsg() {
        if (mContext == null) {
            return null;
        }
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        Log.i((String)"MMS", (String)("appid: " + m_appId + " appkey: " + this.m_appKey));
        SharedPreferences preferences = mContext.getSharedPreferences(AnalyticsConstants.m_app, 0);
        StringBuffer reportData = new StringBuffer();
        reportData.append(4).append(";").append(AnalyticsAgent.m_rootWgt.m_appId).append(";").append(AnalyticsAgent.m_rootWgt.m_widgetName).append(";").append(AnalyticsAgent.m_rootWgt.m_ver).append(";").append(AnalyticsAgent.m_rootWgt.m_channelCode).append(";").append(Build.MODEL).append(";").append("Android ").append(Build.VERSION.RELEASE).append(";").append(telephonyManager.getDeviceId()).append(";").append(AnalyticsUtility.getDeviceResolution(mContext)).append(";").append(AnalyticsUtility.getMobileOperatorName(mContext)).append(";").append(AnalyticsUtility.getNetName(mContext)).append(";").append(AnalyticsUtility.getNowTime()).append(";").append(AnalyticsUtility.getAppIdAppKeyMD5(AnalyticsAgent.m_rootWgt.m_appId, AnalyticsAgent.m_rootWgt.m_appkey)).append(";").append(preferences.getLong("appTotalTime", 0L)).append(";").append(AnalyticsUtility.getMacAddress(mContext)).append(";").append(AnalyticsUtility.getSerialNumber()).append(";").append(AnalyticsUtility.getMobileIMSI(mContext));
        return reportData.toString();
    }

    public static void widgetClose() {
    }

    public boolean isNetworkAvailable(Context context) {
        ConnectivityManager mConnMan = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo info = mConnMan.getActiveNetworkInfo();
        if (info == null) {
            return AnalyticsHttpClient.isNetWork();
        }
        return info.isConnected();
    }

    public static void insertPush(String appId, String title, String body) {
        PushDBAdapter pushDB = new PushDBAdapter(mContext);
        pushDB.open();
        ContentValues cv = new ContentValues();
        cv.put("appId", appId);
        cv.put("body", body);
        cv.put("title", title);
        pushDB.insert(cv, "push");
        pushDB.close();
    }

    public static Cursor getCursor(String appId, String sql) {
        PushDBAdapter pushDB = new PushDBAdapter(mContext);
        pushDB.open();
        Cursor cursor = pushDB.select(sql);
        return cursor;
    }

    public static List selectPush(String appId) {
        ArrayList list = new ArrayList();
        PushDBAdapter pushDB = new PushDBAdapter(mContext);
        pushDB.open();
        String sql = "select * from push where appId = '" + appId + "'";
        Cursor cursor = pushDB.select(sql);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("_id", String.valueOf(cursor.getInt(0)));
                map.put("title", cursor.getString(1));
                map.put("body", cursor.getString(2));
                map.put("appId", cursor.getString(3));
                list.add(map);
            }
            cursor.close();
            cursor = null;
        }
        pushDB.close();
        return list;
    }

    public static void delPush(String appId) {
        PushDBAdapter pushDB = new PushDBAdapter(mContext);
        pushDB.open();
        pushDB.deleteByAppID("push", appId);
        pushDB.close();
    }

    static {
        m_errorReport = true;
        analyticsThread = null;
        m_showViewList = new ArrayList<String>();
        m_eventMap = new HashMap<String, Event>();
        hexStr = "0123456789ABCDEF";
        startReport = true;
        widgetStatus = true;
        widgetPush = true;
        widgetParam = true;
        widgetUpdate = true;
        widgetAnalytics = true;
        mam = false;
        checkRoot = false;
        isCertificate = false;
        isUpdateWidget = false;
        isForceConnected = true;
    }
}

