/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.analytics;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.DisplayMetrics;
import android.util.Xml;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.zywx.wbpalmstar.acedes.ACEDes;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.plugin.uexmam.LogUtils;

public class AnalyticsUtility {
    private static boolean isLog = true;

    public static String getMobileIMSI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String imsi = telephonyManager.getSubscriberId();
        if (imsi == null) {
            imsi = "";
        }
        return imsi;
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static String getNetName(Context activity) {
        if (activity == null) {
            return null;
        }
        String netName = null;
        try {
            NetworkInfo info;
            ConnectivityManager cm = (ConnectivityManager)activity.getApplicationContext().getSystemService("connectivity");
            if (cm != null && (info = cm.getActiveNetworkInfo()) != null && info.isAvailable()) {
                block1 : switch (info.getType()) {
                    case 0: {
                        TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
                        switch (telephonyManager.getNetworkType()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 7: {
                                netName = "GPRS";
                                break block1;
                            }
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: {
                                netName = "3G";
                            }
                        }
                        break;
                    }
                    case 1: {
                        netName = "WIFI";
                    }
                }
            }
        }
        catch (SecurityException e) {
            netName = null;
        }
        return netName;
    }

    public static String getDeviceResolution(Context activity) {
        if (activity == null) {
            return null;
        }
        DisplayMetrics dm = activity.getResources().getDisplayMetrics();
        return dm.widthPixels + "*" + dm.heightPixels;
    }

    public static String getMapToString(Map inAttriDict) {
        String attriDict = "";
        if (inAttriDict != null) {
            for (Object object : inAttriDict.keySet()) {
                if ("".equals(attriDict)) {
                    attriDict = object + ":" + inAttriDict.get(object);
                    continue;
                }
                attriDict = attriDict + "," + object + ":" + inAttriDict.get(object);
            }
        }
        return attriDict;
    }

    public static String getNowTime() {
        Time time = new Time();
        time.setToNow();
        int year = time.year;
        int month = time.month + 1;
        int day = time.monthDay;
        int minute = time.minute;
        int hour = time.hour;
        int sec = time.second;
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + sec;
    }

    public static String getCurYearAndMonth() {
        Time time = new Time();
        time.setToNow();
        int year = time.year;
        int month = time.month + 1;
        return year + "_" + month;
    }

    public static String getAppNameVer(Context activity, String name, String ver) {
        PackageManager pm = activity.getPackageManager();
        PackageInfo pinfo = null;
        try {
            pinfo = pm.getPackageInfo(activity.getPackageName(), 16384);
            String appName = pinfo.applicationInfo.loadLabel(activity.getPackageManager()).toString();
            SharedPreferences preferences = activity.getSharedPreferences(name, 1);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("appName", appName);
            editor.commit();
            return appName + ";" + ver;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSoftToken(Context activity, String appKey, String name) {
        SharedPreferences preferences = activity.getSharedPreferences(name, 0);
        String softToken = preferences.getString("softToken", null);
        if (softToken != null) {
            return softToken;
        }
        String[] val = new String[4];
        try {
            val[0] = AnalyticsUtility.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = AnalyticsUtility.getCPUSerial();
            val[3] = appKey;
        }
        catch (Exception telephonyManager) {
            // empty catch block
        }
        softToken = AnalyticsUtility.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("softToken", softToken);
        editor.commit();
        return softToken;
    }

    public static String getSoftTokenMMS(Context activity, String appKey, String name) {
        SharedPreferences preferences = activity.getSharedPreferences(name, 0);
        String softToken = preferences.getString("softTokenMMS", null);
        if (softToken != null) {
            return softToken;
        }
        String[] val = new String[5];
        try {
            val[0] = AnalyticsUtility.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = AnalyticsUtility.getCPUSerial();
            val[3] = appKey;
            val[4] = AnalyticsUtility.getMobileIMSI(activity);
        }
        catch (Exception telephonyManager) {
            // empty catch block
        }
        softToken = AnalyticsUtility.getMD5Code(val);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("softTokenMMS", softToken);
        editor.commit();
        return softToken;
    }

    public static String getWidgetSoftToken(Context activity, String appKey) {
        String[] val = new String[4];
        try {
            val[0] = AnalyticsUtility.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = AnalyticsUtility.getCPUSerial();
            val[3] = appKey;
        }
        catch (Exception telephonyManager) {
            // empty catch block
        }
        String softToken = AnalyticsUtility.getMD5Code(val);
        return softToken;
    }

    public static String getMacAddress(Context activity) {
        String macSerial = null;
        try {
            WifiManager wifi = (WifiManager)activity.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            macSerial = info.getMacAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (macSerial == null) {
            macSerial = AnalyticsUtility.getMac();
        }
        if (!TextUtils.isEmpty((CharSequence)macSerial)) {
            macSerial = macSerial.toUpperCase();
        }
        return macSerial;
    }

    private static String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (null != str) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    public static String getMD5Code(String[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            for (String va : value) {
                if (va == null) {
                    va = "";
                }
                md.update(va.getBytes());
            }
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCPUSerial() {
        String str = "";
        String strCPU = "";
        String cpuAddress = "0000000000000000";
        try {
            Process pp = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null && (str = input.readLine()) != null) {
                if (str.indexOf("Serial") <= -1) continue;
                strCPU = str.substring(str.indexOf(":") + 1, str.length());
                cpuAddress = strCPU.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)cpuAddress) && !cpuAddress.equalsIgnoreCase("0000000000000000")) {
            cpuAddress = cpuAddress.toUpperCase();
        }
        return cpuAddress;
    }

    public static String getAppIdAppKeyMD5(String appId, String appKey) {
        String[] value = new String[]{appId + ":" + appKey};
        return AnalyticsUtility.getMD5Code(value);
    }

    public static String decodeStr(String key) {
        int j;
        char[] map = new char[]{'d', 'b', 'e', 'a', 'f', 'c'};
        char[] nmap = new char[]{'2', '4', '0', '9', '7', '1', '5', '8', '3', '6'};
        String dest = "";
        String swapstr = "";
        String output = "";
        for (j = 0; j < key.length(); ++j) {
            if (key.charAt(j) == '-') continue;
            swapstr = swapstr + key.charAt(j);
        }
        for (j = 0; j < swapstr.length(); ++j) {
            if (j == 8 || j == 12 || j == 16 || j == 20) {
                dest = dest + "-";
            }
            dest = dest + swapstr.charAt(swapstr.length() - j - 1);
        }
        for (int i = 0; i < dest.length(); ++i) {
            char t = dest.charAt(i);
            if (t >= 'a' && t <= 'f') {
                t = map[t - 97];
            } else if (t >= '0' && t <= '9') {
                t = nmap[t - 48];
            }
            output = output + t;
        }
        return output;
    }

    public static String getMobileOperatorName(Context mContext) {
        String name = "unKnown";
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        if (telephonyManager.getSimState() == 5) {
            String networkOperator = telephonyManager.getNetworkOperator();
            name = networkOperator.equals("46000") || networkOperator.equals("46002") ? "\u4e2d\u56fd\u79fb\u52a8" : (networkOperator.equals("46001") ? "\u4e2d\u56fd\u8054\u901a" : (networkOperator.equals("46003") ? "\u4e2d\u56fd\u7535\u4fe1" : telephonyManager.getSimOperatorName()));
        }
        return name;
    }

    public static void deleteFile(File file, String path, String libPath) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (libPath.equals(files[i].getPath())) continue;
                    AnalyticsUtility.deleteFile(files[i], path, libPath);
                }
            }
            if (!path.equals(file.getPath())) {
                file.delete();
            }
        }
    }

    public static void log(String text) {
        LogUtils.i("mmslog", text);
        if (!isLog) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)text) && BUtility.sdCardIsWork()) {
            String developPath = BUtility.getSdCardRootPath() + "widgetone/log/";
            File dir = new File(developPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = "mms_log_" + AnalyticsUtility.getCurYearAndMonth() + ".txt";
            File log = new File(developPath + fileName);
            try {
                if (!log.exists()) {
                    log.createNewFile();
                }
                BufferedWriter m_fout = new BufferedWriter(new FileWriter(log, true));
                m_fout.write("\r" + AnalyticsUtility.getNowTime() + "\r" + text);
                m_fout.flush();
                m_fout.close();
                m_fout = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSerialNumber() {
        String serial = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class);
            serial = (String)get.invoke(c, "ro.serialno");
            System.out.println(serial);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serial;
    }

    public static String getMamHost(Context context) {
        String mam_host = ResoureFinder.getInstance().getString(context, "mam_host");
        if (TextUtils.isEmpty((CharSequence)mam_host)) {
            mam_host = ResoureFinder.getInstance().getString(context, "widget_startup_report_host");
        }
        return mam_host;
    }

    public static boolean isAuthMam(Context context) {
        String auth = AnalyticsUtility.getWidgetConfigByLable(context, "MMSConfig", "auth");
        LogUtils.o("config isAuthMam:" + auth);
        return !"false".equals(auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWidgetConfigByLable(Context context, String label, String attribute) {
        String config = "";
        if (!TextUtils.isEmpty((CharSequence)label)) {
            String configFile = context.getFilesDir() + "/widget/config.xml";
            InputStream fis = null;
            InputStream fisResult = null;
            File file = new File(configFile);
            if (!file.exists()) {
                try {
                    fis = context.getAssets().open("widget/config.xml");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                fis = AnalyticsUtility.getFileInputStream(configFile);
            }
            if (fis != null) {
                try {
                    fisResult = AnalyticsUtility.decryptWidgetConfig(fis);
                    XmlPullParser parser = Xml.newPullParser();
                    parser.setInput(fisResult, "utf-8");
                    int tokenType = 0;
                    boolean needContinue = true;
                    do {
                        tokenType = parser.next();
                        switch (tokenType) {
                            case 2: {
                                String localName = parser.getName();
                                if (!label.equals(localName)) break;
                                config = !TextUtils.isEmpty((CharSequence)attribute) ? parser.getAttributeValue(null, attribute) : parser.nextText();
                                needContinue = false;
                                break;
                            }
                            case 1: {
                                needContinue = false;
                            }
                        }
                    } while (needContinue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            if (fisResult != null) {
                                fisResult.close();
                                fisResult = null;
                            }
                            fis.close();
                            fis = null;
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        }
        return config;
    }

    private static InputStream decryptWidgetConfig(InputStream inputStream) {
        ByteArrayInputStream fisResult = null;
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream fisCheck = new ByteArrayInputStream(baos.toByteArray());
            fisResult = new ByteArrayInputStream(baos.toByteArray());
            boolean isEncrypted = ACEDes.isEncrypted((InputStream)fisCheck);
            if (isEncrypted) {
                byte[] data = BUtility.transStreamToBytes((InputStream)fisResult, (int)((InputStream)fisResult).available());
                String result = ACEDes.htmlDecode((byte[])data, (String)"config");
                fisResult = new ByteArrayInputStream(result.getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fisResult;
    }

    public static FileInputStream getFileInputStream(String fileName) {
        FileInputStream fis = null;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File file = new File(fileName);
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fis;
    }
}

