/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class PushDBAdapter {
    public static final String F_DB_NAME = "push.db";
    public static final String F_WIDGET_TABLE_NAME = "push";
    public static final int F_DB_VERSION = 1;
    public static final String F_COLUMN_ID = "_id";
    public static final String F_COLUMN_TITLE = "title";
    public static final String F_COLUMN_BODY = "body";
    public static final String F_COLUMN_APPID = "appId";
    public static final String F_WIDGET_CREATE_TABLE = "CREATE TABLE push (_id INTEGER PRIMARY KEY,title TEXT,body TEXT,appId TEXT)";
    private DatabaseHelper DBHelper;
    private SQLiteDatabase db;

    public PushDBAdapter(Context ctx) {
        try {
            this.DBHelper = new DatabaseHelper(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PushDBAdapter open() throws SQLException {
        this.db = this.DBHelper.getWritableDatabase();
        return this;
    }

    public void close() {
        this.DBHelper.close();
    }

    public long insert(ContentValues cv, String tableName) {
        if (this.db == null || tableName == null || cv == null) {
            return -1L;
        }
        return this.db.insert(tableName, null, cv);
    }

    public int deleteTable(String tableName) {
        if (this.db == null) {
            return -1;
        }
        return this.db.delete(tableName, null, null);
    }

    public void update(String sql) {
        this.db.execSQL(sql);
    }

    public void delete(int id, String tableName) {
        this.db.delete(tableName, "_id=" + id, null);
    }

    public int deleteByAppID(String tableName, String appId) {
        return this.db.delete(tableName, "appId='" + appId + "'", null);
    }

    public Cursor select(String sql) {
        return this.db.rawQuery(sql, null);
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, PushDBAdapter.F_DB_NAME, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("DROP TABLE IF EXISTS push");
            db.execSQL(PushDBAdapter.F_WIDGET_CREATE_TABLE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS push");
            this.onCreate(db);
        }
    }
}

