/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.analytics;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.IBinder;
import android.text.TextUtils;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.base.BDebug;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.EBrowserActivity;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsConstants;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.push.MQTTService;
import org.zywx.wbpalmstar.plugin.uexmam.push.PushDataCallback;

public class PushService
extends Service
implements PushDataCallback {
    private int notificationNB = 0;
    private Timer timer = null;
    private long sleepTime = 0L;
    SharedPreferences preferences = null;
    private MyTimerTask myTimerTask = null;
    private String url_push = null;
    private int type = 0;
    private boolean isSend = false;
    private boolean isTemporary = false;
    private Object pushGetData = null;
    public static final int F_TYPE_PUSH = 10;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.start();
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
    }

    private void start() {
        String pushMes;
        this.preferences = this.getSharedPreferences(AnalyticsConstants.m_app, 1);
        this.url_push = ResoureFinder.getInstance().getString((Context)this, "push_host");
        SharedPreferences sp = this.getSharedPreferences(AnalyticsConstants.SP_SAVEDATA, 1);
        String localPushMes = sp.getString("localPushMes", pushMes = sp.getString("pushMes", "0"));
        this.type = "1".equals(localPushMes) && "1".equals(pushMes) ? 1 : 0;
        try {
            if (this.type == 0) {
                if (this.pushGetData != null) {
                    ((MQTTService)this.pushGetData).onDestroy();
                }
                return;
            }
            if (this.pushGetData == null) {
                String softToken = this.preferences.getString("softToken", null);
                this.pushGetData = new MQTTService((Context)this, this.url_push, this, softToken);
                ((MQTTService)this.pushGetData).init();
            } else {
                ((MQTTService)this.pushGetData).onDestroy();
                ((MQTTService)this.pushGetData).init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getPushInfo() {
        String softToken = this.preferences.getString("softToken", null);
        String reData = AnalyticsHttpClient.getGetData(this.url_push + softToken + "/listMsg", (Context)this);
        BDebug.d((String)"debug", (String)("push  reData = = " + reData));
        if (reData != null && reData.length() > 0) {
            try {
                JSONObject json = new JSONObject(reData);
                String status = json.getString("status");
                if ("ok".equals(status)) {
                    String messageList = json.getString("messageList");
                    JSONArray jsonArray = new JSONArray(messageList);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        this.runningNotification(jsonArray.getJSONObject(i));
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void notifiTimer() {
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
            this.myTimerTask = null;
        }
        this.myTimerTask = new MyTimerTask();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.myTimerTask, this.sleepTime, this.sleepTime);
    }

    private void runningNotification(JSONObject text) throws JSONException {
        String packg = this.getPackageName();
        Resources res = this.getResources();
        int icon = res.getIdentifier("icon", "drawable", packg);
        String ns = "notification";
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService(ns);
        String tickerText = text.getString("title");
        long when = System.currentTimeMillis();
        Notification notification = new Notification(icon, (CharSequence)tickerText, when);
        notification.flags = 16;
        notification.defaults |= 1;
        Context context = this.getApplicationContext();
        String widgetName = null;
        PackageManager pm = this.getPackageManager();
        PackageInfo pinfo = null;
        try {
            String appName;
            pinfo = pm.getPackageInfo(packg, 16384);
            widgetName = appName = pinfo.applicationInfo.loadLabel(this.getPackageManager()).toString();
            SharedPreferences.Editor editor = this.preferences.edit();
            editor.putString("widgetName", widgetName);
            editor.commit();
        }
        catch (Exception appName) {
            // empty catch block
        }
        if (TextUtils.isEmpty(widgetName)) {
            widgetName = this.preferences.getString("widgetName", "");
        }
        String contentTitle = widgetName;
        String contentText = text.getString("title");
        String value = text.getString("body");
        Intent notificationIntent = new Intent((Context)this, EBrowserActivity.class);
        notificationIntent.putExtra("data", value);
        notificationIntent.putExtra("ntype", 10);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)this.notificationNB, (Intent)notificationIntent, (int)0x8000000);
        notification.setLatestEventInfo(context, (CharSequence)contentTitle, (CharSequence)contentText, contentIntent);
        mNotificationManager.notify(this.notificationNB, notification);
        ++this.notificationNB;
    }

    private void onReceive() {
        String CONNECTIVITY_CHANGE_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                    if (PushService.this.isTemporary) {
                        PushService.this.sleepTime = 120000L;
                    } else {
                        PushService.this.sleepTime = 900000L;
                    }
                    PushService.this.notifiTimer();
                } else if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                    if (PushService.this.isTemporary) {
                        PushService.this.sleepTime = 30000L;
                    } else {
                        PushService.this.sleepTime = 120000L;
                    }
                    PushService.this.notifiTimer();
                }
                if (TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.net.conn.CONNECTIVITY_CHANGE")) {
                    ConnectivityManager mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
                    if (mConnMgr != null) {
                        NetworkInfo aActiveInfo = mConnMgr.getActiveNetworkInfo();
                        if (aActiveInfo != null && aActiveInfo.isConnectedOrConnecting()) {
                            if (!PushService.this.isSend && aActiveInfo.getType() == 1) {
                                PushService.this.isSend = true;
                            }
                        } else {
                            PushService.this.isSend = false;
                        }
                    } else {
                        PushService.this.isSend = false;
                    }
                }
            }
        }, filter);
    }

    public void stop() {
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
            this.myTimerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void pushData(JSONObject text) {
        try {
            this.runningNotification(text);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            PushService.this.getPushInfo();
            if (PushService.this.isTemporary && PushService.this.sleepTime == 120000L) {
                PushService.this.sleepTime = 900000L;
                PushService.this.notifiTimer();
                return;
            }
            if (PushService.this.sleepTime == 900000L) {
                PushService.this.sleepTime = 1800000L;
                PushService.this.notifiTimer();
            } else if (PushService.this.sleepTime == 1800000L) {
                PushService.this.sleepTime = 3600000L;
                PushService.this.notifiTimer();
            } else if (PushService.this.sleepTime == 3600000L) {
                PushService.this.sleepTime = 0x6DDD00L;
                PushService.this.notifiTimer();
            }
        }
    }
}

