/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class WDBAdapter {
    public static final String F_DB_NAME = "wbpalmstar.db";
    public static final String F_WIDGET_TABLE_NAME = "widget";
    public static final int F_DB_VERSION = 11;
    public static final String F_COLUMN_ID = "_id";
    public static final String F_COLUMN_WIDGETONEID = "widgetOneId";
    public static final String F_COLUMN_WIDGETID = "widgetId";
    public static final String F_COLUMN_APPID = "appId";
    public static final String F_COLUMN_NAME = "name";
    public static final String F_COLUMN_VER = "ver";
    public static final String F_COLUMN_CHANNELCODE = "channelCode";
    public static final String F_COLUMN_IMEI = "imei";
    public static final String F_COLUMN_MD5CODE = "md5Code";
    public static final String F_COLUMN_FILEPATH = "filePath";
    public static final String F_COLUMN_INDEXURL = "indexUrl";
    public static final String F_COLUMN_ICON = "icon";
    public static final String F_COLUMN_OBFUSCATION = "obfuscation";
    public static final String F_COLUMN_LOGSERVERIP = "logserverip";
    public static final String F_COLUMN_WGTTYPE = "wgtType";
    public static final String F_COLUMN_updateurl = "updateurl";
    public static final String F_COLUMN_SHOWSPACE = "spaceStatus";
    public static final String F_COLUMN_DESCRIPTION = "description";
    public static final String F_COLUMN_EMAIL = "email";
    public static final String F_COLUMN_AUTHOR = "author";
    public static final String F_COLUMN_LICENSE = "license";
    public static final String F_COLUMN_ORIENTATION = "orientation";
    public static final String F_WIDGET_CREATE_TABLE = "CREATE TABLE widget (_id INTEGER PRIMARY KEY,widgetOneId TEXT,widgetId TEXT,appId TEXT,name TEXT,ver TEXT,channelCode TEXT,imei TEXT,md5Code TEXT,filePath TEXT,indexUrl TEXT,icon TEXT,obfuscation INTEGER,logserverip TEXT,wgtType INTEGER,updateurl TEXT,spaceStatus INTEGER,description TEXT,email TEXT,author TEXT,license TEXT,orientation INTEGER)";
    private DatabaseHelper DBHelper;
    private SQLiteDatabase db;

    public WDBAdapter(Context ctx) {
        try {
            this.DBHelper = new DatabaseHelper(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WDBAdapter open() throws SQLException {
        this.db = this.DBHelper.getWritableDatabase();
        return this;
    }

    public void close() {
        this.DBHelper.close();
    }

    public long insert(ContentValues cv, String tableName) {
        if (this.db == null || tableName == null || cv == null) {
            return -1L;
        }
        return this.db.insert(tableName, null, cv);
    }

    public int deleteTable(String tableName) {
        if (this.db == null) {
            return -1;
        }
        return this.db.delete(tableName, null, null);
    }

    public void update(String sql) {
        this.db.execSQL(sql);
    }

    public void delete(int id, String tableName) {
        this.db.delete(tableName, "_id=" + id, null);
    }

    public int deleteByAppID(String tableName, String appId) {
        return this.db.delete(tableName, "appId='" + appId + "'", null);
    }

    public void deleteByType(int type) {
        this.db.delete(F_WIDGET_TABLE_NAME, "wgtType=" + type, null);
    }

    public Cursor select(String sql) {
        return this.db.rawQuery(sql, null);
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, WDBAdapter.F_DB_NAME, null, 11);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("DROP TABLE IF EXISTS widget");
            db.execSQL(WDBAdapter.F_WIDGET_CREATE_TABLE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP TABLE IF EXISTS widget");
            this.onCreate(db);
        }
    }
}

