/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.cache;

import android.app.ActivityManager;
import android.content.Context;
import android.os.MemoryFile;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.zywx.wbpalmstar.base.BDebug;
import org.zywx.wbpalmstar.plugin.uexmam.cache.BytesArrayFactory;

public class MemoryFileCache {
    public static final String TAG = "MemoryCache";
    private MemoryFile memoryFile;
    private int currentLayer;
    private int postion;
    private boolean isClosed = false;

    public MemoryFileCache(int capacity) throws IOException {
        if (capacity < 0) {
            throw new IllegalArgumentException("MemoryCache init capacity can't less than zero!!!");
        }
        this.memoryFile = new MemoryFile(String.valueOf(System.currentTimeMillis()), capacity);
        this.memoryFile.allowPurging(false);
        BDebug.d((String)TAG, (String)("MemoryFileCache()  capacity:" + this.memoryFile.length()));
    }

    public int getAvailableSize() {
        if (this.isClosed) {
            return 0;
        }
        return this.memoryFile.length() - this.postion;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized CacheBlock writeData(BytesArrayFactory.BytesArray bytesArray) {
        if (bytesArray == null) {
            throw new NullPointerException("NullPointer!");
        }
        if (this.isClosed) {
            return null;
        }
        CacheBlock cb = null;
        int length = bytesArray.size();
        try {
            int startIndex = this.postion;
            if (length > this.getAvailableSize()) {
                startIndex = 0;
                this.postion = 0;
                ++this.currentLayer;
            }
            this.memoryFile.writeBytes(bytesArray.getData(), 0, this.postion, length);
            this.postion += length;
            cb = new CacheBlock(startIndex, this.postion, this.currentLayer);
        }
        catch (IOException e) {
            e.printStackTrace();
            BDebug.e((String)TAG, (String)("writeData() Exception:" + e.getMessage()));
        }
        return cb;
    }

    public synchronized CacheBlock writeData(ByteArrayInputStream is, int buffSize) {
        long start = System.currentTimeMillis();
        if (is == null) {
            throw new NullPointerException("NullPointer!");
        }
        if (buffSize <= 0) {
            throw new IllegalArgumentException("bufferSize can't not less than zero!");
        }
        if (this.isClosed) {
            return null;
        }
        int dataLength = is.available();
        if (dataLength > this.memoryFile.length()) {
            return null;
        }
        CacheBlock cb = null;
        try {
            int startIndex = this.postion;
            if (dataLength > this.getAvailableSize()) {
                startIndex = 0;
                this.postion = 0;
                ++this.currentLayer;
            }
            byte[] buffer = new byte[buffSize];
            int actualSize = -1;
            while ((actualSize = is.read(buffer)) != -1) {
                this.memoryFile.writeBytes(buffer, 0, this.postion, actualSize);
                this.postion += actualSize;
            }
            cb = new CacheBlock(startIndex, this.postion, this.currentLayer);
        }
        catch (IOException e) {
            e.printStackTrace();
            BDebug.e((String)TAG, (String)("writeData() ERROR:" + e.getMessage()));
        }
        BDebug.d((String)TAG, (String)("writeData(): costTime:" + (System.currentTimeMillis() - start) + "ms   size:" + (float)dataLength / 1024.0f + "KB"));
        return cb;
    }

    public synchronized boolean canReadData(CacheBlock block) {
        if (block == null) {
            throw new NullPointerException("NullPointer!");
        }
        if (!block.isCorrect()) {
            throw new IllegalArgumentException("MemoryBlock info isn't correct!");
        }
        if (this.isClosed) {
            return false;
        }
        boolean canRead = false;
        int layerDelta = this.currentLayer - block.writeLayer;
        int totalLength = this.memoryFile.length();
        if (layerDelta == 0 && block.endIndex < totalLength) {
            canRead = true;
        } else if (layerDelta == 1 && block.startIndex >= this.postion && block.endIndex < totalLength) {
            canRead = true;
        }
        BDebug.d((String)TAG, (String)("canReadData: " + canRead + "  start:" + block.startIndex + "  end:" + block.endIndex + "  layer:" + block.writeLayer));
        return canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean readData(CacheBlock block, BytesArrayFactory.BytesArray bytesArray) {
        long startTime = System.currentTimeMillis();
        if (!this.canReadData(block)) {
            return false;
        }
        if (bytesArray == null) {
            return false;
        }
        int size = block.endIndex - block.startIndex;
        bytesArray.ensureCapacity(size);
        int readLength = 0;
        try {
            readLength = this.memoryFile.readBytes(bytesArray.getData(), block.startIndex, 0, size);
            bytesArray.setCount(readLength);
        }
        catch (IOException e) {
            BDebug.e((String)TAG, (String)("readData() " + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            BDebug.i((String)TAG, (String)("readData() readSize:" + (float)readLength / 1024.0f + "K" + " Start:" + block.startIndex + "  End:" + block.endIndex + "  Layer:" + block.writeLayer + "  costTime:" + (System.currentTimeMillis() - startTime) + "ms"));
        }
        return readLength == size;
    }

    public synchronized void close() {
        try {
            this.isClosed = true;
            this.memoryFile.allowPurging(true);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("close()  " + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            this.memoryFile = null;
        }
    }

    public static int getRecommendMemoryFileSize(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int memoryClass = activityManager.getMemoryClass();
        return memoryClass * 1024 * 1024;
    }

    public static final class CacheBlock {
        public int startIndex;
        public int endIndex;
        public int writeLayer;

        public CacheBlock() {
        }

        public CacheBlock(int startIndex, int endIndex, int writeLayer) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.writeLayer = writeLayer;
        }

        public boolean isCorrect() {
            return this.startIndex >= 0 && this.endIndex > this.startIndex && this.writeLayer >= 0;
        }

        public boolean equals(Object block) {
            if (this == block) {
                return true;
            }
            if (!(block instanceof CacheBlock)) {
                return false;
            }
            CacheBlock mb = (CacheBlock)block;
            return mb.startIndex == this.startIndex && mb.endIndex == this.endIndex && mb.writeLayer == this.writeLayer;
        }
    }
}

