/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.certificates;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.zywx.wbpalmstar.platform.certificates.HNetSSLSocketFactory;
import org.zywx.wbpalmstar.platform.certificates.HSSLSocketFactory;
import org.zywx.wbpalmstar.platform.certificates.HX509HostnameVerifier;

public class Http {
    public static HashMap<String, KeyStore> KEY_STORE = new HashMap();
    public static String algorithm = "X509";
    public static String keyType = "pkcs12";

    public static HttpClient getHttpsClient(int mTimeOut) {
        try {
            KeyStore trustStore = KeyStore.getInstance(keyType);
            trustStore.load(null, null);
            HSSLSocketFactory socketFact = new HSSLSocketFactory(trustStore, null);
            socketFact.setHostnameVerifier((X509HostnameVerifier)new HX509HostnameVerifier());
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)socketFact, 443));
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)mTimeOut);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)mTimeOut);
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getHttpsClientWithCert(String cPassWord, String cPath, int mTimeOut, Context ctx) {
        InputStream inStream = null;
        try {
            int index = cPath.lastIndexOf(47);
            String keyName = cPath.substring(index);
            KeyStore ksP12 = KEY_STORE.get(keyName);
            if (null == ksP12) {
                String assertFile = "file:///android_asset/";
                String sdcardFile = "file:///sdcard";
                if (cPath.startsWith(assertFile)) {
                    cPath = cPath.substring(assertFile.length());
                    AssetManager asset = ctx.getAssets();
                    inStream = asset.open(cPath);
                } else if (cPath.startsWith(sdcardFile)) {
                    cPath = cPath.substring("file://".length());
                    inStream = new FileInputStream(cPath);
                } else {
                    inStream = new FileInputStream(cPath);
                }
                ksP12 = KeyStore.getInstance(keyType);
                ksP12.load(inStream, cPassWord.toCharArray());
                KEY_STORE.put(keyName, ksP12);
            }
            HSSLSocketFactory socketFact = new HSSLSocketFactory(ksP12, cPassWord);
            socketFact.setHostnameVerifier((X509HostnameVerifier)new HX509HostnameVerifier());
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme("https", (SocketFactory)socketFact, 443));
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)mTimeOut);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)mTimeOut);
            HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
            HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
            ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            return defaultHttpClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpClient httpClient = null;
            return httpClient;
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static HttpClient getHttpClient(int mTimeOut) {
        BasicHttpParams bparams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)bparams, (int)mTimeOut);
        HttpConnectionParams.setSoTimeout((HttpParams)bparams, (int)mTimeOut);
        HttpConnectionParams.setSocketBufferSize((HttpParams)bparams, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)bparams, (boolean)true);
        return new DefaultHttpClient((HttpParams)bparams);
    }

    public static HNetSSLSocketFactory getSSLSocketFactoryWithCert(String cPassWord, String cPath, Context ctx) {
        InputStream inStream = null;
        HNetSSLSocketFactory ssSocketFactory = null;
        try {
            int index = cPath.lastIndexOf(47);
            String keyName = cPath.substring(index);
            KeyStore ksP12 = KEY_STORE.get(keyName);
            if (null == ksP12) {
                String assertFile = "file:///android_asset/";
                String sdcardFile = "/sdcard/";
                String wgtFile = "/wgtRes/";
                String file = "file://";
                if (cPath.contains(assertFile)) {
                    cPath = cPath.substring(assertFile.length());
                    AssetManager asset = ctx.getAssets();
                    inStream = asset.open(cPath);
                } else if (cPath.contains(sdcardFile)) {
                    if (cPath.contains(file)) {
                        cPath = cPath.substring("file://".length());
                    }
                    inStream = new FileInputStream(cPath);
                } else if (cPath.contains(wgtFile)) {
                    if (cPath.contains(assertFile)) {
                        cPath = cPath.substring(assertFile.length());
                    }
                    AssetManager asset = ctx.getAssets();
                    inStream = asset.open(cPath);
                } else {
                    inStream = new FileInputStream(cPath);
                }
                ksP12 = KeyStore.getInstance("pkcs12");
                ksP12.load(inStream, cPassWord.toCharArray());
                KEY_STORE.put(keyName, ksP12);
            }
            ssSocketFactory = new HNetSSLSocketFactory(ksP12, cPassWord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ssSocketFactory;
    }
}

