/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.mam;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsUtility;
import org.zywx.wbpalmstar.plugin.uexmam.mam.EResources;
import org.zywx.wbpalmstar.plugin.uexmam.mam.MAMFinishCallback;
import org.zywx.wbpalmstar.plugin.uexmam.mam.Rc4Encrypt;

public class MAMFormActivity
extends Activity
implements View.OnClickListener {
    private RelativeLayout contentView;
    private RelativeLayout formRelativeLayout;
    private RelativeLayout policyRelativeLayout;
    private RelativeLayout scrollViewRelativeLayout;
    private RelativeLayout passiveRelativeLayout;
    private RelativeLayout lvRelativeLayout;
    private TextView textViewTile;
    private TextView activeTextView;
    private TextView passiveTextView;
    private EditText passiveEditText;
    private Button activeButton;
    private Button passiveButton;
    private List<View> formList = new ArrayList<View>();
    private AlertDialog progressDialog;
    private Thread myThread;
    private int tile_textview_id = 1;
    private int activeButton_id = 2;
    private int policyLayout_id = 3;
    private int policyTextViewLabel_id = 4;
    private int activeTextView_id = 5;
    private int formRelativeLayout_id = 6;
    private int passiveTextView_id = 7;
    private int passiveTextViewLabel_id = 8;
    private int passiveButton_id = 9;
    private int passiveRelativeLayout_id = 10;
    private int initLicenseVerification_TextView_id = 11;
    private int lvRelativeLayout_id = 12;
    private int mam_form_textViewLabel_id = 100;
    private int mam_form_lvEditText_id = 200;
    private int mam_form_policy_textViewLabel_id = 300;
    private Context mContext;
    private String softToken;
    private final int inputType_Text = 0;
    private final int inputType_num = 1;
    private final int inputType_phone = 2;
    private final int inputType_email = 3;
    private final int inputType_optionsList = 4;
    private final int JSON_FAIL_MSG = 1;
    private final int GETFORM_FAIL_MSG = 2;
    private final int GETFORM_SUCCESS_MSG = 3;
    private final int SUBMITFORM_SUCCESS_MSG = 4;
    private final int CHECKAT_SUCCESS_MSG = 5;
    private final int CHECKAT_FAIL_MSG = 6;
    private final int MAM_FINISH_MSG = 7;
    private final int POLICY_CHANGE = 8;
    private final int SUBMIT_FAIL_MSG = 9;
    public static final int uncommitted_audit = 0;
    public static final int committed_audit = 1;
    public static final int bind = 2;
    public static final int notNet = 3;
    private static final int auditType_All = 0;
    private static final int auditType_Active = 1;
    private static final int auditType_Passive = 2;
    private String auditSid;
    private String auditType;
    private String mam_host = null;
    private String authType = null;
    private Spinner policySpinner;
    private static MAMFinishCallback mFinishCallback;
    private Map<String, JSONArray> policyMap = new HashMap<String, JSONArray>();
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (MAMFormActivity.this.progressDialog != null && MAMFormActivity.this.progressDialog.isShowing()) {
                MAMFormActivity.this.progressDialog.dismiss();
            }
            switch (msg.what) {
                case 1: {
                    MAMFormActivity.this.showDialog("\u8ba4\u8bc1\u5931\u8d25\uff0c\u662f\u5426\u91cd\u65b0\u8ba4\u8bc1\uff1f", 2, null);
                    break;
                }
                case 2: {
                    Toast.makeText((Context)MAMFormActivity.this.mContext, (CharSequence)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25!", (int)1).show();
                    break;
                }
                case 3: {
                    MAMFormActivity.this.initForm(MAMFormActivity.this.formRelativeLayout, (String)msg.obj);
                    break;
                }
                case 4: {
                    MAMFormActivity.this.auditSid = (String)msg.obj;
                    MAMFormActivity.this.sveAuditSid(MAMFormActivity.this.auditSid);
                    MAMFormActivity.this.changeStatus(1, null);
                    MAMFormActivity.this.showLicenseVerificationView(true);
                    break;
                }
                case 5: {
                    MAMFormActivity.this.getSid();
                    break;
                }
                case 6: {
                    MAMFormActivity.this.getForm();
                    break;
                }
                case 7: {
                    String res = (String)msg.obj;
                    if (TextUtils.isEmpty((CharSequence)res)) {
                        res = "";
                    }
                    MAMFormActivity.this.showDialog("\u60a8\u5df2\u7ecf\u5b8c\u6210\u4e86\u8eab\u4efd\u8ba4\u8bc1\uff0c\u611f\u8c22\u60a8\u4f7f\u7528\u672c\u8f6f\u4ef6\uff01", 1, res);
                    break;
                }
                case 8: {
                    MAMFormActivity.this.changePolicy((JSONArray)msg.obj);
                    break;
                }
                case 9: {
                    MAMFormActivity.this.showDialog("\u60a8\u7684\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u7533\u8bf7\uff01", 0, null);
                    break;
                }
            }
        }
    };
    boolean isAllKeyDownUp = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this;
        this.softToken = this.getIntent().getStringExtra("SoftToken");
        this.auditType = this.getIntent().getStringExtra("auditType");
        this.authType = this.getIntent().getStringExtra("authType");
        int isPortrait = this.getIntent().getIntExtra("Orientation", 2);
        this.getWindow().requestFeature(1);
        this.setRequestedOrientation(isPortrait);
        this.mam_host = AnalyticsUtility.getMamHost((Context)this);
        this.contentView = new RelativeLayout((Context)this);
        this.contentView.setBackgroundResource(EUExUtil.getResDrawableID((String)"startup_bg"));
        this.textViewTile = new TextView((Context)this);
        this.textViewTile.setId(this.tile_textview_id);
        this.textViewTile.setText((CharSequence)"\u6388\u6743\u7533\u8bf7");
        this.textViewTile.setTextColor(Color.parseColor((String)"#FFFFFFFF"));
        this.textViewTile.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_title_bg_shape"));
        this.textViewTile.setGravity(17);
        this.textViewTile.setVisibility(8);
        RelativeLayout.LayoutParams lp_tile_textview = new RelativeLayout.LayoutParams(-1, this.dipToInt(40));
        lp_tile_textview.addRule(10);
        lp_tile_textview.addRule(14, -1);
        this.contentView.addView((View)this.textViewTile, (ViewGroup.LayoutParams)lp_tile_textview);
        if ("InCourseOf".equals(this.authType)) {
            Button button = new Button((Context)this);
            button.setText((CharSequence)"\u53d6\u6d88");
            button.setTextSize(13.0f);
            button.setTextColor(Color.parseColor((String)"#FFFFFFFF"));
            button.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_title_button_selector"));
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MAMFormActivity.this.finish();
                }
            });
            RelativeLayout.LayoutParams lp_tile_button = new RelativeLayout.LayoutParams(this.dipToInt(50), this.dipToInt(35));
            lp_tile_button.addRule(9);
            lp_tile_button.topMargin = this.dipToInt(3);
            lp_tile_button.leftMargin = this.dipToInt(5);
            this.contentView.addView((View)button, (ViewGroup.LayoutParams)lp_tile_button);
        }
        this.scrollViewRelativeLayout = new RelativeLayout((Context)this);
        ScrollView scrollview = new ScrollView((Context)this);
        scrollview.setVerticalScrollBarEnabled(false);
        this.initActiveTextView(this.scrollViewRelativeLayout);
        this.initPolicyRelativeLayout(this.scrollViewRelativeLayout);
        this.initActiveRelativeLayout(this.scrollViewRelativeLayout);
        this.initActiveButton(this.scrollViewRelativeLayout);
        this.initLicenseVerification(this.scrollViewRelativeLayout);
        this.initPassiveTextView(this.scrollViewRelativeLayout);
        this.initPassiveRelativeLayout(this.scrollViewRelativeLayout);
        this.initPassiveButton(this.scrollViewRelativeLayout);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.topMargin = this.dipToInt(20);
        layoutParams.bottomMargin = this.dipToInt(10);
        layoutParams.addRule(3, this.tile_textview_id);
        scrollview.addView((View)this.scrollViewRelativeLayout);
        this.contentView.addView((View)scrollview, (ViewGroup.LayoutParams)layoutParams);
        this.setContentView((View)this.contentView);
        int auditTy = 0;
        if ("Passive".equals(this.auditType)) {
            auditTy = 2;
        } else if ("Active".equals(this.auditType)) {
            auditTy = 1;
        }
        this.showView(auditTy);
    }

    private void initActiveTextView(RelativeLayout relativeLayout) {
        this.activeTextView = new TextView((Context)this);
        this.activeTextView.setId(this.activeTextView_id);
        this.activeTextView.setText((CharSequence)"\u8bf7\u586b\u5199\u8ba4\u8bc1\u4fe1\u606f\u5e76\u63d0\u4ea4\u7533\u8bf7\u5b8c\u6210\u8ba4\u8bc1");
        this.activeTextView.setTextColor(Color.parseColor((String)"#000000"));
        this.activeTextView.setGravity(17);
        RelativeLayout.LayoutParams textViewShuomingLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        textViewShuomingLayoutParams.addRule(14, -1);
        this.activeTextView.setVisibility(8);
        relativeLayout.addView((View)this.activeTextView, (ViewGroup.LayoutParams)textViewShuomingLayoutParams);
    }

    private void initPolicyRelativeLayout(RelativeLayout relativeLayout) {
        this.policyRelativeLayout = new RelativeLayout((Context)this);
        this.policyRelativeLayout.setId(this.policyLayout_id);
        RelativeLayout.LayoutParams policyRelativeLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), -2);
        policyRelativeLayoutParams.addRule(13, -1);
        relativeLayout.addView((View)this.policyRelativeLayout, (ViewGroup.LayoutParams)policyRelativeLayoutParams);
    }

    private void initActiveRelativeLayout(RelativeLayout relativeLayout) {
        this.formRelativeLayout = new RelativeLayout((Context)this);
        this.formRelativeLayout.setId(this.formRelativeLayout_id);
        RelativeLayout.LayoutParams formLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        formLayoutParams.addRule(14, -1);
        formLayoutParams.topMargin = this.dipToInt(20);
        formLayoutParams.addRule(3, this.policyLayout_id);
        relativeLayout.addView((View)this.formRelativeLayout, (ViewGroup.LayoutParams)formLayoutParams);
    }

    private void initActiveButton(RelativeLayout relativeLayout) {
        this.activeButton = new Button((Context)this);
        this.activeButton.setId(this.activeButton_id);
        this.activeButton.setText((CharSequence)"\u7533\u8bf7");
        this.activeButton.setWidth(this.dipToInt(270));
        this.activeButton.setTextColor(Color.parseColor((String)"#000000"));
        this.activeButton.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_button_selector"));
        this.activeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MAMFormActivity.this.submit();
            }
        });
        this.activeButton.setVisibility(8);
        RelativeLayout.LayoutParams buttonLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), this.dipToInt(40));
        buttonLayoutParams.topMargin = this.dipToInt(3);
        buttonLayoutParams.addRule(3, this.formRelativeLayout_id);
        relativeLayout.addView((View)this.activeButton, (ViewGroup.LayoutParams)buttonLayoutParams);
    }

    private void initPassiveTextView(RelativeLayout relativeLayout) {
        this.passiveTextView = new TextView((Context)this);
        this.passiveTextView.setId(this.passiveTextView_id);
        this.passiveTextView.setText((CharSequence)"\u5982\u679c\u60a8\u5df2\u7ecf\u6709\u7ba1\u7406\u5458\u9881\u53d1\u768416\u4f4d\u6570\u5b57\u5bc6\u7801\uff0c\u4f60\u53ef\u5728\u4e0b\u65b9\u586b\u5199\u5b8c\u6210\u8ba4\u8bc1");
        this.passiveTextView.setTextColor(Color.parseColor((String)"#000000"));
        this.passiveTextView.setGravity(17);
        RelativeLayout.LayoutParams passiveTextViewLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), -2);
        passiveTextViewLayoutParams.topMargin = this.dipToInt(5);
        passiveTextViewLayoutParams.addRule(3, this.lvRelativeLayout_id);
        this.passiveTextView.setVisibility(8);
        relativeLayout.addView((View)this.passiveTextView, (ViewGroup.LayoutParams)passiveTextViewLayoutParams);
    }

    private void initPassiveRelativeLayout(RelativeLayout relativeLayout) {
        this.passiveRelativeLayout = new RelativeLayout((Context)this);
        this.passiveRelativeLayout.setId(this.passiveRelativeLayout_id);
        RelativeLayout.LayoutParams passiveLayoutParams1 = new RelativeLayout.LayoutParams(-2, this.dipToInt(50));
        passiveLayoutParams1.topMargin = this.dipToInt(5);
        TextView passiveTextViewLabel = new TextView((Context)this);
        passiveTextViewLabel.setId(this.passiveTextViewLabel_id);
        passiveTextViewLabel.setText((CharSequence)"\u8ba4\u8bc1\u5bc6\u7801:");
        passiveTextViewLabel.setTextColor(Color.parseColor((String)"#000000"));
        passiveTextViewLabel.setWidth(this.dipToInt(100));
        passiveTextViewLabel.setGravity(17);
        this.passiveRelativeLayout.addView((View)passiveTextViewLabel, (ViewGroup.LayoutParams)passiveLayoutParams1);
        RelativeLayout.LayoutParams passiveLayoutParams2 = new RelativeLayout.LayoutParams(this.dipToInt(170), this.dipToInt(50));
        passiveLayoutParams2.topMargin = this.dipToInt(5);
        passiveLayoutParams2.rightMargin = this.dipToInt(10);
        passiveLayoutParams2.addRule(1, this.passiveTextViewLabel_id);
        this.passiveEditText = new EditText((Context)this);
        this.passiveEditText.setHintTextColor(Color.parseColor((String)"#004598"));
        this.passiveEditText.setBackgroundDrawable(null);
        this.passiveEditText.setSingleLine();
        this.passiveEditText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u8ba4\u8bc1\u5bc6\u7801");
        this.passiveRelativeLayout.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_login_bg_shape"));
        this.passiveRelativeLayout.addView((View)this.passiveEditText, (ViewGroup.LayoutParams)passiveLayoutParams2);
        RelativeLayout.LayoutParams passiveRelativeLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), -2);
        passiveRelativeLayoutParams.topMargin = this.dipToInt(5);
        passiveRelativeLayoutParams.addRule(3, this.passiveTextView_id);
        this.passiveRelativeLayout.setVisibility(8);
        relativeLayout.addView((View)this.passiveRelativeLayout, (ViewGroup.LayoutParams)passiveRelativeLayoutParams);
    }

    private void initPassiveButton(RelativeLayout relativeLayout) {
        this.passiveButton = new Button((Context)this);
        this.passiveButton.setId(this.passiveButton_id);
        this.passiveButton.setText((CharSequence)"\u63d0\u4ea4");
        this.passiveButton.setWidth(this.dipToInt(270));
        this.passiveButton.setTextColor(Color.parseColor((String)"#000000"));
        this.passiveButton.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_button_selector"));
        this.passiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String value = MAMFormActivity.this.passiveEditText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)value)) {
                    Toast.makeText((Context)MAMFormActivity.this.mContext, (CharSequence)"\u8ba4\u8bc1\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (int)1).show();
                    return;
                }
                if (value.length() != 16 || !MAMFormActivity.this.isNumeric(value)) {
                    Toast.makeText((Context)MAMFormActivity.this.mContext, (CharSequence)"\u8ba4\u8bc1\u5bc6\u7801\u5fc5\u987b\u4e3a16\u4f4d\u6570\u5b57!", (int)1).show();
                    return;
                }
                MAMFormActivity.this.passiveSubmit(value);
            }
        });
        this.passiveButton.setVisibility(8);
        RelativeLayout.LayoutParams buttonLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), this.dipToInt(40));
        buttonLayoutParams.topMargin = this.dipToInt(3);
        buttonLayoutParams.addRule(3, this.passiveRelativeLayout_id);
        relativeLayout.addView((View)this.passiveButton, (ViewGroup.LayoutParams)buttonLayoutParams);
    }

    private void initLicenseVerification(RelativeLayout relativeLayout) {
        this.lvRelativeLayout = new RelativeLayout((Context)this);
        this.lvRelativeLayout.setId(this.lvRelativeLayout_id);
        this.lvRelativeLayout.setVisibility(8);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(14, -1);
        layoutParams.addRule(3, this.activeButton_id);
        relativeLayout.addView((View)this.lvRelativeLayout, (ViewGroup.LayoutParams)layoutParams);
        TextView textView = new TextView((Context)this);
        textView.setId(this.initLicenseVerification_TextView_id);
        textView.setText((CharSequence)"\u60a8\u4e3b\u52a8\u63d0\u4ea4\u7684\u8ba4\u8bc1\u8bf7\u5728\u6b64\u8f93\u5165\u7ba1\u7406\u5458\u9881\u53d1\u76846\u4f4d\u5bc6\u7801\uff0c\u5b8c\u6210\u8ba4\u8bc1\u786e\u8ba4");
        textView.setTextColor(Color.parseColor((String)"#000000"));
        textView.setGravity(17);
        RelativeLayout.LayoutParams textViewLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), -2);
        this.lvRelativeLayout.addView((View)textView, (ViewGroup.LayoutParams)textViewLayoutParams);
        RelativeLayout.LayoutParams editTextLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), -2);
        editTextLayoutParams.addRule(3, this.initLicenseVerification_TextView_id);
        final EditText editText = new EditText((Context)this);
        editText.setWidth(this.dipToInt(270));
        editText.setId(this.mam_form_lvEditText_id);
        editText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u6388\u6743\u9a8c\u8bc1\u7801");
        editText.setHintTextColor(Color.parseColor((String)"#004598"));
        this.lvRelativeLayout.addView((View)editText, (ViewGroup.LayoutParams)editTextLayoutParams);
        Button lvButton = new Button((Context)this);
        lvButton.setText((CharSequence)"\u63d0\u4ea4");
        lvButton.setTextColor(Color.parseColor((String)"#000000"));
        lvButton.setWidth(this.dipToInt(270));
        lvButton.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_button_selector"));
        lvButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String value = editText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)value) || value.length() != 6) {
                    Toast.makeText((Context)MAMFormActivity.this.mContext, (CharSequence)"\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f6\u4f4d\u5bc6\u7801!", (int)1).show();
                } else {
                    MAMFormActivity.this.lvSubmit(value);
                }
            }
        });
        RelativeLayout.LayoutParams lvButtonLayoutParams = new RelativeLayout.LayoutParams(this.dipToInt(270), this.dipToInt(40));
        lvButtonLayoutParams.addRule(14, -1);
        lvButtonLayoutParams.topMargin = this.dipToInt(10);
        lvButtonLayoutParams.addRule(3, this.mam_form_lvEditText_id);
        this.lvRelativeLayout.addView((View)lvButton, (ViewGroup.LayoutParams)lvButtonLayoutParams);
    }

    private void showView(int type) {
        switch (type) {
            case 0: {
                if (this.getStatus() == 0) {
                    this.getForm();
                    break;
                }
                if (this.getStatus() == 1) {
                    this.showLicenseVerificationView(true);
                    break;
                }
                if (this.getStatus() != 2) break;
                this.getSid();
                break;
            }
            case 1: {
                this.passiveTextView.setVisibility(8);
                this.passiveRelativeLayout.setVisibility(8);
                this.passiveButton.setVisibility(8);
                if (this.getStatus() == 0) {
                    this.getForm();
                    break;
                }
                if (this.getStatus() == 1) {
                    this.showLicenseVerificationView(true);
                    break;
                }
                if (this.getStatus() != 2) break;
                this.getSid();
                break;
            }
            case 2: {
                this.activeTextView.setVisibility(8);
                this.policyRelativeLayout.setVisibility(8);
                this.formRelativeLayout.setVisibility(8);
                this.activeButton.setVisibility(8);
                break;
            }
        }
    }

    private void submit() {
        boolean isOk = true;
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (View view : this.formList) {
            String[] tag = ((String)view.getTag()).split(";");
            if (view instanceof EditText) {
                String value = ((EditText)view).getText().toString();
                if (TextUtils.isEmpty((CharSequence)value)) {
                    Toast.makeText((Context)this.mContext, (CharSequence)(tag[2] + "\u4e0d\u80fd\u4e3a\u7a7a!"), (int)1).show();
                    return;
                }
                switch (Integer.parseInt(tag[0])) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (this.isNumeric(value)) break;
                        isOk = false;
                        Toast.makeText((Context)this.mContext, (CharSequence)(tag[2] + "\u5fc5\u987b\u4e3a\u6570\u5b57!"), (int)1).show();
                        break;
                    }
                    case 2: {
                        if (this.isMobileNO(value)) break;
                        isOk = false;
                        Toast.makeText((Context)this.mContext, (CharSequence)(tag[2] + "\u4e0d\u662f\u6709\u6548\u7684\u624b\u673a\u53f7\u7801!"), (int)1).show();
                        break;
                    }
                    case 3: {
                        if (this.checkEmail(value)) break;
                        isOk = false;
                        Toast.makeText((Context)this.mContext, (CharSequence)(tag[2] + "\u4e0d\u662f\u6709\u6548\u7684\u90ae\u7bb1\u5730\u5740!"), (int)1).show();
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                if (!isOk) {
                    return;
                }
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(tag[1], value));
                continue;
            }
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(tag[1], (String)((Spinner)view).getSelectedItem()));
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("policyName", (String)this.policySpinner.getSelectedItem()));
        this.sendPost(nameValuePairs);
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private boolean isMobileNO(String mobiles) {
        Pattern p = Pattern.compile("^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    private boolean checkEmail(String email) {
        return email.matches("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");
    }

    private void initForm(RelativeLayout relativeLayout, String value) {
        try {
            JSONArray infoJArray = new JSONArray(value);
            for (int i = 0; i < infoJArray.length(); ++i) {
                String policyName = infoJArray.getJSONObject(i).getString("policy");
                this.policyMap.put(policyName, infoJArray.getJSONObject(i).getJSONArray("fields"));
                RelativeLayout.LayoutParams policyLayoutParams = new RelativeLayout.LayoutParams(-2, this.dipToInt(50));
                if (i > 0) {
                    policyLayoutParams.addRule(3, this.mam_form_policy_textViewLabel_id - 1);
                    policyLayoutParams.topMargin = this.dipToInt(15);
                }
                TextView policyTextViewLabel = new TextView((Context)this);
                policyTextViewLabel.setId(this.mam_form_policy_textViewLabel_id);
                policyTextViewLabel.setText((CharSequence)policyName);
                policyTextViewLabel.setTextColor(Color.parseColor((String)"#000000"));
                policyTextViewLabel.setGravity(17);
                policyTextViewLabel.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_textview_bg"));
                this.policyRelativeLayout.addView((View)policyTextViewLabel, (ViewGroup.LayoutParams)policyLayoutParams);
                policyTextViewLabel.setTag((Object)infoJArray.getJSONObject(i).getJSONArray("fields"));
                policyTextViewLabel.setOnClickListener((View.OnClickListener)this);
                ++this.mam_form_policy_textViewLabel_id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void changePolicy(JSONArray jsonArray) {
        this.policyRelativeLayout.setVisibility(8);
        this.formRelativeLayout.setVisibility(0);
        try {
            this.formRelativeLayout.removeAllViews();
            this.formList.clear();
            this.mam_form_textViewLabel_id = 100;
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject json = jsonArray.getJSONObject(i);
                RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(-2, this.dipToInt(50));
                layoutParams1.topMargin = this.dipToInt(10);
                if (i == jsonArray.length() - 1) {
                    layoutParams1.bottomMargin = this.dipToInt(20);
                }
                if (this.mam_form_textViewLabel_id != 100) {
                    layoutParams1.addRule(3, this.mam_form_textViewLabel_id - 1);
                }
                TextView textViewLabel = new TextView((Context)this);
                textViewLabel.setId(this.mam_form_textViewLabel_id);
                String inputLabel = json.getString("inputLabel");
                textViewLabel.setText((CharSequence)(inputLabel + ":"));
                textViewLabel.setTextColor(Color.parseColor((String)"#000000"));
                textViewLabel.setWidth(this.dipToInt(100));
                textViewLabel.setGravity(17);
                this.formRelativeLayout.addView((View)textViewLabel, (ViewGroup.LayoutParams)layoutParams1);
                RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(this.dipToInt(170), this.dipToInt(50));
                layoutParams2.topMargin = this.dipToInt(10);
                if (i == jsonArray.length() - 1) {
                    layoutParams2.bottomMargin = this.dipToInt(20);
                }
                layoutParams2.rightMargin = this.dipToInt(10);
                layoutParams2.addRule(1, this.mam_form_textViewLabel_id);
                if (this.mam_form_textViewLabel_id != 100) {
                    layoutParams2.addRule(3, this.mam_form_textViewLabel_id - 1);
                }
                switch (json.getInt("inputType")) {
                    case 0: {
                        EditText editText = new EditText((Context)this);
                        editText.setHintTextColor(Color.parseColor((String)"#004598"));
                        editText.setBackgroundDrawable(null);
                        editText.setTag((Object)("0;" + json.getString("inputName") + ";" + inputLabel));
                        editText.setSingleLine();
                        editText.setHint((CharSequence)json.getString("defaultValue"));
                        this.formRelativeLayout.addView((View)editText, (ViewGroup.LayoutParams)layoutParams2);
                        this.formList.add((View)editText);
                        break;
                    }
                    case 1: {
                        EditText editNum = new EditText((Context)this);
                        editNum.setHintTextColor(Color.parseColor((String)"#004598"));
                        editNum.setBackgroundDrawable(null);
                        editNum.setTag((Object)("1;" + json.getString("inputName") + ";" + inputLabel));
                        editNum.setSingleLine();
                        editNum.setHint((CharSequence)json.getString("defaultValue"));
                        editNum.setInputType(2);
                        this.formRelativeLayout.addView((View)editNum, (ViewGroup.LayoutParams)layoutParams2);
                        this.formList.add((View)editNum);
                        break;
                    }
                    case 2: {
                        EditText editPhone = new EditText((Context)this);
                        editPhone.setHintTextColor(Color.parseColor((String)"#004598"));
                        editPhone.setBackgroundDrawable(null);
                        editPhone.setTag((Object)("2;" + json.getString("inputName") + ";" + inputLabel));
                        editPhone.setSingleLine();
                        editPhone.setHint((CharSequence)json.getString("defaultValue"));
                        editPhone.setInputType(3);
                        this.formRelativeLayout.addView((View)editPhone, (ViewGroup.LayoutParams)layoutParams2);
                        this.formList.add((View)editPhone);
                        break;
                    }
                    case 3: {
                        EditText editEmai = new EditText((Context)this);
                        editEmai.setHintTextColor(Color.parseColor((String)"#004598"));
                        editEmai.setBackgroundDrawable(null);
                        editEmai.setTag((Object)("3;" + json.getString("inputName") + ";" + inputLabel));
                        editEmai.setSingleLine();
                        editEmai.setHint((CharSequence)json.getString("defaultValue"));
                        editEmai.setInputType(1);
                        this.formRelativeLayout.addView((View)editEmai, (ViewGroup.LayoutParams)layoutParams2);
                        this.formList.add((View)editEmai);
                        break;
                    }
                    case 4: {
                        String optionsString = json.getString("optionsList");
                        if (TextUtils.isEmpty((CharSequence)optionsString)) break;
                        ArrayAdapter adapter = new ArrayAdapter((Context)this, 17367048);
                        adapter.setDropDownViewResource(0x1090009);
                        optionsString = optionsString.replaceAll("\"", "");
                        String[] optionsList = optionsString.substring(1, optionsString.length() - 1).split(",");
                        Spinner spinner = new Spinner((Context)this);
                        spinner.setAdapter((SpinnerAdapter)adapter);
                        spinner.setTag((Object)("4;" + json.getString("inputName") + ";" + inputLabel));
                        for (int j = 0; j < optionsList.length; ++j) {
                            if (optionsList[j].equals(json.getString("defaultValue"))) {
                                spinner.setSelection(j);
                            }
                            adapter.add((Object)optionsList[j]);
                        }
                        this.formRelativeLayout.addView((View)spinner, (ViewGroup.LayoutParams)layoutParams2);
                        this.formList.add((View)spinner);
                        break;
                    }
                }
                if (i != jsonArray.length() - 1) {
                    ImageView imageView = new ImageView((Context)this);
                    imageView.setBackgroundColor(Color.parseColor((String)"#C5C5C5"));
                    RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(this.dipToInt(270), this.dipToInt(2));
                    layoutParams3.topMargin = this.dipToInt(4);
                    layoutParams3.rightMargin = 0;
                    layoutParams3.leftMargin = 0;
                    layoutParams3.addRule(3, this.mam_form_textViewLabel_id);
                    this.formRelativeLayout.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams3);
                }
                ++this.mam_form_textViewLabel_id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.formRelativeLayout.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_login_bg_shape"));
    }

    private void getForm() {
        this.initProgressDialog();
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Message msg = new Message();
                try {
                    String res = AnalyticsHttpClient.getGetData(MAMFormActivity.this.mam_host + "/term/" + AnalyticsAgent.m_rootWgt.m_appId + "/form", MAMFormActivity.this.mContext);
                    if (TextUtils.isEmpty((CharSequence)res)) {
                        msg.what = 1;
                        MAMFormActivity.this.handler.sendMessage(msg);
                        return;
                    }
                    JSONObject json = new JSONObject(res);
                    if ("ok".equals(json.getString("status"))) {
                        msg.what = 3;
                        msg.obj = json.getString("info");
                        MAMFormActivity.this.handler.sendMessage(msg);
                    } else {
                        msg.what = 2;
                        MAMFormActivity.this.handler.sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    msg.what = 2;
                    MAMFormActivity.this.handler.sendMessage(msg);
                }
            }
        });
        this.myThread.start();
    }

    private void showLicenseVerificationView(boolean isShow) {
        if (isShow) {
            this.activeTextView.setVisibility(8);
            this.policyRelativeLayout.setVisibility(8);
            this.formRelativeLayout.setVisibility(8);
            this.activeButton.setVisibility(8);
            this.lvRelativeLayout.setVisibility(0);
        } else {
            this.activeTextView.setVisibility(0);
            this.policyRelativeLayout.setVisibility(0);
            this.formRelativeLayout.setVisibility(0);
            this.activeButton.setVisibility(0);
            this.lvRelativeLayout.setVisibility(8);
        }
    }

    private void sendPost(final List<NameValuePair> nameValuePairs) {
        if (nameValuePairs == null || nameValuePairs.size() == 0) {
            return;
        }
        this.initProgressDialog();
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String res = AnalyticsHttpClient.sendPostDataByNameValuePair(MAMFormActivity.this.mam_host + "/term/" + MAMFormActivity.this.softToken + "/", nameValuePairs, MAMFormActivity.this.mContext);
                Message msg = new Message();
                if (TextUtils.isEmpty((CharSequence)res)) {
                    msg.what = 1;
                    MAMFormActivity.this.handler.sendMessage(msg);
                    return;
                }
                try {
                    JSONObject json = new JSONObject(res);
                    if ("ok".equals(json.getString("status"))) {
                        msg.what = 4;
                        msg.obj = new JSONObject(json.getString("info")).getString("auditSid");
                        MAMFormActivity.this.handler.sendMessage(msg);
                    } else {
                        msg.what = 2;
                        MAMFormActivity.this.handler.sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    msg.what = 2;
                    MAMFormActivity.this.handler.sendMessage(msg);
                }
            }
        });
        this.myThread.start();
    }

    private void lvSubmit(final String value) {
        this.initProgressDialog();
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String rc4AndMd5 = AnalyticsHttpClient.getGetData(MAMFormActivity.this.mam_host + "/term/" + MAMFormActivity.this.getAuditSid() + "/at", MAMFormActivity.this.mContext);
                Message msg = new Message();
                if (TextUtils.isEmpty((CharSequence)rc4AndMd5)) {
                    msg.what = 1;
                    MAMFormActivity.this.handler.sendMessage(msg);
                    return;
                }
                try {
                    JSONObject json = new JSONObject(rc4AndMd5);
                    if ("ok".equals(json.getString("status"))) {
                        JSONObject info = new JSONObject(json.getString("info"));
                        String rc4 = info.getString("p1");
                        String md5 = info.getString("p2");
                        String accessToken = Rc4Encrypt.decry_RC4(rc4, value);
                        String nowMd5 = AnalyticsUtility.getMD5Code(new String[]{accessToken, value});
                        if (md5.equals(nowMd5)) {
                            MAMFormActivity.this.changeStatus(2, accessToken);
                            msg.what = 5;
                            MAMFormActivity.this.handler.sendMessage(msg);
                            return;
                        }
                        msg.what = 6;
                        MAMFormActivity.this.handler.sendMessage(msg);
                        return;
                    }
                    msg.what = 9;
                    MAMFormActivity.this.handler.sendMessage(msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.myThread.start();
    }

    private void passiveSubmit(final String value) {
        this.initProgressDialog();
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("md5Pwd", AnalyticsUtility.getMD5Code(new String[]{value})));
                String rc4AndMd5 = AnalyticsHttpClient.sendPostDataByNameValuePair(MAMFormActivity.this.mam_host + "/term/" + MAMFormActivity.this.softToken + "/directAt", nameValuePairs, MAMFormActivity.this.mContext);
                Message msg = new Message();
                if (TextUtils.isEmpty((CharSequence)rc4AndMd5)) {
                    msg.what = 1;
                    MAMFormActivity.this.handler.sendMessage(msg);
                    return;
                }
                try {
                    JSONObject json = new JSONObject(rc4AndMd5);
                    if ("ok".equals(json.getString("status"))) {
                        JSONObject info = new JSONObject(json.getString("info"));
                        String rc4 = info.getString("p1");
                        String md5 = info.getString("p2");
                        String accessToken = Rc4Encrypt.decry_RC4(rc4, value);
                        String nowMd5 = AnalyticsUtility.getMD5Code(new String[]{accessToken, value});
                        if (md5.equals(nowMd5)) {
                            MAMFormActivity.this.changeStatus(2, accessToken);
                            msg.what = 5;
                            MAMFormActivity.this.handler.sendMessage(msg);
                            return;
                        }
                        msg.what = 6;
                        MAMFormActivity.this.handler.sendMessage(msg);
                        return;
                    }
                    msg.what = 9;
                    MAMFormActivity.this.handler.sendMessage(msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.myThread.start();
    }

    private void getSid() {
        this.initProgressDialog();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.myThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String sidString = AnalyticsHttpClient.getGetData(MAMFormActivity.this.mam_host + "/term/" + MAMFormActivity.this.softToken + "/authSid", MAMFormActivity.this.mContext);
                Message msg = new Message();
                if (TextUtils.isEmpty((CharSequence)sidString)) {
                    msg.what = 1;
                    MAMFormActivity.this.handler.sendMessage(msg);
                    return;
                }
                try {
                    JSONObject sidJson = new JSONObject(sidString);
                    if ("ok".equals(sidJson.getString("status"))) {
                        JSONObject sidInfoJson = new JSONObject(sidJson.getString("info"));
                        if ("auth".equals(sidInfoJson.getString("AuthStatus"))) {
                            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair("md5Code", AnalyticsUtility.getMD5Code(new String[]{MAMFormActivity.this.getAccessToken(), sidInfoJson.getString("AuthSid")})));
                            String checkAccessToken = AnalyticsHttpClient.sendPostDataByNameValuePair(MAMFormActivity.this.mam_host + "/term/" + MAMFormActivity.this.softToken + "/authSid", nameValuePairs, MAMFormActivity.this.mContext);
                            MAMFormActivity.this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                            if (TextUtils.isEmpty((CharSequence)checkAccessToken)) {
                                msg.what = 1;
                                MAMFormActivity.this.handler.sendMessage(msg);
                                return;
                            }
                            JSONObject checkAccessTokenJson = new JSONObject(checkAccessToken);
                            if ("ok".equals(checkAccessTokenJson.getString("status"))) {
                                JSONObject checkAccessInfo = new JSONObject(checkAccessTokenJson.getString("info"));
                                if ("audit".equals(checkAccessInfo.getString("AuthStatus"))) {
                                    msg.what = 6;
                                    MAMFormActivity.this.handler.sendMessage(msg);
                                    return;
                                }
                                msg.what = 7;
                                msg.obj = sidInfoJson.getString("AuthSid");
                                MAMFormActivity.this.handler.sendMessage(msg);
                                MAMFormActivity.this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                                return;
                            }
                            msg.what = 6;
                            MAMFormActivity.this.handler.sendMessage(msg);
                            return;
                        }
                        if ("audit".equals(sidInfoJson.getString("AuthStatus"))) {
                            msg.what = 6;
                            MAMFormActivity.this.handler.sendMessage(msg);
                            return;
                        }
                        msg.what = 7;
                        msg.obj = sidInfoJson.getString("AuthSid");
                        MAMFormActivity.this.handler.sendMessage(msg);
                        MAMFormActivity.this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.myThread.start();
    }

    private void initProgressDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View view = inflater.inflate(EUExUtil.getResLayoutID((String)"platform_mam_progress_dialog_layout"), null);
        ((TextView)view.findViewById(EUExUtil.getResIdID((String)"mam_progress_dialog_text"))).setText((CharSequence)"\u6b63\u5728\u52a0\u8f7d\u4e2d,\u8bf7\u7a0d\u540e.....");
        this.progressDialog = new AlertDialog.Builder((Context)this).create();
        this.progressDialog.setView(view);
        this.progressDialog.setCancelable(true);
        this.progressDialog.show();
    }

    private void changeStatus(int status, String accessToken) {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt("status", status);
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            editor.putString("accessToken", accessToken);
        }
        editor.commit();
    }

    private void saveAuthorizeID(String authorizeID) {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("authorizeID", authorizeID);
        editor.commit();
    }

    private void sveAuditSid(String auditSid) {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("auditSid", auditSid);
        editor.commit();
    }

    private String getAuditSid() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getString("auditSid", null);
    }

    private int getStatus() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getInt("status", 0);
    }

    private String getAccessToken() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getString("accessToken", null);
    }

    private int dipToInt(int dip) {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        return (int)(dm.density * (float)dip);
    }

    public final boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isAllKeyDownUp) {
            AlertDialog.Builder tDialog = new AlertDialog.Builder((Context)this);
            if ("InCourseOf".equals(this.authType)) {
                tDialog.setTitle(EResources.browser_exitdialog_msg);
                tDialog.setNegativeButton(EResources.cancel, null);
                tDialog.setMessage((CharSequence)"\u786e\u5b9a\u9000\u51fa\u8eab\u4efd\u8ba4\u8bc1\u5417\uff1f");
                tDialog.setPositiveButton(EResources.confirm, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        MAMFormActivity.this.finish();
                    }
                });
            } else {
                tDialog.setTitle(EResources.browser_exitdialog_msg);
                tDialog.setNegativeButton(EResources.cancel, null);
                tDialog.setMessage(EResources.browser_exitdialog_app_text);
                tDialog.setPositiveButton(EResources.confirm, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent();
                        intent.putExtra("result", 0);
                        MAMFormActivity.this.setResult(-1, intent);
                        MAMFormActivity.this.finish();
                    }
                });
            }
            tDialog.show();
        }
        this.isAllKeyDownUp = false;
        return false;
    }

    public final boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: 
            case 82: {
                this.isAllKeyDownUp = true;
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public static void setFinishCallback(MAMFinishCallback callback) {
        mFinishCallback = callback;
    }

    private void showDialog(String text, final int type, final String res) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                if (type == 0) {
                    dialog.cancel();
                } else if (type == 1) {
                    Intent intent = new Intent();
                    intent.putExtra("result", 1);
                    intent.putExtra("authorizeID", res);
                    MAMFormActivity.this.setResult(-1, intent);
                    MAMFormActivity.this.finish();
                    if (mFinishCallback != null) {
                        mFinishCallback.finishCallback();
                    }
                } else {
                    int auditTy = 0;
                    if ("Passive".equals(MAMFormActivity.this.auditType)) {
                        auditTy = 2;
                    } else if ("Active".equals(MAMFormActivity.this.auditType)) {
                        auditTy = 1;
                    }
                    MAMFormActivity.this.showView(auditTy);
                }
            }
        });
        if (type == 2) {
            builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if ("InCourseOf".equals(MAMFormActivity.this.authType)) {
                        MAMFormActivity.this.finish();
                    } else {
                        Intent intent = new Intent();
                        intent.putExtra("result", 0);
                        MAMFormActivity.this.setResult(-1, intent);
                        MAMFormActivity.this.finish();
                    }
                }
            });
        }
        builder.show();
    }

    public void onClick(View v) {
        Message message = new Message();
        message.what = 8;
        message.obj = v.getTag();
        this.handler.sendMessage(message);
    }
}

