/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.push;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import com.ibm.mqtt.MqttClient;
import com.ibm.mqtt.MqttSimpleCallback;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.PushService;
import org.zywx.wbpalmstar.plugin.uexmam.push.PushDataCallback;
import org.zywx.wbpalmstar.plugin.uexmam.push.Rc4Encrypt;

public class PushGetData2 {
    private PushDataCallback pushDataCallback = null;
    private BroadcastReceiver myBroadcastReceiver = null;
    private boolean isNotify = false;
    private Context mCtx = null;
    private String ip = null;
    private MqttClient mqttClient = null;
    private SimpleCallbackHandler simpleCallbackHandler = null;
    private static final boolean CLEAN_START = false;
    private static final short KEEP_ALIVE = 30;
    private int[] QOS_VALUES = new int[]{2, 2};
    private String[] TOPICS = null;
    private String mAppId = null;
    String CLIENT_ID = null;
    private static final long KEEP_ALIVE_INTERVAL = 600000L;

    public PushGetData2(String softToken, String url, Context context, PushDataCallback callback, String[] parm) {
        this.pushDataCallback = callback;
        this.mCtx = context;
        this.ip = "tcp://" + url;
        SharedPreferences sp = this.mCtx.getSharedPreferences("app", 1);
        this.mAppId = sp.getString("appid", null);
        this.TOPICS = new String[]{"push/" + this.mAppId, "push/" + softToken};
    }

    public void start() {
        this.onReceive();
    }

    public void init() {
        block6: {
            try {
                this.CLIENT_ID = this.getMacAddress() + this.mAppId;
                if (this.mqttClient == null) {
                    this.mqttClient = new MqttClient(this.ip);
                }
                if (this.simpleCallbackHandler == null) {
                    this.simpleCallbackHandler = new SimpleCallbackHandler();
                }
                this.mqttClient.registerSimpleHandler((MqttSimpleCallback)this.simpleCallbackHandler);
                this.mqttClient.connect(this.CLIENT_ID, false, (short)30);
                this.mqttClient.subscribe(this.TOPICS, this.QOS_VALUES);
                String conn = this.mqttClient.getConnection();
                this.startKeepAlives();
                System.out.println("\u5ba2\u6237\u673a\u548cbroker\u5df2\u8fde\u63a5");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("mqtt  Exception  " + e.getMessage());
                if (!this.isNotify) break block6;
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.init();
            }
        }
    }

    private void startKeepAlives() {
        Intent i = new Intent();
        i.setClass(this.mCtx, PushService.class);
        i.setAction(this.CLIENT_ID + ".KEEP_ALIVE");
        PendingIntent pi = PendingIntent.getService((Context)this.mCtx, (int)0, (Intent)i, (int)0);
        AlarmManager alarmMgr = (AlarmManager)this.mCtx.getSystemService("alarm");
        alarmMgr.setRepeating(0, System.currentTimeMillis() + 600000L, 600000L, pi);
    }

    private void stopKeepAlives() {
        Intent i = new Intent();
        i.setClass(this.mCtx, PushService.class);
        i.setAction(this.CLIENT_ID + ".KEEP_ALIVE");
        PendingIntent pi = PendingIntent.getService((Context)this.mCtx, (int)0, (Intent)i, (int)0);
        AlarmManager alarmMgr = (AlarmManager)this.mCtx.getSystemService("alarm");
        alarmMgr.cancel(pi);
    }

    public void stop(boolean isRealStop) {
        System.out.println("\u5ba2\u6237\u673a\u548cbroker\u5df2\u7ecf\u65ad\u5f00  stop " + isRealStop);
        if (this.mqttClient != null) {
            try {
                this.mqttClient.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mqttClient = null;
        }
        if (isRealStop && this.myBroadcastReceiver != null && this.mCtx != null) {
            this.mCtx.unregisterReceiver(this.myBroadcastReceiver);
            this.isNotify = false;
            this.stopKeepAlives();
        }
    }

    private void onReceive() {
        String CONNECTIVITY_CHANGE_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        if (this.myBroadcastReceiver == null) {
            this.myBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.net.conn.CONNECTIVITY_CHANGE")) {
                        ConnectivityManager mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
                        if (mConnMgr != null) {
                            NetworkInfo aActiveInfo = mConnMgr.getActiveNetworkInfo();
                            if (!PushGetData2.this.isNotify && aActiveInfo != null && aActiveInfo.isConnectedOrConnecting()) {
                                PushGetData2.this.init();
                                PushGetData2.this.isNotify = true;
                            } else if (aActiveInfo == null) {
                                PushGetData2.this.isNotify = false;
                                System.out.println("\u5ba2\u6237\u673a\u548cbroker\u5df2\u7ecf\u65ad\u5f00  stop 1");
                                PushGetData2.this.stop(false);
                            }
                        } else {
                            PushGetData2.this.isNotify = false;
                            PushGetData2.this.stop(false);
                            System.out.println("\u5ba2\u6237\u673a\u548cbroker\u5df2\u7ecf\u65ad\u5f00  stop 2");
                        }
                    }
                }
            };
        }
        this.mCtx.registerReceiver(this.myBroadcastReceiver, filter);
    }

    private String getMacAddress() {
        WifiManager wifi = (WifiManager)this.mCtx.getSystemService("wifi");
        WifiInfo info = wifi.getConnectionInfo();
        return info.getMacAddress().replaceAll(":", "");
    }

    class SimpleCallbackHandler
    implements MqttSimpleCallback {
        SimpleCallbackHandler() {
        }

        public void connectionLost() {
            System.out.println("\u5ba2\u6237\u673a\u548cbroker\u5df2\u7ecf\u65ad\u5f00  isNotify " + PushGetData2.this.isNotify);
            if (PushGetData2.this.isNotify) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                PushGetData2.this.init();
            }
        }

        public void publishArrived(String topicName, byte[] payload, int Qos, boolean retained) throws Exception {
            String reData = new String(payload);
            if (reData != null && reData.length() > 0) {
                try {
                    JSONObject json = new JSONObject(Rc4Encrypt.decry_RC4(reData, PushGetData2.this.mAppId));
                    String status = json.getString("status");
                    if ("ok".equals(status)) {
                        String messageList = json.getString("messageList");
                        JSONArray jsonArray = new JSONArray(messageList);
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            if (PushGetData2.this.pushDataCallback == null) continue;
                            PushGetData2.this.pushDataCallback.pushData(jsonArray.getJSONObject(i));
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

