/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.analytics;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.zywx.wbpalmstar.base.BDebug;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexmam.LogUtils;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.UpgradeUtils;

public class DownloadDialog
extends ProgressDialog
implements Runnable {
    private static final String TAG = "MMSDownloadDialog";
    public static final String FROYO_USERAGENT = "Mozilla/5.0 (Linux; U; Android " + Build.VERSION.RELEASE + "; en-us; " + Build.MODEL + " Build/FRF91) AppleWebKit/533.1 " + "(KHTML, like Gecko) Version/4.0 Mobile Safari/533.1";
    private HttpClient mHttpClient;
    public InputStream mInStream;
    private String url;
    public String userAgent;
    public String contentDisposition;
    public String mimetype;
    public int mTotalSize;
    public File mTmpFile;
    public boolean mFromStop;
    private Object mObject;
    private Context mContext;
    private Handler mProgressHandler = new Handler(){

        public void handleMessage(Message msg) {
            DownloadDialog.this.setProgress(msg.what);
            if (100 == msg.what) {
                this.sendEmptyMessageDelayed(-1, 1000L);
            } else if (-1 == msg.what) {
                DownloadDialog.this.downloadDone();
            } else if (-2 == msg.what) {
                Toast.makeText((Context)DownloadDialog.this.getContext(), (CharSequence)((String)msg.obj), (int)0).show();
            } else if (-3 == msg.what) {
                DownloadDialog.this.stopDownload();
            } else if (-4 == msg.what) {
                DownloadDialog.this.showDialog("\u4e0b\u8f7d\u5931\u8d25");
            }
        }
    };
    private int downLoaderSize = 0;

    public DownloadDialog(Context context, String url, Object object) {
        super(context);
        this.mContext = context;
        this.init(url);
        this.mObject = object;
    }

    public DownloadDialog(Context context, int theme, String url) {
        super(context, theme);
        this.init(url);
    }

    private void init(String inUrl) {
        this.mFromStop = false;
        this.url = inUrl;
        String suffix = this.makeFileSuffix(this.url);
        MimeTypeMap mtm = MimeTypeMap.getSingleton();
        this.mimetype = mtm.getMimeTypeFromExtension(suffix);
        this.setProgress(0);
        this.setIcon(EUExUtil.getResDrawableID((String)"icon"));
        this.setCancelable(false);
        this.setTitle("\u6b63\u5728\u4e0b\u8f7d\u6587\u4ef6");
        this.setProgressStyle(1);
        this.setMax(100);
        this.setButton("\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                LogUtils.i(DownloadDialog.TAG, "cancel");
                DownloadDialog.this.mFromStop = true;
                DownloadDialog.this.stopDownload();
                DownloadDialog.this.showDialog("\u4e0b\u8f7d\u5931\u8d25");
            }
        });
    }

    public void show() {
        super.show();
        new Thread(this).start();
    }

    private void stopDownload() {
        LogUtils.i(TAG, "stopDownload");
        this.dismiss();
        try {
            if (this.mHttpClient != null) {
                this.mHttpClient.getConnectionManager().shutdown();
                this.mHttpClient = null;
            }
            if (this.mInStream != null) {
                this.mInStream.close();
                this.mInStream = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reShow() {
        if (this.url != null) {
            this.init(this.url);
            this.show();
        }
    }

    private void showDialog(String text) {
        LogUtils.i(TAG, "showDialog");
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)text).setTitle((CharSequence)"\u63d0\u793a").setCancelable(false).setPositiveButton((CharSequence)"\u91cd\u65b0\u4e0b\u8f7d", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                DownloadDialog.this.reShow();
            }
        }).setNegativeButton((CharSequence)"\u6682\u4e0d\u66f4\u65b0", new DialogInterface.OnClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(DialogInterface dialog, int id) {
                if (DownloadDialog.this.mObject != null) {
                    Object object = DownloadDialog.this.mObject;
                    synchronized (object) {
                        DownloadDialog.this.mObject.notify();
                    }
                }
            }
        }).show();
    }

    private void showDialogInstallAPK(String text) {
        LogUtils.i(TAG, "showDialogInstallAPK");
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)text).setTitle((CharSequence)"\u63d0\u793a").setCancelable(false).setPositiveButton((CharSequence)"\u5b89\u88c5\u66f4\u65b0", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                LogUtils.i(DownloadDialog.TAG, "onClick_ShowDialogInstallAPK");
                DownloadDialog.this.downloadDone();
            }
        }).setNegativeButton((CharSequence)"\u6682\u4e0d\u66f4\u65b0", new DialogInterface.OnClickListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(DialogInterface dialog, int id) {
                if (DownloadDialog.this.mObject != null) {
                    Object object = DownloadDialog.this.mObject;
                    synchronized (object) {
                        DownloadDialog.this.mObject.notify();
                    }
                }
            }
        }).show();
    }

    @Override
    public void run() {
        block9: {
            UpgradeUtils.UpdateInfo updateInfo = UpgradeUtils.isContinue(this.mContext, "upgrade", this.url);
            this.mTotalSize = updateInfo.totalSize;
            this.downLoaderSize = updateInfo.downloaded;
            try {
                if (!Environment.getExternalStorageState().equals("mounted")) {
                    this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)"\u60a8\u7684\u624b\u673a\u672a\u5b89\u88c5SD\u5361!"));
                    this.mProgressHandler.sendEmptyMessage(-3);
                    return;
                }
                LogUtils.o("updateFullPkgUrl: " + this.url);
                this.mHttpClient = this.url != null && this.url.startsWith("http://") ? new DefaultHttpClient() : AnalyticsHttpClient.getAnalyticsHttpClientEx(this.mContext);
                HttpGet httpGet = new HttpGet(this.url);
                httpGet.setHeader("Connection", "Keep-Alive");
                httpGet.setHeader("Charset", "UTF-8");
                httpGet.setHeader("User-Agent", FROYO_USERAGENT);
                httpGet.setHeader("RANGE", "bytes=" + this.downLoaderSize + "-");
                String cookie = this.getCookie(this.url);
                if (cookie != null) {
                    httpGet.addHeader("Cookie", cookie);
                }
                HttpResponse httpResponse = this.mHttpClient.execute((HttpUriRequest)httpGet);
                int responseCode = httpResponse.getStatusLine().getStatusCode();
                LogUtils.i(TAG, "responseCode: " + responseCode);
                if (200 == responseCode || 206 == responseCode) {
                    Header header = null;
                    if (206 == responseCode) {
                        header = httpResponse.getFirstHeader("Content-Range");
                    }
                    if (header == null) {
                        this.downLoaderSize = 0;
                        BDebug.d((String)"uexDataAnalysisLite", (String)"Server doesn't support Resuming Broken Transfer!");
                    } else {
                        BDebug.d((String)"uexDataAnalysisLite", (String)("Content-Range = " + header));
                    }
                    this.saveToFile(httpResponse, updateInfo);
                } else {
                    this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)"\u8fde\u63a5\u5931\u8d25,\u8bf7\u91cd\u8bd5!"));
                    this.mProgressHandler.sendEmptyMessage(-3);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mProgressHandler.sendEmptyMessage(-3);
                if (this.mFromStop) break block9;
                this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)"\u4e0b\u8f7d\u51fa\u9519,\u8bf7\u91cd\u8bd5!"));
                this.mProgressHandler.sendEmptyMessage(-4);
            }
        }
    }

    private void saveToFile(HttpResponse httpResponse, UpgradeUtils.UpdateInfo updateInfo) throws Exception {
        String cLength;
        this.mInStream = httpResponse.getEntity().getContent();
        if (this.mInStream == null) {
            return;
        }
        if (this.mTotalSize <= 0 && (cLength = httpResponse.getFirstHeader("Content-Length").getValue()) != null) {
            this.mTotalSize = (int)Long.parseLong(cLength) + this.downLoaderSize;
        }
        MimeTypeMap mtm = MimeTypeMap.getSingleton();
        String extension = mtm.getExtensionFromMimeType(this.mimetype);
        File tm = Environment.getExternalStorageDirectory();
        File target = new File(tm.getAbsoluteFile() + "/Download/");
        if (!target.exists()) {
            target.mkdirs();
        }
        this.mTmpFile = TextUtils.isEmpty((CharSequence)updateInfo.filePath) ? File.createTempFile("/Download/", "." + extension, tm) : new File(updateInfo.filePath);
        RandomAccessFile raf = null;
        try {
            try {
                int numread;
                raf = new RandomAccessFile(this.mTmpFile, "rw");
                raf.seek(this.downLoaderSize);
                byte[] buffer = new byte[3072];
                while ((numread = this.mInStream.read(buffer)) != -1) {
                    raf.write(buffer, 0, numread);
                    this.downLoaderSize += numread;
                    int p = (int)((float)this.downLoaderSize / (float)this.mTotalSize * 100.0f);
                    this.mProgressHandler.sendEmptyMessage(p);
                }
                if (this.mTotalSize <= 0) {
                    this.mProgressHandler.sendEmptyMessage(100);
                }
                this.downLoaderSize = 0;
            }
            catch (Exception e) {
                this.downLoaderSize = 0;
                throw e;
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private void downloadDone() {
        this.stopDownload();
        this.showDialogInstallAPK("\u66f4\u65b0\u5305\u4e0b\u8f7d\u5b8c\u6210");
        Intent installIntent = new Intent("android.intent.action.VIEW");
        String filename = this.mTmpFile.getAbsolutePath();
        Uri path = Uri.parse((String)filename);
        if (path.getScheme() == null) {
            path = Uri.fromFile((File)new File(filename));
        }
        installIntent.setDataAndType(path, this.mimetype);
        installIntent.setFlags(0x10000000);
        try {
            this.getContext().startActivity(installIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-2, (Object)"\u672a\u627e\u5230\u53ef\u6267\u884c\u7684\u5e94\u7528"));
        }
    }

    private String makeFileSuffix(String url) {
        int index = url.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return url.substring(index + 1);
    }

    private final String getCookie(String inUrl) {
        return CookieManager.getInstance().getCookie(inUrl);
    }
}

