/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.mam;

import android.app.Dialog;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import org.zywx.wbpalmstar.base.ResoureFinder;

public class ActionSheetDialog
extends Dialog
implements View.OnClickListener,
AdapterView.OnItemClickListener {
    private LayoutInflater inflater;
    private TextView tvTitle;
    private ListView lvBtnList;
    private Button btnCancel;
    private ListAdapter lisAdapter;
    private boolean mCloseByBackKey;
    private ActionSheetDialogItemClickListener listener;
    public static final int MESSAGE_ACTION_CLICKED_POSTION = 100;
    public static final int MESSAGE_ACTION_CLICKED_CANCEL = 101;
    public static final int INDEX_DELETE = 0;
    public static final int ANIM_TIME = 300;
    private ResoureFinder finder;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    if (ActionSheetDialog.this.listener == null) break;
                    ActionSheetDialog.this.listener.onItemClicked(ActionSheetDialog.this, msg.arg1);
                    break;
                }
                case 101: {
                    if (ActionSheetDialog.this.listener == null) break;
                    ActionSheetDialog.this.listener.onCanceled(ActionSheetDialog.this);
                }
            }
        }
    };

    public ActionSheetDialog(Context context) {
        super(context, ResoureFinder.getInstance((Context)context).getStyleId("Style_platform_dialog"));
        this.finder = ResoureFinder.getInstance((Context)context);
        this.inflater = LayoutInflater.from((Context)context);
        this.init();
    }

    private void init() {
        this.requestWindowFeature(1);
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.windowAnimations = this.finder.getStyleId("Anim_platform_window_actionsheet_dialog");
        params.gravity = 87;
        params.flags = 2;
        params.dimAmount = 0.5f;
        this.setContentView(this.finder.getLayoutId("platform_mam_action_sheet_dialog_layout"));
        this.tvTitle = (TextView)this.findViewById(this.finder.getId("dialog_title"));
        this.btnCancel = (Button)this.findViewById(this.finder.getId("dialog_cancel_button"));
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        this.lvBtnList = (ListView)this.findViewById(this.finder.getId("dialog_button_list"));
        this.lvBtnList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    protected void onStop() {
        if (this.mCloseByBackKey) {
            this.handler.sendEmptyMessageDelayed(101, 300L);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mCloseByBackKey = true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void setupData(String[] labels) {
        if (labels == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int size = labels.length;
        while (i < size) {
            list.add(labels[i]);
            ++i;
        }
        this.lisAdapter = new ListAdapter(list);
        this.lvBtnList.setAdapter((android.widget.ListAdapter)this.lisAdapter);
    }

    public void setTitle(CharSequence title) {
        this.tvTitle.setText(title);
    }

    public void setButtonLabel(String label) {
        this.btnCancel.setText((CharSequence)label);
    }

    public void show() {
        super.show();
    }

    public void setOnDialogItemClickedListener(ActionSheetDialogItemClickListener cb) {
        this.listener = cb;
    }

    public void onClick(View v) {
        this.dismiss();
        this.handler.sendEmptyMessageDelayed(101, 300L);
    }

    private void sendPostionMessage(int postion) {
        Message message = this.handler.obtainMessage(100);
        message.arg1 = postion;
        this.handler.sendMessageDelayed(message, 300L);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        this.dismiss();
        this.sendPostionMessage(position);
    }

    public static void show(Context context, String[] lables, String title, String cancelLabel, ActionSheetDialogItemClickListener listener) {
        ActionSheetDialog actionSheetDialog = new ActionSheetDialog(context);
        actionSheetDialog.setTitle(title);
        actionSheetDialog.setButtonLabel(cancelLabel);
        actionSheetDialog.setupData(lables);
        actionSheetDialog.setOnDialogItemClickedListener(listener);
        actionSheetDialog.show();
    }

    public static interface ActionSheetDialogItemClickListener {
        public void onItemClicked(ActionSheetDialog var1, int var2);

        public void onCanceled(ActionSheetDialog var1);
    }

    private class ListAdapter
    extends BaseAdapter {
        private ArrayList<String> list;

        public ListAdapter(ArrayList<String> texts) {
            this.list = texts;
        }

        public int getCount() {
            return this.list.size();
        }

        public String getItem(int position) {
            return this.list.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            RelativeLayout layout = (RelativeLayout)ActionSheetDialog.this.inflater.inflate(ActionSheetDialog.this.finder.getLayoutId("platform_mam_actionsheet_list_item"), null);
            TextView button = (TextView)layout.findViewById(ActionSheetDialog.this.finder.getId("actionsheet_list_menu_item_btn"));
            button.setText((CharSequence)this.list.get(position));
            return layout;
        }
    }
}

