/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.mam;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsUtility;
import org.zywx.wbpalmstar.plugin.uexmam.mam.EResources;
import org.zywx.wbpalmstar.plugin.uexmam.mam.PolicyInfoActivity;
import org.zywx.wbpalmstar.plugin.uexmam.mam.Rc4Encrypt;

public class PolicyActivity
extends Activity
implements View.OnClickListener {
    private ScrollView mam_scrollview;
    private RelativeLayout policyRelativeLayout;
    private RelativeLayout passiveRelativeLayout;
    private RelativeLayout shelter;
    private AlertDialog progressDialog;
    private String mam_host;
    private String softToken;
    private String authType;
    private String auditType;
    private int mam_form_policy_textViewLabel_id = 300;
    private int isPortrait;
    private TextView passiveTextViewLabel;
    private TextView passiveTextView;
    private Button passiveButton;
    private EditText passiveEditText;
    private String authorizeID;
    private static final int auditType_All = 0;
    private static final int auditType_Active = 1;
    private static final int auditType_Passive = 2;
    private static final int auditType_Direct = 3;
    public static final int uncommitted_audit = 0;
    public static final int committed_audit = 1;
    public static final int bind = 2;
    boolean isAllKeyDownUp = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isPortrait = this.getIntent().getIntExtra("Orientation", 2);
        this.getWindow().requestFeature(1);
        this.setRequestedOrientation(this.isPortrait);
        this.setContentView(EUExUtil.getResLayoutID((String)"platform_mam_policy_layout"));
        this.shelter = (RelativeLayout)this.findViewById(EUExUtil.getResIdID((String)"shelter"));
        this.shelter.setClickable(true);
        this.shelter.setBackgroundResource(EUExUtil.getResColorID((String)"start_bg_color"));
        ImageView background = new ImageView((Context)this);
        background.setBackgroundResource(EUExUtil.getResDrawableID((String)"startup_bg"));
        RelativeLayout.LayoutParams backgroundPa = new RelativeLayout.LayoutParams(-1, -1);
        background.setLayoutParams((ViewGroup.LayoutParams)backgroundPa);
        this.shelter.addView((View)background);
        ImageView foreground = new ImageView((Context)this);
        DisplayMetrics dispm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dispm);
        if (dispm.widthPixels < 480) {
            foreground.setBackgroundResource(EUExUtil.getResDrawableID((String)"startup_fg_small"));
        } else {
            foreground.setBackgroundResource(EUExUtil.getResDrawableID((String)"startup_fg_normal"));
        }
        RelativeLayout.LayoutParams foregroundPa = new RelativeLayout.LayoutParams(-2, -2);
        foregroundPa.addRule(13, -1);
        foreground.setLayoutParams((ViewGroup.LayoutParams)foregroundPa);
        this.shelter.addView((View)foreground);
        ImageView mark = new ImageView((Context)this);
        mark.setBackgroundResource(EResources.mark_bg);
        RelativeLayout.LayoutParams markPa = new RelativeLayout.LayoutParams(-2, -2);
        markPa.addRule(12, -1);
        markPa.addRule(11, -1);
        mark.setLayoutParams((ViewGroup.LayoutParams)markPa);
        this.shelter.addView((View)mark);
        this.mam_scrollview = (ScrollView)this.findViewById(EUExUtil.getResIdID((String)"mam_scrollview"));
        this.policyRelativeLayout = (RelativeLayout)this.findViewById(EUExUtil.getResIdID((String)"policyRelativeLayout"));
        this.mam_host = AnalyticsUtility.getMamHost((Context)this);
        this.softToken = this.getIntent().getStringExtra("SoftToken");
        this.auditType = this.getIntent().getStringExtra("auditType");
        this.authType = this.getIntent().getStringExtra("authType");
        this.passiveRelativeLayout = (RelativeLayout)this.findViewById(EUExUtil.getResIdID((String)"passiveRelativeLayout"));
        this.passiveTextView = (TextView)this.findViewById(EUExUtil.getResIdID((String)"passiveTextView"));
        this.passiveTextView.setText((CharSequence)"\u5982\u679c\u60a8\u5df2\u7ecf\u6709\u7ba1\u7406\u5458\u9881\u53d1\u768416\u4f4d\u6570\u5b57\u5bc6\u7801\uff0c\u4f60\u53ef\u5728\u4e0b\u65b9\u586b\u5199\u5b8c\u6210\u8ba4\u8bc1");
        this.passiveTextView.setTextColor(Color.parseColor((String)"#000000"));
        this.passiveTextViewLabel = (TextView)this.findViewById(EUExUtil.getResIdID((String)"passiveTextViewLabel"));
        this.passiveTextViewLabel.setText((CharSequence)"\u8ba4\u8bc1\u5bc6\u7801:");
        this.passiveTextViewLabel.setTextColor(Color.parseColor((String)"#000000"));
        this.passiveEditText = (EditText)this.findViewById(EUExUtil.getResIdID((String)"passiveEditText"));
        this.passiveEditText.setHintTextColor(Color.parseColor((String)"#004598"));
        this.passiveEditText.setBackgroundDrawable(null);
        this.passiveEditText.setHint((CharSequence)"\u8bf7\u8f93\u5165\u8ba4\u8bc1\u5bc6\u7801");
        this.passiveButton = (Button)this.findViewById(EUExUtil.getResIdID((String)"passiveButton"));
        this.passiveButton.setText((CharSequence)"\u63d0\u4ea4");
        this.passiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String value = PolicyActivity.this.passiveEditText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)value)) {
                    Toast.makeText((Context)PolicyActivity.this, (CharSequence)"\u8ba4\u8bc1\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (int)1).show();
                    return;
                }
                if (value.length() != 16 || !PolicyActivity.this.isNumeric(value)) {
                    Toast.makeText((Context)PolicyActivity.this, (CharSequence)"\u8ba4\u8bc1\u5bc6\u7801\u5fc5\u987b\u4e3a16\u4f4d\u6570\u5b57!", (int)1).show();
                    return;
                }
                PolicyActivity.this.passiveSubmit(value);
            }
        });
        int auditTy = 0;
        if ("Passive".equals(this.auditType)) {
            auditTy = 2;
        } else if ("Active".equals(this.auditType)) {
            auditTy = 1;
        } else if ("Direct".equals(this.auditType)) {
            auditTy = 3;
        }
        this.showView(auditTy);
        if (this.getAutoAuthStatus()) {
            this.autoAuth();
            return;
        }
        this.getRelative();
    }

    private void getRelative() {
        new AsyncTask<String, Object, String>(){

            protected void onPreExecute() {
                PolicyActivity.this.initProgressDialog(null);
            }

            protected String doInBackground(String ... params) {
                String res = AnalyticsHttpClient.getGetData(String.valueOf(PolicyActivity.this.mam_host) + "/term/" + AnalyticsAgent.m_appId + "/form", (Context)PolicyActivity.this);
                return res;
            }

            protected void onPostExecute(String result) {
                if (PolicyActivity.this.progressDialog != null && PolicyActivity.this.progressDialog.isShowing()) {
                    PolicyActivity.this.progressDialog.dismiss();
                }
                if (TextUtils.isEmpty((CharSequence)result)) {
                    Toast.makeText((Context)PolicyActivity.this, (CharSequence)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25!", (int)1).show();
                    return;
                }
                try {
                    JSONObject json = new JSONObject(result);
                    if ("ok".equals(json.getString("status"))) {
                        PolicyActivity.this.initForm(json.getString("info"));
                    } else {
                        Toast.makeText((Context)PolicyActivity.this, (CharSequence)"\u83b7\u53d6\u4fe1\u606f\u5931\u8d25!", (int)1).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }.execute((Object[])new String[0]);
    }

    private void initForm(String value) {
        this.policyRelativeLayout.removeAllViews();
        try {
            JSONArray infoJArray = new JSONArray(value);
            int i = 0;
            while (i < infoJArray.length()) {
                String policyName = infoJArray.getJSONObject(i).getString("policy");
                RelativeLayout.LayoutParams policyLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
                if (i > 0) {
                    policyLayoutParams.addRule(3, this.mam_form_policy_textViewLabel_id - 1);
                    policyLayoutParams.topMargin = this.dipToInt(15);
                }
                TextView policyTextViewLabel = new TextView((Context)this);
                policyTextViewLabel.setId(this.mam_form_policy_textViewLabel_id);
                policyTextViewLabel.setText((CharSequence)policyName);
                policyTextViewLabel.setTextColor(Color.parseColor((String)"#000000"));
                policyTextViewLabel.setGravity(17);
                policyTextViewLabel.setBackgroundResource(EUExUtil.getResDrawableID((String)"platform_mam_textview_selector"));
                this.policyRelativeLayout.addView((View)policyTextViewLabel, (ViewGroup.LayoutParams)policyLayoutParams);
                policyTextViewLabel.setTag((Object)infoJArray.getJSONObject(i).toString());
                policyTextViewLabel.setOnClickListener((View.OnClickListener)this);
                ++this.mam_form_policy_textViewLabel_id;
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int dipToInt(int dip) {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        return (int)(dm.density * (float)dip);
    }

    public void onClick(View v) {
        Intent intent = new Intent((Context)this, PolicyInfoActivity.class);
        intent.putExtra("json", String.valueOf(v.getTag()));
        intent.putExtra("Orientation", this.isPortrait);
        intent.putExtra("SoftToken", this.softToken);
        intent.putExtra("auditType", this.auditType);
        intent.putExtra("authType", this.authType);
        this.startActivityForResult(intent, 500);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        int result;
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && 500 == requestCode && data != null && (result = data.getIntExtra("result", 0)) != -1) {
            if (result == -2) {
                this.getRelative();
            } else {
                this.setResult(-1, data);
                this.finish();
            }
        }
    }

    public final boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isAllKeyDownUp) {
            AlertDialog.Builder tDialog = new AlertDialog.Builder((Context)this);
            if ("InCourseOf".equals(this.authType)) {
                tDialog.setTitle(EResources.browser_exitdialog_msg);
                tDialog.setNegativeButton(EResources.cancel, null);
                tDialog.setMessage((CharSequence)"\u786e\u5b9a\u9000\u51fa\u8eab\u4efd\u8ba4\u8bc1\u5417\uff1f");
                tDialog.setPositiveButton(EResources.confirm, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        PolicyActivity.this.finish();
                    }
                });
            } else {
                tDialog.setTitle(EResources.browser_exitdialog_msg);
                tDialog.setNegativeButton(EResources.cancel, null);
                tDialog.setMessage(EResources.browser_exitdialog_app_text);
                tDialog.setPositiveButton(EResources.confirm, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Intent intent = new Intent();
                        intent.putExtra("result", 0);
                        PolicyActivity.this.setResult(-1, intent);
                        PolicyActivity.this.finish();
                    }
                });
            }
            tDialog.show();
        }
        this.isAllKeyDownUp = false;
        return false;
    }

    private void passiveSubmit(final String value) {
        new AsyncTask<String, Object, String>(){

            protected void onPreExecute() {
                PolicyActivity.this.initProgressDialog(null);
            }

            protected String doInBackground(String ... params) {
                ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("md5Pwd", AnalyticsUtility.getMD5Code(new String[]{value})));
                String rc4AndMd5 = AnalyticsHttpClient.sendPostDataByNameValuePair(String.valueOf(PolicyActivity.this.mam_host) + "/term/" + PolicyActivity.this.softToken + "/directAt", nameValuePairs, (Context)PolicyActivity.this);
                if (TextUtils.isEmpty((CharSequence)rc4AndMd5)) {
                    return null;
                }
                return rc4AndMd5;
            }

            protected void onPostExecute(String result) {
                PolicyActivity.this.progressDialog.dismiss();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    PolicyActivity.this.showDialog("\u8ba4\u8bc1\u5931\u8d25\uff0c\u662f\u5426\u91cd\u65b0\u8ba4\u8bc1\uff1f", 2, null);
                    return;
                }
                try {
                    JSONObject json = new JSONObject(result);
                    if ("ok".equals(json.getString("status"))) {
                        JSONObject info = new JSONObject(json.getString("info"));
                        String rc4 = info.getString("p1");
                        String md5 = info.getString("p2");
                        String accessToken = Rc4Encrypt.decry_RC4(rc4, value);
                        String nowMd5 = AnalyticsUtility.getMD5Code(new String[]{accessToken, value});
                        if (md5.equals(nowMd5)) {
                            PolicyActivity.this.changeStatus(2, accessToken);
                            PolicyActivity.this.getSid();
                            return;
                        }
                        PolicyActivity.this.getRelative();
                        return;
                    }
                    PolicyActivity.this.showDialog("\u60a8\u7684\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u7533\u8bf7\uff01", 0, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.execute((Object[])new String[0]);
    }

    private void getSid() {
        new AsyncTask<String, Object, String>(){

            protected void onPreExecute() {
                PolicyActivity.this.initProgressDialog(null);
            }

            protected String doInBackground(String ... params) {
                String sidString;
                block7: {
                    JSONObject sidInfoJson;
                    block12: {
                        block8: {
                            block10: {
                                block11: {
                                    String checkAccessToken;
                                    block9: {
                                        sidString = AnalyticsHttpClient.getGetData(String.valueOf(PolicyActivity.this.mam_host) + "/term/" + PolicyActivity.this.softToken + "/authSid", (Context)PolicyActivity.this);
                                        if (TextUtils.isEmpty((CharSequence)sidString)) {
                                            return null;
                                        }
                                        JSONObject sidJson = new JSONObject(sidString);
                                        if (!"ok".equals(sidJson.getString("status"))) break block7;
                                        sidInfoJson = new JSONObject(sidJson.getString("info"));
                                        if (!"auth".equals(sidInfoJson.getString("AuthStatus"))) break block8;
                                        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("md5Code", AnalyticsUtility.getMD5Code(new String[]{PolicyActivity.this.getAccessToken(), sidInfoJson.getString("AuthSid")})));
                                        checkAccessToken = AnalyticsHttpClient.sendPostDataByNameValuePair(String.valueOf(PolicyActivity.this.mam_host) + "/term/" + PolicyActivity.this.softToken + "/authSid", nameValuePairs, (Context)PolicyActivity.this);
                                        PolicyActivity.this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                                        if (!TextUtils.isEmpty((CharSequence)checkAccessToken)) break block9;
                                        return null;
                                    }
                                    JSONObject checkAccessTokenJson = new JSONObject(checkAccessToken);
                                    if (!"ok".equals(checkAccessTokenJson.getString("status"))) break block10;
                                    JSONObject checkAccessInfo = new JSONObject(checkAccessTokenJson.getString("info"));
                                    if (!"audit".equals(checkAccessInfo.getString("AuthStatus"))) break block11;
                                    return "audit";
                                }
                                PolicyActivity.this.authorizeID = sidInfoJson.getString("AuthSid");
                                PolicyActivity.this.saveAuthorizeID(PolicyActivity.this.authorizeID);
                                return "success";
                            }
                            return "audit";
                        }
                        if (!"audit".equals(sidInfoJson.getString("AuthStatus"))) break block12;
                        return "audit";
                    }
                    try {
                        PolicyActivity.this.authorizeID = sidInfoJson.getString("AuthSid");
                        PolicyActivity.this.saveAuthorizeID(PolicyActivity.this.authorizeID);
                        return "success";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return sidString;
            }

            protected void onPostExecute(String result) {
                PolicyActivity.this.progressDialog.dismiss();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    PolicyActivity.this.showDialog("\u8ba4\u8bc1\u5931\u8d25\uff0c\u662f\u5426\u91cd\u65b0\u8ba4\u8bc1\uff1f", 2, null);
                    return;
                }
                if ("audit".equals(result)) {
                    PolicyActivity.this.getRelative();
                } else if ("success".equals(result)) {
                    if (TextUtils.isEmpty((CharSequence)PolicyActivity.this.authorizeID)) {
                        PolicyActivity.this.authorizeID = "";
                    }
                    PolicyActivity.this.showDialog("\u60a8\u5df2\u7ecf\u5b8c\u6210\u4e86\u8eab\u4efd\u8ba4\u8bc1", 1, PolicyActivity.this.authorizeID);
                }
            }
        }.execute((Object[])new String[0]);
    }

    private void showDialog(String text, final int type, final String res) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)text).setCancelable(false).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                if (type == 0) {
                    dialog.dismiss();
                } else if (type == 1) {
                    Intent intent = new Intent();
                    intent.putExtra("result", 1);
                    intent.putExtra("authorizeID", res);
                    PolicyActivity.this.setResult(-1, intent);
                    PolicyActivity.this.finish();
                } else {
                    dialog.dismiss();
                }
            }
        });
        if (type == 2) {
            builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if ("InCourseOf".equals(PolicyActivity.this.authType)) {
                        PolicyActivity.this.finish();
                    } else {
                        Intent intent = new Intent();
                        intent.putExtra("result", 0);
                        PolicyActivity.this.setResult(-1, intent);
                        PolicyActivity.this.finish();
                    }
                }
            });
        }
        builder.show();
    }

    private void initProgressDialog(String text) {
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View view = inflater.inflate(EUExUtil.getResLayoutID((String)"platform_mam_progress_dialog_layout"), null);
        ((TextView)view.findViewById(EUExUtil.getResIdID((String)"mam_progress_dialog_text"))).setText((CharSequence)(TextUtils.isEmpty((CharSequence)text) ? "\u6b63\u5728\u52a0\u8f7d\u4e2d,\u8bf7\u7a0d\u5019..." : text));
        this.progressDialog = new AlertDialog.Builder((Context)this).create();
        this.progressDialog.setView(view);
        this.progressDialog.setCancelable(false);
        this.progressDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                return keyCode == 4;
            }
        });
        this.progressDialog.show();
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    private String getAccessToken() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getString("accessToken", null);
    }

    private void changeStatus(int status, String accessToken) {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt("status", status);
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            editor.putString("accessToken", accessToken);
        }
        editor.commit();
    }

    private void saveAuthorizeID(String authorizeID) {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("authorizeID", authorizeID);
        editor.commit();
    }

    private int getStatus() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getInt("status", 0);
    }

    private void showView(int type) {
        switch (type) {
            case 0: {
                if (this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() != 2) break;
                this.getSid();
                break;
            }
            case 1: {
                this.passiveRelativeLayout.setVisibility(8);
                if (this.getStatus() == 0 || this.getStatus() == 1 || this.getStatus() != 2) break;
                this.getSid();
                break;
            }
            case 2: {
                this.policyRelativeLayout.setVisibility(8);
                break;
            }
            case 3: {
                this.passiveRelativeLayout.setVisibility(8);
                break;
            }
        }
    }

    private void autoAuth() {
        new AsyncTask<String, Object, String>(){

            protected void onPreExecute() {
                if (PolicyActivity.this.progressDialog == null || !PolicyActivity.this.progressDialog.isShowing()) {
                    PolicyActivity.this.initProgressDialog("\u6b63\u5728\u7b49\u5f85\u6388\u6743...");
                }
            }

            protected String doInBackground(String ... params) {
                String sidString;
                if (PolicyActivity.this.getAutoAuthStatus()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (TextUtils.isEmpty((CharSequence)(sidString = AnalyticsHttpClient.getGetData(String.valueOf(PolicyActivity.this.mam_host) + "/term/" + PolicyActivity.this.getAuditSid() + "/atWithoutPwd", (Context)PolicyActivity.this)))) {
                    return null;
                }
                return sidString;
            }

            protected void onPostExecute(String result) {
                if (TextUtils.isEmpty((CharSequence)result)) {
                    PolicyActivity.this.progressDialog.dismiss();
                    PolicyActivity.this.showDialog("\u8ba4\u8bc1\u5931\u8d25\uff0c\u662f\u5426\u91cd\u65b0\u8ba4\u8bc1\uff1f", 2, null);
                    return;
                }
                try {
                    JSONObject json = new JSONObject(result);
                    String status = json.getString("status");
                    if ("ok".equals(status)) {
                        PolicyActivity.this.progressDialog.dismiss();
                        PolicyActivity.this.saveAutoAuthStatus(false);
                        String accessToken = json.getString("accessToken");
                        PolicyActivity.this.changeStatus(2, accessToken);
                        PolicyActivity.this.getSid();
                    } else if ("waitting".equals(status)) {
                        PolicyActivity.this.saveAutoAuthStatus(true);
                        PolicyActivity.this.autoAuth();
                    } else if ("denied".equals(status) || "failed".equals(status)) {
                        PolicyActivity.this.progressDialog.dismiss();
                        PolicyActivity.this.saveAutoAuthStatus(false);
                        PolicyActivity.this.showDialog("\u8ba4\u8bc1\u5931\u8d25\uff0c\u662f\u5426\u91cd\u65b0\u8ba4\u8bc1\uff1f", 2, null);
                    }
                }
                catch (Exception e) {
                    PolicyActivity.this.progressDialog.dismiss();
                }
            }
        }.execute((Object[])new String[0]);
    }

    private void saveAutoAuthStatus(boolean isWaitting) {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("Waitting", isWaitting);
        editor.commit();
    }

    private boolean getAutoAuthStatus() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getBoolean("Waitting", false);
    }

    private String getAuditSid() {
        SharedPreferences preferences = this.getSharedPreferences("mamStatus", 1);
        return preferences.getString("auditSid", null);
    }

    public final boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: 
            case 82: {
                this.isAllKeyDownUp = true;
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }
}

