/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.push.PushDataCallback;

public class PushGetData {
    private Timer timer = null;
    private long sleepTime = 0L;
    private MyTimerTask myTimerTask = null;
    private boolean isTemporary = true;
    private String mSoftToken = null;
    private String getPushURL = null;
    private Context mCtx = null;
    private PushDataCallback pushDataCallback = null;
    private boolean isNotify = false;
    private BroadcastReceiver myBroadcastReceiver = null;

    public PushGetData(String softToken, String url, Context context, PushDataCallback callback, String[] parm) {
        this.mSoftToken = softToken;
        this.getPushURL = String.valueOf(url) + "/msg/";
        this.mCtx = context;
        this.pushDataCallback = callback;
    }

    public void start() {
        this.onReceive();
    }

    private void init() {
        this.sleepTime = this.isTemporary ? 30000L : 120000L;
        if (this.timer == null) {
            this.timer = new Timer();
        }
        if (this.myTimerTask == null) {
            this.myTimerTask = new MyTimerTask();
        }
        this.timer.schedule((TimerTask)this.myTimerTask, 0L, this.sleepTime);
    }

    private void notifiTimer() {
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
            this.myTimerTask = null;
        }
        this.myTimerTask = new MyTimerTask();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.myTimerTask, this.sleepTime, this.sleepTime);
    }

    private void getPushInfo() {
        String reData = AnalyticsHttpClient.getGetData(String.valueOf(this.getPushURL) + this.mSoftToken + "/listMsg", this.mCtx);
        if (reData != null && reData.length() > 0) {
            try {
                JSONObject json = new JSONObject(reData);
                String status = json.getString("status");
                if ("ok".equals(status)) {
                    String messageList = json.getString("messageList");
                    JSONArray jsonArray = new JSONArray(messageList);
                    int i = 0;
                    while (i < jsonArray.length()) {
                        if (this.pushDataCallback != null) {
                            this.pushDataCallback.pushData(jsonArray.getJSONObject(i));
                        }
                        ++i;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop(boolean isRealStop) {
        if (this.myTimerTask != null) {
            this.myTimerTask.cancel();
            this.myTimerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (isRealStop && this.myBroadcastReceiver != null && this.mCtx != null) {
            this.mCtx.unregisterReceiver(this.myBroadcastReceiver);
        }
    }

    private void onReceive() {
        String CONNECTIVITY_CHANGE_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        if (this.myBroadcastReceiver == null) {
            this.myBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                        if (PushGetData.this.isTemporary) {
                            PushGetData.this.sleepTime = 120000L;
                        } else {
                            PushGetData.this.sleepTime = 900000L;
                        }
                        PushGetData.this.notifiTimer();
                    } else if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
                        if (PushGetData.this.isTemporary) {
                            PushGetData.this.sleepTime = 30000L;
                        } else {
                            PushGetData.this.sleepTime = 120000L;
                        }
                    }
                    if (TextUtils.equals((CharSequence)intent.getAction(), (CharSequence)"android.net.conn.CONNECTIVITY_CHANGE")) {
                        ConnectivityManager mConnMgr = (ConnectivityManager)context.getSystemService("connectivity");
                        if (mConnMgr != null) {
                            NetworkInfo aActiveInfo = mConnMgr.getActiveNetworkInfo();
                            if (!PushGetData.this.isNotify && aActiveInfo != null && aActiveInfo.isConnectedOrConnecting()) {
                                PushGetData.this.init();
                                PushGetData.this.isNotify = true;
                            } else {
                                PushGetData.this.isNotify = false;
                                PushGetData.this.stop(false);
                            }
                        } else {
                            PushGetData.this.isNotify = false;
                            PushGetData.this.stop(false);
                        }
                    }
                }
            };
        }
        this.mCtx.registerReceiver(this.myBroadcastReceiver, filter);
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            PushGetData.this.getPushInfo();
            if (PushGetData.this.isTemporary && PushGetData.this.sleepTime == 120000L) {
                PushGetData.this.sleepTime = 900000L;
                PushGetData.this.notifiTimer();
                return;
            }
            if (PushGetData.this.sleepTime == 900000L) {
                PushGetData.this.sleepTime = 1800000L;
                PushGetData.this.notifiTimer();
            } else if (PushGetData.this.sleepTime == 1800000L) {
                PushGetData.this.sleepTime = 3600000L;
                PushGetData.this.notifiTimer();
            } else if (PushGetData.this.sleepTime == 3600000L) {
                PushGetData.this.sleepTime = 0x6DDD00L;
                PushGetData.this.notifiTimer();
            }
        }
    }
}

