/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.uexcamera;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Toast;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.zywx.wbpalmstar.plugin.uexmam.uexcamera.CRes;

public class CustomCamera
extends Activity
implements SurfaceHolder.Callback,
Camera.AutoFocusCallback {
    public SurfaceView mSurfaceView;
    private Button mBtnCancel;
    private Button mBtnHandler;
    private Button mBtnTakePic;
    private Button mBtnChangeFacing;
    private Button mBtnFlash1;
    private Button mBtnFlash2;
    private Button mBtnFlash3;
    private ImageView mIvPreShow;
    public Camera mCamera;
    public String filePath = null;
    private boolean hasSurface;
    private boolean isOpenFlash = false;
    public int cameraCurrentlyLocked;
    private ArrayList<Integer> flashDrawableIds;
    private boolean mPreviewing = false;
    protected boolean isHasPic = false;
    private boolean isHasFrontCamera = false;
    private boolean isHasBackCamera = false;
    protected Bitmap takedPic;
    private final int NEED_CLOSE_FLASH_BTS = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1 && CustomCamera.this.isOpenFlash) {
                CustomCamera.this.mBtnFlash2.setVisibility(4);
                CustomCamera.this.mBtnFlash3.setVisibility(4);
                CustomCamera.this.isOpenFlash = false;
            }
        }
    };
    private boolean mOnKeyDown;
    Camera.PictureCallback jpeg = new Camera.PictureCallback(){

        public void onPictureTaken(byte[] data, Camera camera) {
            try {
                try {
                    Bitmap bm = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix m = new Matrix();
                    if (CustomCamera.this.cameraCurrentlyLocked == 1) {
                        m.setRotate(-90.0f, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
                    } else if (CustomCamera.this.cameraCurrentlyLocked == 0) {
                        m.setRotate(90.0f, (float)bm.getWidth() / 2.0f, (float)bm.getHeight() / 2.0f);
                    }
                    bm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)bm.getWidth(), (int)bm.getHeight(), (Matrix)m, (boolean)true);
                    File file = new File(CustomCamera.this.filePath);
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
                    bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                    bos.flush();
                    bos.close();
                    Bitmap scaledBm = Bitmap.createScaledBitmap((Bitmap)bm, (int)CustomCamera.this.mIvPreShow.getWidth(), (int)CustomCamera.this.mIvPreShow.getHeight(), (boolean)true);
                    CustomCamera.this.mIvPreShow.setImageBitmap(scaledBm);
                    CustomCamera.this.isHasPic = true;
                    CustomCamera.this.mIvPreShow.setVisibility(0);
                    bm.recycle();
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CustomCamera.this.mCamera.startPreview();
                }
            }
            finally {
                CustomCamera.this.mCamera.startPreview();
            }
        }
    };
    private int mOrientation = -1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CRes.init((Context)this.getApplication());
        this.requestWindowFeature(1);
        Window window = this.getWindow();
        window.addFlags(128);
        window.addFlags(1024);
        this.setRequestedOrientation(1);
        this.setContentView(CRes.plugin_camera_layout);
        this.filePath = this.getIntent().getStringExtra("photoPath");
        int numberOfCameras = Camera.getNumberOfCameras();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int i = 0;
        while (i < numberOfCameras) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 0) {
                this.isHasBackCamera = true;
            } else if (cameraInfo.facing == 1) {
                this.isHasFrontCamera = true;
            }
            ++i;
        }
        if (this.isHasBackCamera) {
            this.cameraCurrentlyLocked = 0;
        } else if (this.isHasFrontCamera) {
            this.cameraCurrentlyLocked = 1;
        } else {
            Toast.makeText((Context)this, (CharSequence)"no camera find", (int)0).show();
            return;
        }
        this.mSurfaceView = (SurfaceView)this.findViewById(CRes.plugin_camera_surfaceview);
        this.mBtnCancel = (Button)this.findViewById(CRes.plugin_camera_bt_cancel);
        this.mBtnHandler = (Button)this.findViewById(CRes.plugin_camera_bt_complete);
        this.mBtnChangeFacing = (Button)this.findViewById(CRes.plugin_camera_bt_changefacing);
        if (!this.isHasBackCamera || !this.isHasFrontCamera) {
            this.mBtnChangeFacing.setVisibility(4);
        }
        this.mIvPreShow = (ImageView)this.findViewById(CRes.plugin_camera_iv_preshow);
        this.mBtnTakePic = (Button)this.findViewById(CRes.plugin_camera_bt_takepic);
        this.mBtnFlash1 = (Button)this.findViewById(CRes.plugin_camera_bt_flash1);
        this.mBtnFlash2 = (Button)this.findViewById(CRes.plugin_camera_bt_flash2);
        this.mBtnFlash3 = (Button)this.findViewById(CRes.plugin_camera_bt_flash3);
        this.flashDrawableIds = new ArrayList();
        this.flashDrawableIds.add(CRes.plugin_camera_flash_drawale_auto);
        this.flashDrawableIds.add(CRes.plugin_camera_flash_drawale_open);
        this.flashDrawableIds.add(CRes.plugin_camera_flash_drawale_close);
        if (this.cameraCurrentlyLocked == 1) {
            this.mBtnFlash1.setVisibility(4);
        }
        this.mBtnFlash1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomCamera.this.isOpenFlash) {
                    CustomCamera.this.updateFlashButtonState(0);
                } else {
                    CustomCamera.this.isOpenFlash = true;
                    CustomCamera.this.mBtnFlash2.setVisibility(0);
                    CustomCamera.this.mBtnFlash3.setVisibility(0);
                    CustomCamera.this.mHandler.sendEmptyMessageDelayed(1, 4000L);
                }
            }
        });
        this.mBtnFlash2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCamera.this.updateFlashButtonState(1);
            }
        });
        this.mBtnFlash3.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCamera.this.updateFlashButtonState(2);
            }
        });
        this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCamera.this.setResult(0);
                CustomCamera.this.finish();
            }
        });
        this.mBtnHandler.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomCamera.this.isHasPic) {
                    CustomCamera.this.setResult(-1);
                    CustomCamera.this.finish();
                }
            }
        });
        this.mBtnTakePic.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCamera.this.takePic();
            }
        });
        this.mBtnChangeFacing.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomCamera.this.cameraCurrentlyLocked == 0) {
                    if (CustomCamera.this.mCamera != null && CustomCamera.this.mPreviewing) {
                        CustomCamera.this.mCamera.stopPreview();
                        CustomCamera.this.mPreviewing = false;
                        CustomCamera.this.mCamera.release();
                        CustomCamera.this.mCamera = null;
                        CustomCamera.this.cameraCurrentlyLocked = 1;
                        CustomCamera.this.mCamera = Camera.open((int)CustomCamera.this.cameraCurrentlyLocked);
                        CustomCamera.this.mBtnFlash1.setVisibility(4);
                        CustomCamera.this.mBtnFlash2.setVisibility(4);
                        CustomCamera.this.mBtnFlash3.setVisibility(4);
                        try {
                            CustomCamera.this.mCamera.setPreviewDisplay(CustomCamera.this.mSurfaceView.getHolder());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (CustomCamera.this.cameraCurrentlyLocked == 1 && CustomCamera.this.mCamera != null && CustomCamera.this.mPreviewing) {
                    CustomCamera.this.mCamera.stopPreview();
                    CustomCamera.this.mPreviewing = false;
                    CustomCamera.this.mCamera.release();
                    CustomCamera.this.mCamera = null;
                    CustomCamera.this.cameraCurrentlyLocked = 0;
                    CustomCamera.this.mCamera = Camera.open((int)CustomCamera.this.cameraCurrentlyLocked);
                    CustomCamera.this.mBtnFlash1.setVisibility(0);
                    try {
                        CustomCamera.this.mCamera.setPreviewDisplay(CustomCamera.this.mSurfaceView.getHolder());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                CustomCamera.this.initCameraParameters();
                CustomCamera.this.mCamera.startPreview();
                CustomCamera.this.mPreviewing = true;
            }
        });
    }

    private void updateFlashButtonState(int index) {
        this.isOpenFlash = false;
        Integer i = this.flashDrawableIds.get(index);
        this.flashDrawableIds.remove(index);
        this.flashDrawableIds.add(0, i);
        this.mBtnFlash2.setVisibility(4);
        this.mBtnFlash3.setVisibility(4);
        this.mBtnFlash1.setBackgroundResource(this.flashDrawableIds.get(0).intValue());
        this.mBtnFlash2.setBackgroundResource(this.flashDrawableIds.get(1).intValue());
        this.mBtnFlash3.setBackgroundResource(this.flashDrawableIds.get(2).intValue());
        this.checkFlash(i);
    }

    private void checkFlash(Integer i) {
        int j = i;
        Camera.Parameters par = this.mCamera.getParameters();
        if (j == CRes.plugin_camera_flash_drawale_auto) {
            par.setFlashMode("auto");
        } else if (j == CRes.plugin_camera_flash_drawale_open) {
            par.setFlashMode("on");
        } else if (j == CRes.plugin_camera_flash_drawale_close) {
            par.setFlashMode("off");
        }
        this.mCamera.setParameters(par);
    }

    protected void onPause() {
        super.onPause();
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    protected void onResume() {
        super.onResume();
        SurfaceHolder surfaceHolder = this.mSurfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            if (this.mCamera == null) {
                this.mCamera = Camera.open();
            }
            if (this.mCamera == null) {
                throw new RuntimeException("camera error!");
            }
            this.mCamera.setPreviewDisplay(surfaceHolder);
            this.initCameraParameters();
            this.mCamera.startPreview();
            this.mPreviewing = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCameraParameters() {
        Camera.Parameters parameters = this.mCamera.getParameters();
        String mod = Build.MODEL;
        if (Build.VERSION.SDK_INT >= 8) {
            if ("M9".equalsIgnoreCase(mod) || "MX".equalsIgnoreCase(mod)) {
                this.setDisplayOrientation(this.mCamera, 180);
            } else {
                this.setDisplayOrientation(this.mCamera, 90);
            }
        } else {
            parameters.set("orientation", "portrait");
            parameters.set("rotation", 90);
        }
        if (this.cameraCurrentlyLocked == 1) {
            parameters.setFocusMode("infinity");
            parameters.setFlashMode("off");
        } else {
            parameters.setFocusMode("auto");
            parameters.setFlashMode("auto");
        }
        parameters.setPictureFormat(256);
        Log.d((String)"camera", (String)("camera flashMode:" + parameters.getFlashMode()));
        List preSizes = parameters.getSupportedPreviewSizes();
        Camera.Size miniPre = this.computeNeedSize(preSizes);
        parameters.setPreviewSize(miniPre.width, miniPre.height);
        List picSizes = parameters.getSupportedPictureSizes();
        Camera.Size miniPic = this.computeNeedSize(picSizes);
        parameters.setPictureSize(miniPic.width, miniPic.height);
        if (parameters.isZoomSupported()) {
            parameters.setZoom(1);
        }
        this.mCamera.setParameters(parameters);
    }

    private void setDisplayOrientation(Camera camera, int angle) {
        try {
            Method downPolymorphic = camera.getClass().getMethod("setDisplayOrientation", Integer.TYPE);
            if (downPolymorphic != null) {
                downPolymorphic.invoke((Object)camera, angle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Camera.Size computeNeedSize(List<Camera.Size> sizes) {
        if (sizes == null || sizes.size() == 0) {
            return null;
        }
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        Camera.Size best = null;
        int screenPix = dm.widthPixels * dm.heightPixels;
        for (Camera.Size size : sizes) {
            int sizeOne = size.width * size.height;
            Log.d((String)"ldx", (String)("superSize: " + size.width + "*" + size.height));
            if (sizeOne != screenPix) continue;
            best = size;
            break;
        }
        if (best == null) {
            int length = sizes.size();
            if (2 >= length) {
                best = sizes.get(0);
            } else {
                int harf = length / 2 + 1;
                best = sizes.get(harf);
            }
        }
        return best;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mOnKeyDown = true;
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mOnKeyDown) {
                this.finish();
            }
            this.mOnKeyDown = false;
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void onAutoFocus(boolean success, Camera camera) {
        if (success) {
            camera.takePicture(null, null, this.jpeg);
        } else {
            camera.takePicture(null, null, this.jpeg);
        }
    }

    public void takePic() {
        this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public static int roundOrientation(int orientation) {
        return (orientation + 45) / 90 * 90 % 360;
    }
}

