/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.zywx.wbpalmstar.engine.EBrowserView;
import org.zywx.wbpalmstar.engine.universalex.EUExBase;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsConstants;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsHttpClient;
import org.zywx.wbpalmstar.plugin.uexmam.analytics.AnalyticsUtility;

public class EUExMAM
extends EUExBase {
    public static final String tag = "uexDataAnalysisLite";
    public static final String F_SPACE_APPID = "9999999";
    public static final boolean IS_FOR_TEST = true;
    public MAMHandler cbHandler;
    private static final String CB_updateParams = "uexDataAnalysis.cbUpdateParams";
    private static final String CB_refreshGetAuthorizeID = "uexDataAnalysis.cbGetAuthorizeID";
    private static final String CB_getDisablePlugins = "uexDataAnalysis.cbGetDisablePlugins";
    private static final String CB_getDisableWindows = "uexDataAnalysis.cbGetDisableWindows";
    private static final String CB_getUserInfo = "uexDataAnalysis.cbGetUserInfo";
    private static final String ON_widgetPatchUpdate = "uexEMM.onWidgetPatchUpdate";

    public EUExMAM(Context context, EBrowserView inParent) {
        super(context, inParent);
        AnalyticsAgent.getInstance().setEUExMAMInstance(this);
    }

    public void setEvent(String[] parm) {
        String inEventId = null;
        String inAttri = null;
        if (parm.length == 2) {
            inEventId = parm[0];
            inAttri = parm[1];
        } else if (parm.length == 1) {
            inEventId = parm[0];
        } else {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)inEventId)) {
            return;
        }
        HashMap<String, String> inMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)inAttri)) {
            try {
                JSONObject json = new JSONObject(inAttri);
                Iterator iterator = json.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    inMap.put(key, json.getString(key));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mBrwView.getBrowserWindow() == null) {
            return;
        }
        AnalyticsAgent.setEvent(inEventId, inMap);
    }

    public void beginEvent(String[] parm) {
        String inEventId;
        String inKeyWord = null;
        String inAttri = null;
        if (parm.length == 3) {
            inEventId = parm[0];
            inKeyWord = parm[1];
            inAttri = parm[2];
        } else if (parm.length == 2) {
            inEventId = parm[0];
            inKeyWord = parm[1];
        } else if (parm.length == 1) {
            inEventId = parm[0];
        } else {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)inEventId)) {
            return;
        }
        HashMap<String, String> inMap = new HashMap<String, String>();
        if (!TextUtils.isEmpty((CharSequence)inAttri)) {
            try {
                JSONObject json = new JSONObject(inAttri);
                Iterator iterator = json.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    inMap.put(key, json.getString(key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mBrwView.getBrowserWindow() == null) {
            return;
        }
        AnalyticsAgent.beginEvent(inEventId, inKeyWord, inMap);
    }

    public void endEvent(String[] parm) {
        String inEventId;
        String inKeyWord = null;
        if (parm.length == 2) {
            inEventId = parm[0];
            inKeyWord = parm[1];
        } else if (parm.length == 1) {
            inEventId = parm[0];
        } else {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)inEventId)) {
            return;
        }
        if (this.mBrwView.getBrowserWindow() == null) {
            return;
        }
        AnalyticsAgent.endEvent(inEventId, inKeyWord);
    }

    public void updateParams(String[] parm) {
        SharedPreferences sp = this.mContext.getSharedPreferences(AnalyticsConstants.SP_SAVEDATA, 0);
        this.jsCallback(CB_updateParams, 0, 1, sp.getString("appParam", ""));
    }

    public void getAuthorizeID(String[] parm) {
        if (!AnalyticsAgent.mam) {
            return;
        }
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        String authorizeID = preferences.getString("authorizeID", "");
        this.jsCallback(CB_refreshGetAuthorizeID, 0, 0, authorizeID);
    }

    public void refreshGetAuthorizeID(String[] parm) {
        Log.i((String)"MMS", (String)"\u6682\u65e0\u6b64\u529f\u80fd");
        Toast.makeText((Context)this.mContext, (CharSequence)"\u6682\u65e0\u6b64\u529f\u80fd", (int)1).show();
    }

    public void getDisablePlugins(String[] parm) {
        SharedPreferences sp = this.mContext.getSharedPreferences(AnalyticsConstants.SP_SAVEDATA, 0);
        String disablePlugins = sp.getString("disablePlugins", "");
        this.jsCallback(CB_getDisablePlugins, 0, 1, disablePlugins);
    }

    public void getUserInfo(String[] parm) {
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        String formInfo = preferences.getString("formInfo", "");
        String authorizeID = this.getAuthorizeID();
        if (TextUtils.isEmpty((CharSequence)authorizeID)) {
            formInfo = "";
        }
        if (!TextUtils.isEmpty((CharSequence)formInfo)) {
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString("formInfo", "");
            editor.commit();
        }
        this.jsCallback(CB_getUserInfo, 0, 1, formInfo);
    }

    public void getDisableWindows(String[] parm) {
        SharedPreferences sp = this.mContext.getSharedPreferences(AnalyticsConstants.SP_SAVEDATA, 0);
        String disableWindows = sp.getString("disableWindows", "");
        this.jsCallback(CB_getDisableWindows, 0, 0, disableWindows);
    }

    public void setErrorReport(String[] parm) {
        if (parm.length != 1) {
            return;
        }
        if (this.mBrwView.getBrowserWindow() == null) {
            return;
        }
        if ("1".equals(parm[0])) {
            AnalyticsAgent.setErrorReport(true);
        } else {
            AnalyticsAgent.setErrorReport(false);
        }
    }

    private int getStatus() {
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        return preferences.getInt("status", 0);
    }

    private int getSid(String softToken) {
        block7: {
            JSONObject sidInfoJson;
            block12: {
                block8: {
                    block10: {
                        block11: {
                            String checkAccessToken;
                            block9: {
                                String mam_host = AnalyticsUtility.getMamHost(this.mContext);
                                String sidString = AnalyticsHttpClient.getGetData(String.valueOf(mam_host) + "/term/" + softToken + "/authSid", this.mContext);
                                if (TextUtils.isEmpty((CharSequence)sidString)) {
                                    return 0;
                                }
                                JSONObject sidJson = new JSONObject(sidString);
                                if (!"ok".equals(sidJson.getString("status"))) break block7;
                                sidInfoJson = new JSONObject(sidJson.getString("info"));
                                if (!"auth".equals(sidInfoJson.getString("AuthStatus"))) break block8;
                                ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
                                nameValuePairs.add((NameValuePair)new BasicNameValuePair("md5Code", AnalyticsUtility.getMD5Code(new String[]{this.getAccessToken(), sidInfoJson.getString("AuthSid")})));
                                checkAccessToken = AnalyticsHttpClient.sendPostDataByNameValuePair(String.valueOf(mam_host) + "/term/" + softToken + "/authSid", nameValuePairs, this.mContext);
                                this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                                if (!TextUtils.isEmpty((CharSequence)checkAccessToken)) break block9;
                                return 0;
                            }
                            JSONObject checkAccessTokenJson = new JSONObject(checkAccessToken);
                            if (!"ok".equals(checkAccessTokenJson.getString("status"))) break block10;
                            JSONObject checkAccessInfo = new JSONObject(checkAccessTokenJson.getString("info"));
                            if (!"audit".equals(checkAccessInfo.getString("AuthStatus"))) break block11;
                            return 0;
                        }
                        this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                        return 2;
                    }
                    return 0;
                }
                if (!"audit".equals(sidInfoJson.getString("AuthStatus"))) break block12;
                return 0;
            }
            try {
                this.saveAuthorizeID(sidInfoJson.getString("AuthSid"));
                return 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private String getAccessToken() {
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        return preferences.getString("accessToken", null);
    }

    private void saveAuthorizeID(String authorizeID) {
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString("authorizeID", authorizeID);
        editor.commit();
    }

    private String getAuthorizeID() {
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        return preferences.getString("authorizeID", null);
    }

    private void clearMAMStatus() {
        SharedPreferences preferences = this.mContext.getSharedPreferences("mamStatus", 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt("status", 0);
        editor.putString("accessToken", null);
        editor.commit();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (data == null) {
            return;
        }
        int result = data.getIntExtra("result", 0);
        if (result == 0) {
            return;
        }
        String authorizeID = data.getStringExtra("authorizeID");
        this.jsCallback(CB_refreshGetAuthorizeID, 0, 0, authorizeID);
    }

    protected boolean clean() {
        return false;
    }

    public class MAMHandler
    extends Handler {
        public void send2Callback(String result, int what) {
            Message msg = Message.obtain();
            msg.what = what;
            msg.obj = result;
            this.sendMessage(msg);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    EUExMAM.this.jsCallback(EUExMAM.ON_widgetPatchUpdate, 0, 1, (String)msg.obj);
                    break;
                }
            }
        }
    }
}

