/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DiskCache {
    public static final String TAG = "DiskCache";
    private static File cacheFolder;

    public static void initDiskCache(Context context) {
        if (Build.VERSION.SDK_INT <= 7) {
            if ("mounted".equals(Environment.getExternalStorageState())) {
                String appendPath = "Android/data/" + context.getPackageName() + "/cache";
                try {
                    cacheFolder = new File(Environment.getExternalStorageDirectory(), appendPath);
                    if (!cacheFolder.exists()) {
                        cacheFolder.mkdirs();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            cacheFolder = context.getExternalCacheDir();
        }
    }

    public static boolean writeDiskCache(String fileName, Bitmap bitmap) {
        boolean isWrited;
        block16: {
            if (cacheFolder == null || fileName == null || bitmap == null || !cacheFolder.exists()) {
                return false;
            }
            if (bitmap.isRecycled()) {
                return false;
            }
            isWrited = false;
            FileOutputStream fos = null;
            File cacheFile = null;
            try {
                try {
                    cacheFile = new File(cacheFolder, fileName);
                    if (cacheFile.exists()) {
                        cacheFile.delete();
                    }
                    fos = new FileOutputStream(cacheFile);
                    if (bitmap.compress(bitmap.hasAlpha() ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos)) {
                        isWrited = true;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fos == null) break block16;
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isWrited;
    }

    public static Bitmap readCache(String key) {
        Bitmap bitmap;
        block14: {
            if (cacheFolder == null || key == null) {
                return null;
            }
            bitmap = null;
            File cacheFile = new File(cacheFolder, key);
            if (!cacheFile.exists() || !cacheFile.isFile()) {
                return null;
            }
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(cacheFile);
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)input.getFD());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (input == null) break block14;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return bitmap;
    }
}

