/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.cache;

import android.graphics.Bitmap;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.zywx.wbpalmstar.plugin.uexmam.cache.BytesArrayFactory;

public abstract class ImageLoadTask {
    public String filePath;
    private ImageLoadTaskCallback callback;
    public static final int STATUS_READY = 0;
    public static final int STATUS_STARTED = 1;
    public static final int STATUS_FINISHED = 2;
    private int currentState = 0;
    private String key = null;

    public ImageLoadTask(String filePath) {
        this.filePath = filePath;
        this.key = ImageLoadTask.getDigestCode(filePath);
    }

    public ImageLoadTask addCallback(ImageLoadTaskCallback callback) {
        this.callback = callback;
        return this;
    }

    public ImageLoadTaskCallback getCallBack() {
        return this.callback;
    }

    public Bitmap startExecute() {
        this.currentState = 1;
        return this.doInBackground();
    }

    public String getKey() {
        return this.key;
    }

    protected abstract Bitmap doInBackground();

    protected BytesArrayFactory.BytesArray transBitmapToBytesArray(Bitmap bitmap) {
        return null;
    }

    public void removeCallback() {
        this.callback = null;
    }

    public void performCallback(Bitmap bitmap) {
        if (this.callback != null) {
            this.callback.onImageLoaded(this, bitmap);
        }
        this.currentState = 2;
    }

    public void setStatus(int status) {
        this.currentState = status;
    }

    public int getStatus() {
        return this.currentState;
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImageLoadTask)) {
            return false;
        }
        ImageLoadTask task = (ImageLoadTask)o;
        return this.filePath.equals(task.filePath);
    }

    public static String getDigestCode(String msg) {
        String digest = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(msg.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            int offset = 0;
            while (offset < b.length) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
                ++offset;
            }
            digest = buf.toString().substring(8, 24);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return digest;
    }

    public static interface ImageLoadTaskCallback {
        public void onImageLoaded(ImageLoadTask var1, Bitmap var2);
    }
}

