/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.mam;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SlidePaneLayout
extends RelativeLayout {
    private static final String TAG = "SlidePaneLayout";
    private int mSliderFadeColor = -872415232;
    private static final int MIN_FLING_VELOCITY = 400;
    private int mCoveredFadeColor;
    private boolean mCanSlide;
    private View mSlideableView;
    private float mSlideOffset;
    private int mSlideRange;
    private int initSlideTop;
    private boolean mIsUnableToDrag;
    private int mParallayBy;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private PanelSlideListener mPanelSlideListener;
    private final ViewDragHelper mDragHelper;
    private boolean mPreservedOpenState;
    private boolean mFirstLayout = true;
    private final Rect mTmpRect = new Rect();
    private final ArrayList<DisableLayerRunnable> mPostedRunnables = new ArrayList();
    static final SlidingPanelLayoutImpl IMPL;

    static {
        int deviceVersion = Build.VERSION.SDK_INT;
        IMPL = deviceVersion >= 17 ? new SlidingPanelLayoutImplJBMR1() : (deviceVersion >= 16 ? new SlidingPanelLayoutImplJB() : new SlidingPanelLayoutImplBase());
    }

    public SlidePaneLayout(Context context) {
        this(context, null);
    }

    public SlidePaneLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidePaneLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float density = context.getResources().getDisplayMetrics().density;
        this.setWillNotDraw(false);
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (float)0.5f, (ViewDragHelper.Callback)new DragHelperCallback());
        this.mDragHelper.setEdgeTrackingEnabled(15);
        this.mDragHelper.setMinVelocity(400.0f * density);
    }

    public void setParallaxDistance(int parallaxBy) {
        this.mParallayBy = parallaxBy;
        this.requestLayout();
    }

    public int getParallaxDistance() {
        return this.mParallayBy;
    }

    public void setSliderFadeColor(int color) {
        this.mSliderFadeColor = color;
    }

    public int getSliderFadeColor() {
        return this.mSliderFadeColor;
    }

    public void setCoveredFadeColor(int color) {
        this.mCoveredFadeColor = color;
    }

    public int getCoveredFadeColor() {
        return this.mCoveredFadeColor;
    }

    public void setPanelSlideListener(PanelSlideListener listener) {
        this.mPanelSlideListener = listener;
    }

    void dispatchOnPanelSlide(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelSlide(panel, this.mSlideOffset);
        }
    }

    void dispatchOnPanelOpened(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelOpened(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void dispatchOnPanelClosed(View panel) {
        if (this.mPanelSlideListener != null) {
            this.mPanelSlideListener.onPanelClosed(panel);
        }
        this.sendAccessibilityEvent(32);
    }

    void setAllChildrenVisible() {
        int i = 0;
        int childCount = this.getChildCount();
        while (i < childCount) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 4) {
                child.setVisibility(0);
            }
            ++i;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
        int i = 0;
        int count = this.mPostedRunnables.size();
        while (i < count) {
            DisableLayerRunnable dlr = this.mPostedRunnables.get(i);
            dlr.run();
            ++i;
        }
        this.mPostedRunnables.clear();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        if (childCount > 2) {
            Log.e((String)TAG, (String)"onMeasure: More than two child views are not supported.");
        }
        this.mSlideableView = null;
        int i = 0;
        while (i < childCount) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (i == 1) {
                lp.slideable = true;
                if (lp.slideable) {
                    this.mSlideableView = child;
                }
            } else {
                lp.dimWhenOffset = true;
            }
            ++i;
        }
        this.mCanSlide = true;
        if (this.mDragHelper.getViewDragState() != 0 && !this.mCanSlide) {
            this.mDragHelper.abort();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mFirstLayout) {
            this.mSlideOffset = this.mCanSlide && this.mPreservedOpenState ? 1.0f : 0.0f;
        }
        int count = this.getChildCount();
        int i = 0;
        while (i < count) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 8) {
                RelativeLayout.LayoutParams st = (RelativeLayout.LayoutParams)child.getLayoutParams();
                RelativeLayoutParamsWrapper wrapper = new RelativeLayoutParamsWrapper(st);
                int offset = 0;
                if (i == 1) {
                    if (this.mFirstLayout) {
                        this.mSlideRange = Math.abs(st.bottomMargin);
                        this.initSlideTop = wrapper.getTop();
                    }
                    offset = (int)(this.mSlideOffset * (float)this.mSlideRange);
                }
                child.layout(wrapper.getLeft(), wrapper.getTop() - offset, wrapper.getRight(), wrapper.getBottom() - offset);
            }
            ++i;
        }
        this.mFirstLayout = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.mFirstLayout = true;
        }
    }

    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        if (!this.isInTouchMode() && !this.mCanSlide) {
            this.mPreservedOpenState = child == this.mSlideableView;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        View secondChild;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (!this.mCanSlide && action == 0 && this.getChildCount() > 1 && (secondChild = this.getChildAt(1)) != null) {
            boolean bl = this.mPreservedOpenState = !this.mDragHelper.isViewUnder(secondChild, (int)ev.getX(), (int)ev.getY());
        }
        if (!this.mCanSlide || this.mIsUnableToDrag && action != 0) {
            this.mDragHelper.cancel();
            return super.onInterceptTouchEvent(ev);
        }
        if (action == 3 || action == 1) {
            this.mDragHelper.cancel();
            return false;
        }
        boolean interceptTap = false;
        switch (action) {
            case 0: {
                this.mIsUnableToDrag = false;
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                if (!this.mDragHelper.isViewUnder(this.mSlideableView, (int)x, (int)y) || !this.isDimmed(this.mSlideableView)) break;
                interceptTap = true;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                float adx = Math.abs(x - this.mInitialMotionX);
                float ady = Math.abs(y - this.mInitialMotionY);
                int slop = this.mDragHelper.getTouchSlop();
                if (!(adx > (float)slop) || !(ady > adx)) break;
                this.mDragHelper.cancel();
                this.mIsUnableToDrag = true;
                return false;
            }
        }
        boolean interceptForDrag = this.mDragHelper.shouldInterceptTouchEvent(ev);
        return interceptForDrag || interceptTap;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mCanSlide) {
            return super.onTouchEvent(ev);
        }
        this.mDragHelper.processTouchEvent(ev);
        int action = ev.getAction();
        boolean wantTouchEvents = true;
        switch (action & 0xFF) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                break;
            }
            case 1: {
                int slop;
                float y;
                float dy;
                float x;
                float dx;
                if (!this.isDimmed(this.mSlideableView) || !((dx = (x = ev.getX()) - this.mInitialMotionX) * dx + (dy = (y = ev.getY()) - this.mInitialMotionY) * dy < (float)((slop = this.mDragHelper.getTouchSlop()) * slop)) || !this.mDragHelper.isViewUnder(this.mSlideableView, (int)x, (int)y)) break;
                this.closePane(this.mSlideableView, 0);
            }
        }
        return wantTouchEvents;
    }

    private boolean closePane(View pane, int initialVelocity) {
        if (this.mFirstLayout || this.smoothSlideTo(0.0f, initialVelocity)) {
            this.mPreservedOpenState = false;
            return true;
        }
        return false;
    }

    private boolean openPane(View pane, int initialVelocity) {
        if (this.mFirstLayout || this.smoothSlideTo(1.0f, initialVelocity)) {
            this.mPreservedOpenState = true;
            return true;
        }
        return false;
    }

    public boolean openPane() {
        return this.openPane(this.mSlideableView, 0);
    }

    public boolean closePane() {
        return this.closePane(this.mSlideableView, 0);
    }

    public boolean isOpen() {
        return !this.mCanSlide || this.mSlideOffset == 1.0f;
    }

    @Deprecated
    public boolean canSlide() {
        return this.mCanSlide;
    }

    public boolean isSlideable() {
        return this.mCanSlide;
    }

    private void onPanelDragged(int newTop) {
        LayoutParams lp = (LayoutParams)this.getChildAt(0).getLayoutParams();
        this.mSlideOffset = (float)(this.initSlideTop - newTop) / (float)this.mSlideRange;
        if (lp.dimWhenOffset) {
            this.dimChildView(this.getChildAt(0), this.mSlideOffset, this.mSliderFadeColor);
        }
        this.dispatchOnPanelSlide(this.mSlideableView);
    }

    private void dimChildView(View v, float mag, int fadeColor) {
        LayoutParams lp = (LayoutParams)v.getLayoutParams();
        if (mag > 0.0f && fadeColor != 0) {
            int baseAlpha = (fadeColor & 0xFF000000) >>> 24;
            int imag = (int)((float)baseAlpha * mag);
            int color = imag << 24 | fadeColor & 0xFFFFFF;
            if (lp.dimPaint == null) {
                lp.dimPaint = new Paint();
            }
            lp.dimPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_OVER));
            if (ViewCompat.getLayerType((View)v) != 2) {
                ViewCompat.setLayerType((View)v, (int)2, (Paint)lp.dimPaint);
            }
            this.invalidateChildRegion(v);
        } else if (ViewCompat.getLayerType((View)v) != 0) {
            if (lp.dimPaint != null) {
                lp.dimPaint.setColorFilter(null);
            }
            DisableLayerRunnable dlr = new DisableLayerRunnable(v);
            this.mPostedRunnables.add(dlr);
            ViewCompat.postOnAnimation((View)this, (Runnable)dlr);
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean result;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int save = canvas.save(2);
        if (!this.mCanSlide || !lp.slideable) {
            // empty if block
        }
        if (Build.VERSION.SDK_INT >= 11) {
            result = super.drawChild(canvas, child, drawingTime);
        } else if (lp.dimWhenOffset && this.mSlideOffset > 0.0f) {
            Bitmap cache;
            if (!child.isDrawingCacheEnabled()) {
                child.setDrawingCacheEnabled(true);
            }
            if ((cache = child.getDrawingCache()) != null) {
                canvas.drawBitmap(cache, (float)child.getLeft(), (float)child.getTop(), lp.dimPaint);
                result = false;
            } else {
                Log.e((String)TAG, (String)("drawChild: child view " + child + " returned null drawing cache"));
                result = super.drawChild(canvas, child, drawingTime);
            }
        } else {
            if (child.isDrawingCacheEnabled()) {
                child.setDrawingCacheEnabled(false);
            }
            result = super.drawChild(canvas, child, drawingTime);
        }
        canvas.restoreToCount(save);
        return result;
    }

    private void invalidateChildRegion(View v) {
        IMPL.invalidateChildRegion(this, v);
    }

    boolean smoothSlideTo(float slideOffset, int velocity) {
        if (!this.mCanSlide) {
            return false;
        }
        LayoutParams lp = (LayoutParams)this.mSlideableView.getLayoutParams();
        int topBound = this.initSlideTop;
        int y = (int)((float)topBound - slideOffset * (float)this.mSlideRange);
        if (this.mDragHelper.smoothSlideViewTo(this.mSlideableView, this.getLeft(), y)) {
            this.setAllChildrenVisible();
            ViewCompat.postInvalidateOnAnimation((View)this);
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mDragHelper.continueSettling(true)) {
            if (!this.mCanSlide) {
                this.mDragHelper.abort();
                return;
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    boolean isDimmed(View child) {
        if (child == null) {
            return false;
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return this.mCanSlide && lp.dimWhenOffset && this.mSlideOffset > 0.0f;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public RelativeLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isOpen = this.isSlideable() ? this.isOpen() : this.mPreservedOpenState;
        Log.i((String)TAG, (String)("onSaveInstanceState isOpen:" + ss.isOpen));
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.isOpen) {
            this.openPane();
        } else {
            this.closePane();
        }
        this.mPreservedOpenState = ss.isOpen;
        Log.i((String)TAG, (String)("onRestoreInstanceState isOpen:" + ss.isOpen));
    }

    private class DisableLayerRunnable
    implements Runnable {
        final View mChildView;

        DisableLayerRunnable(View childView) {
            this.mChildView = childView;
        }

        @Override
        public void run() {
            if (this.mChildView.getParent() == SlidePaneLayout.this) {
                ViewCompat.setLayerType((View)this.mChildView, (int)0, null);
                SlidePaneLayout.this.invalidateChildRegion(this.mChildView);
            }
            SlidePaneLayout.this.mPostedRunnables.remove(this);
        }
    }

    private class DragHelperCallback
    extends ViewDragHelper.Callback {
        private DragHelperCallback() {
        }

        public boolean tryCaptureView(View child, int pointerId) {
            if (SlidePaneLayout.this.mIsUnableToDrag) {
                return false;
            }
            return ((LayoutParams)child.getLayoutParams()).slideable;
        }

        public void onViewDragStateChanged(int state) {
            if (SlidePaneLayout.this.mDragHelper.getViewDragState() == 0) {
                if (SlidePaneLayout.this.mSlideOffset == 0.0f) {
                    SlidePaneLayout.this.dispatchOnPanelClosed(SlidePaneLayout.this.mSlideableView);
                    SlidePaneLayout.this.mPreservedOpenState = false;
                } else {
                    SlidePaneLayout.this.dispatchOnPanelOpened(SlidePaneLayout.this.mSlideableView);
                    SlidePaneLayout.this.mPreservedOpenState = true;
                }
            }
        }

        public void onViewCaptured(View capturedChild, int activePointerId) {
            SlidePaneLayout.this.setAllChildrenVisible();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SlidePaneLayout.this.onPanelDragged(top);
            SlidePaneLayout.this.invalidate();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            LayoutParams lp = (LayoutParams)releasedChild.getLayoutParams();
            boolean open = false;
            int top = SlidePaneLayout.this.initSlideTop;
            if (yvel < 0.0f || yvel == 0.0f && (double)SlidePaneLayout.this.mSlideOffset > 0.5) {
                top -= SlidePaneLayout.this.mSlideRange;
                open = true;
            }
            Log.i((String)SlidePaneLayout.TAG, (String)("onViewReleased() ySpeed:" + yvel + " offset:" + SlidePaneLayout.this.mSlideOffset + " open:" + open));
            SlidePaneLayout.this.mDragHelper.settleCapturedViewAt(releasedChild.getLeft(), top);
            SlidePaneLayout.this.invalidate();
        }

        public int getViewVerticalDragRange(View child) {
            return SlidePaneLayout.this.mSlideRange;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            LayoutParams lp = (LayoutParams)SlidePaneLayout.this.mSlideableView.getLayoutParams();
            int maxTop = SlidePaneLayout.this.initSlideTop;
            int minTop = SlidePaneLayout.this.initSlideTop - SlidePaneLayout.this.mSlideRange;
            int newTop = Math.min(Math.max(top, minTop), maxTop);
            return newTop;
        }

        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            SlidePaneLayout.this.mDragHelper.captureChildView(SlidePaneLayout.this.mSlideableView, pointerId);
        }
    }

    public static class LayoutParams
    extends RelativeLayout.LayoutParams {
        boolean slideable;
        boolean dimWhenOffset = false;
        Paint dimPaint;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }
    }

    public static interface PanelSlideListener {
        public void onPanelSlide(View var1, float var2);

        public void onPanelOpened(View var1);

        public void onPanelClosed(View var1);
    }

    private class RelativeLayoutParamsWrapper {
        private RelativeLayout.LayoutParams lp = null;
        private Field mLeft;
        private Field mRight;
        private Field mTop;
        private Field mBottom;

        public RelativeLayoutParamsWrapper(RelativeLayout.LayoutParams lp) {
            this.lp = lp;
            try {
                this.mLeft = RelativeLayout.LayoutParams.class.getDeclaredField("mLeft");
                this.mLeft.setAccessible(true);
                this.mRight = RelativeLayout.LayoutParams.class.getDeclaredField("mRight");
                this.mRight.setAccessible(true);
                this.mTop = RelativeLayout.LayoutParams.class.getDeclaredField("mTop");
                this.mTop.setAccessible(true);
                this.mBottom = RelativeLayout.LayoutParams.class.getDeclaredField("mBottom");
                this.mBottom.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)SlidePaneLayout.TAG, (String)"Couldn't fetch  field;", (Throwable)e);
            }
        }

        public int getLeft() {
            int value = 0;
            try {
                value = this.mLeft.getInt(this.lp);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return value;
        }

        public int getRight() {
            int value = 0;
            try {
                value = this.mRight.getInt(this.lp);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return value;
        }

        public int getTop() {
            int value = 0;
            try {
                value = this.mTop.getInt(this.lp);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return value;
        }

        public int getBottom() {
            int value = 0;
            try {
                value = this.mBottom.getInt(this.lp);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return value;
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean isOpen;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.isOpen = in.readInt() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isOpen ? 1 : 0);
        }
    }

    public static class SimplePanelSlideListener
    implements PanelSlideListener {
        @Override
        public void onPanelSlide(View panel, float slideOffset) {
        }

        @Override
        public void onPanelOpened(View panel) {
        }

        @Override
        public void onPanelClosed(View panel) {
        }
    }

    static interface SlidingPanelLayoutImpl {
        public void invalidateChildRegion(SlidePaneLayout var1, View var2);
    }

    static class SlidingPanelLayoutImplBase
    implements SlidingPanelLayoutImpl {
        SlidingPanelLayoutImplBase() {
        }

        @Override
        public void invalidateChildRegion(SlidePaneLayout parent, View child) {
            ViewCompat.postInvalidateOnAnimation((View)parent, (int)child.getLeft(), (int)child.getTop(), (int)child.getRight(), (int)child.getBottom());
        }
    }

    static class SlidingPanelLayoutImplJB
    extends SlidingPanelLayoutImplBase {
        private Method mGetDisplayList;
        private Field mRecreateDisplayList;

        SlidingPanelLayoutImplJB() {
            try {
                this.mGetDisplayList = View.class.getDeclaredMethod("getDisplayList", null);
            }
            catch (NoSuchMethodException e) {
                Log.e((String)SlidePaneLayout.TAG, (String)"Couldn't fetch getDisplayList method; dimming won't work right.", (Throwable)e);
            }
            try {
                this.mRecreateDisplayList = View.class.getDeclaredField("mRecreateDisplayList");
                this.mRecreateDisplayList.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.e((String)SlidePaneLayout.TAG, (String)"Couldn't fetch mRecreateDisplayList field; dimming will be slow.", (Throwable)e);
            }
        }

        @Override
        public void invalidateChildRegion(SlidePaneLayout parent, View child) {
            if (this.mGetDisplayList != null && this.mRecreateDisplayList != null) {
                try {
                    this.mRecreateDisplayList.setBoolean(child, true);
                    this.mGetDisplayList.invoke((Object)child, null);
                }
                catch (Exception e) {
                    Log.e((String)SlidePaneLayout.TAG, (String)"Error refreshing display list state", (Throwable)e);
                }
            } else {
                child.invalidate();
                return;
            }
            super.invalidateChildRegion(parent, child);
        }
    }

    static class SlidingPanelLayoutImplJBMR1
    extends SlidingPanelLayoutImplBase {
        SlidingPanelLayoutImplJBMR1() {
        }

        @Override
        public void invalidateChildRegion(SlidePaneLayout parent, View child) {
            ViewCompat.setLayerPaint((View)child, (Paint)((LayoutParams)child.getLayoutParams()).dimPaint);
        }
    }
}

