/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.push;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.PowerManager;
import android.util.Log;
import com.ibm.mqtt.IMqttClient;
import com.ibm.mqtt.MqttClient;
import com.ibm.mqtt.MqttException;
import com.ibm.mqtt.MqttNotConnectedException;
import com.ibm.mqtt.MqttPersistence;
import com.ibm.mqtt.MqttPersistenceException;
import com.ibm.mqtt.MqttSimpleCallback;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexmam.push.PushDataCallback;
import org.zywx.wbpalmstar.plugin.uexmam.push.Rc4Encrypt;

public class MQTTService
implements MqttSimpleCallback {
    public static final String MQTT_PING_ACTION = "org.mosquitto.android.powerviewer.PING";
    public static final int MQTT_NOTIFICATION_ONGOING = 1;
    public static final int MQTT_NOTIFICATION_UPDATE = 2;
    private Context _context;
    private String _softToken;
    private PushDataCallback pushDataCallback = null;
    public static final int MAX_MQTT_CLIENTID_LENGTH = 22;
    private MQTTConnectionStatus connectionStatus = MQTTConnectionStatus.INITIAL;
    private String brokerHostName = "";
    private String topicName = "";
    private MqttPersistence usePersistence = null;
    private boolean cleanStart = false;
    private int[] qualitiesOfService = new int[]{2, 2};
    private short keepAliveSeconds = (short)1200;
    private IMqttClient mqttClient = null;
    private NetworkConnectionIntentReceiver netConnReceiver;
    private BackgroundDataChangeIntentReceiver dataEnabledReceiver;
    private PingSender pingSender;
    private LocalBinder<MQTTService> mBinder;
    private Hashtable<String, String> dataCache = new Hashtable();

    public MQTTService(Context context, String url, PushDataCallback callback, String softToken) {
        this._context = context;
        this.brokerHostName = url;
        this.pushDataCallback = callback;
        this._softToken = softToken;
    }

    public void init() {
        this.connectionStatus = MQTTConnectionStatus.INITIAL;
        this.mBinder = new LocalBinder<MQTTService>(this);
        this.dataEnabledReceiver = new BackgroundDataChangeIntentReceiver();
        this._context.registerReceiver((BroadcastReceiver)this.dataEnabledReceiver, new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED"));
        this.defineConnectionToBroker(this.brokerHostName);
        this.onStart();
    }

    public void onStart() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                MQTTService.this.handleStart();
            }
        }, "MQTTservice").start();
    }

    synchronized void handleStart() {
        if (this.mqttClient == null) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)this._context.getSystemService("connectivity");
        if (!cm.getBackgroundDataSetting()) {
            this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_DATADISABLED;
            this.broadcastServiceStatus("Not connected - background data disabled");
            return;
        }
        this.rebroadcastStatus();
        this.rebroadcastReceivedMessages();
        if (!this.isAlreadyConnected()) {
            this.connectionStatus = MQTTConnectionStatus.CONNECTING;
            if (this.isOnline()) {
                if (this.connectToBroker()) {
                    this.subscribeToTopic(this.topicName);
                }
            } else {
                this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_WAITINGFORINTERNET;
                this.broadcastServiceStatus("Waiting for network connection");
            }
        }
        if (this.netConnReceiver == null) {
            this.netConnReceiver = new NetworkConnectionIntentReceiver();
            this._context.registerReceiver((BroadcastReceiver)this.netConnReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        if (this.pingSender == null) {
            this.pingSender = new PingSender();
            this._context.registerReceiver((BroadcastReceiver)this.pingSender, new IntentFilter(MQTT_PING_ACTION));
        }
    }

    public void onDestroy() {
        this.disconnectFromBroker();
        this.broadcastServiceStatus("Disconnected");
        if (this.dataEnabledReceiver != null) {
            this._context.unregisterReceiver((BroadcastReceiver)this.dataEnabledReceiver);
            this.dataEnabledReceiver = null;
        }
        if (this.mBinder != null) {
            this.mBinder.close();
            this.mBinder = null;
        }
    }

    private void broadcastServiceStatus(String statusDescription) {
    }

    private void broadcastReceivedMessage(String topic, String message) {
    }

    private void notifyUser(String alert, String title, String body) {
    }

    public MQTTConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void rebroadcastStatus() {
        String status = "";
        switch (this.connectionStatus) {
            case INITIAL: {
                status = "Please wait";
                break;
            }
            case CONNECTING: {
                status = "Connecting...";
                break;
            }
            case CONNECTED: {
                status = "Connected";
                break;
            }
            case NOTCONNECTED_UNKNOWNREASON: {
                status = "Not connected - waiting for network connection";
                break;
            }
            case NOTCONNECTED_USERDISCONNECT: {
                status = "Disconnected";
                break;
            }
            case NOTCONNECTED_DATADISABLED: {
                status = "Not connected - background data disabled";
                break;
            }
            case NOTCONNECTED_WAITINGFORINTERNET: {
                status = "Unable to connect";
            }
        }
        this.broadcastServiceStatus(status);
    }

    public void disconnect() {
        this.disconnectFromBroker();
        this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_USERDISCONNECT;
        this.broadcastServiceStatus("Disconnected");
    }

    public void connectionLost() throws Exception {
        System.out.println("connectionLost");
        PowerManager pm = (PowerManager)this._context.getSystemService("power");
        PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT");
        wl.acquire();
        if (!this.isOnline()) {
            this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_WAITINGFORINTERNET;
            this.broadcastServiceStatus("Connection lost - no network connection");
            this.notifyUser("Connection lost - no network connection", "MQTT", "Connection lost - no network connection");
        } else {
            this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_UNKNOWNREASON;
            this.broadcastServiceStatus("Connection lost - reconnecting...");
            if (this.connectToBroker()) {
                this.subscribeToTopic(this.topicName);
            }
        }
        wl.release();
    }

    public void publishArrived(String topic, byte[] payloadbytes, int qos, boolean retained) {
        PowerManager pm = (PowerManager)this._context.getSystemService("power");
        PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT");
        wl.acquire();
        String reData = new String(payloadbytes);
        if (reData != null && reData.length() > 0) {
            SharedPreferences sp = this._context.getSharedPreferences("app", 1);
            String mAppId = sp.getString("appid", null);
            try {
                JSONObject json = new JSONObject(Rc4Encrypt.decry_RC4(reData, mAppId));
                String status = json.getString("status");
                if ("ok".equals(status)) {
                    String messageList = json.getString("messageList");
                    JSONArray jsonArray = new JSONArray(messageList);
                    int i = 0;
                    while (i < jsonArray.length()) {
                        if (this.pushDataCallback != null) {
                            this.pushDataCallback.pushData(jsonArray.getJSONObject(i));
                        }
                        ++i;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.scheduleNextPing();
        wl.release();
    }

    private void defineConnectionToBroker(String brokerHostName) {
        String mqttConnSpec = "tcp://" + brokerHostName;
        try {
            this.mqttClient = MqttClient.createMqttClient((String)mqttConnSpec, (MqttPersistence)this.usePersistence);
            this.mqttClient.registerSimpleHandler((MqttSimpleCallback)this);
        }
        catch (MqttException e) {
            this.mqttClient = null;
            this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_UNKNOWNREASON;
            this.broadcastServiceStatus("Invalid connection parameters");
            this.notifyUser("Unable to connect", "MQTT", "Unable to connect");
        }
    }

    private String getMacAddress() {
        String macSerial = null;
        try {
            WifiManager wifi = (WifiManager)this._context.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            macSerial = info.getMacAddress().replaceAll(":", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (macSerial == null) {
            macSerial = this.getMac().replaceAll(":", "");
        }
        return macSerial;
    }

    private String getMac() {
        String macSerial = "";
        String str = "";
        try {
            Process pp = Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address ");
            InputStreamReader ir = new InputStreamReader(pp.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while (str != null) {
                str = input.readLine();
                if (str == null) continue;
                macSerial = str.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return macSerial;
    }

    private boolean connectToBroker() {
        try {
            SharedPreferences sp = this._context.getSharedPreferences("app", 1);
            String mAppId = sp.getString("appid", null);
            this.mqttClient.connect(String.valueOf(this.getMacAddress()) + mAppId, this.cleanStart, this.keepAliveSeconds);
            this.broadcastServiceStatus("Connected");
            this.connectionStatus = MQTTConnectionStatus.CONNECTED;
            System.out.println("connectToBroker");
            this.scheduleNextPing();
            return true;
        }
        catch (Exception e) {
            this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_UNKNOWNREASON;
            this.broadcastServiceStatus("Unable to connect");
            this.notifyUser("Unable to connect", "MQTT", "Unable to connect - will retry later");
            this.scheduleNextPing();
            return false;
        }
    }

    private void subscribeToTopic(String topicName) {
        boolean subscribed = false;
        if (!this.isAlreadyConnected()) {
            Log.e((String)"mqtt", (String)"Unable to subscribe as we are not connected");
        } else {
            try {
                SharedPreferences sp = this._context.getSharedPreferences("app", 1);
                String mAppId = sp.getString("appid", null);
                String[] topics = new String[]{"push/" + mAppId, "push/" + this._softToken};
                this.mqttClient.subscribe(topics, this.qualitiesOfService);
                subscribed = true;
            }
            catch (MqttNotConnectedException e) {
                Log.e((String)"mqtt", (String)"subscribe failed - MQTT not connected", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"mqtt", (String)"subscribe failed - illegal argument", (Throwable)e);
            }
            catch (MqttException e) {
                Log.e((String)"mqtt", (String)"subscribe failed - MQTT exception", (Throwable)e);
            }
        }
        if (!subscribed) {
            this.broadcastServiceStatus("Unable to subscribe");
            this.notifyUser("Unable to subscribe", "MQTT", "Unable to subscribe");
        }
    }

    private void disconnectFromBroker() {
        block10: {
            try {
                if (this.netConnReceiver != null) {
                    this._context.unregisterReceiver((BroadcastReceiver)this.netConnReceiver);
                    this.netConnReceiver = null;
                }
                if (this.pingSender != null) {
                    this._context.unregisterReceiver((BroadcastReceiver)this.pingSender);
                    this.pingSender = null;
                }
            }
            catch (Exception eee) {
                Log.e((String)"mqtt", (String)"unregister failed", (Throwable)eee);
            }
            try {
                try {
                    if (this.mqttClient != null) {
                        this.mqttClient.disconnect();
                    }
                }
                catch (MqttPersistenceException e) {
                    Log.e((String)"mqtt", (String)"disconnect failed - persistence exception", (Throwable)e);
                    this.mqttClient = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.mqttClient = null;
                throw throwable;
            }
            this.mqttClient = null;
        }
        NotificationManager nm = (NotificationManager)this._context.getSystemService("notification");
        nm.cancelAll();
    }

    private boolean isAlreadyConnected() {
        return this.mqttClient != null && this.mqttClient.isConnected();
    }

    private void scheduleNextPing() {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this._context, (int)0, (Intent)new Intent(MQTT_PING_ACTION), (int)0x8000000);
        Calendar wakeUpTime = Calendar.getInstance();
        wakeUpTime.add(13, this.keepAliveSeconds);
        AlarmManager aMgr = (AlarmManager)this._context.getSystemService("alarm");
        aMgr.set(0, wakeUpTime.getTimeInMillis(), pendingIntent);
    }

    private boolean addReceivedMessageToStore(String key, String value) {
        String previousValue = null;
        previousValue = value.length() == 0 ? this.dataCache.remove(key) : this.dataCache.put(key, value);
        return previousValue == null || !previousValue.equals(value);
    }

    public void rebroadcastReceivedMessages() {
        Enumeration<String> e = this.dataCache.keys();
        while (e.hasMoreElements()) {
            String nextKey = e.nextElement();
            String nextValue = this.dataCache.get(nextKey);
            this.broadcastReceivedMessage(nextKey, nextValue);
        }
    }

    private boolean isOnline() {
        ConnectivityManager cm = (ConnectivityManager)this._context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo() != null && cm.getActiveNetworkInfo().isAvailable() && cm.getActiveNetworkInfo().isConnected();
    }

    private class BackgroundDataChangeIntentReceiver
    extends BroadcastReceiver {
        private BackgroundDataChangeIntentReceiver() {
        }

        public void onReceive(Context ctx, Intent intent) {
            PowerManager pm = (PowerManager)MQTTService.this._context.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT");
            wl.acquire();
            ConnectivityManager cm = (ConnectivityManager)MQTTService.this._context.getSystemService("connectivity");
            if (cm.getBackgroundDataSetting()) {
                MQTTService.this.defineConnectionToBroker(MQTTService.this.brokerHostName);
            } else {
                MQTTService.this.connectionStatus = MQTTConnectionStatus.NOTCONNECTED_DATADISABLED;
                MQTTService.this.broadcastServiceStatus("Not connected - background data disabled");
                MQTTService.this.disconnectFromBroker();
            }
            wl.release();
        }
    }

    public class LocalBinder<S>
    extends Binder {
        private WeakReference<S> mService;

        public LocalBinder(S service) {
            this.mService = new WeakReference<S>(service);
        }

        public S getService() {
            return (S)this.mService.get();
        }

        public void close() {
            this.mService = null;
        }
    }

    public static enum MQTTConnectionStatus {
        INITIAL,
        CONNECTING,
        CONNECTED,
        NOTCONNECTED_WAITINGFORINTERNET,
        NOTCONNECTED_USERDISCONNECT,
        NOTCONNECTED_DATADISABLED,
        NOTCONNECTED_UNKNOWNREASON;

    }

    private class NetworkConnectionIntentReceiver
    extends BroadcastReceiver {
        private NetworkConnectionIntentReceiver() {
        }

        public void onReceive(Context ctx, Intent intent) {
            PowerManager pm = (PowerManager)MQTTService.this._context.getSystemService("power");
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT");
            wl.acquire();
            if (MQTTService.this.isOnline() && MQTTService.this.connectToBroker()) {
                MQTTService.this.subscribeToTopic(MQTTService.this.topicName);
            }
            wl.release();
        }
    }

    public class PingSender
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            block4: {
                try {
                    MQTTService.this.mqttClient.ping();
                }
                catch (MqttException e) {
                    Log.e((String)"mqtt", (String)"ping failed - MQTT exception", (Throwable)e);
                    try {
                        MQTTService.this.mqttClient.disconnect();
                    }
                    catch (MqttPersistenceException e1) {
                        Log.e((String)"mqtt", (String)"disconnect failed - persistence exception", (Throwable)e1);
                    }
                    if (!MQTTService.this.connectToBroker()) break block4;
                    MQTTService.this.subscribeToTopic(MQTTService.this.topicName);
                }
            }
            MQTTService.this.scheduleNextPing();
        }
    }
}

