/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexmam.uexcamera;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.webkit.URLUtil;
import android.widget.Toast;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.zywx.wbpalmstar.base.BUtility;
import org.zywx.wbpalmstar.base.ResoureFinder;
import org.zywx.wbpalmstar.engine.EBrowserView;
import org.zywx.wbpalmstar.engine.universalex.EUExBase;
import org.zywx.wbpalmstar.plugin.uexmam.uexcamera.Util;

public class EUExCamera
extends EUExBase {
    public static final String function = "uexCamera.cbOpen";
    public static final String function1 = "uexCamera.cbOpenInternal";
    private File m_tempPath;
    private boolean mWillCompress;
    private int mQuality;

    public EUExCamera(Context context, EBrowserView inParent) {
        super(context, inParent);
    }

    public void open(String[] parm) {
        int value;
        this.mWillCompress = false;
        this.mQuality = -1;
        if (parm.length == 1) {
            value = 1;
            try {
                value = Integer.parseInt(parm[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWillCompress = value == 0;
        } else if (parm.length == 2) {
            value = 1;
            try {
                value = Integer.parseInt(parm[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = this.mWillCompress = value == 0;
            if (this.mWillCompress) {
                int quality = -1;
                try {
                    quality = Integer.parseInt(parm[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mQuality = quality;
            }
        }
        ActivityManager.MemoryInfo outInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        activityManager.getMemoryInfo(outInfo);
        if (outInfo.lowMemory || outInfo.availMem < 31000000L) {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u5185\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u6253\u5f00\u76f8\u673a", (int)1).show();
            Runtime.getRuntime().gc();
            return;
        }
        if (BUtility.sdCardIsWork()) {
            if (!this.mWillCompress) {
                String path = String.valueOf(this.mBrwView.getCurrentWidget().getWidgetPath()) + this.getName();
                this.m_tempPath = new File(path);
            } else {
                this.m_tempPath = new File(String.valueOf(BUtility.getSdCardRootPath()) + "demo.jpg");
            }
            if (!this.m_tempPath.exists()) {
                try {
                    this.m_tempPath.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)ResoureFinder.getInstance().getString(this.mContext, "error_sdcard_is_not_available"), (int)0).show();
            this.errorCallback(0, 1030106, "Storage error");
            return;
        }
        this.checkPath();
        Intent camaIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        Uri uri = Uri.fromFile((File)this.m_tempPath);
        camaIntent.putExtra("output", (Parcelable)uri);
        camaIntent.setFlags(0x400000);
        this.startActivityForResult(camaIntent, 66666);
    }

    public void openInternal(String[] parm) {
        int value;
        this.mWillCompress = false;
        this.mQuality = -1;
        if (parm.length == 1) {
            value = 1;
            try {
                value = Integer.parseInt(parm[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWillCompress = value == 0;
        } else if (parm.length == 2) {
            value = 1;
            try {
                value = Integer.parseInt(parm[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = this.mWillCompress = value == 0;
            if (this.mWillCompress) {
                int quality = -1;
                try {
                    quality = Integer.parseInt(parm[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mQuality = quality;
            }
        }
        ActivityManager.MemoryInfo outInfo = new ActivityManager.MemoryInfo();
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        activityManager.getMemoryInfo(outInfo);
        if (outInfo.lowMemory || outInfo.availMem < 31000000L) {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u5185\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u6253\u5f00\u76f8\u673a", (int)1).show();
            Runtime.getRuntime().gc();
            return;
        }
        if (BUtility.sdCardIsWork()) {
            if (!this.mWillCompress) {
                String path = String.valueOf(this.mBrwView.getCurrentWidget().getWidgetPath()) + this.getName();
                this.m_tempPath = new File(path);
            } else {
                this.m_tempPath = new File(String.valueOf(BUtility.getSdCardRootPath()) + "demo.jpg");
            }
            if (!this.m_tempPath.exists()) {
                try {
                    this.m_tempPath.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)ResoureFinder.getInstance().getString(this.mContext, "error_sdcard_is_not_available"), (int)0).show();
            this.errorCallback(0, 1030106, "Storage error");
            return;
        }
        this.checkPath();
        Intent camaIntent = new Intent();
        camaIntent.setAction("android.intent.action.CAMERA_PLUGIN");
        camaIntent.putExtra("photoPath", this.m_tempPath.getAbsolutePath());
        camaIntent.setFlags(0x400000);
        this.startActivityForResult(camaIntent, 66667);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        String finalPath = "";
        ExifInterface exif = null;
        int degree = 0;
        if (resultCode == -1) {
            if (requestCode == 66666) {
                try {
                    int orientation;
                    if (this.m_tempPath != null) {
                        finalPath = this.m_tempPath.getAbsolutePath();
                    } else if (data != null) {
                        Uri content = data.getData();
                        if (content != null) {
                            String realPath = null;
                            String url = content.toString();
                            if (URLUtil.isFileUrl((String)url)) {
                                realPath = url.replace("file://", "");
                            } else if (URLUtil.isContentUrl((String)url)) {
                                Activity activity = (Activity)this.mContext;
                                Cursor c = activity.managedQuery(content, null, null, null, null);
                                boolean isExist = c.moveToFirst();
                                if (isExist) {
                                    realPath = c.getString(c.getColumnIndex("_data"));
                                }
                                c.close();
                            }
                            if (realPath != null) {
                                finalPath = realPath;
                            }
                        } else {
                            Bitmap bitmap;
                            Bundle bundle = data.getExtras();
                            if (bundle != null && (bitmap = (Bitmap)bundle.get("data")) != null) {
                                String newfile = String.valueOf(BUtility.getSdCardRootPath()) + "demo.jpg";
                                File newFile = new File(newfile);
                                if (!newFile.exists()) {
                                    newFile.createNewFile();
                                }
                                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(newfile)));
                                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                                bos.flush();
                                bos.close();
                                finalPath = newfile;
                            }
                        }
                    }
                    if (finalPath == null) {
                        this.errorCallback(0, 1030106, "Storage error or no permission");
                        return;
                    }
                    if (URLUtil.isFileUrl((String)finalPath)) {
                        finalPath = finalPath.replace("file://", "");
                    }
                    if ((orientation = (exif = new ExifInterface(finalPath)).getAttributeInt("Orientation", -1)) != -1) {
                        switch (orientation) {
                            case 1: {
                                degree = 0;
                                break;
                            }
                            case 6: {
                                degree = 90;
                                break;
                            }
                            case 3: {
                                degree = 180;
                                break;
                            }
                            case 8: {
                                degree = 270;
                            }
                        }
                    }
                    if (!this.mWillCompress && degree == 0) {
                        this.jsCallback(function, 0, 0, finalPath);
                    }
                    String tPath = this.makePictrue(new File(finalPath), degree);
                    if (tPath == null) {
                        this.errorCallback(0, 1030106, "Storage error or no permission");
                    }
                    this.jsCallback(function, 0, 0, tPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errorCallback(0, 1030106, "Storage error or no permission");
                    return;
                }
            } else if (requestCode == 66667) {
                if (data != null) {
                    // empty if block
                }
                if ((finalPath = this.m_tempPath.getAbsolutePath()) != null) {
                    try {
                        exif = new ExifInterface(finalPath);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    int orientation = exif.getAttributeInt("Orientation", -1);
                    if (orientation != -1) {
                        switch (orientation) {
                            case 1: {
                                degree = 0;
                                break;
                            }
                            case 6: {
                                degree = 90;
                                break;
                            }
                            case 3: {
                                degree = 180;
                                break;
                            }
                            case 8: {
                                degree = 270;
                            }
                        }
                    }
                    if (!this.mWillCompress && degree == 0) {
                        this.jsCallback(function1, 0, 0, finalPath);
                    } else {
                        String tPath = this.makePictrue(new File(finalPath), degree);
                        if (tPath == null) {
                            this.errorCallback(0, 1030106, "Storage error or no permission");
                        } else {
                            this.jsCallback(function1, 0, 0, tPath);
                        }
                    }
                }
            }
        }
    }

    private String makePictrue(File inPath, int degree) {
        String newPath = String.valueOf(this.mBrwView.getCurrentWidget().getWidgetPath()) + this.getName();
        BitmapFactory.Options opts = new BitmapFactory.Options();
        if (this.mWillCompress) {
            if (this.mQuality <= 0) {
                opts.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)inPath.getAbsolutePath(), (BitmapFactory.Options)opts);
                int sampleSize = 1;
                int w = opts.outWidth;
                int h = opts.outHeight;
                sampleSize = w > 3600 || h > 3600 ? 4 : (w > 2500 || h > 2500 ? 3 : (w > 1200 || h > 1200 ? 2 : 1));
                opts.inSampleSize = sampleSize;
                opts.inPurgeable = true;
                opts.inInputShareable = true;
                opts.inJustDecodeBounds = false;
                this.mQuality = 60;
            }
        } else {
            opts.inSampleSize = 2;
            opts.inPurgeable = true;
            opts.inInputShareable = true;
            opts.inJustDecodeBounds = false;
            this.mQuality = 100;
        }
        Bitmap picture = null;
        File newFile = new File(newPath);
        try {
            try {
                picture = BitmapFactory.decodeFile((String)inPath.getAbsolutePath(), (BitmapFactory.Options)opts);
                if (degree > 0 && picture != null) {
                    picture = Util.rotate(picture, degree);
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(newFile));
                picture.compress(Bitmap.CompressFormat.JPEG, this.mQuality, (OutputStream)bos);
                bos.flush();
                bos.close();
            }
            catch (OutOfMemoryError e) {
                Toast.makeText((Context)this.mContext, (CharSequence)"\u7167\u7247\u5c3a\u5bf8\u8fc7\u5927\uff0c\u5185\u5b58\u6ea2\u51fa\uff0c\n\u8bf7\u964d\u4f4e\u5c3a\u5bf8\u62cd\u6444\uff01", (int)1).show();
                if (picture != null) {
                    picture.recycle();
                }
                inPath.delete();
                System.gc();
                return null;
            }
            catch (IOException e) {
                if (picture != null) {
                    picture.recycle();
                }
                inPath.delete();
                System.gc();
                return null;
            }
        }
        finally {
            if (picture != null) {
                picture.recycle();
            }
            inPath.delete();
            System.gc();
        }
        this.mWillCompress = false;
        this.mQuality = -1;
        return newPath;
    }

    private String getName() {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");
        return "photo/scan" + df.format(date) + ".jpg";
    }

    private void checkPath() {
        String widgetPath = String.valueOf(this.mBrwView.getCurrentWidget().getWidgetPath()) + "photo";
        File temp = new File(widgetPath);
        if (!temp.exists()) {
            temp.mkdirs();
        } else {
            File[] files = temp.listFiles();
            if (files.length >= 20) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
        }
    }

    protected boolean clean() {
        if (this.m_tempPath != null) {
            this.m_tempPath = null;
        }
        return true;
    }
}

