/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.MimeTypeMap;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar.ProgressBarHandler;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMThread;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.AppUpgradeDialogViewVO;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.upgrade.EMMUpgradeUtils;
import org.zywx.wbpalmstar.plugin.uexemm.upgrade.widgetpatch.WidgetPatchDownloadTask;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class AppUpgradeDialog
extends AlertDialog {
    private AlertDialog alertDialog;
    private AppUpgradeDialogViewVO mAppUpgradeDialogViewVO;
    private ProgressBarHandler mProgressBarHandler;
    private int mMaxProgress;
    private static final String FROYO_USERAGENT = "Mozilla/5.0 (Linux; U; Android " + Build.VERSION.RELEASE + "; en-us; " + Build.MODEL + " Build/FRF91) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1";
    private HttpURLConnection mHttpConnection;
    private EMMStartReportResVO emmStatus;
    private EMMWWidgetData mWidgetData;
    private InputStream mInStream;
    private int mTotalSize;
    private File mTmpFile = null;
    private int downLoaderSize = 0;
    private Context mContext;
    private EMMThread mEMMThread;
    private Handler mProgressHandler = new Handler(){

        public void handleMessage(Message msg) {
            AppUpgradeDialog.this.setProgress(msg.what);
            switch (msg.what) {
                case 100: {
                    this.sendMessageDelayed(AppUpgradeDialog.this.mProgressHandler.obtainMessage(-1, (Object)((String)msg.obj)), 1000L);
                    break;
                }
                case -1: {
                    AppUpgradeDialog.this.downloadDone(AppUpgradeDialog.this.mContext, (String)msg.obj);
                    break;
                }
                case -4: {
                    UpdateDialogUIConfig config = new UpdateDialogUIConfig();
                    config.msg = (String)msg.obj;
                    config.forceUpdate = Boolean.valueOf(((AppUpgradeDialog)AppUpgradeDialog.this).emmStatus.forceUpdate);
                    config.pkgType = "upgrade";
                    AppUpgradeDialog.this.updateDialogUI(AppUpgradeDialog.this.mContext, 2, config);
                    GrayRelease.freeGrayReleaseVersion(AppUpgradeDialog.this.mContext, EMMAgent.s_rootWgt, AppUpgradeDialog.this.emmStatus);
                }
                case -3: {
                    AppUpgradeDialog.this.stopDownload();
                    break;
                }
                case -2: {
                    AppUpgradeDialog.this.dismiss();
                    Toast.makeText((Context)AppUpgradeDialog.this.getContext(), (CharSequence)((String)msg.obj), (int)1).show();
                    break;
                }
            }
        }
    };
    private static WidgetPatchDownloadTask netAsyncTask = null;
    private static AppUpgradeDialog mAppUpgradeDialog = null;

    public AppUpgradeDialog(Context mContext, ProgressBarHandler mProgressBarHandler) {
        super(mContext);
        this.mContext = mContext;
        this.mProgressBarHandler = mProgressBarHandler;
        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
        builder.setCancelable(false);
        this.alertDialog = builder.create();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)mContext);
        View dialogView = layoutInflater.inflate(EUExUtil.getResLayoutID((String)"plugin_emm_new_app_dialog_layout"), null);
        RelativeLayout newAppRly = (RelativeLayout)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_rly"));
        ImageView ivIcon = (ImageView)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_dailog_tile_icon"));
        TextView tvTitle = (TextView)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_dailog_tile_tv"));
        TextView tvMsg = (TextView)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_dialog_msg"));
        Button rightBtn = (Button)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_dailog_right_btn"));
        Button leftBtn = (Button)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_dailog_left_btn"));
        View progressBar = mProgressBarHandler.getProgressBar(mContext, dialogView);
        Button centerBtn = (Button)dialogView.findViewById(EUExUtil.getResIdID((String)"plugin_uexemm_new_app_dailog_center_btn"));
        this.mAppUpgradeDialogViewVO = new AppUpgradeDialogViewVO(dialogView, newAppRly, ivIcon, tvTitle, progressBar, tvMsg, rightBtn, leftBtn, centerBtn);
        this.mMaxProgress = mProgressBarHandler.getMaxProgress(progressBar);
    }

    @SuppressLint(value={"NewApi"})
    public void setIcon(Drawable icon) {
        this.mAppUpgradeDialogViewVO.getIvIcon().setBackground(icon);
    }

    public void setTitle(String title) {
        this.mAppUpgradeDialogViewVO.getTvTitle().setText((CharSequence)title);
    }

    public void setMsg(String msg) {
        msg = EMMUtils.replaceReturn(msg);
        this.mAppUpgradeDialogViewVO.getTvMsg().setText((CharSequence)Html.fromHtml((String)msg));
    }

    public void setRightButtonText(String text) {
        this.mAppUpgradeDialogViewVO.getRightBtn().setVisibility(0);
        this.mAppUpgradeDialogViewVO.getRightBtn().setText((CharSequence)text);
    }

    public void setRightButtonOnClickListener(View.OnClickListener mOnClickListener) {
        this.mAppUpgradeDialogViewVO.getRightBtn().setOnClickListener(mOnClickListener);
    }

    public void setLeftButtonText(String text) {
        this.mAppUpgradeDialogViewVO.getLeftBtn().setVisibility(0);
        this.mAppUpgradeDialogViewVO.getLeftBtn().setText((CharSequence)text);
    }

    public void setLeftButtonOnClickListener(View.OnClickListener mOnClickListener) {
        this.mAppUpgradeDialogViewVO.getLeftBtn().setOnClickListener(mOnClickListener);
    }

    public void setCenterButtonText(String text) {
        this.mAppUpgradeDialogViewVO.getCenterBtn().setVisibility(0);
        this.mAppUpgradeDialogViewVO.getCenterBtn().setText((CharSequence)text);
    }

    public void setCenterButtonOnClickListener(View.OnClickListener mOnClickListener) {
        this.mAppUpgradeDialogViewVO.getCenterBtn().setOnClickListener(mOnClickListener);
    }

    public void setProgress(int progress) {
        if (progress >= 0) {
            progress = progress <= this.mMaxProgress ? progress : this.mMaxProgress;
            this.mProgressBarHandler.setProgress(this.mAppUpgradeDialogViewVO.getProgressBar(), progress);
        }
    }

    public void show() {
        this.alertDialog.show();
        Window window = this.alertDialog.getWindow();
        window.setContentView(this.mAppUpgradeDialogViewVO.getDialogView());
    }

    public void dismiss() {
        this.alertDialog.dismiss();
    }

    private String getMimeType(String extension) {
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }

    public void initDownloadUpgradePkg(Context mContext, EMMStartReportResVO emmStatus, EMMWWidgetData mWData, EMMThread thread) {
        this.mContext = mContext;
        this.emmStatus = emmStatus;
        this.mWidgetData = mWData;
        this.mEMMThread = thread;
        this.downloadUpgradePkg(mContext);
    }

    private void downloadUpgradePkg(final Context context) {
        this.updateDialogUI(context, 0, null);
        final String url = this.emmStatus.newAppUrl;
        final EMMUpgradeUtils.UpdateVO updateVO = EMMUpgradeUtils.getUpdateVO(this.mContext, this.emmStatus.pkgType, this.emmStatus.newAppUrl);
        this.mTotalSize = updateVO.totalSize;
        this.downLoaderSize = updateVO.downloaded;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String cookie;
                    if (!Environment.getExternalStorageState().equals("mounted")) {
                        AppUpgradeDialog.this.mProgressHandler.sendMessage(AppUpgradeDialog.this.mProgressHandler.obtainMessage(-2, (Object)EUExUtil.getString((String)"plugin_uexemm_no_sd_card")));
                        return;
                    }
                    AppUpgradeDialog.this.mHttpConnection = EMMHttpURLConnection.getHttpURLConnection(context, url, 40000, false);
                    AppUpgradeDialog.this.mHttpConnection.setRequestMethod("GET");
                    AppUpgradeDialog.this.mHttpConnection.addRequestProperty("Connection", "Keep-Alive");
                    AppUpgradeDialog.this.mHttpConnection.addRequestProperty("Charset", "utf-8");
                    AppUpgradeDialog.this.mHttpConnection.addRequestProperty("User-Agent", FROYO_USERAGENT);
                    AppUpgradeDialog.this.mHttpConnection;
                    HttpURLConnection.setFollowRedirects(true);
                    if (AppUpgradeDialog.this.downLoaderSize != 0) {
                        AppUpgradeDialog.this.mHttpConnection.addRequestProperty("RANGE", "bytes=" + AppUpgradeDialog.this.downLoaderSize + "-");
                    }
                    if (null != (cookie = AppUpgradeDialog.this.getCookie(url))) {
                        AppUpgradeDialog.this.mHttpConnection.setRequestProperty("Cookie", cookie);
                    }
                    LogUtils.logDebug("requestUrl: " + url);
                    AppUpgradeDialog.this.mHttpConnection.connect();
                    int responseCode = AppUpgradeDialog.this.mHttpConnection.getResponseCode();
                    LogUtils.logDebug("responseCode: " + responseCode);
                    if (responseCode >= 200 && responseCode < 300) {
                        String header = "";
                        if (206 == responseCode) {
                            header = AppUpgradeDialog.this.mHttpConnection.getHeaderField("Content-Range");
                        }
                        if (TextUtils.isEmpty((CharSequence)header)) {
                            AppUpgradeDialog.this.downLoaderSize = 0;
                            LogUtils.logDebugO("Server doesn't support Resuming Broken Transfer!");
                        } else {
                            LogUtils.logDebugO("Content-Range = " + header);
                        }
                        AppUpgradeDialog.this.saveToFile(context, AppUpgradeDialog.this.mHttpConnection, url, updateVO);
                    } else {
                        AppUpgradeDialog.this.mProgressHandler.sendMessage(AppUpgradeDialog.this.mProgressHandler.obtainMessage(-4, (Object)EUExUtil.getString((String)"plugin_uexemm_connect_error")));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AppUpgradeDialog.this.mProgressHandler.sendMessage(AppUpgradeDialog.this.mProgressHandler.obtainMessage(-4, (Object)EUExUtil.getString((String)"plugin_uexemm_download_error")));
                }
                finally {
                    String tempFile = "";
                    if (AppUpgradeDialog.this.mTmpFile != null) {
                        tempFile = AppUpgradeDialog.this.mTmpFile.getAbsolutePath();
                    }
                    EMMUpgradeUtils.updateUpdateVO(AppUpgradeDialog.this.mContext, tempFile, ((AppUpgradeDialog)AppUpgradeDialog.this).emmStatus.pkgType, url, AppUpgradeDialog.this.mTotalSize, AppUpgradeDialog.this.downLoaderSize);
                    AppUpgradeDialog.this.downLoaderSize = 0;
                }
            }
        }.start();
    }

    private String getCookie(String inUrl) {
        return CookieManager.getInstance().getCookie(inUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(Context context, HttpURLConnection mHttpConnection, String url, EMMUpgradeUtils.UpdateVO updateVO) {
        LogUtils.logDebug("saveToFile");
        try {
            this.mInStream = mHttpConnection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.mInStream == null) {
            return;
        }
        long contentLength = mHttpConnection.getContentLength();
        LogUtils.logDebug("contentLength:" + contentLength + " downLoaderSize:" + this.downLoaderSize);
        this.mTotalSize = (int)contentLength + this.downLoaderSize;
        String extension = FileUtils.getFileExtension(url, "apk");
        RandomAccessFile raf = null;
        try {
            String tempFile = EMMUpgradeUtils.getUpgradeTempFileName(context);
            this.mTmpFile = TextUtils.isEmpty((CharSequence)updateVO.filePath) ? new File(tempFile + "." + extension) : new File(updateVO.filePath);
            raf = new RandomAccessFile(this.mTmpFile, "rw");
            raf.seek(this.downLoaderSize);
            byte[] buffer = new byte[3072];
            while (true) {
                int numread;
                if ((numread = this.mInStream.read(buffer)) == -1) {
                    if (this.downLoaderSize >= this.mTotalSize) break;
                    LogUtils.logError("downLoader apk error, numread == -1!");
                    this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-4, (Object)EUExUtil.getString((String)"plugin_uexemm_download_error")));
                    break;
                }
                raf.write(buffer, 0, numread);
                if (contentLength <= 0L) continue;
                this.downLoaderSize += numread;
                int p = (int)((float)this.downLoaderSize / (float)this.mTotalSize * 100.0f);
                if (p != 100) {
                    this.mProgressHandler.sendEmptyMessage(p);
                    continue;
                }
                this.sendFullProgross(extension);
            }
            LogUtils.logDebug("saveToFile done!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.mTotalSize <= 0) {
            LogUtils.logDebug("download finish --- downLoaderSise: " + this.downLoaderSize);
            this.sendFullProgross(extension);
        }
    }

    private void sendFullProgross(String extension) {
        this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(100, (Object)extension));
    }

    private void downloadDone(Context context, String extension) {
        LogUtils.logDebug("downloadDone");
        UpdateDialogUIConfig config = new UpdateDialogUIConfig();
        config.forceUpdate = Boolean.valueOf(this.emmStatus.forceUpdate);
        if ("upgrade".equalsIgnoreCase(this.emmStatus.pkgType)) {
            String mimeType = this.getMimeType(extension);
            if (!TextUtils.isEmpty((CharSequence)mimeType)) {
                config.mimetype = mimeType;
            }
            this.updateDialogUI(context, 1, config);
            Intent installIntent = new Intent("android.intent.action.VIEW");
            String filename = this.mTmpFile.getAbsolutePath();
            Uri path = Uri.parse((String)filename);
            if (path.getScheme() == null) {
                path = Uri.fromFile((File)new File(filename));
            }
            installIntent.setDataAndType(path, config.mimetype);
            installIntent.setFlags(0x10000000);
            try {
                this.getContext().startActivity(installIntent);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mProgressHandler.sendMessage(this.mProgressHandler.obtainMessage(-4, (Object)EUExUtil.getString((String)"plugin_uexemm_not_found_app")));
            }
        }
    }

    private void stopDownload() {
        LogUtils.logDebug("stopDownload");
        try {
            if (null != this.mHttpConnection) {
                this.mHttpConnection.disconnect();
                this.mHttpConnection = null;
            }
            if (null != this.mInStream) {
                this.mInStream.close();
                this.mInStream = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDialogUI(final Context context, int updateStatus, final UpdateDialogUIConfig config) {
        switch (updateStatus) {
            case 0: {
                this.mProgressBarHandler.downloadNewAppBegin(this.mAppUpgradeDialogViewVO);
                break;
            }
            case 1: {
                String leftBtnText = config.forceUpdate ? EUExUtil.getString((String)"plugin_uexemm_exit_app") : EUExUtil.getString((String)"plugin_uexemm_upgrade_later");
                this.mProgressBarHandler.downloadNewAppFinish(context, this.mAppUpgradeDialogViewVO, EUExUtil.getString((String)"plugin_uexemm_download_completed"), new View.OnClickListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClick(View v) {
                        if (config != null) {
                            AppUpgradeDialog.this.dismiss();
                            EMMThread eMMThread = AppUpgradeDialog.this.mEMMThread;
                            synchronized (eMMThread) {
                                AppUpgradeDialog.this.mEMMThread.notify();
                            }
                            if (config.forceUpdate) {
                                AppUpgradeDialog.this.mEMMThread.killMyPid();
                            }
                        }
                    }
                }, leftBtnText, new View.OnClickListener(){

                    public void onClick(View v) {
                        if (config != null) {
                            AppUpgradeDialog.this.downloadDone(context, FileUtils.getFileExtension(AppUpgradeDialog.this.mTmpFile.getAbsolutePath(), "apk"));
                        }
                    }
                }, EUExUtil.getString((String)"plugin_uexemm_install_upgrade"));
                break;
            }
            case 2: {
                String msg = config != null ? config.msg : EUExUtil.getString((String)"plugin_uexemm_download_fail");
                String leftBtnText = config.forceUpdate ? EUExUtil.getString((String)"plugin_uexemm_exit_app") : EUExUtil.getString((String)"plugin_uexemm_upgrade_later");
                this.mProgressBarHandler.downloadNewAppFinish(context, this.mAppUpgradeDialogViewVO, msg, new View.OnClickListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onClick(View v) {
                        if (config != null) {
                            AppUpgradeDialog.this.dismiss();
                            EMMThread eMMThread = AppUpgradeDialog.this.mEMMThread;
                            synchronized (eMMThread) {
                                AppUpgradeDialog.this.mEMMThread.notify();
                            }
                            if (config.forceUpdate) {
                                AppUpgradeDialog.this.mEMMThread.killMyPid();
                            }
                        }
                    }
                }, leftBtnText, new View.OnClickListener(){

                    public void onClick(View v) {
                        if (config != null) {
                            if ("upgrade".equals(config.pkgType)) {
                                AppUpgradeDialog.this.downloadUpgradePkg(context);
                            } else if ("patch".equals(config.pkgType)) {
                                AppUpgradeDialog.this.downloadPatchPkg();
                            }
                        }
                    }
                }, EUExUtil.getString((String)"plugin_uexemm_download_again"));
                break;
            }
        }
    }

    public void downloadPatchPkg(Context mContext, EMMStartReportResVO emmStatus, EMMWWidgetData mWData, EMMThread thread, AppUpgradeDialog appUpgradeDialog) {
        this.mContext = mContext;
        this.emmStatus = emmStatus;
        this.mWidgetData = mWData;
        this.mEMMThread = thread;
        mAppUpgradeDialog = appUpgradeDialog;
        this.downloadPatchPkg();
    }

    private void downloadPatchPkg() {
        if (netAsyncTask != null) {
            netAsyncTask.cancel(true);
            netAsyncTask = null;
        }
        EMMUpgradeUtils.UpdateVO updateVO = EMMUpgradeUtils.getUpdateVO(this.mContext, this.emmStatus.pkgType, this.emmStatus.newAppUrl);
        this.updateDialogUI(this.mContext, 0, null);
        netAsyncTask = new WidgetPatchDownloadTask(this.mContext, this.emmStatus, this.mEMMThread, mAppUpgradeDialog, this.mWidgetData);
        if (!updateVO.isContinue) {
            netAsyncTask.execute(new Object[]{this.emmStatus.newAppUrl});
        } else {
            netAsyncTask.execute(new Object[]{this.emmStatus.newAppUrl, updateVO.downloaded, updateVO.totalSize});
        }
    }

    public static class UpdateDialogUIConfig {
        public String mimetype;
        public boolean forceUpdate;
        public String msg;
        public String pkgType;
    }
}

