/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import java.util.LinkedList;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar.RoundBaseProgressBar;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.GradualArcVO;

public class CircleGradualProgressBar
extends RoundBaseProgressBar {
    private float progressOuterRadius = 0.0f;
    private LinkedList<GradualArcVO> mGradualArcVOs = null;
    private String[] colors = new String[]{"#FF38A7EA", "#FF49B4EE", "#FF55BBEE", "#FF55BDEE", "#FF54C3FF"};

    public CircleGradualProgressBar(Context context) {
        super(context, null);
    }

    public CircleGradualProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.postInvalidate();
    }

    @Override
    protected void drawProgressText(Canvas canvas, Paint paint, float centre, float radius, int percent, float textSize, int textColor) {
        paint.setStrokeWidth(0.0f);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(textColor);
        paint.setShadowLayer(1.0f, 1.0f, 1.0f, textColor);
        paint.setTextSize(textSize);
        float textWidth = paint.measureText(percent + "%");
        float textHight = this.getTexthight(paint);
        canvas.drawText(percent + "%", centre - textWidth / 2.0f, centre + textHight / 2.0f - 15.0f, paint);
        paint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
    }

    private float getTexthight(Paint paint) {
        Paint.FontMetrics fm = paint.getFontMetrics();
        return (float)Math.ceil(fm.descent - fm.ascent);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null == this.mGradualArcVOs) {
            this.progressWidth = this.centre / 7.0f;
            this.progressOuterRadius = this.centre * 0.62f;
            this.progressRadius = this.progressOuterRadius - this.progressWidth / 2.0f;
            this.mGradualArcVOs = this.getGradualArcVOs(this.centre, this.progressOuterRadius, this.progressRadius);
        }
        if (this.textIsDisplayable && this.style == 0) {
            this.drawProgressText(canvas, this.paint, this.centre, this.radius, (int)((float)this.progress / (float)this.maxValue * 100.0f), this.textSize, this.textColor);
        }
        double sweepAngle = 360 * this.progress / this.maxValue;
        this.drawSymmetryGradualArc(canvas, this.paint, this.style, this.startAngle.floatValue(), (float)sweepAngle, this.progress);
    }

    private GradualArcVO getGradualArcVO(float centre, float radius, int color, float shadowWidth) {
        RectF mRectF = new RectF(centre - radius, centre - radius, centre + radius - 1.5f, centre + radius - 1.5f);
        return new GradualArcVO(mRectF, color, shadowWidth);
    }

    private LinkedList<GradualArcVO> getGradualArcVOs(float centre, float progressOuterShadowRadius, float progressRadius) {
        LinkedList<GradualArcVO> gradualArcVOs = new LinkedList<GradualArcVO>();
        float shadowWidth = 2.0f;
        float radius = progressOuterShadowRadius;
        for (int i = 0; i < 4; ++i) {
            gradualArcVOs.add(this.getGradualArcVO(centre, radius -= shadowWidth, Color.parseColor((String)this.colors[i]), shadowWidth));
        }
        float centWidth = (radius - progressRadius) * 2.0f;
        gradualArcVOs.add(this.getGradualArcVO(centre, progressRadius, Color.parseColor((String)this.colors[4]), centWidth + 2.0f));
        radius -= centWidth;
        for (int i = 3; i >= 0; --i) {
            gradualArcVOs.add(this.getGradualArcVO(centre, radius -= shadowWidth, Color.parseColor((String)this.colors[i]), shadowWidth));
        }
        return gradualArcVOs;
    }

    private void drawSymmetryGradualArc(Canvas canvas, Paint paint, int style, float startAngle, float sweepAngle, int progress) {
        for (GradualArcVO gradualArcVO : this.mGradualArcVOs) {
            this.drawArc(canvas, paint, style, gradualArcVO.color, gradualArcVO.arcWidth, startAngle, sweepAngle, gradualArcVO.mRectF, progress);
        }
    }
}

