/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.encryption;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;

public class SignatureUtils {
    private static final String DEFAULT_SIGN_MD5 = "D382D671C6672CBA4B87980992CD9D77";

    public static boolean isSignatureCorrect(Context context) {
        return DEFAULT_SIGN_MD5.equalsIgnoreCase(SignatureUtils.getCurrentAppSignMD5(context));
    }

    private static String getCurrentAppSignMD5(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] signs = packageInfo.signatures;
            Signature sign = signs[0];
            String md5 = SignatureUtils.getMD5Code(sign.toByteArray());
            md5 = md5.toUpperCase();
            return md5;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCurrentAppIdentifier(Context context) {
        String signMD5 = SignatureUtils.getCurrentAppSignMD5(context);
        String packageName = context.getPackageName();
        LogUtils.logDebugO("Cur Sign MD5:" + signMD5);
        LogUtils.logDebugO("Cur Pkg:" + packageName);
        String identifierStr = signMD5 + packageName;
        String appIdentifier = SignatureUtils.getMD5Code(identifierStr.getBytes());
        return appIdentifier;
    }

    private static String getMD5Code(byte[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(value);
            byte[] md5Bytes = md.digest();
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < md5Bytes.length; ++i) {
                int val = md5Bytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

