/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.http;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.http.Http;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequestHeadVO;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequrstInputVO;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequrstResultVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.InputStreamUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LanguageUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SafetyVerify;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppCanCertVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class EMMHttpURLConnection {
    private static boolean mIsCertificate = false;
    private static String mPassWord = null;
    private static String mPath = null;
    private static List<HttpURLConnection> httpURLConnections = new ArrayList<HttpURLConnection>();
    private static AppCanCertVO mCertInfo = null;

    private static void writeFormByUriEncode(PrintWriter writer, JSONObject json) {
        Iterator it = json.keys();
        String key = "";
        String value = "";
        StringBuffer sbBuffer = new StringBuffer();
        while (it.hasNext()) {
            key = (String)it.next();
            value = json.optString(key);
            if (TextUtils.isEmpty((CharSequence)value)) {
                value = "default";
            }
            sbBuffer.append(EMMHttpURLConnection.uriEncode(key, "")).append("=").append(EMMHttpURLConnection.uriEncode(value, "")).append("&");
        }
        int strLen = sbBuffer.length();
        if (strLen >= 1) {
            sbBuffer.deleteCharAt(strLen - 1);
        }
        writer.append(sbBuffer.toString());
        writer.flush();
        writer.close();
    }

    private static void addHttpURLConnectionHeader(Context context, EMMWWidgetData wData, HttpURLConnection httpConnection, String url, String contentType, String userAgent, HttpRequestHeadVO headVO) {
        String cookie;
        httpConnection.addRequestProperty("Accept", "*/*");
        httpConnection.addRequestProperty("Accept-Language", LanguageUtils.getLanguage(context) + ";" + "q=" + 1.0f);
        if (!TextUtils.isEmpty((CharSequence)userAgent)) {
            httpConnection.addRequestProperty("User-Agent", userAgent);
        }
        if (wData != null) {
            httpConnection.setRequestProperty("channel", wData.m_channelCode);
            httpConnection.setRequestProperty("varifyApp", SafetyVerify.getAppVerifyCode(wData));
            httpConnection.setRequestProperty("appverify", SafetyVerify.getAppVerifyCode(wData));
            httpConnection.setRequestProperty("x-mas-app-id", wData.m_appId);
        }
        if (!TextUtils.isEmpty((CharSequence)(cookie = EMMHttpURLConnection.getCookie(url)))) {
            httpConnection.setRequestProperty("Cookie", cookie);
        }
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            httpConnection.setRequestProperty("Content-Type", contentType);
        }
        if (headVO != null) {
            if (!TextUtils.isEmpty((CharSequence)headVO.jwtkey)) {
                httpConnection.setRequestProperty("jwtKey", headVO.jwtkey);
            }
            if (!TextUtils.isEmpty((CharSequence)headVO.userId)) {
                httpConnection.setRequestProperty("userId", headVO.userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setHttpRequestConfig(Context context, EMMWWidgetData wData, String url, HttpURLConnection httpConnection, HttpRequrstInputVO inputVO, String requestMethod, String userAgent, HttpRequestHeadVO headVO) {
        String contentType = inputVO.getContentType();
        EMMHttpURLConnection.addHttpURLConnectionHeader(context, wData, httpConnection, url, contentType, userAgent, headVO);
        String data = "";
        LogUtils.logDebugO("httpRequest header:" + httpConnection.getRequestProperties().toString());
        OutputStream outputStream = null;
        PrintWriter writer = null;
        try {
            httpConnection.setInstanceFollowRedirects(true);
            httpConnection.setRequestMethod(requestMethod);
            httpConnection.connect();
            if (inputVO.getDataJson() != null || !TextUtils.isEmpty((CharSequence)inputVO.getDataStr())) {
                outputStream = httpConnection.getOutputStream();
                if ("application/x-www-form-urlencoded".equals(contentType)) {
                    writer = new PrintWriter(new OutputStreamWriter(outputStream, "utf-8"));
                    JSONObject dataJson = inputVO.getDataJson();
                    if (dataJson != null) {
                        EMMHttpURLConnection.writeFormByUriEncode(writer, inputVO.getDataJson());
                        data = dataJson.toString();
                    }
                } else {
                    data = inputVO.getDataStr();
                    if (!TextUtils.isEmpty((CharSequence)data)) {
                        byte[] buffer = data.getBytes();
                        outputStream.write(buffer, 0, buffer.length);
                        outputStream.flush();
                    }
                }
            }
            LogUtils.logDebugO("httpRequest data:" + data);
        }
        catch (Exception e) {
            LogUtils.oe("sendHttpRequest:" + url + ":", e);
            e.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outputStream = null;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    public static HttpRequrstResultVO sendPostRequestByStream(Context mCtx, EMMWWidgetData wData, String url, String data) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("application/octet-stream", data, null), "POST", null, false, null);
    }

    public static HttpRequrstResultVO sendPostRequestByFrom(Context mCtx, EMMWWidgetData wData, String url, JSONObject jsonData, boolean isCaAuth) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("application/x-www-form-urlencoded", "", jsonData), "POST", null, isCaAuth, null);
    }

    public static HttpRequrstResultVO sendPostRequestByFrom(Context mCtx, EMMWWidgetData wData, String url, JSONObject jsonData, boolean isCaAuth, HttpRequestHeadVO headVO) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("application/x-www-form-urlencoded", "", jsonData), "POST", null, isCaAuth, headVO);
    }

    public static HttpRequrstResultVO sendGetRequest(Context mCtx, EMMWWidgetData wData, String url) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("", "", null), "GET", null, false, null);
    }

    public static HttpRequrstResultVO sendGetRequest(Context mCtx, EMMWWidgetData wData, String url, String userAgent) {
        return EMMHttpURLConnection.sendHttpRequest(mCtx, wData, url, new HttpRequrstInputVO("", "", null), "GET", userAgent, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpRequrstResultVO sendHttpRequest(Context mCtx, EMMWWidgetData wData, String url, HttpRequrstInputVO inputVO, String requestMethod, String userAgent, boolean isCaAuth, HttpRequestHeadVO headVO) {
        LogUtils.logDebugO("sendHttpRequest url:" + url);
        HttpURLConnection httpConnection = EMMHttpURLConnection.getHttpURLConnection(mCtx, url, 40000, isCaAuth);
        HttpRequrstResultVO result = new HttpRequrstResultVO();
        if (httpConnection != null) {
            String responseRes = "";
            int responseCode = -1;
            EMMHttpURLConnection.setHttpRequestConfig(mCtx, wData, url, httpConnection, inputVO, requestMethod, userAgent, headVO);
            try {
                responseCode = httpConnection.getResponseCode();
                LogUtils.logDebugO("responseCode = " + responseCode + " url:" + url);
                responseRes = InputStreamUtils.InputStreamTOString(httpConnection.getInputStream());
                LogUtils.logDebugO(" res:" + responseRes + " url:" + url);
                EMMHttpURLConnection.handleCookie(mCtx, url, httpConnection.getHeaderFields());
            }
            catch (Exception e) {
                LogUtils.oe("sendHttpRequest:" + url + ":", e);
                e.printStackTrace();
            }
            finally {
                result.setResult(responseRes);
                result.setResponseCode(responseCode);
                try {
                    httpConnection.disconnect();
                    httpConnection = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            LogUtils.logError("sendHttpRequest get HttpRequrstResult error\uff1a" + url);
        }
        return result;
    }

    public static boolean getNetworkFile(Context mCtx, EMMWWidgetData wData, String url, String requestMethod, File file) {
        return EMMHttpURLConnection.downLoadFile(mCtx, wData, url, new HttpRequrstInputVO("", "", null), requestMethod, file);
    }

    public static boolean getNetworkFile(Context mCtx, EMMWWidgetData wData, String url, JSONObject jsonData, String contentType, String requestMethod, File file) {
        return EMMHttpURLConnection.downLoadFile(mCtx, wData, url, new HttpRequrstInputVO(contentType, "", jsonData), requestMethod, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean downLoadFile(Context mCtx, EMMWWidgetData wData, String url, HttpRequrstInputVO inputVO, String requestMethod, File file) {
        LogUtils.logDebugO("getGetFileData url:" + url);
        boolean isSuccess = false;
        HttpURLConnection httpConnection = EMMHttpURLConnection.getHttpURLConnection(mCtx, url, 40000, false);
        EMMHttpURLConnection.setHttpRequestConfig(mCtx, wData, url, httpConnection, inputVO, requestMethod, null, null);
        InputStream in = null;
        try {
            int responseCode = httpConnection.getResponseCode();
            LogUtils.logDebugO("responseCode = " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                in = httpConnection.getInputStream();
                isSuccess = EMMHttpURLConnection.saveInputStreamToFile(in, file);
            }
            EMMHttpURLConnection.handleCookie(mCtx, url, httpConnection.getHeaderFields());
        }
        catch (Exception e) {
            LogUtils.logDebugO("sendPostJsonData Exception\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                httpConnection.disconnect();
                httpConnection = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (in != null) {
                try {
                    in.close();
                    in = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveInputStreamToFile(InputStream in, File file) {
        boolean isSuccess = false;
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            int len = -1;
            long fileSize = 0L;
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                fileSize += (long)len;
                ((OutputStream)os).write(buffer, 0, len);
            }
            os.flush();
            if (fileSize > 0L) {
                isSuccess = true;
            } else {
                LogUtils.logDebugO("getGetFileData fileSize=" + fileSize);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    private static void handleCookie(Context context, String url, Map<String, List<String>> headers) {
        if (headers != null) {
            List<String> list;
            List<String> list2;
            List<String> setCookies2;
            List<String> setCookies = headers.get("Set-Cookie");
            if (null != setCookies) {
                for (String string : setCookies) {
                    EMMHttpURLConnection.setCookie(url, string);
                }
            }
            if (null != (setCookies2 = headers.get("Set-Cookie2"))) {
                for (String string : setCookies2) {
                    EMMHttpURLConnection.setCookie(url, string);
                }
            }
            if (null != (list2 = headers.get("Cookie"))) {
                for (String v : list2) {
                    EMMHttpURLConnection.setCookie(url, v);
                }
            }
            if (null != (list = headers.get("Cookie2"))) {
                for (String v : list) {
                    EMMHttpURLConnection.setCookie(url, v);
                }
            }
        }
    }

    private static final void setCookie(String inUrl, String cookie) {
        EMMAgent.getInstance().getEUExEMMInstance().setCookie(inUrl, cookie);
    }

    private static final String getCookie(String inUrl) {
        return EMMAgent.getInstance().getEUExEMMInstance().getCookie(inUrl);
    }

    public static void setCertificate(boolean isCertificate, String cPath, String cPassWord) {
        mIsCertificate = isCertificate;
        mPassWord = cPassWord;
        mPath = cPath;
    }

    public static void setAppCanCertificate(AppCanCertVO info) {
        mCertInfo = info;
    }

    public static void close() {
        try {
            for (HttpURLConnection connection : httpURLConnections) {
                if (connection == null) continue;
                connection.disconnect();
                Object var1_2 = null;
            }
            httpURLConnections.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HttpURLConnection getHttpURLConnection(Context mCtx, String urlStr, int timeout, boolean isCaAuth) {
        URLConnection httpConnection = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)urlStr)) {
                URL url = new URL(EMMHttpURLConnection.uriEncode(urlStr, "/?:=&#@+$%"));
                if (urlStr.startsWith("http://")) {
                    httpConnection = (HttpURLConnection)url.openConnection();
                } else if (!isCaAuth) {
                    httpConnection = mIsCertificate ? Http.getHttpsURLConnectionWithCert(url, mPassWord, mPath, mCtx) : Http.getHttpsURLConnection(url);
                } else if (mCertInfo != null) {
                    httpConnection = Http.getHttpsURLConnectionWithCert(url, EMMHttpURLConnection.mCertInfo.certPwd, EMMHttpURLConnection.mCertInfo.certPath, mCtx);
                } else {
                    LogUtils.logError("mCertInfo is null");
                }
            } else {
                LogUtils.logError("getHttpConnection url is null!");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (httpConnection != null) {
            httpConnection.setReadTimeout(timeout);
            httpConnection.setConnectTimeout(timeout);
        }
        httpURLConnections.add((HttpURLConnection)httpConnection);
        return httpConnection;
    }

    private static String uriEncode(String url, String allow) {
        return Uri.encode((String)url, (String)allow);
    }
}

