/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.analytics;

import android.content.Context;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.Event;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SystemTime;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class AnalyticsUtility {
    private static StringBuilder reportDataBuilder = new StringBuilder();

    public static String getMapToString(Map inAttriDict) {
        String attriDict = "";
        if (inAttriDict != null) {
            for (Object object : inAttriDict.keySet()) {
                if ("".equals(attriDict)) {
                    attriDict = object + ":" + inAttriDict.get(object);
                    continue;
                }
                attriDict = attriDict + "," + object + ":" + inAttriDict.get(object);
            }
        }
        return attriDict;
    }

    public static String getReportData(Context m_activity, String appId) {
        String spName = TextUtils.isEmpty((CharSequence)appId) ? "app" : "saveData" + appId;
        String data = SharedPrefUtils.getString(m_activity, spName, "reportData", "");
        SharedPrefUtils.putString(m_activity, spName, "reportData", "");
        return data;
    }

    public static void setReportTime(Context m_activity, String appId) {
        String spName = TextUtils.isEmpty((CharSequence)appId) ? "app" : "saveData" + appId;
        SharedPrefUtils.putString(m_activity, spName, "reportTime", SystemTime.getNowTime());
    }

    public static String getReportTime(Context m_activity, String appId) {
        String spName = TextUtils.isEmpty((CharSequence)appId) ? "app" : "saveData" + appId;
        return SharedPrefUtils.getString(m_activity, spName, "reportTime", null);
    }

    public static void saveReportData(Context m_activity, String appId, String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return;
        }
        String spName = TextUtils.isEmpty((CharSequence)appId) ? "app" : "saveData" + appId;
        String oldData = SharedPrefUtils.getString(m_activity, spName, "reportData", "");
        reportDataBuilder.delete(0, reportDataBuilder.length());
        reportDataBuilder.append(oldData);
        reportDataBuilder.append(data);
        LogUtils.logDebug("oldData + data == " + reportDataBuilder.toString());
        SharedPrefUtils.putString(m_activity, spName, "reportData", reportDataBuilder.toString());
        reportDataBuilder.delete(0, reportDataBuilder.length());
    }

    public static String saveReportData(Context m_activity, String appId, String data, String res) {
        String status = null;
        if (res != null && res.length() > 0) {
            try {
                JSONObject json = new JSONObject(res);
                status = json.getString("status");
                if (!"success".equals(status)) {
                    AnalyticsUtility.saveReportData(m_activity, appId, data);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                AnalyticsUtility.saveReportData(m_activity, appId, data);
            }
        } else {
            AnalyticsUtility.saveReportData(m_activity, appId, data);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String collectReportData(EMMWWidgetData mCurWData) {
        StringBuilder stringBuilder = new StringBuilder();
        int wgtType = mCurWData.m_wgtType;
        ArrayList<String> m_showViewList = AnalyticsAgent.sShowViewListMap.get(mCurWData.m_appId);
        HashMap<String, Event> m_eventMap = AnalyticsThread.sEventMap.get(mCurWData.m_appId);
        if (m_showViewList != null) {
            ArrayList<String> arrayList = m_showViewList;
            synchronized (arrayList) {
                if (m_showViewList.size() != 0) {
                    for (String val : m_showViewList) {
                        stringBuilder.append(val);
                        stringBuilder.append("\r");
                    }
                    m_showViewList.clear();
                }
            }
        }
        if (wgtType == 0) {
            try {
                block13: for (int i = 0; i < AnalyticsAgent.endViewList.size(); ++i) {
                    String[] endString = AnalyticsAgent.endViewList.get(i);
                    try {
                        for (int j = 0; j < AnalyticsAgent.startViewList.size(); ++j) {
                            String[] startString = AnalyticsAgent.startViewList.get(j);
                            if (!endString[0].equals(startString[1])) continue;
                            AnalyticsAgent.startViewList.remove(j);
                            AnalyticsAgent.endViewList.remove(i);
                            stringBuilder.append(0);
                            stringBuilder.append(";");
                            stringBuilder.append(startString[0]);
                            stringBuilder.append(";");
                            stringBuilder.append(startString[1]);
                            stringBuilder.append(";");
                            stringBuilder.append(startString[2]);
                            stringBuilder.append(";");
                            stringBuilder.append(endString[2]);
                            stringBuilder.append(";");
                            stringBuilder.append(startString[3]);
                            stringBuilder.append(";");
                            stringBuilder.append(endString[1]);
                            stringBuilder.append(";");
                            stringBuilder.append(startString[4]);
                            stringBuilder.append("\r");
                            continue block13;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        LogUtils.oe("cyclic startViewList \uff1a", e);
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                LogUtils.oe("cyclic endViewList \uff1a", e);
                e.printStackTrace();
            }
        }
        if (m_eventMap != null) {
            HashMap<String, Event> e = m_eventMap;
            synchronized (e) {
                Iterator<String> iterator = m_eventMap.keySet().iterator();
                try {
                    while (iterator.hasNext()) {
                        String name = iterator.next();
                        Event event = m_eventMap.get(name);
                        stringBuilder.append(event.m_type);
                        stringBuilder.append(";");
                        stringBuilder.append(name.split(";")[0]);
                        stringBuilder.append(";");
                        stringBuilder.append(event.m_clickNum);
                        stringBuilder.append(";");
                        stringBuilder.append(event.m_totalTime);
                        if (event.m_dict != null && event.m_dict.length() > 0) {
                            stringBuilder.append(";[");
                            stringBuilder.append(event.m_dict);
                            stringBuilder.append("]");
                        }
                        stringBuilder.append("\r");
                    }
                }
                catch (Exception e2) {
                    LogUtils.oe("cyclic iterator \uff1a", e2);
                    e2.printStackTrace();
                }
                m_eventMap.clear();
            }
        }
        String saveString = stringBuilder.toString();
        return saveString;
    }
}

