/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.analytics;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Process;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import java.util.Date;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsUtility;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMURLMgr;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMTokenUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.IPLocation;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SystemTime;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class SubWidgetAnalyticsThread
extends Thread {
    private boolean isRun = true;
    public static int INTERVAL_TIME = 5000;
    private boolean isRunning = true;
    private boolean strategyStartReport = false;
    public Context ctx = null;
    private int mStrategy;
    private EMMWWidgetData mCurWData;
    private BroadcastReceiver mReceiver;
    public static boolean dialogStatus = true;
    public static boolean dialogShow = false;

    private SubWidgetAnalyticsThread() {
    }

    public SubWidgetAnalyticsThread(final EMMWWidgetData data, Context context, int strategy) {
        super("AppCan-SubWidgetAnalyticsThread");
        this.mCurWData = data;
        this.ctx = context;
        this.mStrategy = strategy;
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent == null) {
                    return;
                }
                if (context.getPackageName().equals(intent.getPackage())) {
                    try {
                        String appId = intent.getStringExtra("appId");
                        String type = intent.getStringExtra("type");
                        LogUtils.logDebug("SubWidgetAnalyticsThread OnReceive: " + appId + " " + type);
                        if (intent != null && data.m_appId.equals(appId)) {
                            if ("updateCancelled".equals(type)) {
                                // empty if block
                            }
                            if ("doUpdateWithConfirm".equals(type)) {
                                SubWidgetAnalyticsThread.this.stopSelf();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (SubWidgetAnalyticsThread.this.mReceiver != null) {
                        LocalBroadcastManager.getInstance((Context)SubWidgetAnalyticsThread.this.ctx).unregisterReceiver(SubWidgetAnalyticsThread.this.mReceiver);
                        SubWidgetAnalyticsThread.this.mReceiver = null;
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("org.zywx.emm.widgetupdate.event.ack.action");
        LocalBroadcastManager.getInstance((Context)this.ctx).registerReceiver(this.mReceiver, filter);
    }

    public void stopSelf() {
        if (this.mReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this.ctx).unregisterReceiver(this.mReceiver);
            this.mReceiver = null;
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        ((Activity)this.ctx).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                IPLocation.getIPLocation(SubWidgetAnalyticsThread.this.ctx, ((SubWidgetAnalyticsThread)SubWidgetAnalyticsThread.this).mCurWData.m_appId);
            }
        });
        do {
            Object time;
            switch (this.mStrategy) {
                case 2: {
                    Object status;
                    LogUtils.logDebug("REPORT_STRATEGY_DAILY");
                    time = AnalyticsUtility.getReportTime(this.ctx, this.mCurWData.m_appId);
                    String res = null;
                    String reportData = AnalyticsUtility.collectReportData(this.mCurWData) + AnalyticsUtility.getReportData(this.ctx, this.mCurWData.m_appId);
                    if (reportData == null || reportData.length() == 0) {
                        try {
                            SubWidgetAnalyticsThread subWidgetAnalyticsThread = this;
                            synchronized (subWidgetAnalyticsThread) {
                                this.wait(INTERVAL_TIME);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    if (time == null) {
                        res = EMMHttpURLConnection.sendPostRequestByStream(this.ctx, this.mCurWData, EMMURLMgr.getUrlEventReport() + EMMTokenUtils.getSoftToken(this.ctx, this.mCurWData), reportData).getResult();
                        String statue = AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, reportData, res);
                        if (!"success".equals(statue)) break;
                        AnalyticsUtility.setReportTime(this.ctx, this.mCurWData.m_appId);
                        break;
                    }
                    Object newTime = SystemTime.getNowTime();
                    Date oldDate = new Date((String)time);
                    Date newDate = new Date((String)newTime);
                    if (newDate.getTime() - oldDate.getTime() > 86400000L) {
                        res = EMMHttpURLConnection.sendPostRequestByStream(this.ctx, this.mCurWData, EMMURLMgr.getUrlEventReport() + EMMTokenUtils.getSoftToken(this.ctx, this.mCurWData), reportData).getResult();
                        status = AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, reportData, res);
                        if ("success".equals(status)) {
                            AnalyticsUtility.setReportTime(this.ctx, this.mCurWData.m_appId);
                        }
                    } else {
                        AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, AnalyticsUtility.collectReportData(this.mCurWData));
                    }
                    LogUtils.logDebug("REPORT_STRATEGY_DAILY res == " + res);
                    try {
                        status = this;
                        synchronized (status) {
                            this.wait(INTERVAL_TIME);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    SubWidgetAnalyticsThread e7;
                    Object newTime;
                    LogUtils.logDebug("REPORT_STRATEGY_REALTIME");
                    String reportData = AnalyticsUtility.collectReportData(this.mCurWData) + AnalyticsUtility.getReportData(this.ctx, this.mCurWData.m_appId);
                    if (reportData == null || reportData.length() == 0) {
                        try {
                            newTime = this;
                            synchronized (newTime) {
                                this.wait(INTERVAL_TIME);
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        break;
                    }
                    String res = EMMHttpURLConnection.sendPostRequestByStream(this.ctx, this.mCurWData, EMMURLMgr.getUrlEventReport() + EMMTokenUtils.getSoftToken(this.ctx, this.mCurWData), reportData).getResult();
                    AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, reportData, res);
                    LogUtils.logDebug("REPORT_STRATEGY_REALTIME res == " + res);
                    try {
                        e7 = this;
                        synchronized (e7) {
                            this.wait(INTERVAL_TIME);
                        }
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                    break;
                }
                case 0: {
                    SubWidgetAnalyticsThread e7;
                    String reportData;
                    String res;
                    if (!this.strategyStartReport) {
                        LogUtils.logDebug("subWidgetReportThread REPORT_STRATEGY_START");
                        reportData = AnalyticsUtility.getReportData(this.ctx, this.mCurWData.m_appId);
                        if (TextUtils.isEmpty((CharSequence)reportData)) {
                            try {
                                e7 = this;
                                synchronized (e7) {
                                    this.wait(INTERVAL_TIME);
                                }
                            }
                            catch (Exception e4) {
                                e4.printStackTrace();
                            }
                        } else {
                            res = EMMHttpURLConnection.sendPostRequestByStream(this.ctx, this.mCurWData, EMMURLMgr.getUrlEventReport() + EMMTokenUtils.getSoftToken(this.ctx, this.mCurWData), reportData).getResult();
                            AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, reportData, res);
                        }
                        this.strategyStartReport = true;
                    } else {
                        AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, AnalyticsUtility.collectReportData(this.mCurWData), null);
                    }
                    try {
                        e7 = this;
                        synchronized (e7) {
                            this.wait(INTERVAL_TIME);
                        }
                    }
                    catch (Exception e5) {
                        e5.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    SubWidgetAnalyticsThread e7;
                    String reportData;
                    String res;
                    LogUtils.logDebug("subWidgetReportThread REPORT_STRATEGY_WIFI");
                    if ("WIFI".equals(NetworkUtils.getNetName(this.ctx))) {
                        reportData = AnalyticsUtility.collectReportData(this.mCurWData) + AnalyticsUtility.getReportData(this.ctx, this.mCurWData.m_appId);
                        if (TextUtils.isEmpty((CharSequence)reportData)) {
                            try {
                                e7 = this;
                                synchronized (e7) {
                                    this.wait(INTERVAL_TIME);
                                }
                            }
                            catch (Exception e6) {
                                e6.printStackTrace();
                            }
                            break;
                        }
                        res = EMMHttpURLConnection.sendPostRequestByStream(this.ctx, this.mCurWData, EMMURLMgr.getUrlEventReport() + EMMTokenUtils.getSoftToken(this.ctx, this.mCurWData), reportData).getResult();
                        AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, reportData, res);
                        LogUtils.logDebug("REPORT_STRATEGY_WIFI res == " + res);
                        break;
                    }
                    AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, AnalyticsUtility.collectReportData(this.mCurWData), null);
                    try {
                        e7 = this;
                        synchronized (e7) {
                            this.wait(INTERVAL_TIME);
                        }
                    }
                    catch (Exception e7) {
                        e7.printStackTrace();
                    }
                    break;
                }
                case -2: {
                    AnalyticsUtility.saveReportData(this.ctx, this.mCurWData.m_appId, AnalyticsUtility.collectReportData(this.mCurWData));
                    break;
                }
                default: {
                    SubWidgetAnalyticsThread e7;
                    try {
                        e7 = this;
                        synchronized (e7) {
                            this.wait(INTERVAL_TIME);
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                time = this;
                synchronized (time) {
                    this.wait(INTERVAL_TIME);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (this.isRun && this.isRunning);
    }
}

