/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.utils.DeviceInfo;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class EMMTokenUtils {
    public static String getSoftToken(Context activity, EMMWWidgetData wData) {
        String softToken = "";
        if (0 == wData.m_wgtType && SharedPrefUtils.getBoolean(activity, "app", "isEMMSaveLegalSoftToken", false)) {
            softToken = SharedPrefUtils.getString(activity, "app", "softToken", "");
        }
        if (TextUtils.isEmpty((CharSequence)softToken)) {
            GetWidgetSoftTokenResult result = null;
            result = EMMTokenUtils.getWidgetSoftToken(activity, wData.m_appkey);
            softToken = result.softToken;
            if (0 == wData.m_wgtType) {
                EMMTokenUtils.saveSoftToken(activity, softToken, 1 == result.ret);
            }
        }
        return softToken;
    }

    private static void saveSoftToken(Context context, String softToken, boolean isLegal) {
        SharedPrefUtils.putString(context, "app", "softToken", softToken);
        SharedPrefUtils.putBoolean(context, "app", "isEMMSaveLegalSoftToken", isLegal);
    }

    private static GetWidgetSoftTokenResult getWidgetSoftToken(Context activity, String appKey) {
        GetWidgetSoftTokenResult result = new GetWidgetSoftTokenResult();
        String[] val = new String[4];
        try {
            val[0] = DeviceInfo.getMacAddress(activity);
            TelephonyManager telephonyManager = (TelephonyManager)activity.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = DeviceInfo.getCPUSerial();
            val[3] = appKey;
        }
        catch (Exception e) {
            LogUtils.oe("GetWidgetSoftTokenResult", e);
        }
        LogUtils.logDebugO("MAC add:" + val[0] + "; telephoney deviceId:" + val[1] + "; CPU serial:" + val[2] + "; appkey:" + val[3]);
        int ret = 1;
        if (TextUtils.isEmpty((CharSequence)val[0]) && TextUtils.isEmpty((CharSequence)val[1])) {
            ret = 0;
            EMMAgent.getInstance().getEUExEMMInstance().cbHandler.send2Callback(EMMUtils.getErrorCallbakMsg(0, EUExUtil.getString((String)"plugin_uexemm_get_soft_token_error_info")), 30);
        }
        result.ret = ret;
        result.softToken = MD5Encryption.getMD5Code(val);
        return result;
    }

    public static String getDeviceToken(Context context, String name) {
        String deviceToken = SharedPrefUtils.getString(context, name, "deviceToken", null);
        if (deviceToken != null) {
            return deviceToken;
        }
        String[] val = new String[3];
        try {
            val[0] = DeviceInfo.getMacAddress(context);
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            val[1] = telephonyManager.getDeviceId();
            val[2] = DeviceInfo.getCPUSerial();
        }
        catch (Exception exception) {
            // empty catch block
        }
        deviceToken = MD5Encryption.getMD5Code(val);
        SharedPrefUtils.putString(context, name, "deviceToken", deviceToken);
        return deviceToken;
    }

    public static void saveAccessToken(Context context, String appId, String accessToken) {
        if (TextUtils.isEmpty((CharSequence)accessToken)) {
            LogUtils.logDebug("saveAccessToken accessToken\u4e3a\u7a7a");
        }
        SharedPrefUtils.putString(context, "accessToken", "accessToken_" + appId, accessToken);
    }

    public static String getAccessTokenByAppId(Context context, String appId) {
        String accessToken = "";
        try {
            accessToken = SharedPrefUtils.getString(context, "accessToken", "accessToken_" + appId);
            LogUtils.logDebugO("getAccessTokenByAppId success");
        }
        catch (Exception e) {
            LogUtils.oe("getAccessTokenByAppId failed", e);
        }
        return accessToken;
    }

    public static void removeAccessTokenByAppId(Context context, String appId) {
        try {
            SharedPrefUtils.remove(context, "accessToken", "accessToken_" + appId);
            LogUtils.logDebugO("removeAccessTokenByAppId success");
        }
        catch (Exception e) {
            LogUtils.oe("removeAccessTokenByAppId failed", e);
        }
    }

    public static class GetWidgetSoftTokenResult {
        public int ret;
        public String softToken;
    }
}

