/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMURLMgr;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMTokenUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.StringUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class GrayRelease {
    public static void saveGrayReleaseStrategyId(Context context, EMMStartReportResVO emmStatus, String curAppId) {
        if (!TextUtils.isEmpty((CharSequence)emmStatus.strategyId)) {
            SharedPrefUtils.putString(context, "isInstallGrayReleaseApp" + curAppId, emmStatus.newVersion, emmStatus.strategyId);
            SharedPrefUtils.putString(context, "upgradeStrategyId" + curAppId, emmStatus.strategyId, emmStatus.newVersion);
        }
    }

    private static void delGrayReleaseStrategyId(Context context, EMMStartReportResVO emmStatus, String curAppId) {
        SharedPrefUtils.remove(context, "isInstallGrayReleaseApp" + curAppId, emmStatus.newVersion);
        SharedPrefUtils.remove(context, "upgradeStrategyId" + curAppId, emmStatus.strategyId);
    }

    public static void freeGrayReleaseVersion(final Context context, final EMMWWidgetData mWidgetData, final EMMStartReportResVO emmStatus) {
        if (!TextUtils.isEmpty((CharSequence)emmStatus.strategyId)) {
            new AsyncTask<Void, Void, String>(){

                protected String doInBackground(Void ... params) {
                    return GrayRelease.freeGrayReleaseVersionReport(context, mWidgetData, emmStatus.strategyId);
                }

                protected void onPostExecute(String result) {
                    String status;
                    if (!TextUtils.isEmpty((CharSequence)result) && "ok".equals(status = StringUtils.getString(result, "status"))) {
                        GrayRelease.delGrayReleaseStrategyId(context, emmStatus, mWidgetData.m_appId);
                    }
                }
            }.execute((Object[])new Void[0]);
        }
    }

    private static String freeGrayReleaseVersionReport(Context context, EMMWWidgetData mWData, String strategyId) {
        String result = "";
        if (!TextUtils.isEmpty((CharSequence)strategyId)) {
            String url = EMMURLMgr.getUrlUpdateStrategy().replace("{strategyId}", strategyId);
            LogUtils.logDebug("updateStrategyReport url:" + url);
            JSONObject json = new JSONObject();
            try {
                json.put("appId", (Object)mWData.m_appId);
                json.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, mWData));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            result = EMMHttpURLConnection.sendPostRequestByFrom(context, mWData, url, json, false).getResult();
        }
        LogUtils.logDebug("updateStrategyReport appId:" + mWData.m_appId + " strategyId:" + strategyId + " result:" + result);
        return result;
    }

    public static void checkGrayReleaseNewVersion(Context context, EMMWWidgetData rootWidgetData) {
        Map<String, String> strategyIdMaps;
        String strategyId = SharedPrefUtils.getString(context, "isInstallGrayReleaseApp" + rootWidgetData.m_appId, rootWidgetData.m_ver, "");
        if (!TextUtils.isEmpty((CharSequence)strategyId)) {
            SharedPrefUtils.remove(context, "isInstallGrayReleaseApp" + rootWidgetData.m_appId, rootWidgetData.m_ver);
            SharedPrefUtils.remove(context, "upgradeStrategyId" + rootWidgetData.m_appId, strategyId);
        }
        if ((strategyIdMaps = SharedPrefUtils.getAll(context, "upgradeStrategyId" + rootWidgetData.m_appId)) != null) {
            for (int i = 0; i < strategyIdMaps.size(); ++i) {
                Set<Map.Entry<String, String>> set = strategyIdMaps.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    strategyId = entry.getKey();
                    if (TextUtils.isEmpty((CharSequence)strategyId)) continue;
                    GrayRelease.freeGrayReleaseVersion(context, rootWidgetData, new EMMStartReportResVO(strategyId, rootWidgetData.m_ver));
                }
            }
        }
    }
}

