/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.Map;

public class SharedPrefUtils {
    private static final int sharedPrefModel = 4;

    public static void putString(Context context, String spName, String key, String value) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        if (!TextUtils.isEmpty((CharSequence)key)) {
            sp.edit().putString(key, value).commit();
        }
    }

    public static void putStringArray(Context context, String spName, String[] keyArray, String[] valueArray) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        for (int i = 0; i < keyArray.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)keyArray[i])) continue;
            sp.edit().putString(keyArray[i], valueArray[i]).commit();
        }
    }

    public static void putIntArray(Context context, String spName, String[] keyArray, int[] valueArray) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        for (int i = 0; i < keyArray.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)keyArray[i])) continue;
            sp.edit().putInt(keyArray[i], valueArray[i]).commit();
        }
    }

    public static void putLong(Context context, String spName, String key, Long value) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        if (!TextUtils.isEmpty((CharSequence)key)) {
            sp.edit().putLong(key, value.longValue()).commit();
        }
    }

    public static void putBoolean(Context context, String spName, String key, Boolean value) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        if (!TextUtils.isEmpty((CharSequence)key)) {
            sp.edit().putBoolean(key, value.booleanValue()).commit();
        }
    }

    public static String getString(Context context, String spName, String key) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        return sp.getString(key, "");
    }

    public static String getString(Context context, String spName, String key, String defValue) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        return sp.getString(key, defValue);
    }

    public static boolean getBoolean(Context context, String spName, String key, boolean defValue) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        return sp.getBoolean(key, defValue);
    }

    public static long getLong(Context context, String spName, String key, long defValue) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        return sp.getLong(key, defValue);
    }

    public static int getInt(Context context, String spName, String key, int defValue) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        return sp.getInt(key, defValue);
    }

    public static void remove(Context context, String spName, String key) {
        SharedPreferences.Editor editor = context.getSharedPreferences(spName, 4).edit();
        editor.remove(key);
        editor.commit();
    }

    public static void clear(Context context, String spName) {
        SharedPreferences.Editor editor = context.getSharedPreferences(spName, 4).edit();
        editor.clear();
        editor.commit();
    }

    public static Map<String, String> getAll(Context context, String spName) {
        SharedPreferences sp = context.getSharedPreferences(spName, 4);
        return sp.getAll();
    }
}

