/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.analytics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import android.text.format.Time;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AlterAnalyTime;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsUtility;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.Event;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.SubWidgetAnalyticsThread;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.StringUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SystemTime;

public class AnalyticsAgent {
    private static AnalyticsAgent sAnalyticsAgent;
    private long m_appBecomeActiveTime;
    private long m_appBecomeBackgroundTime = 0L;
    private long m_currentAppTime;
    public int m_status = -1;
    public static AnalyticsThread analyticsThread;
    public static SubWidgetAnalyticsThread subWidgetReportThread;
    public static HashMap<String, ArrayList<String>> sShowViewListMap;
    public static HashMap<String, HashMap<String, Event>> sEventMap;
    public static List<String[]> startViewList;
    public static List<String[]> endViewList;
    public String certificatePsw = null;

    public static AnalyticsAgent getInstance(Context context) {
        if (sAnalyticsAgent == null) {
            sAnalyticsAgent = new AnalyticsAgent();
        }
        return sAnalyticsAgent;
    }

    public void clear() {
        if (null != analyticsThread) {
            try {
                analyticsThread.finish();
                analyticsThread.interrupt();
                analyticsThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AlterAnalyTime.finish();
    }

    public void initAppOnlineTime() {
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        AlterAnalyTime.getInstance().fastAnalytics();
        if (this.m_appBecomeActiveTime == 0L) {
            this.m_appBecomeActiveTime = System.currentTimeMillis();
        }
        LogUtils.logDebug("initAppOnlineTime==" + this.m_appBecomeActiveTime);
    }

    public void setAppBecomeActive(Context mContext) {
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        AlterAnalyTime.getInstance().fastAnalytics();
        this.m_appBecomeActiveTime = System.currentTimeMillis();
        if (this.m_appBecomeBackgroundTime != 0L && this.m_appBecomeActiveTime - this.m_appBecomeBackgroundTime > 1800000L) {
            EMMAgent.getInstance().widgetStartup(mContext, EMMAgent.s_rootWgt, EMMAgent.getInstance().getEUExEMMInstance().cbHandler, true, null);
        }
        LogUtils.logDebug("setAppBecomeActive==" + this.m_appBecomeActiveTime);
    }

    public void setAppBecomeBackground(Context mContext) {
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        AlterAnalyTime.getInstance().fastAnalytics();
        this.m_appBecomeBackgroundTime = System.currentTimeMillis();
        this.m_currentAppTime += (this.m_appBecomeBackgroundTime - this.m_appBecomeActiveTime) / 1000L;
        if (mContext == null) {
            return;
        }
        SharedPrefUtils.putLong(mContext, "app", "appTotalTime", this.m_currentAppTime);
        LogUtils.logDebug("setAppBecomeBackground m_currentAppTime  ==" + this.m_currentAppTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartView(String opener, String name, int startType, int windowType) {
        String[] view;
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        AlterAnalyTime.getInstance().fastAnalytics();
        view = new String[]{TextUtils.isEmpty((CharSequence)opener) ? "application" : opener, TextUtils.isEmpty((CharSequence)name) ? view[0] : name, SystemTime.getNowTime(), String.valueOf(startType), String.valueOf(windowType)};
        LogUtils.logDebug("setStartView == " + opener + "==" + name);
        List<String[]> list = startViewList;
        synchronized (list) {
            startViewList.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndView(String name, int endType) {
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)name)) {
            return;
        }
        AlterAnalyTime.getInstance().fastAnalytics();
        String[] view = new String[]{name, String.valueOf(endType), SystemTime.getNowTime()};
        LogUtils.logDebug("setEndView == " + name);
        List<String[]> list = endViewList;
        synchronized (list) {
            endViewList.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEvent(String appId, String inEventID, String inAttri) {
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        Map<String, String> inMap = StringUtils.jsonStrToMap(inAttri);
        AlterAnalyTime.getInstance().fastAnalytics();
        ArrayList<String> m_showViewList = sShowViewListMap.get(appId);
        if (m_showViewList == null) {
            m_showViewList = new ArrayList();
            sShowViewListMap.put(appId, m_showViewList);
        }
        ArrayList<String> arrayList = m_showViewList;
        synchronized (arrayList) {
            m_showViewList.add("2;" + inEventID + ";" + SystemTime.getNowTime() + ";[" + AnalyticsUtility.getMapToString(inMap) + "]");
        }
    }

    public static void beginEvent(String appId, String inEventID, String inKey, String inAttri) {
        Event event;
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        Map<String, String> inMap = StringUtils.jsonStrToMap(inAttri);
        HashMap<String, Event> m_eventMap = sEventMap.get(appId);
        if (m_eventMap == null) {
            m_eventMap = new HashMap();
            sEventMap.put(appId, m_eventMap);
        }
        if ((event = m_eventMap.get(inEventID + ";" + inKey)) == null) {
            event = new Event();
            m_eventMap.put(inEventID + ";" + inKey, event);
        }
        event.m_type = 3;
        event.m_beginTime_int = System.currentTimeMillis();
        ++event.m_clickNum;
        event.m_dict = AnalyticsUtility.getMapToString(inMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endEvent(String appId, String inEventID, String inKey) {
        Event event;
        if (!EMMAgent.getAppStatus().startReport) {
            return;
        }
        AlterAnalyTime.getInstance().fastAnalytics();
        HashMap<String, Event> m_eventMap = sEventMap.get(appId);
        if (m_eventMap != null && (event = m_eventMap.get(inEventID + ";" + inKey)) != null) {
            HashMap<String, Event> hashMap = m_eventMap;
            synchronized (hashMap) {
                event.m_totalTime = (System.currentTimeMillis() - event.m_beginTime_int) / 1000L;
                m_eventMap.put(inEventID + ";" + inKey, event);
                AnalyticsThread.sEventMap.put(appId, m_eventMap);
            }
        }
    }

    public static String getError(Context mContext) {
        String localObject = "";
        try {
            String str1 = mContext.getPackageName();
            String str2 = "";
            boolean i1 = false;
            boolean i2 = false;
            ArrayList<String> localArrayList = new ArrayList<String>();
            localArrayList.add("logcat");
            localArrayList.add("-d");
            localArrayList.add("-v");
            localArrayList.add("time");
            localArrayList.add("-s");
            localArrayList.add("AndroidRuntime:E");
            localArrayList.add("-p");
            localArrayList.add(str1);
            Process localProcess = Runtime.getRuntime().exec(localArrayList.toArray(new String[localArrayList.size()]));
            BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(localProcess.getInputStream()), 1024);
            String errorTime = null;
            Time time = new Time();
            time.setToNow();
            String str3 = localBufferedReader.readLine();
            while (str3 != null) {
                if (str3.indexOf("------- beginning") <= 0) {
                    if (str3.indexOf("):") > 0) {
                        int index = str3.indexOf(")");
                        if (errorTime == null) {
                            errorTime = time.year + "-" + str3.substring(0, str3.substring(0, index).indexOf("."));
                        }
                        str3 = str3.substring(index + 2);
                    }
                    if (str3.indexOf("thread attach failed") < 0) {
                        str2 = str2 + str3 + '\n';
                    }
                    if (!i2 && str3.toLowerCase().indexOf("exception") >= 0) {
                        i2 = true;
                    }
                    if (!i1 && str3.indexOf(str1) >= 0) {
                        i1 = true;
                    }
                }
                str3 = localBufferedReader.readLine();
            }
            if (str2.length() > 0 && i2 && i1) {
                PackageManager pm = mContext.getPackageManager();
                PackageInfo pinfo = null;
                try {
                    pinfo = pm.getPackageInfo(mContext.getPackageName(), 16384);
                    localObject = "5;" + errorTime + ";" + pinfo.versionName + ";" + Build.MODEL + ";Android " + Build.VERSION.RELEASE + ";{" + str2 + "}";
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                Runtime.getRuntime().exec("logcat -c");
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localObject;
    }

    static {
        analyticsThread = null;
        subWidgetReportThread = null;
        sShowViewListMap = new HashMap();
        sEventMap = new HashMap();
        startViewList = new ArrayList<String[]>();
        endViewList = new ArrayList<String[]>();
    }
}

