/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar.RoundBaseProgressBar;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.CoordinateVO;

public class CircleProgressBar
extends RoundBaseProgressBar {
    public CircleProgressBar(Context context) {
        super(context, null);
    }

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        this.postInvalidate();
    }

    @Override
    protected void drawProgressText(Canvas canvas, Paint paint, float centre, float radius, int percent, float textSize, int textColor) {
        super.drawProgressText(canvas, paint, centre, radius, percent, textSize, textColor);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null == this.progressOval) {
            this.radius = (int)(this.centre - this.progressWidth / 2.0f);
            this.progressRadius = (int)((double)this.centre * 0.85 - (double)(this.progressWidth / 2.0f));
            this.progressOval = new RectF(this.centre - this.progressRadius, this.centre - this.progressRadius, this.centre + this.progressRadius, this.centre + this.progressRadius);
        }
        this.drawCircle(canvas, this.paint, new CoordinateVO(this.centre, this.centre), this.centre, -1, this.centre, Paint.Style.FILL);
        if (this.textIsDisplayable && this.style == 0) {
            this.drawProgressText(canvas, this.paint, this.centre, this.radius, (int)((float)this.progress / (float)this.maxValue * 100.0f), this.textSize, this.textColor);
        }
        double sweepAngle = 360 * this.progress / this.maxValue;
        if (this.hasSpecialEffects) {
            this.drawArc(canvas, this.paint, this.style, this.roundProgressColor, this.progressWidth, this.startAngle.floatValue(), (float)sweepAngle, this.progressOval, this.progress);
        }
        if (this.hasSpecialEffects) {
            float spcERadius = this.progressWidth / 2.0f;
            CoordinateVO mCoordinateStart = new CoordinateVO(this.centre, this.centre - this.progressRadius);
            CoordinateVO mCoordinateEnd = this.getCircleCenterVO(sweepAngle);
            if (this.progress > 20) {
                this.drawCircle(canvas, this.paint, mCoordinateStart, spcERadius, -1, 0.0f, Paint.Style.FILL);
                this.drawCircle(canvas, this.paint, mCoordinateEnd, spcERadius, this.roundProgressColor, 0.0f, Paint.Style.FILL);
            } else {
                int color = this.roundProgressColor;
                if (0 == this.progress) {
                    color = -1;
                }
                this.drawCircle(canvas, this.paint, mCoordinateEnd, spcERadius, color, 0.0f, Paint.Style.FILL);
                this.drawCircle(canvas, this.paint, mCoordinateStart, spcERadius, -1, 0.0f, Paint.Style.FILL);
            }
        }
    }
}

