/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar.RoundBaseProgressBar;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.CoordinateVO;

public class RollProgressBar
extends RoundBaseProgressBar {
    private float rollStartAngle = 0.0f;
    private Canvas mCanvas = null;
    private Runnable mLongPressRunnable = new Runnable(){

        @Override
        public void run() {
            RollProgressBar.this.postInvalidate();
            RollProgressBar.this.postDelayed(RollProgressBar.this.mLongPressRunnable, RollProgressBar.this.rollInterval);
        }
    };

    @Override
    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
    }

    public RollProgressBar(Context context) {
        super(context, null);
    }

    public RollProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void sartUpdateProgress() {
        this.post(this.mLongPressRunnable);
    }

    public void stopUpdateProgress() {
        this.removeCallbacks(this.mLongPressRunnable);
    }

    @Override
    protected void drawProgressText(Canvas canvas, Paint paint, float centre, float radius, int percent, float textSize, int textColor) {
        super.drawProgressText(canvas, paint, centre, radius, percent, textSize, textColor);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null == this.progressOval) {
            this.radius = (int)(this.centre - this.progressWidth / 2.0f);
            this.progressRadius = (int)((double)this.centre * 0.85 - (double)(this.progressWidth / 2.0f));
            this.progressOval = new RectF(this.centre - this.progressRadius, this.centre - this.progressRadius, this.centre + this.progressRadius, this.centre + this.progressRadius);
        }
        this.drawCircle(canvas, this.paint, new CoordinateVO(this.centre, this.centre), this.progressRadius, this.roundColor, this.progressWidth, Paint.Style.STROKE);
        if (this.textIsDisplayable && this.style == 0) {
            this.drawProgressText(canvas, this.paint, this.centre, this.radius, (int)((float)this.progress / (float)this.maxValue * 100.0f), this.textSize, this.textColor);
        }
        if (null == this.mCanvas) {
            this.mCanvas = canvas;
        }
        float spcERadius = this.progressWidth / 2.0f;
        this.drawRollCircle(canvas, this.paint, spcERadius, this.roundProgressColor, this.rollStartAngle);
        this.rollStartAngle += (float)this.rollStep;
    }

    private void drawRollCircle(Canvas canvas, Paint paint, float radius, int color, double rollStartAngle) {
        CoordinateVO startCenter = this.getCircleCenterVO(rollStartAngle);
        this.drawCircle(canvas, paint, startCenter, radius, color, 0.0f, Paint.Style.FILL);
        CoordinateVO endCenter = this.getCircleCenterVO(rollStartAngle + (double)this.rollSweepAngle);
        this.drawCircle(canvas, paint, endCenter, radius, color, 0.0f, Paint.Style.FILL);
        this.drawArc(canvas, paint, this.style, color, this.progressWidth, (float)(rollStartAngle - 90.0), this.rollSweepAngle, this.progressOval, this.progress);
    }
}

