/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.dialog.progressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import java.lang.reflect.Field;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.CoordinateVO;

public class RoundBaseProgressBar
extends View {
    protected Paint paint;
    protected int roundColor;
    protected int roundProgressColor;
    protected int textColor;
    protected float textSize;
    protected float progressWidth;
    protected int maxValue;
    protected int progress = 0;
    protected boolean textIsDisplayable;
    protected boolean hasSpecialEffects = false;
    protected int style;
    public static final int STROKE = 0;
    public static final int FILL = 1;
    protected Float startAngle = Float.valueOf(270.0f);
    private static final int DEFAULT_STYLE = 0;
    private static final int DEFAULT_ROUND_COLOR = -65536;
    private static final int DEFAULT_ROUND_PROGRESS_COLOR = -16711936;
    private static final int DEFAULT_TEXT_COLOR = -16711936;
    private static final int DEFAULT_TEXT_SIZE = 15;
    private static final int DEFAULT_ROUND_WIDTH = 5;
    private static final int DEFAULT_MAX_VALUE = 100;
    private static final boolean DEFAULT_TEXT_DISPLAYABLE = true;
    private static final String CUSTOM_CLASS = "plugin_emm_circle_progress_";
    private static final String ROUND_COLOR = "plugin_emm_round_bg_color";
    private static final String ROUND_PROGRESS_COLOR = "plugin_emm_round_progress_color";
    private static final String ROUND_WIDTH = "plugin_emm_round_width";
    private static final String TEXT_COLOR = "plugin_emm_text_color";
    private static final String TEXT_SIZE = "plugin_emm_text_size";
    private static final String MAX_VALUE = "plugin_emm_max_value";
    private static final String TEXT_DISPLAYABLE = "plugin_emm_text_is_displayable";
    private static final String STYLE = "plugin_emm_style";
    private static final String RES_TYPE = "styleable";
    protected RectF progressOval = null;
    protected float centre;
    protected float radius;
    protected float progressRadius;
    protected float rollSweepAngle = 60.0f;
    protected int rollStep = 5;
    protected int rollInterval = 10;

    public RoundBaseProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private static Object getResourceId(Context context, String name, String type) {
        String className = context.getPackageName() + ".R";
        try {
            Class<?> cls = Class.forName(className);
            for (Class<?> childClass : cls.getClasses()) {
                String simple = childClass.getSimpleName();
                if (!simple.equals(type)) continue;
                for (Field field : childClass.getFields()) {
                    String fieldName = field.getName();
                    if (!fieldName.equals(name)) continue;
                    return field.get(null);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private RoundBaseProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.paint = new Paint();
        int[] styleAttrs = new int[]{EUExUtil.getResAttrID((String)MAX_VALUE), EUExUtil.getResAttrID((String)ROUND_COLOR), EUExUtil.getResAttrID((String)ROUND_PROGRESS_COLOR), EUExUtil.getResAttrID((String)ROUND_WIDTH), EUExUtil.getResAttrID((String)STYLE), EUExUtil.getResAttrID((String)TEXT_COLOR), EUExUtil.getResAttrID((String)TEXT_DISPLAYABLE), EUExUtil.getResAttrID((String)TEXT_SIZE)};
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, styleAttrs);
        this.roundColor = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_round_bg_color", RES_TYPE) ? -65536 : mTypedArray.getColor(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_round_bg_color", RES_TYPE)).intValue(), -65536);
        this.roundProgressColor = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_round_progress_color", RES_TYPE) ? -16711936 : mTypedArray.getColor(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_round_progress_color", RES_TYPE)).intValue(), -16711936);
        this.progressWidth = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_round_width", RES_TYPE) ? 5.0f : mTypedArray.getDimension(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_round_width", RES_TYPE)).intValue(), 5.0f);
        this.textColor = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_text_color", RES_TYPE) ? -16711936 : mTypedArray.getColor(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_text_color", RES_TYPE)).intValue(), -16711936);
        this.textSize = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_text_size", RES_TYPE) ? 15.0f : mTypedArray.getDimension(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_text_size", RES_TYPE)).intValue(), 15.0f);
        this.maxValue = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_max_value", RES_TYPE) ? 100 : mTypedArray.getInteger(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_max_value", RES_TYPE)).intValue(), 100);
        this.textIsDisplayable = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_text_is_displayable", RES_TYPE) ? true : mTypedArray.getBoolean(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_text_is_displayable", RES_TYPE)).intValue(), true);
        this.style = null == RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_style", RES_TYPE) ? 0 : mTypedArray.getInt(((Integer)RoundBaseProgressBar.getResourceId(context, "plugin_emm_circle_progress_plugin_emm_style", RES_TYPE)).intValue(), 0);
        mTypedArray.recycle();
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        super.onSizeChanged(w, h, ow, oh);
    }

    protected void drawCircle(Canvas canvas, Paint paint, CoordinateVO centerCoordinate, float radius, int color, float roundWidth, Paint.Style style) {
        paint.setColor(color);
        paint.setStyle(style);
        paint.setStrokeWidth(roundWidth);
        paint.setAntiAlias(true);
        canvas.drawCircle(centerCoordinate.x, centerCoordinate.y, radius, paint);
    }

    protected void drawProgressText(Canvas canvas, Paint paint, float centre, float radius, int percent, float textSize, int textColor) {
        paint.setStrokeWidth(0.0f);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(textColor);
        paint.setTextSize(textSize);
        paint.setTypeface(Typeface.DEFAULT_BOLD);
        float textWidth = paint.measureText(percent + "%");
        canvas.drawText(percent + "%", centre - textWidth / 2.0f, centre + textSize / 2.0f, paint);
    }

    protected void drawArc(Canvas canvas, Paint paint, int style, int roundColor, float roundWidth, float startAngle, float sweepAngle, RectF oval, int progress) {
        paint.setStrokeWidth(roundWidth);
        paint.setColor(roundColor);
        paint.setAntiAlias(true);
        boolean uesCenter = false;
        switch (style) {
            case 0: {
                paint.setStyle(Paint.Style.STROKE);
                break;
            }
            case 1: {
                paint.setStyle(Paint.Style.FILL_AND_STROKE);
            }
        }
        if (progress >= 0) {
            canvas.drawArc(oval, startAngle, sweepAngle, uesCenter, paint);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null == this.progressOval) {
            this.centre = this.getWidth() / 2;
        }
    }

    public synchronized int getMax() {
        return this.maxValue;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max not less than 0");
        }
        this.maxValue = max;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        this.progress = progress;
        if (progress >= 0) {
            this.progress = progress <= this.maxValue ? progress : this.maxValue;
        }
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int cricleProgressColor) {
        this.roundProgressColor = cricleProgressColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public float getRoundWidth() {
        return this.progressWidth;
    }

    public void setRoundColor(int roundColor) {
        this.roundColor = roundColor;
    }

    public void setRoundWidth(float roundWidth) {
        this.progressWidth = roundWidth;
    }

    private double getAnglePI(double angle) {
        return Math.PI * angle / 180.0;
    }

    protected CoordinateVO getCircleCenterVO(double angle) {
        double sweepAnglePI = this.getAnglePI(angle);
        CoordinateVO mCoordinateVO = new CoordinateVO((float)((double)this.centre + (double)this.progressRadius * Math.sin(sweepAnglePI)), (float)((double)this.centre - (double)this.progressRadius * Math.cos(sweepAnglePI)));
        return mCoordinateVO;
    }

    public void setRollSweepAngle(int angle) {
        this.rollSweepAngle = angle;
    }

    public void setRollStep(int step) {
        this.rollStep = step;
    }

    public void setRollInterval(int rollInterval) {
        this.rollInterval = rollInterval;
    }

    public void setHasSpecialEffects(boolean hasSpecialEffects) {
        this.hasSpecialEffects = hasSpecialEffects;
    }
}

