/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.emm;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.EMMConfigManager;
import org.zywx.wbpalmstar.plugin.uexemm.EUExEMM;
import org.zywx.wbpalmstar.plugin.uexemm.analytics.AnalyticsAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMThread;
import org.zywx.wbpalmstar.plugin.uexemm.emm.StartReportResultListener;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.FileEncryption;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.MD5Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.encryption.RC4Encryption;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.http.Http;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.HttpRequestHeadVO;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMDataMgr;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMTokenUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.EMMUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexemm.utils.HexConverter;
import org.zywx.wbpalmstar.plugin.uexemm.utils.IPLocation;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.NetworkUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SafetyVerify;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.StringUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppCanCertVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.AppStatusVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMAppVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMConfigVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;
import org.zywx.wbpalmstar.plugin.uexemm.vo.LoginPropertyOptionVO;
import org.zywx.wbpalmstar.plugin.uexemm.vo.ValitionJwtTokenVO;

public class EMMAgent {
    public static int PLATFORM_VERSION = 4;
    public static int UPGRADE_PROGRESS_STYLE = 0;
    public static EMMWWidgetData s_rootWgt;
    private static EMMThread sEmmThread;
    private static boolean isGetIpLocation;
    private EUExEMM mEMM;
    private boolean isLogining = false;
    private AppCanCertVO mTempCertInfo = null;
    private JSONObject mTempLoginInfo = new JSONObject();
    private static Map<String, String> loginPropertyMap;
    private static EMMConfigVO mEmmConfig;
    private static AppStatusVO mAppStatus;
    public static StartReportResultListener mStartResultListener;
    private String certPath = null;
    private String certPwd = null;
    public static boolean checkAppStatus;

    private EMMAgent() {
    }

    public static EMMAgent getInstance() {
        return EMMAgentHandler.sInstance;
    }

    public void initEMM(Context context) {
        if (null == mEmmConfig) {
            this.setEMMPluginConfig();
            LogUtils.setPackageName(context.getPackageName());
            mEmmConfig = EMMConfigManager.getEMMConfigByXML(context);
        }
    }

    private void setEMMPluginConfig() {
        PLATFORM_VERSION = 3;
        UPGRADE_PROGRESS_STYLE = 0;
    }

    public static EMMConfigVO getEMMConfig() {
        return mEmmConfig;
    }

    public void setAppStatus(AppStatusVO appStatusVO) {
        mAppStatus = appStatusVO;
        Http.setCheckTrustCert(EMMAgent.mAppStatus.isCheckService);
    }

    public static AppStatusVO getAppStatus() {
        return mAppStatus;
    }

    public void setEUExEMMInstance(EUExEMM emm) {
        if (null == this.mEMM) {
            this.mEMM = emm;
        }
    }

    public EUExEMM getEUExEMMInstance() {
        return this.mEMM;
    }

    public void disableCheckAppStatus() {
        checkAppStatus = false;
    }

    public void setClientCertVO(String certPath, String certPwd) {
        this.certPath = certPath;
        this.certPwd = certPwd;
    }

    public void getLoginProperty(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, LoginPropertyOptionVO loginPropertyInfo) {
        if (NetworkUtils.isNetworkAvailable(context)) {
            if (loginPropertyInfo.isGetOfflineData) {
                handler.send2Callback(loginPropertyMap.get(EMMUtils.getTenantAccount(context)), 1);
            } else {
                this.getLoginPropertyOnLine(context, wData, handler, loginPropertyInfo.jwtKey);
            }
        } else {
            this.getLoginPropertyOffLine(context, handler);
        }
    }

    public void getLoginProperty(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler) {
        if (NetworkUtils.isNetworkAvailable(context)) {
            this.getLoginPropertyOnLine(context, wData, handler, "");
        } else {
            this.getLoginPropertyOffLine(context, handler);
        }
    }

    private void getLoginPropertyOffLine(Context context, EUExEMM.EMMHandler cbHandler) {
        if (EMMAgent.mAppStatus.isOfflineLogin) {
            String offLineLoginProperty = SharedPrefUtils.getString(context, "loginPropertyResult", EMMUtils.getTenantAccount(context));
            cbHandler.send2Callback(StringUtils.putString(offLineLoginProperty, "isOfflineLogin", "true"), 1);
        } else {
            cbHandler.send2Callback(null, 1);
        }
    }

    private void getLoginPropertyOnLine(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, String jwtKey) {
        if (PLATFORM_VERSION != 3) {
            try {
                EMMAppVO emmAppVO;
                JSONObject jsonData;
                String tenantAccount = EMMUtils.getTenantAccount(context);
                if (!EMMUtils.isAppFirstStart(tenantAccount)) {
                    JSONObject json = new JSONObject();
                    json.put("tenantAccount", (Object)tenantAccount);
                    json.put("appId", (Object)wData.m_appId);
                    jsonData = EMMDataMgr.putDataToJsonObj(json);
                    emmAppVO = new EMMAppVO();
                    if (!TextUtils.isEmpty((CharSequence)jwtKey)) {
                        emmAppVO.serviceType = 1;
                        emmAppVO.jwtKey = jwtKey;
                    }
                } else {
                    this.mEMM.cbHandler.send2Callback(null, 24);
                    return;
                }
                sEmmThread = EMMThread.getPostThread(context, handler, wData, 1, jsonData, null, emmAppVO);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            sEmmThread = EMMThread.getGetDataThread(context, handler, wData, 1);
        }
        sEmmThread.start();
    }

    public void saveLoginProperty(Context mContext, String loginProperty) {
        if (PLATFORM_VERSION != 3) {
            loginPropertyMap.put(EMMUtils.getTenantAccount(mContext), loginProperty);
        }
        if (EMMAgent.mAppStatus.isOfflineLogin) {
            SharedPrefUtils.putString(mContext, "loginPropertyResult", EMMUtils.getTenantAccount(mContext), loginProperty);
        }
    }

    public void regist(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject registInfo) {
        if (PLATFORM_VERSION != 3) {
            try {
                String tenantAccount = EMMUtils.getTenantAccount(context);
                if (EMMUtils.isAppFirstStart(tenantAccount)) {
                    this.mEMM.cbHandler.send2Callback(null, 24);
                    return;
                }
                registInfo.put("tenantAccount", (Object)tenantAccount);
                registInfo.put("appId", (Object)wData.m_appId);
                registInfo = EMMDataMgr.putDataToJsonObj(registInfo);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 2, registInfo);
        sEmmThread.start();
    }

    public void queryUserCertFile(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, AppCanCertVO mCertInfo) {
        sEmmThread = EMMThread.getGetCertDataThread(context, handler, wData, 12, mCertInfo);
        sEmmThread.start();
    }

    public void initApp(Context context, EMMWWidgetData wData, StartReportResultListener resultListener) {
        if (null == mStartResultListener) {
            mStartResultListener = resultListener;
        }
        s_rootWgt = wData;
        EMMAgent.s_rootWgt.m_appkey = wData.m_appkey;
        LogUtils.logDebugO(wData.m_appId + " " + wData.m_appkey);
        SharedPrefUtils.putString(context, "app", "appid", EMMAgent.s_rootWgt.m_appId);
        if (!EMMAgent.mAppStatus.startReport) {
            LogUtils.logDebug("EMM off");
            return;
        }
        if (checkAppStatus && EMMAgent.mAppStatus.isCheckAppSign && !SafetyVerify.checkAppSign(context)) {
            return;
        }
        EMMHttpURLConnection.setCertificate(EMMAgent.mAppStatus.isCertificate, this.certPath, this.certPwd);
        EMMUtils.saveMainAppId(context, EMMAgent.s_rootWgt.m_appId);
        if (!EMMAgent.mAppStatus.startReport) {
            LogUtils.logDebug("EMM off");
            return;
        }
    }

    public void widgetStartReport(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, boolean isAutoReport, EMMAppVO appInfo) {
        if (PLATFORM_VERSION != 3) {
            String tenantAccount = appInfo.tenantAccount;
            LogUtils.logDebug("tenantAccount:" + tenantAccount);
            if (!TextUtils.isEmpty((CharSequence)tenantAccount)) {
                EMMUtils.saveTenantAccount(context, appInfo.tenantAccount, false);
            } else {
                handler.send2Callback(null, 24);
                return;
            }
        }
        this.widgetStartup(context, wData, handler, isAutoReport, appInfo);
    }

    public void widgetStartup(final Context context, final EMMWWidgetData wData, EUExEMM.EMMHandler handler, boolean isAutoReport, EMMAppVO appInfo) {
        if (!isGetIpLocation) {
            ((Activity)context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    IPLocation.getIPLocation(context, wData.m_appId);
                }
            });
        }
        int serviceType = EMMUtils.getServiceTypeForAppid(context, wData.m_appId);
        String jwtKey = EMMUtils.getJwtKeyForAppid(context, wData.m_appId);
        if (appInfo == null) {
            appInfo = new EMMAppVO();
            appInfo.serviceType = serviceType;
            appInfo.jwtKey = jwtKey;
        } else if (TextUtils.isEmpty((CharSequence)appInfo.jwtKey)) {
            appInfo.serviceType = serviceType;
            appInfo.jwtKey = jwtKey;
        }
        sEmmThread = EMMThread.widgetStartupThread(context, handler, wData, 0, isAutoReport, appInfo);
        sEmmThread.start();
        GrayRelease.checkGrayReleaseNewVersion(context, s_rootWgt);
    }

    public void login(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject loginInfo) {
        this.login(context, wData, handler, loginInfo, 0);
    }

    public void login(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject loginInfo, int loginType) {
        if (NetworkUtils.isNetworkAvailable(context)) {
            AppCanCertVO certInfo = new AppCanCertVO();
            this.login(context, wData, handler, certInfo, loginInfo, loginType);
        } else {
            this.offLineLogin(context, handler, loginInfo);
        }
    }

    public void loginGrid(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject loginInfo) {
        this.login(context, wData, handler, loginInfo, 1);
    }

    public void login(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject loginInfo, AppCanCertVO certInfo) {
        boolean flg;
        block8: {
            flg = true;
            String loginName = loginInfo.optString("loginName");
            try {
                if (!certInfo.isCaAuth) break block8;
                if (TextUtils.isEmpty((CharSequence)loginName)) {
                    throw new Exception("Wrong Cert Params");
                }
                certInfo.userName = loginName;
                String path = EMMUtils.getCertPathByLoginName(context, loginName);
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    certInfo.certPath = path;
                    EMMHttpURLConnection.setAppCanCertificate(certInfo);
                    break block8;
                }
                this.isLogining = true;
                this.mTempCertInfo = certInfo;
                this.mTempLoginInfo = loginInfo;
                this.queryUserCertFile(context, wData, handler, certInfo);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.oe("login", e);
                try {
                    flg = false;
                    loginInfo.put("status", (Object)"fail");
                    loginInfo.put("info", (Object)EUExUtil.getString((String)"plugin_uexemm_parm_error"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
        LogUtils.logDebug("Login " + loginInfo);
        if (flg) {
            this.login(context, wData, handler, certInfo, loginInfo);
        } else {
            handler.send2Callback(loginInfo.toString(), 3);
        }
    }

    public void loginAfterLoadCert(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, String certPath) {
        this.isLogining = false;
        EMMHttpURLConnection.setAppCanCertificate(this.mTempCertInfo);
        this.login(context, wData, handler, this.mTempCertInfo, this.mTempLoginInfo);
    }

    public boolean isLogining() {
        return this.isLogining;
    }

    private void offLineLogin(Context context, EUExEMM.EMMHandler cbHandler, JSONObject loginInfo) {
        LogUtils.logDebug("into offLineLogin");
        if (EMMAgent.mAppStatus.isOfflineLogin) {
            loginInfo.remove("isFirstLogin");
            String domainName = loginInfo.optString("domainName");
            String offLineLoginInfo = SharedPrefUtils.getString(context, "loginInfo", domainName);
            String loginResult = "";
            if (MD5Encryption.getMD5Code(loginInfo.toString()).equals(offLineLoginInfo)) {
                String loginResultRC4 = SharedPrefUtils.getString(context, "loginResult", domainName);
                byte[] loginResultBytes = HexConverter.hexStringToBinary(loginResultRC4);
                loginResult = new String(RC4Encryption.os_decrypt(loginResultBytes, loginResultBytes.length, "appcanuse$%^&%^&%^&%&^$#$#sdfsda90239%^)f8y99e7we98\t\t\t yhfdsuyf892yr98ghwequifyh879esa6yf83g2ui1rfgtvbiygf\t\t\t appcanuse923yhr32hjfklsdahfjsadhjkfsadfbhdjkdsahfuy\t\t\t 28973yr^%UBFG%^&*IO^bjk789234y6cxzv98324df96621378*\t\t\t ^&$69879872364327848e^$%^$*(&(&wrtf32fuiheappcanuse"));
                loginResult = StringUtils.putString(loginResult, "isOfflineLogin", "true");
            } else {
                JSONObject json = new JSONObject();
                try {
                    json.put("status", (Object)"fail");
                    json.put("info", (Object)EUExUtil.getString((String)"plugin_uexemm_offline_login_error"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                loginResult = json.toString();
            }
            cbHandler.send2Callback(loginResult, 3);
        } else {
            cbHandler.send2Callback(null, 3);
        }
    }

    private void login(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, AppCanCertVO mCertInfo, JSONObject loginJson) {
        this.login(context, wData, handler, mCertInfo, loginJson, 0);
    }

    private void login(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, AppCanCertVO mCertInfo, JSONObject loginJson, int loginType) {
        EMMAppVO emmAppVO = new EMMAppVO();
        if (1 == loginType) {
            emmAppVO.serviceType = loginType;
            emmAppVO.jwtKey = loginJson.optString("jwtKey");
        }
        if (PLATFORM_VERSION != 3) {
            String tenantAccount = EMMUtils.getTenantAccount(context);
            if (!EMMUtils.isAppFirstStart(tenantAccount)) {
                try {
                    loginJson.put("tenantAccount", (Object)tenantAccount);
                    loginJson.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
                    loginJson.put("appId", (Object)wData.m_appId);
                    loginJson = EMMDataMgr.putDataToJsonObj(loginJson);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                this.mEMM.cbHandler.send2Callback(null, 24);
                return;
            }
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 3, loginJson, mCertInfo, emmAppVO);
        sEmmThread.start();
    }

    public void changePassword(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject changePwdJson) {
        JSONObject jsonData = null;
        if (PLATFORM_VERSION != 3) {
            Object json = null;
            try {
                changePwdJson.put("accessToken", (Object)EMMTokenUtils.getAccessTokenByAppId(context, wData.m_appId));
                changePwdJson.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
                jsonData = EMMDataMgr.putDataToJsonObj(changePwdJson);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            jsonData = changePwdJson;
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 11, jsonData);
        sEmmThread.start();
    }

    public void ssoLogin(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject ssoLoginJson) {
        if (PLATFORM_VERSION != 3) {
            try {
                ssoLoginJson.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ssoLoginJson = EMMDataMgr.putDataToJsonObj(ssoLoginJson);
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 4, ssoLoginJson);
        sEmmThread.start();
    }

    public void bindUserRelation(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject bindUser) {
        if (PLATFORM_VERSION != 3) {
            try {
                bindUser.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            bindUser = EMMDataMgr.putDataToJsonObj(bindUser);
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 5, bindUser);
        sEmmThread.start();
    }

    public void releaseUserRelation(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject releaseJson) {
        if (PLATFORM_VERSION != 3) {
            try {
                releaseJson.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            releaseJson = EMMDataMgr.putDataToJsonObj(releaseJson);
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 13, releaseJson);
        sEmmThread.start();
    }

    public void validateCode(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject validateInfo) {
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 6, validateInfo);
        sEmmThread.start();
    }

    public void validateBindCode(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject bindValidateInfo) {
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 8, bindValidateInfo);
        sEmmThread.start();
    }

    public void boundOtherInfo(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject otherInfo) {
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 7, otherInfo);
        sEmmThread.start();
    }

    public void logout(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, JSONObject logoutInfo) {
        EMMAppVO emmAppVO = new EMMAppVO();
        try {
            if (null == logoutInfo) {
                logoutInfo = new JSONObject();
                logoutInfo.put("accessToken", (Object)EMMTokenUtils.getAccessTokenByAppId(context, wData.m_appId));
            } else {
                if (!logoutInfo.has("accessToken")) {
                    logoutInfo.put("accessToken", (Object)EMMTokenUtils.getAccessTokenByAppId(context, wData.m_appId));
                }
                if (logoutInfo.has("jwtKey")) {
                    emmAppVO.serviceType = 1;
                    emmAppVO.jwtKey = logoutInfo.optString("jwtKey");
                    logoutInfo.remove("jwtKey");
                }
            }
            if (PLATFORM_VERSION != 3) {
                logoutInfo.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
                logoutInfo = EMMDataMgr.putDataToJsonObj(logoutInfo);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 9, logoutInfo, new AppCanCertVO(), emmAppVO);
        sEmmThread.start();
    }

    public void getVerificationImage(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler) {
        JSONObject jsonData = null;
        if (PLATFORM_VERSION != 3) {
            JSONObject json = new JSONObject();
            try {
                json.put("softToken", (Object)EMMTokenUtils.getSoftToken(context, wData));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            jsonData = EMMDataMgr.putDataToJsonObj(json);
        }
        sEmmThread = EMMThread.getPostThread(context, handler, wData, 10, jsonData);
        sEmmThread.start();
    }

    public void setEvent(String appId, String inEventID, String inAttri) {
        AnalyticsAgent.setEvent(appId, inEventID, inAttri);
    }

    public void beginEvent(String appId, String inEventID, String inKey, String inAttri) {
        AnalyticsAgent.beginEvent(appId, inEventID, inKey, inAttri);
    }

    public void endEvent(String appId, String inEventID, String inKey) {
        AnalyticsAgent.endEvent(appId, inEventID, inKey);
    }

    public String getOnlineParams(Context context, String mSPName) {
        return SharedPrefUtils.getString(context, mSPName, "appParam", "");
    }

    public String getAccessToken(Context context, String appId) {
        return EMMTokenUtils.getAccessTokenByAppId(context, appId);
    }

    public void removeAccessToken(Context context, String appId) {
        EMMTokenUtils.removeAccessTokenByAppId(context, appId);
    }

    public void getDisablePlugins(Context context, EUExEMM.EMMHandler handler, String mSPName) {
        handler.send2Callback(SharedPrefUtils.getString(context, mSPName, "disablePlugins", ""), 12);
    }

    public void getDisableWindows(Context context, EUExEMM.EMMHandler handler, String mSPName) {
        handler.send2Callback(SharedPrefUtils.getString(context, mSPName, "disableWindows", ""), 13);
    }

    public String getWidgetInfo(Context context, EMMWWidgetData mCurWData) {
        String widgetInfo = "";
        try {
            widgetInfo = new JSONStringer().object().key("appId").value((Object)mCurWData.m_appId).key("channelCode").value((Object)mCurWData.m_channelCode).key("version").value((Object)mCurWData.m_ver).key("appKey").value((Object)mCurWData.m_appkey).endObject().toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return widgetInfo;
    }

    public String getWidgetReportResult(Context context, EMMWWidgetData mCurWData) {
        return EMMUtils.getWidgetReportResult(context, mCurWData);
    }

    public String getSoftToken(Context context, EMMWWidgetData mCurWData) {
        return EMMTokenUtils.getSoftToken(context, mCurWData);
    }

    public void fileEncrypt(final Context context, final EMMWWidgetData mCurWData, final EUExEMM.EMMHandler handler, final String path) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... parm) {
                String newPath = EMMDataMgr.parsePath(context, mCurWData, path);
                if (TextUtils.isEmpty((CharSequence)newPath)) {
                    LogUtils.logDebugO("fileEncrypt: path--> " + newPath + " <--format error");
                    handler.send2Callback("", 15);
                    return null;
                }
                File file = new File(newPath);
                boolean isSuccess = FileEncryption.encryptFile(file);
                handler.send2Callback(isSuccess ? file.getAbsolutePath() : "", 15);
                return null;
            }

            protected void onPostExecute(Void result) {
            }
        }.execute((Object[])new Void[0]);
    }

    public void fileDecrypt(final Context context, final EMMWWidgetData mCurWData, final EUExEMM.EMMHandler handler, final String srcPath, final String dstPath) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... parm) {
                if (TextUtils.isEmpty((CharSequence)srcPath) || TextUtils.isEmpty((CharSequence)dstPath)) {
                    LogUtils.logDebugO("fileDecrypt: srcPath--> " + srcPath + " <--  dstPath--> " + dstPath + " <--path params error");
                    handler.send2Callback("", 16);
                    return null;
                }
                String srcPathParse = EMMDataMgr.parsePath(context, mCurWData, srcPath);
                String dstPathParse = EMMDataMgr.parsePath(context, mCurWData, dstPath);
                if (TextUtils.isEmpty((CharSequence)srcPathParse) || TextUtils.isEmpty((CharSequence)dstPath)) {
                    LogUtils.logDebugO("fileDecrypt: srcPath--> " + srcPathParse + " <--  dstPath--> " + dstPathParse + " <--format error");
                    handler.send2Callback("", 16);
                    return null;
                }
                File srcFile = new File(srcPathParse);
                File dstFile = new File(dstPathParse);
                if (!dstFile.getParentFile().exists()) {
                    dstFile.getParentFile().mkdirs();
                }
                try {
                    dstFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                boolean isSuccess = false;
                isSuccess = srcPathParse.equals(dstPathParse) ? FileEncryption.decryptFile(srcFile) : FileEncryption.decryptFileInCoverly(srcFile, dstFile);
                handler.send2Callback(isSuccess ? dstFile.getAbsolutePath() : "", 16);
                return null;
            }

            protected void onPostExecute(Void result) {
            }
        }.execute((Object[])new Void[0]);
    }

    public String getTenantAccount(Context mContext) {
        return EMMUtils.getTenantAccount(mContext);
    }

    public void outputLogFile(Context context) {
        LogUtils.outputLogcatInfo(context);
    }

    public void getGridList(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler) {
        sEmmThread = EMMThread.getGetDataThread(context, handler, wData, 14);
        sEmmThread.start();
    }

    public void saveGridListInfo(Context mContext, String gridListInfo) {
        EMMDataMgr.saveGridListInfo(mContext, gridListInfo);
    }

    public void valitionJwtToken(Context context, EMMWWidgetData wData, EUExEMM.EMMHandler handler, ValitionJwtTokenVO valitionJwtTokenVO) {
        try {
            JSONObject json = new JSONObject();
            json.put("jwtToken", (Object)valitionJwtTokenVO.jwtToken);
            json.put("appId", (Object)wData.m_appId);
            sEmmThread = EMMThread.getPostThread(context, handler, wData, 15, json, new HttpRequestHeadVO(valitionJwtTokenVO.userId, valitionJwtTokenVO.jwtkey));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        sEmmThread.start();
    }

    public void clear() {
        if (null != sEmmThread) {
            try {
                sEmmThread.finish();
                sEmmThread.interrupt();
                sEmmThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void finishWidget(String inResultInfo, String appId) {
        this.mEMM.finishWidget(inResultInfo, appId, false);
    }

    static {
        sEmmThread = null;
        isGetIpLocation = false;
        loginPropertyMap = new HashMap<String, String>(1);
        checkAppStatus = true;
    }

    private static class EMMAgentHandler {
        private static final EMMAgent sInstance = new EMMAgent();

        private EMMAgentHandler() {
        }
    }
}

