/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.http;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.zywx.wbpalmstar.plugin.uexemm.http.HNetSSLSocketFactory;
import org.zywx.wbpalmstar.plugin.uexemm.http.HX509HostnameVerifier;

public class Http {
    public static HashMap<String, KeyStore> KEY_STORE = new HashMap();
    public static String algorithm = "X509";
    public static String keyType = "pkcs12";
    private static boolean isCheckTrustCert = false;

    private static InputStream getInputStream(String cPath, Context ctx) throws IOException, FileNotFoundException {
        InputStream inStream;
        String assertFile = "file:///android_asset/";
        String sdcardFile = "/sdcard/";
        String wgtFile = "widget/";
        String file = "file://";
        if (cPath.contains(assertFile)) {
            cPath = cPath.substring(assertFile.length());
            AssetManager asset = ctx.getAssets();
            inStream = asset.open(cPath);
        } else if (cPath.contains(sdcardFile)) {
            if (cPath.contains(file)) {
                cPath = cPath.substring("file://".length());
            }
            inStream = new FileInputStream(cPath);
        } else if (cPath.startsWith(wgtFile)) {
            AssetManager asset = ctx.getAssets();
            inStream = asset.open(cPath);
        } else {
            inStream = new FileInputStream(cPath);
        }
        return inStream;
    }

    public static HNetSSLSocketFactory getSSLSocketFactoryWithCert(String cPassWord, String cPath, Context ctx) {
        InputStream inStream = null;
        HNetSSLSocketFactory ssSocketFactory = null;
        try {
            int index = cPath.lastIndexOf(47);
            String keyName = cPath.substring(index);
            KeyStore ksP12 = KEY_STORE.get(keyName);
            if (null == ksP12) {
                inStream = Http.getInputStream(cPath, ctx);
                ksP12 = KeyStore.getInstance("pkcs12");
                ksP12.load(inStream, cPassWord.toCharArray());
                KEY_STORE.put(keyName, ksP12);
            }
            ssSocketFactory = new HNetSSLSocketFactory(ksP12, cPassWord);
        }
        catch (Exception e) {
            e.printStackTrace();
            ssSocketFactory = Http.getSSLSocketFactory();
        }
        return ssSocketFactory;
    }

    public static HNetSSLSocketFactory getSSLSocketFactory() {
        HNetSSLSocketFactory ssSocketFactory = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(keyType);
            keyStore.load(null, null);
            ssSocketFactory = new HNetSSLSocketFactory(keyStore, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ssSocketFactory;
    }

    public static HttpsURLConnection getHttpsURLConnection(URL url) throws Exception {
        HttpsURLConnection mConnection = null;
        mConnection = (HttpsURLConnection)url.openConnection();
        HNetSSLSocketFactory ssFact = null;
        ssFact = Http.getSSLSocketFactory();
        mConnection.setSSLSocketFactory(ssFact);
        if (!Http.isCheckTrustCert()) {
            mConnection.setHostnameVerifier((HostnameVerifier)((Object)new HX509HostnameVerifier()));
        } else {
            mConnection.setHostnameVerifier((HostnameVerifier)SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        }
        return mConnection;
    }

    public static HttpsURLConnection getHttpsURLConnectionWithCert(URL url, String cPassWord, String cPath, Context ctx) throws Exception {
        HttpsURLConnection mConnection = null;
        mConnection = (HttpsURLConnection)url.openConnection();
        HNetSSLSocketFactory ssFact = null;
        ssFact = Http.getSSLSocketFactoryWithCert(cPassWord, cPath, ctx);
        mConnection.setSSLSocketFactory(ssFact);
        if (!Http.isCheckTrustCert()) {
            mConnection.setHostnameVerifier((HostnameVerifier)((Object)new HX509HostnameVerifier()));
        } else {
            mConnection.setHostnameVerifier((HostnameVerifier)SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
        }
        return mConnection;
    }

    public static boolean isCheckTrustCert() {
        return isCheckTrustCert;
    }

    public static void setCheckTrustCert(boolean isCheckTrustCert) {
        Http.isCheckTrustCert = isCheckTrustCert;
    }
}

