/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.upgrade;

import android.content.Context;
import java.io.File;
import org.zywx.wbpalmstar.plugin.uexemm.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.SharedPrefUtils;

public class EMMUpgradeUtils {
    public static UpdateVO getUpdateVO(Context mContext, String pkgType, String inUrl) {
        String filePath;
        String spName = "patch".equals(pkgType) ? "updateInfo" : "updateInfoFull";
        UpdateVO updateInfo = new UpdateVO();
        String url = SharedPrefUtils.getString(mContext, spName, "url", "");
        updateInfo.url = inUrl;
        if (!url.equals(inUrl)) {
            updateInfo.isContinue = false;
            return updateInfo;
        }
        updateInfo.filePath = filePath = SharedPrefUtils.getString(mContext, spName, "filePath", "");
        File file = new File(filePath);
        if (!file.exists()) {
            updateInfo.isContinue = false;
            return updateInfo;
        }
        int totalSize = SharedPrefUtils.getInt(mContext, spName, "totalSize", 0);
        int downloaded = SharedPrefUtils.getInt(mContext, spName, "downloaded", 0);
        if (totalSize == 0 || downloaded == 0) {
            updateInfo.isContinue = false;
            return updateInfo;
        }
        updateInfo.isContinue = true;
        updateInfo.downloaded = downloaded;
        updateInfo.totalSize = totalSize;
        return updateInfo;
    }

    public static void updateUpdateVO(Context context, String tempFilePath, String pkgType, String url, int totalSize, int downloaded) {
        String spName = "patch".equals(pkgType) ? "updateInfo" : "updateInfoFull";
        LogUtils.logDebugO("saveUpdateInfo url: " + url + " totalSize: " + totalSize + " downloaded: " + downloaded);
        String[] stringKeyArray = new String[]{"url", "filePath"};
        String[] stringValueArray = new String[]{url, tempFilePath};
        String[] intKeyArray = new String[]{"totalSize", "downloaded"};
        int[] intValueArray = new int[]{totalSize, downloaded};
        SharedPrefUtils.putStringArray(context, spName, stringKeyArray, stringValueArray);
        SharedPrefUtils.putIntArray(context, spName, intKeyArray, intValueArray);
    }

    public static String getUpgradeTempFileName(Context context) {
        File file = FileUtils.getExternalCacheDir(context);
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.logError("mkdirs:" + e.getMessage());
        }
        return file.getAbsolutePath() + File.separator + System.currentTimeMillis();
    }

    public static class UpdateVO {
        public boolean isContinue = false;
        public int downloaded = 0;
        public int totalSize = 0;
        public String url = "";
        public String filePath = "";
    }
}

