/*
 * Decompiled with CFR 0.152.
 */
package org.zywx.wbpalmstar.plugin.uexemm.upgrade.widgetpatch;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import org.json.JSONStringer;
import org.zywx.wbpalmstar.engine.universalex.EUExUtil;
import org.zywx.wbpalmstar.plugin.uexemm.dialog.AppUpgradeDialog;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMAgent;
import org.zywx.wbpalmstar.plugin.uexemm.emm.EMMThread;
import org.zywx.wbpalmstar.plugin.uexemm.http.EMMHttpURLConnection;
import org.zywx.wbpalmstar.plugin.uexemm.privatevo.EMMStartReportResVO;
import org.zywx.wbpalmstar.plugin.uexemm.upgrade.EMMUpgradeUtils;
import org.zywx.wbpalmstar.plugin.uexemm.upgrade.widgetpatch.WidgetPatchUpgradeMgr;
import org.zywx.wbpalmstar.plugin.uexemm.utils.FileUtils;
import org.zywx.wbpalmstar.plugin.uexemm.utils.GrayRelease;
import org.zywx.wbpalmstar.plugin.uexemm.utils.LogUtils;
import org.zywx.wbpalmstar.plugin.uexemm.vo.EMMWWidgetData;

public class WidgetPatchDownloadTask
extends AsyncTask<Object, Integer, Object> {
    private static final int SUCCESS = 0;
    private static final int NETWORK_ERROR = 1;
    private static final int UNKNOWN_ERROR = -1;
    private int mTotalSize = 0;
    private int mDownloaded = 0;
    private String url = null;
    private boolean forceUpdate = true;
    private boolean needConfirm = true;
    private EMMThread mEMMThread;
    private AppUpgradeDialog mAppUpgradeDialog;
    private Context mContext;
    private EMMStartReportResVO emmStatus;

    public WidgetPatchDownloadTask(Context mContext, EMMStartReportResVO emmStatus, EMMThread thread, AppUpgradeDialog mAppUpgradeDialog, EMMWWidgetData mWidgetData) {
        this.mContext = mContext;
        this.mEMMThread = thread;
        this.forceUpdate = Boolean.valueOf(emmStatus.forceUpdate);
        this.needConfirm = Boolean.valueOf(emmStatus.needConfirm);
        this.mAppUpgradeDialog = mAppUpgradeDialog;
        this.emmStatus = emmStatus;
    }

    protected void onPreExecute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doInBackground(Object ... params) {
        DownloadRes downloadRes = new DownloadRes();
        InputStream is = null;
        RandomAccessFile raf = null;
        this.url = (String)params[0];
        if (params.length == 3) {
            this.mDownloaded = (Integer)params[1];
            this.mTotalSize = (Integer)params[2];
        }
        if (this.mDownloaded == this.mTotalSize && this.mDownloaded != 0) {
            downloadRes.resCode = 0;
        } else {
            try {
                LogUtils.logDebugO("updatePatch url: " + this.url + " mDownloaded: " + this.mDownloaded + " mTotalSize:" + this.mTotalSize);
                HttpURLConnection mHttpConnection = EMMHttpURLConnection.getHttpURLConnection(this.mContext, this.url, 40000, false);
                HttpURLConnection.setFollowRedirects(true);
                mHttpConnection.setRequestMethod("GET");
                mHttpConnection.addRequestProperty("RANGE", "bytes=" + this.mDownloaded + "-");
                mHttpConnection.connect();
                int responseCode = mHttpConnection.getResponseCode();
                LogUtils.logDebugO("updatePatch responseCode: " + responseCode);
                if (responseCode >= 200 && responseCode < 300) {
                    String tempPath;
                    String header = "";
                    if (206 == responseCode) {
                        header = mHttpConnection.getHeaderField("Content-Range");
                    }
                    if (TextUtils.isEmpty((CharSequence)header)) {
                        this.mDownloaded = 0;
                        LogUtils.logDebugO("Server doesn't support Resuming Broken Transfer!");
                    } else {
                        LogUtils.logDebugO("Content-Range = " + header);
                    }
                    String extension = FileUtils.getFileExtension(this.url, "zip");
                    extension = "zip";
                    String tempFile = EMMUpgradeUtils.getUpgradeTempFileName(this.mContext);
                    downloadRes.tempFilePath = tempPath = tempFile + "." + extension;
                    raf = new RandomAccessFile(tempPath, "rw");
                    long totalSize = mHttpConnection.getContentLength();
                    boolean countable = false;
                    if (totalSize > 0L) {
                        countable = true;
                    }
                    this.mTotalSize = (int)totalSize + this.mDownloaded;
                    LogUtils.logDebugO("updatePatch mTotalSize: " + this.mTotalSize);
                    is = mHttpConnection.getInputStream();
                    long downloaded = this.mDownloaded;
                    byte[] buffer = new byte[4096];
                    int actulSize = 0;
                    raf.seek(downloaded);
                    while (!this.isCancelled() && (actulSize = is.read(buffer)) != -1 && !this.isCancelled()) {
                        raf.write(buffer, 0, actulSize);
                        if (!countable) continue;
                        this.mDownloaded = (int)(downloaded += (long)actulSize);
                        int progress = (int)((float)this.mDownloaded / (float)this.mTotalSize * 100.0f);
                        this.publishProgress(new Integer[]{progress != 100 ? progress : 99});
                    }
                    LogUtils.logDebugO("updatePatch downloaded: " + downloaded);
                    if (!this.isCancelled()) {
                        downloadRes.resCode = 0;
                    } else {
                        EMMUpgradeUtils.updateUpdateVO(this.mContext, tempPath, this.emmStatus.pkgType, this.url, this.mTotalSize, this.mDownloaded);
                    }
                } else {
                    downloadRes.resCode = 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.oe("updatePatchPkg", e);
            }
            catch (OutOfMemoryError error) {
                error.printStackTrace();
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                is = null;
            }
        }
        return downloadRes;
    }

    protected void onProgressUpdate(Integer ... values) {
        if (this.needConfirm) {
            this.mAppUpgradeDialog.setProgress(values[0]);
        }
    }

    protected void onCancelled(Object result) {
        if (result == null) {
            return;
        }
        if (this.isCancelled()) {
            LogUtils.logDebugO("on user cancelled download patch");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Object result) {
        block15: {
            if (result == null) {
                return;
            }
            DownloadRes downloadRes = (DownloadRes)result;
            EMMUpgradeUtils.updateUpdateVO(this.mContext, downloadRes.tempFilePath, this.emmStatus.pkgType, this.url, this.mTotalSize, this.mDownloaded);
            if (this.isCancelled()) {
                LogUtils.logDebugO("user cancelled download patch");
                return;
            }
            try {
                int res = downloadRes.resCode;
                if (res == 0) {
                    if (this.mEMMThread != null) {
                        EMMThread eMMThread = this.mEMMThread;
                        synchronized (eMMThread) {
                            this.mEMMThread.notify();
                        }
                    }
                    LogUtils.logDebugO("download patch completed");
                    if (!EMMAgent.getEMMConfig().isRealTimePatchUpdate) {
                        LogUtils.logDebugO("start installWidgetPatch plugin");
                        this.installWidgetPatch(this.mContext, EMMAgent.s_rootWgt.m_appId, 2);
                    } else {
                        LogUtils.logDebugO("start installWidgetPatch all");
                        String version = this.installWidgetPatch(this.mContext, EMMAgent.s_rootWgt.m_appId, 3);
                        if (!TextUtils.isEmpty((CharSequence)version)) {
                            EMMAgent.s_rootWgt.m_ver = version;
                        }
                        LogUtils.logDebugO("installWidgetPatch all completed");
                    }
                    if (this.needConfirm) {
                        this.onProgressUpdate(100);
                    }
                    LogUtils.logDebugO("WidgetPatchUpdate completed");
                    String updateResultString = new JSONStringer().object().key("status").value((Object)"ok").key("msg").value((Object)"").key("forceUpdate").value(this.forceUpdate).key("needConfirm").value(this.needConfirm).endObject().toString();
                    EMMAgent.getInstance().getEUExEMMInstance().cbHandler.send2Callback(updateResultString, 20);
                    if (this.needConfirm) {
                        this.mAppUpgradeDialog.dismiss();
                    }
                    break block15;
                }
                if (this.needConfirm) {
                    AppUpgradeDialog.UpdateDialogUIConfig config = new AppUpgradeDialog.UpdateDialogUIConfig();
                    config.forceUpdate = this.forceUpdate;
                    config.msg = EUExUtil.getString((String)"plugin_uexemm_problems_msg");
                    config.pkgType = "patch";
                    this.mAppUpgradeDialog.updateDialogUI(this.mContext, 2, config);
                }
                GrayRelease.freeGrayReleaseVersion(this.mContext, EMMAgent.s_rootWgt, this.emmStatus);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogUtils.oe("UpdateWidgetAsyncTask", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installWidgetPatch(Context context, String appId, int installType) {
        String version = "";
        boolean isInvoke = false;
        try {
            Method installWidgetPatch = Class.forName("org.zywx.wbpalmstar.base.BUtility").getMethod("installWidgetPatch", Context.class, String.class, Integer.TYPE);
            try {
                version = (String)installWidgetPatch.invoke((Object)this, context, appId, installType);
                isInvoke = true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (3 == installType && !isInvoke) {
                LogUtils.logErrorO("App can not support dynamic loading plugins\uff01");
                WidgetPatchUpgradeMgr wPatchUpgradeMgr = new WidgetPatchUpgradeMgr(context);
                wPatchUpgradeMgr.installWidgetPatch(context);
            }
        }
        return version;
    }

    class DownloadRes {
        int resCode = -1;
        String tempFilePath = "";

        DownloadRes() {
        }
    }
}

